/*ContCreatePointers set up pointers for lines and continua called by cloudy after input read in */
/*fill define the continuum energy grid over a specified range */
/*ChckFill perform sanity check confirming that the energy array has been properly filled */
/*fiddle adjust energy bounds of certain cells so that match ionization edges exactly */
/*eina convert a gf into an Einstein A */
#include "cddefines.h"
#include "physconst.h"
#include "iso.h"
#include "hydrogenic.h"
#include "secondaries.h"
#include "nfeii.h"
#include "nhe1lvl.h"
#include "taulines.h"
#include "elementnames.h"
#include "getgf.h"
#include "abscf.h"
#include "ionrec.h"
#include "helike.h" 
#include "rt.h"
#include "opacity.h"
#include "ipvfil.h"
#include "twophoton.h"
#include "ipfe2.h"
#include "fe2pmp.h"
#include "abundances.h"
#include "pumpfe.h"
#include "pbowen.h"
#include "ip626.h"
#include "rfield.h"
#include "he1nionryd.h"
#include "iphe1l.h"
#include "nhe1.h"
#include "he.h"
#include "ip2gam.h"
#include "pmp2s.h"
#include "pop371.h"
#include "atom_oi.h"
#include "fekems.h"
#include "trace.h"
#include "iphmin.h"
#include "egray.h"
#include "kshllenr.h"
#include "hmi.h"
#include "heavy.h"
#include "he3lines.h"
#include "predcont.h"
#include "ph1com.h"
#include "ipoint.h"
#include "h2.h"
#include "ipshells.h"
#include "continuum.h"

/*fiddle adjust energy bounds of certain cells so that match ionization edges exactly */
static void fiddle(long int ipnt, 
  double exact);

/*eina convert a gf into an Einstein A */
static double eina(double gf, 
	  double enercm, 
	  double gup);

void ContCreatePointers(void)
{
	char chLab[5];
	long int 
	  i, 
	  ion, 
	  ipHi, 
	  ipLo, 
	  ipISO,
	  iWL_Ang,
	  j, 
	  limit ,
	  nelem,
	  nshells;
	double energy,
		xnew;
	/* counter to say whether pointers have ever been evaluated */
	static int nCalled = 0;

#	ifdef DEBUG_FUN
	fputs( "<+>ContCreatePointers()\n", debug_fp );
#	endif

	/* create the hydrogen atom for this coreload, routine creates space then zeros it out
	 * on first call, on second and later calls it only zeros things out */
	iso_create();

	/* create internal static variables needed to do the he-like series */
	HeCreate();

	/* create internal static variables needed to do the H2 molecule */
	H2_Create();

	/* nCalled is local static variable defined 0 when defined. 
	 * it is incremented below, so that space only allocated one time per coreload. */
	if( nCalled > 0 )
	{
		if( trace.lgTrace )
		{
			fprintf( ioQQQ, " ContCreatePointers called, not evaluating.\n" );
		}
		
#		ifdef DEBUG_FUN
		fputs( " <->ContCreatePointers()\n", debug_fp );
#		endif
		return;
	}
	else
	{
		if( trace.lgTrace )
		{
			fprintf( ioQQQ, " ContCreatePointers called first time.\n" );
		}
		++nCalled;
	}

	for( i=0; i < rfield.nupper; i++ )
	{
		/* this is array of labels for lines and continua, set to blanks at first */
		strcpy( rfield.chContLabel[i], "    ");
		strcpy( rfield.chLineLabel[i], "    ");
	}

	/* we will generate a set of array indices to ionization edges for
	 * the first thirty elements.  First set all array indices to
	 * totally bogus values so we will crash if misused */
	for( nelem=0; nelem<LIMELM; ++nelem )
	{
		if( abundances.lgElmtOn[nelem] )
		{
			for( ion=0; ion<LIMELM; ++ion )
			{
				for( nshells=0; nshells<7; ++nshells )
				{
					for( j=0; j<3; ++j )
					{
						opac.ipElement[nelem][ion][nshells][j] = INT_MIN;
					}
				}
			}
		}
	}

	/* pointer to excited state of O+2 */
	opac.ipo3exc[0] = ipContEnergy(3.855,"O3ex");

	/* main hydrogenic arrays - THIS OCCURS TWICE!! H and He here, then the
	 * remaining hydrogenic species near the bottom.  This is so that H and HeII get
	 * their labels stuffed into the arrays, and the rest of the hydrogenic series 
	 * get whatever is left over after the level 1 lines.
	 * to find second block, search on "ipZ=2" */
	/* NB note that no test for H or He being on exists here - we will always
	 * define the H and He arrays even when he is off, since we need to
	 * know where the he edges are for the bookkeeping that occurs in continuum
	 * binning routines */
	/* this loop is over H, He-like only */
	for( ipISO=ipHYDROGEN; ipISO<=ipHELIUM; ++ipISO )
	{
		/* this will be over HI, HeII, then HeI only */
		for( nelem=ipISO; nelem < 2; nelem++ )
		{
			/* generate label for this ion */
			sprintf( chLab, "%2s%2ld",elementnames.chElementSym[nelem], nelem+1-ipISO );

			/* array index for continuum edges for ground */
			iso.ipIsoLevNIonCon[ipISO][nelem][0] = ipContEnergy(iso.xIsoLevNIonRyd[ipISO][nelem][0],chLab);
			for( ipHi=1; ipHi < iso.numLevels[ipISO][nelem]; ipHi++ )
			{
				/* array index for continuum edges for excited levels */
				iso.ipIsoLevNIonCon[ipISO][nelem][ipHi] = ipContEnergy(iso.xIsoLevNIonRyd[ipISO][nelem][ipHi],chLab);

				/* define all line array indices */
				for( ipLo=0; ipLo < ipHi; ipLo++ )
				{
					/* some lines have negative or zero energy */
					if( EmisLines[ipISO][nelem][ipHi][ipLo].EnergyWN <= 0. )
					{
						EmisLines[ipISO][nelem][ipHi][ipLo].ipCont = -1;
					}
					else
					{
						/* some energies are negative for inverted levels */
						EmisLines[ipISO][nelem][ipHi][ipLo].ipCont = 
							(int)ipLineEnergy(EmisLines[ipISO][nelem][ipHi][ipLo].EnergyWN * WAVNRYD , chLab ,
							iso.ipIsoLevNIonCon[ipISO][nelem][ipLo]);
					}
				}
			}
		}
	}


	/* need to increase the cell for the HeII balmer continuum by one, so that
	 * hydrogen lyman continuum will pick it up. */
	nelem = 1;
	/* copy label over to next higher cell */
	if( strcmp( rfield.chContLabel[iso.ipIsoLevNIonCon[ipH_LIKE][nelem][ipH2s]-1] , "He 2" ) == 0)
	{
		strcpy( rfield.chContLabel[iso.ipIsoLevNIonCon[ipH_LIKE][nelem][ipH2s]], 
				 rfield.chContLabel[iso.ipIsoLevNIonCon[ipH_LIKE][nelem][ipH2s]-1] );
		/* set previous spot to blank */
		strcpy( rfield.chContLabel[iso.ipIsoLevNIonCon[ipH_LIKE][nelem][ipH2s]-1] , "    ");
	}
	else if( strcmp( rfield.chContLabel[iso.ipIsoLevNIonCon[ipH_LIKE][nelem][ipH2s]-1] , "H  1" ) == 0)
	{
		/* set previous spot to blank */
		strcpy( rfield.chContLabel[iso.ipIsoLevNIonCon[ipH_LIKE][nelem][ipH2s]] , "He 2");
	}
	else
	{
		fprintf(ioQQQ," insanity heii pointer fix contcreatepointers\n");
	}
	/* finally increment the two HeII pointers so that they are above the Lyman continuum */
	++iso.ipIsoLevNIonCon[ipH_LIKE][nelem][ipH2s];
	++iso.ipIsoLevNIonCon[ipH_LIKE][nelem][ipH2p];

	/* array of either 1 or 0 for energy of elec to be counted
	 * as able to produce secondary ionizations
	 * below 100eV no secondary ionization */
	Secondaries.ipSecIon = ipoint(7.353);

	/* this is highest energy where k-shell opacities are counted
	 * can be adjusted with "set kshell" command */
	KshllEnr.KshellLimit = ipoint(KshllEnr.EnergyKshell);

	/* pointers for molecules
	 * H2+ dissociation energy 2.647 eV but cs small below 0.638 Ryd */
	opac.ih2pnt[0] = ipContEnergy(0.502,"H2+ ");
	opac.ih2pnt[1] = ipoint(1.03);

	/* pointers for most prominent PAH features
	 * energies given to ipContEnergy are only to put lave in the right place
	 * wavelenghts are rough observed values of blends
	 * 7.6 microns */
	i = ipContEnergy(0.0117, "PAH " );

	/* feature near 6.2 microns */
	i = ipContEnergy(0.0147, "PAH " );

	/* 3.3 microns */
	i = ipContEnergy(0.028, "PAH " );

	/* 11.2 microns */
	i = ipContEnergy(0.0080, "PAH " );

	/* 12.3 microns */
	i = ipContEnergy(0.0077, "PAH " );

	/* 13.5 microns */
	i = ipContEnergy(0.0069, "PAH " );


	/* fix pointers for hydrogen and helium */

	/* pointers to He I triplet lines */
	he3lines.ipHe3l[0] = ipLineEnergy(0.08416,"HeI3",0);
	he3lines.ipHe3l[1] = ipLineEnergy(RYDLAM/5876.,"HeI3",0);
	he3lines.ipHe3l[2] = ipLineEnergy(RYDLAM/7065.,"HeI3",0);
	he3lines.ipHe3l[3] = ipLineEnergy(RYDLAM/3889.,"HeI3",0);

	/* pointer to Bowen 374A resonance line */
	pbowen.ip374 = ipLineEnergy((1.92),"He 2",0);
	pbowen.ip660 = ipLineEnergy((1.38),"He 2",0);

	/* set up series of continuum pointers to be used in routine lines to
	 * enter continnum points into line array */
	for( i=0; i < NPREDCONT; i++ )
	{
		/* EnrPredCont contains array of energy points, as set in zerologic.c */
		ipPredCont[i] = ipoint(EnrPredCont[i]) - 1;
	}

	/* do HeI */
	for( i=0; i < (NHE1LVL - 1); i++ )
	{
		nhe1Com.nhe1[i] = ipContEnergy(He1NIonRyd.He1IonRyd[i],"He 1" );
		for( j=i + 1; j < NHE1LVL; j++ )
		{
			/* get energies from table, in zero */
			iphe1lCom.iphe1l[i][j] = ipLineEnergy((He1NIonRyd.He1IonRyd[i]-
			  He1NIonRyd.He1IonRyd[j]),"He 1" , nhe1Com.nhe1[i]);
			/* make sure pointer not in next higher continuum */
			/*if( iphe1lCom.iphe1l[i][j] >= nhe1Com.nhe1[i] )
			{
				fprintf( ioQQQ, " He1 line%3ld%3ld spills over into%3ld continuum, energy=%11.3e\n", 
				  j, i, i, rfield.anu[iphe1lCom.iphe1l[i][j]-1] );
			}*/
		}
	}

	nhe1Com.nhe1[NHE1LVL-1] = ipContEnergy(He1NIonRyd.He1IonRyd[NHE1LVL-1],
	  "He 1");

	nhe1Com.nhe1[NHE1LVL] = nhe1Com.nhe1[1];

	/* pointer to helium 2 trip s to ground decay */
	ip626.ipHe23sGrnd = ipLineEnergy(1.457,"HeI3",0);

	/* photoionization for HeI triplet 23s */
	he.nhei3 = ipContEnergy(0.3506,"HeI3");

	/* TODO remove following two, replace with above */
	he.nhei1 = nhe1Com.nhe1[0];
	he.nheii = iso.ipIsoLevNIonCon[ipH_LIKE][ipHELIUM][ipH1s];

	/* pointer to energy defining effect x-ray column */
	rt.ipxry = ipoint(73.5);

	/* double photoionization
	 * TODO most of these have been removed */
	ip2gam.ip2ePhoto = ipoint(7.3);

	/* pointer to Hminus edge at 0.754eV */
	iphminCom.iphmin = ipContEnergy(0.05544,"H-  ");

	/* pointer to CaII XYZ at 8700A
	 * ipxyz = ipoint(0.1)
	 * */
	hmi.iheh1 = ipoint(1.6);
	hmi.iheh2 = ipoint(2.3);

	/* pointer to carbon k-shell ionization */
	opac.ipCKshell = ipoint(20.6);

	/* pointer to threshold for pair production */
	opac.ippr = ipoint(7.51155e4) + 1;

	/* pointer to x-ray - gamma ray bound; 100 kev */
	egray.ipEnerGammaRay = ipoint(egray.EnerGammaRay);

	for( i=0; i < NFEII; i++ )
	{
		ipfe2Com.ipfe2[i] = ipoint(fe2pmp.fe2enr[i]);
	}

	/* pointers to hot and cold iron */
	fekems.ipkcld = ipLineEnergy(6400./13.54,"Fekc",0);
	fekems.ipkhot = ipLineEnergy(6600./13.54,"Fekh",0);
	he3lines.ipHe3l[0] = ipLineEnergy(0.08416,"HeI3",0);

	/* make low energy edges of some cells exact,
	 * index is on c scale
	 * 0.99946 is correct energy of hydrogen in inf mass ryd */
	fiddle(iso.ipIsoLevNIonCon[ipH_LIKE][ipHYDROGEN][ipH1s]-1,0.99946);
	fiddle(iso.ipIsoLevNIonCon[ipH_LIKE][ipHYDROGEN][ipH2p]-1,0.24986);
	/* confirm that labels are in correct location */
	ASSERT( strcmp( rfield.chContLabel[iso.ipIsoLevNIonCon[ipH_LIKE][ipHYDROGEN][ipH1s]-1], "H  1" ) ==0 );
	ASSERT( strcmp( rfield.chContLabel[iso.ipIsoLevNIonCon[ipH_LIKE][ipHYDROGEN][ipH2p]-1], "H  1" ) ==0 );

	fiddle(nhe1Com.nhe1[0]-1,1.8072);
	fiddle(iso.ipIsoLevNIonCon[ipH_LIKE][ipHELIUM][ipH1s]-1,4.00000);
	ASSERT( strcmp( rfield.chContLabel[nhe1Com.nhe1[0]-1], "He 1" ) ==0 );
	ASSERT( strcmp( rfield.chContLabel[iso.ipIsoLevNIonCon[ipH_LIKE][ipHELIUM][ipH1s]-1], "He 2" ) ==0 );

	/* pointer to excited state of O+2
	 * ipo3exc(1) = ipContEnergy(3.855 ,'O3ex' ) */
	fiddle(opac.ipo3exc[0]-1,3.855);

	/* now fix widflx array so that it is correct */
	for( i=1; i<rfield.nupper-1; ++i )
	{
		rfield.widflx[i] = ((rfield.anu[i+1] - rfield.anu[i]) + (rfield.anu[i] - rfield.anu[i-1]))/2.f;
	}

	/* now save current form of array */
	for( i=0; i < rfield.nupper; i++ )
	{
		rfield.AnuOrg[i] = rfield.anu[i];
		rfield.anusqr[i] = (float)sqrt(rfield.AnuOrg[i]);
	}

	/* following order of elements is in roughly decreasing abundance
	 * when ipShells gets a cell for the valence IP it does so through
	 * ipContEnergy, which makes sure that no two ions get the same cell
	 * earliest elements have most precise ip mapping */

	/* set up shell pointers for hydrogen */
	nelem = ipHYDROGEN;
	ion = 0;

	/* the number of shells */
	Heavy.nsShells[nelem][0] = 1;

	/*pointer to ionization threshold in energy array*/
	Heavy.ipHeavy[nelem][ion] = iso.ipIsoLevNIonCon[ipH_LIKE][nelem][ipH1s];
	opac.ipElement[nelem][ion][0][0] = iso.ipIsoLevNIonCon[ipH_LIKE][nelem][ipH1s];

	/* upper limit to energy integration */
	opac.ipElement[nelem][ion][0][1] = rfield.nupper;

	if( abundances.lgElmtOn[ipHELIUM] )
	{
		/* set up shell pointers for helium */
		nelem = 1;
		ion = 0;

		/* the number of shells */
		Heavy.nsShells[nelem][0] = 1;

		/*pointer to ionization threshold in energy array*/
		Heavy.ipHeavy[nelem][ion] = nhe1Com.nhe1[0];
		opac.ipElement[nelem][ion][0][0] = nhe1Com.nhe1[0];

		/* upper limit to energy integration */
		opac.ipElement[nelem][ion][0][1] = rfield.nupper;

		/* (hydrogenic) helium ion */
		ion = 1;
		/* the number of shells */
		Heavy.nsShells[nelem][1] = 1;

		/*pointer to ionization threshold in energy array*/
		Heavy.ipHeavy[nelem][ion] = iso.ipIsoLevNIonCon[ipH_LIKE][nelem][ipH1s];
		opac.ipElement[nelem][ion][0][0] = iso.ipIsoLevNIonCon[ipH_LIKE][nelem][ipH1s];

		/* upper limit to energy integration */
		opac.ipElement[nelem][ion][0][1] = rfield.nupper;
	}

	/* check that ionization potential of neutral carbon valence shell is
	 * positive */
	ASSERT( PH1COM.PH1[2][5][5][0] > 0. );

	/* now fill in all sub-shell ionization array indices for elements heavier than He,
	 * this must be done after previous loop on iso.ipIsoLevNIonCon[ipH_LIKE] since hydrogenic species use
	 * iso.ipIsoLevNIonCon[ipH_LIKE] rather than ipoint in getting array index within continuum array */
	for( i=2; i<LIMELM; ++i )
	{
		if( abundances.lgElmtOn[i])
		{
			/* i is the atomic number on the c scale, 2 for Li */
			ipShells(i);
		}
	}

	/* most of these are set in ipshells, but not h-like or he-like, so do these here */
	Heavy.Valence_IP_Ryd[ipHYDROGEN][0] = PH1COM.PH1[0][0][ipHYDROGEN][0]/EVRYD* 0.9998787 ;
	Heavy.Valence_IP_Ryd[ipHELIUM][0] = PH1COM.PH1[0][1][ipHELIUM][0]/EVRYD* 0.9998787 ;
	Heavy.Valence_IP_Ryd[ipHELIUM][1] = PH1COM.PH1[0][0][ipHELIUM][0]/EVRYD* 0.9998787 ;
	for( nelem=2; nelem<LIMELM; ++nelem )
	{
		Heavy.Valence_IP_Ryd[nelem][nelem-1] = PH1COM.PH1[0][1][nelem][0]/EVRYD* 0.9998787 ;
		Heavy.Valence_IP_Ryd[nelem][nelem] = PH1COM.PH1[0][0][nelem][0]/EVRYD* 0.9998787 ;
		if( abundances.lgElmtOn[nelem])
		{
			/* now confirm that all are properly set */
			for( j=0; j<=nelem; ++j )
			{
				ASSERT( Heavy.Valence_IP_Ryd[nelem][j] > 0.05 );
			}
			for( j=0; j<nelem; ++j )
			{
				ASSERT( Heavy.Valence_IP_Ryd[nelem][j] < Heavy.Valence_IP_Ryd[nelem][j+1]);
			}
		}
	}

	/* array indices to bound compton electron recoil ionization of all elements */
	for( nelem=0; nelem<LIMELM; ++nelem )
	{
		if( abundances.lgElmtOn[nelem])
		{
			for( ion=0; ion<nelem+1; ++ion )
			{
				/* this is the threshold energy to compton ionize valence shell electrons */
				energy = sqrt( Heavy.Valence_IP_Ryd[nelem][ion] * EN1RYD * ELECTRON_MASS * SPEEDLIGHT * SPEEDLIGHT ) / EN1RYD;
				/* the array index for this energy */
				ionrec.ipCompRecoil[nelem][ion] = ipoint( energy );
			}
		}
	}

	/* oxygen
	 * pointers for excited states
	 * IO3 is pointer to O++ exc state, is set above */
	pmp2s.i2d = ipoint(1.242);
	pmp2s.i2p = ipoint(1.367);
	opac.ipo1exc[0] = ipContEnergy(0.856,"O1ex");
	opac.ipo1exc[1] = ipoint(2.0);

	/* atomic oxygen valence shell 
	Heavy.nsShells[ipOXYGEN][0]*/
	/* this is the valence shell index */
	/* finish off excited state photoionization
	 * do not use ipContEnergy since only upper limit */
	opac.ipo3exc[1] = ipoint(5.0);

	/* upper level of 4363 */
	opac.ipo3exc3[0] = ipContEnergy(3.646,"O3ex");
	opac.ipo3exc3[1] = ipoint(5.0);

	/* following are various pointers for OI - Lybeta pump problem
	 * these are delta energies for boltzmann factors
	 * TODO this is redundant with contents of oxygen line arrays
	 * use them instead
	 * when removing this, make sure all line intensity predictions
	 * also go into oi line arrays */
	atom_oi.ipoiex[0] = ipoint(0.7005);
	atom_oi.ipoiex[1] = ipoint(0.10791);
	atom_oi.ipoiex[2] = ipoint(0.06925);
	atom_oi.ipoiex[3] = ipoint(0.01151);
	atom_oi.ipoiex[4] = ipoint(0.01999);

	/* >>chng 97 jan 27, move nitrogen after oxygen so that O gets the
	 * most accurate pointers
	 * Nitrogen
	 * in1(1) is thresh for photo from excited state */
	opac.in1[0] = ipContEnergy(0.893,"N1ex");

	/* upper limit */
	opac.in1[1] = ipoint(2.);

	if( (trace.lgTrace && trace.lgConBug) || (trace.lgTrace && trace.lgPointBug) )
	{
		fprintf( ioQQQ, "   ContCreatePointers:%ld energy cells used. N(1R):%4ld N(1.8):%4ld  N(4Ryd):%4ld N(O3)%4ld  N(x-ray):%5ld N(rcoil)%5ld\n", 
		  rfield.nupper, iso.ipIsoLevNIonCon[ipH_LIKE][ipHYDROGEN][ipH1s], nhe1Com.nhe1[0], 
		  iso.ipIsoLevNIonCon[ipH_LIKE][ipHELIUM][ipH1s], opac.ipo3exc[0], opac.ipCKshell, 
		  ionrec.ipCompRecoil[ipHYDROGEN][0] );

		fprintf( ioQQQ, "   ContCreatePointers: HeI trip: %5ld\n", he.nhei3 );

		fprintf( ioQQQ, "   ContCreatePointers: ipEnerGammaRay: %5ld IPPRpari produc%5ld\n", 
		  egray.ipEnerGammaRay, opac.ippr );

		fprintf( ioQQQ, "   ContCreatePointers: H pointers;" );
		for( i=0; i <= 6; i++ )
		{
			fprintf( ioQQQ, "%4ld%4ld", i, iso.ipIsoLevNIonCon[ipH_LIKE][ipHYDROGEN][i] );
		}
		fprintf( ioQQQ, "\n" );

		fprintf( ioQQQ, "   ContCreatePointers: HeI pnters;" );
		for( i=1; i <= 6; i++ )
		{
			fprintf( ioQQQ, "%4ld%4ld", i, nhe1Com.nhe1[i-1] );
		}
		fprintf( ioQQQ, "\n" );
		fprintf( ioQQQ, "   ContCreatePointers: Oxy pnters;" );

		for( i=1; i <= 8; i++ )
		{
			fprintf( ioQQQ, "%4ld%4ld", i, Heavy.ipHeavy[ipOXYGEN][i-1] );
		}
		fprintf( ioQQQ, "\n" );
	}

	/* Magnesium
	 * following is energy for phot of MG+ from exc state producing 2798 */
	opac.ipmgex = ipoint(0.779);

	/* pointers to ir triplet, kh
	 * icaxyz = ipoint( 0.11 )
	 * icakh = ipoint( 0.235 )
	 * lower, upper edges of Ca+ excited term photoionizaiton
	 * ica2ex(1) = ipoint(0.72) */
	opac.ica2ex[0] = ipContEnergy(0.72,"Ca2x");
	opac.ica2ex[1] = ipoint(1.);

	/* set all pointers to ionizaiton edges with labels */
	/* set up factors and pointers for Fe continuum fluorescence */
	pumpfe.ipfe10 = ipoint(2.605);

	/* center of V filter */
	ipvfil.ipVFilter = ipoint(0.164);

	/* following is WL(CM)**2/(8PI) * conv fac for RYD to NU *A21 */
	pumpfe.pfe10 = (float)(2.00e-18/rfield.widflx[pumpfe.ipfe10-1]);

	/* this is 353 pump, f=0.032 */
	pumpfe.pfe11a = (float)(4.54e-19/rfield.widflx[pumpfe.ipfe10-1]);

	/* this is 341.1 f=0.012 */
	pumpfe.pfe11b = (float)(2.75e-19/rfield.widflx[pumpfe.ipfe10-1]);
	pumpfe.pfe14 = (float)(1.15e-18/rfield.widflx[pumpfe.ipfe10-1]);

	/* set up energy pointers for line optical depth arrays
	 * this also increments flux, sets other parameters for lines */

	/* level 1 heavy elements line array */
	for( i=1; i <= nLevel1; i++ )
	{
		/* put null terminated line label into chLab using line array*/
		chIonLbl(chLab, &TauLines[i]);

		TauLines[i].ipCont = 
			(int)ipLineEnergy(TauLines[i].EnergyWN * WAVNRYD, chLab ,0);
		/* for debugging pointer - index on f not c scale, 
		 * this will find all lines that entered a given cell 
		   if( TauLines[i].ipCont==603 )
			fprintf(ioQQQ,"( level1 %s\n", chLab);*/

		if( TauLines[i].gf > 0. )
		{
			/* the gf value was entered
			 * derive the A, call to function is gf, wl (A), g_up */
			TauLines[i].Aul = 
				(float)(eina(TauLines[i].gf,
			  TauLines[i].EnergyWN,TauLines[i].gHi));
		}
		else if( TauLines[i].Aul > 0. )
		{
			/* the Einstion A value was entered
			 * derive the gf, call to function is A, wl (A), g_up */
			TauLines[i].gf = 
				(float)(GetGF(TauLines[i].Aul,
			  TauLines[i].EnergyWN,TauLines[i].gHi));
		}
		else
		{
			fprintf( ioQQQ, " level 1 line does not have valid gf or A\n" );
			fprintf( ioQQQ, " This is ContCreatePointers\n" );
			puts( "[Stop in ContCreatePointers]" );
			cdEXIT(EXIT_FAILURE);
		}

		TauLines[i].damprel = 
			(float)(TauLines[i].Aul*
		  TauLines[i].WLAng*1e-8/PI4);
		TauLines[i].damp = TauLines[i].damprel / 1e5f;

		/* derive the abs coef, call to function is gf, wl (A), g_low */
		TauLines[i].opacity = 
			(float)(abscf(TauLines[i].gf,
		  TauLines[i].EnergyWN,TauLines[i].gLo));
		/*fprintf(ioQQQ,"TauLinesss\t%li\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\n",
			i,TauLines[i].opacity , TauLines[i].gf , TauLines[i].Aul ,TauLines[i].EnergyWN,TauLines[i].gLo);*/

		/* excitation energy of transition in degrees kelvin */
		TauLines[i].EnergyK = 
			(float)(T1CM)*TauLines[i].EnergyWN;

		/* energy of photon in ergs */
		TauLines[i].EnergyErg = 
			(float)(ERG1CM)*TauLines[i].EnergyWN;

		/*line wavelength must be gt 0 */
		ASSERT( TauLines[i].WLAng > 0 );
	}

	/* set the ipCont struc element for the H2 molecule */
	H2_ContPoint();

	for( ipISO=ipHYDROGEN; ipISO<NISO; ++ipISO )
	{
		/* do remaining part of the he iso sequence */
		for( nelem=2; nelem < LIMELM; nelem++ )
		{
			if( abundances.lgElmtOn[nelem])
			{
				/* generate label for this ion */
				sprintf( chLab, "%2s%2ld",elementnames.chElementSym[nelem], nelem+1-ipISO );
				/* Lya itself is the only transition below n=3 - we explicitly do not
				* want to generate pointers for 2s-1s or 2p-2s */
				/* array index for continuum edges for levels in He-like ions  */
				iso.ipIsoLevNIonCon[ipISO][nelem][0] = 
					ipContEnergy(iso.xIsoLevNIonRyd[ipISO][nelem][0],chLab);

				for( ipHi=1; ipHi < iso.numLevels[ipISO][nelem] ; ipHi++ )
				{
					/* array index for continuum edges for levels in He-like ions  */
					iso.ipIsoLevNIonCon[ipISO][nelem][ipHi] = ipContEnergy(iso.xIsoLevNIonRyd[ipISO][nelem][ipHi],chLab);

					/* define all he-like line pointers */
					for( ipLo=0; ipLo < ipHi; ipLo++ )
					{
						/* some lines have negative or zero energy */
						if( EmisLines[ipISO][nelem][ipHi][ipLo].EnergyWN <= 0. )
						{
							/* some energies are negative for inverted levels */
							EmisLines[ipISO][nelem][ipHi][ipLo].ipCont = -1;
						}
						else
						{
							EmisLines[ipISO][nelem][ipHi][ipLo].ipCont = 
								(int)ipLineEnergy(EmisLines[ipISO][nelem][ipHi][ipLo].EnergyWN * WAVNRYD , chLab ,
								iso.ipIsoLevNIonCon[ipISO][nelem][ipLo]);
						}
					}
				}
				iso.ipIsoLevNIonCon[ipISO][nelem][0] = ipContEnergy(iso.xIsoLevNIonRyd[ipISO][nelem][0],chLab);
			}
		}
	}

	/* some lines do not exist, the flag indicating this is ipCont == -1 */
	/* for H-like sequence, these are 2p-2s (energies degenerate) and 2s-1s, two photon */
	ipISO = ipHYDROGEN;
	/* do remaining part of the he iso sequence */
	for( nelem=ipISO; nelem < LIMELM; nelem++ )
	{
		if( abundances.lgElmtOn[nelem])
		{
			/* for H-like sequence want 2p-2s (energies degenerate) and 2s-1s, two photon */
			EmisLines[ipISO][nelem][ipH2p][ipH2s].ipCont = -1;
			EmisLines[ipISO][nelem][ipH2s][ipH1s].ipCont = -1;
		}
	}

	/* for He-like sequence the majority of the transitions are bogus - A set to special value in this case */
	ipISO = ipHELIUM;
	/* do remaining part of the he iso sequence */
	for( nelem=ipISO; nelem < LIMELM; nelem++ )
	{
		if( abundances.lgElmtOn[nelem])
		{
			/* this is the two photon transition in the singlets */
			EmisLines[ipISO][nelem][ipHe2s1S][ipHe1s1S].ipCont = -1;

			for( ipHi=1; ipHi < iso.numLevels[ipISO][nelem] ; ipHi++ )
			{
				for( ipLo=0; ipLo < ipHi; ipLo++ )
				{
					if( fabs(EmisLines[ipISO][nelem][ipHi][ipLo].Aul - helike.SmallA) < SMALLFLOAT )
					{
						/* helike.SmallA is value assigned to bogus transitions */
						EmisLines[ipISO][nelem][ipHi][ipLo].ipCont = -1;
					}
				}
			}
		}
	}

	/* co carbon monoxide line array */
	for( i=0; i < nCORotate; i++ )
	{
		/* excitation energy of transition in degrees kelvin */
		C12O16Rotate[i].EnergyK = 
			(float)(T1CM)*C12O16Rotate[i].EnergyWN;
		C13O16Rotate[i].EnergyK = 
			(float)(T1CM)*C13O16Rotate[i].EnergyWN;

		/* energy of photon in ergs */
		C12O16Rotate[i].EnergyErg = 
			(float)(ERG1CM)*C12O16Rotate[i].EnergyWN;
		C13O16Rotate[i].EnergyErg = 
			(float)(ERG1CM)*C13O16Rotate[i].EnergyWN;

		/* put null terminated line label into chLab using line array*/
		chIonLbl(chLab, &C12O16Rotate[i]);
		chIonLbl(chLab, &C13O16Rotate[i]);

		C12O16Rotate[i].ipCont = 
			(int)ipLineEnergy(C12O16Rotate[i].EnergyWN * WAVNRYD, "12CO" ,0);
		C13O16Rotate[i].ipCont = 
			(int)ipLineEnergy(C13O16Rotate[i].EnergyWN * WAVNRYD, "13CO" ,0);

		if( C12O16Rotate[i].gf > 0. )
		{
			/* the gf value was entered
			 * derive the A, call to function is gf, wl (A), g_up */
			C12O16Rotate[i].Aul = 
				(float)(eina(C12O16Rotate[i].gf,
			  C12O16Rotate[i].EnergyWN,C12O16Rotate[i].gHi));
		}
		else if( C12O16Rotate[i].Aul > 0. )
		{
			/* the Einstion A value was entered
			 * derive the gf, call to function is A, wl (A), g_up */
			C12O16Rotate[i].gf = 
				(float)(GetGF(C12O16Rotate[i].Aul,
			  C12O16Rotate[i].EnergyWN,C12O16Rotate[i].gHi));
		}
		else
		{
			fprintf( ioQQQ, " 12CO line does not have valid gf or A\n" );
			fprintf( ioQQQ, " This is ContCreatePointers\n" );
			puts( "[Stop in ContCreatePointers]" );
			cdEXIT(EXIT_FAILURE);
		}
		if( C13O16Rotate[i].gf > 0. )
		{
			/* the gf value was entered
			 * derive the A, call to function is gf, wl (A), g_up */
			C13O16Rotate[i].Aul = 
				(float)(eina(C13O16Rotate[i].gf,
			  C13O16Rotate[i].EnergyWN,C13O16Rotate[i].gHi));
		}
		else if( C13O16Rotate[i].Aul > 0. )
		{
			/* the Einstion A value was entered
			 * derive the gf, call to function is A, wl (A), g_up */
			C13O16Rotate[i].gf = 
				(float)(GetGF(C13O16Rotate[i].Aul,
			  C13O16Rotate[i].EnergyWN,C13O16Rotate[i].gHi));
		}
		else
		{
			fprintf( ioQQQ, " 13CO line does not have valid gf or A\n" );
			fprintf( ioQQQ, " This is ContCreatePointers\n" );
			puts( "[Stop in ContCreatePointers]" );
			cdEXIT(EXIT_FAILURE);
		}

		/*line wavelength must be gt 0 */
		ASSERT( C12O16Rotate[i].WLAng > 0 );
		ASSERT( C13O16Rotate[i].WLAng > 0 );

		C12O16Rotate[i].damprel = 
			(float)(C12O16Rotate[i].Aul*
		  C12O16Rotate[i].WLAng*1e-8/PI4);
		C12O16Rotate[i].damp = C12O16Rotate[i].damprel / 1e5f;

		C13O16Rotate[i].damprel = 
			(float)(C13O16Rotate[i].Aul*
		  C13O16Rotate[i].WLAng*1e-8/PI4);
		C13O16Rotate[i].damp = C13O16Rotate[i].damprel / 1e5f;

		/* derive the abs coef, call to function is gf, wl (A), g_low */
		C12O16Rotate[i].opacity = 
			(float)(abscf(C12O16Rotate[i].gf,
		  C12O16Rotate[i].EnergyWN,C12O16Rotate[i].gLo));
		C13O16Rotate[i].opacity = 
			(float)(abscf(C13O16Rotate[i].gf,
		  C13O16Rotate[i].EnergyWN,C13O16Rotate[i].gLo));
	}

	/* level 2 heavy element lines */
	for( i=0; i < nWindLine; i++ )
	{

		/* derive the A, call to function is gf, wl (A), g_up */
		TauLine2[i].Aul = 
			(float)(eina(TauLine2[i].gf,
		  TauLine2[i].EnergyWN,TauLine2[i].gHi));

		/* coef needed for damping constant */
		TauLine2[i].damprel = 
			(float)(TauLine2[i].Aul*
		  TauLine2[i].WLAng*1e-8/PI4);
		TauLine2[i].damp = TauLine2[i].damprel / 1e5f;

		/* derive the abs coef, call to function is gf, wl (A), g_low */
		TauLine2[i].opacity = 
			(float)(abscf(TauLine2[i].gf,
		  TauLine2[i].EnergyWN,TauLine2[i].gLo));

		/* excitation energy of transition in degrees kelvin */
		TauLine2[i].EnergyK = 
			(float)(T1CM*TauLine2[i].EnergyWN);

		/* energy of photon in ergs */
		TauLine2[i].EnergyErg = 
			(float)(ERG1CM*TauLine2[i].EnergyWN);

		/* put null terminated line label into chLab using line array*/
		chIonLbl(chLab, &TauLine2[i]);

		/* get pointer to energy in continuum mesh */
		TauLine2[i].ipCont = (int)ipLineEnergy(TauLine2[i].EnergyWN * WAVNRYD , chLab,0 );
		/*if( TauLine2[i].ipCont==751 )
			fprintf(ioQQQ,"( level2 %s\n", chLab);*/
	}

	/* hyperfine structure lines */
	for( i=0; i < nHFLines; i++ )
	{
		/* derive the A, call to function is gf, wl (A), g_up */
		HFLines[i].Aul = 
			(float)(eina(HFLines[i].gf,
		  HFLines[i].EnergyWN,HFLines[i].gHi));

		/* coef needed for damping constant */
		HFLines[i].damprel = 
			(float)(HFLines[i].Aul*
		  HFLines[i].WLAng*1e-8/PI4);
		HFLines[i].damp = HFLines[i].damprel / 1e5f;

		/* derive the abs coef, call to function is gf, wl (A), g_low */
		HFLines[i].opacity = 
			(float)(abscf(HFLines[i].gf,
		  HFLines[i].EnergyWN,HFLines[i].gLo));
		/* gf from this and 21 cm do not agree, A for HFS is 10x larger than level1 dat */
		/*fprintf(ioQQQ,"HFLinesss\t%li\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\n",
			i,HFLines[i].opacity , HFLines[i].gf , HFLines[i].Aul , HFLines[i].EnergyWN,HFLines[i].gLo);*/

		/* excitation energy of transition in degrees kelvin */
		HFLines[i].EnergyK = 
			(float)(T1CM*HFLines[i].EnergyWN);

		/* energy of photon in ergs */
		HFLines[i].EnergyErg = 
			(float)(ERG1CM*HFLines[i].EnergyWN);

		/* put null terminated line label into chLab using line array*/
		chIonLbl(chLab, &HFLines[i]);

		/* get pointer to energy in continuum mesh */
		HFLines[i].ipCont = (int)ipLineEnergy(HFLines[i].EnergyWN * WAVNRYD , chLab,0 );
		/*if( HFLines[i].ipCont==751 )
			fprintf(ioQQQ,"( level2 %s\n", chLab);*/
	}


	/* Verner's FeII lines - do first so following labels will over write this
	 * only call if large feii atom is turned on */
	if( FeII.lgFeIION )
	{
		FeIIPoint();
	}

	/* ================================================================================== */
	/*        two photon two-photon 2-nu 2 nu 2 photon 2-photon                           */

	/* >>chng 01 jan 27, add iso-electronic dimension to following vectors */
	/* for induced two photon emission we need mirror image set
	 * of continuum indices for continuum between Lya and helf Lya */
	/* first MALLOC LIMELM dimension of space */
	if( (hydro.ipSymHy2nu = (long ***)MALLOC(sizeof(long *)*(unsigned)2 ) )==NULL )
	{
		fprintf( ioQQQ, 
			" ContCreatePointers could not MALLOC hydro.ipHy2nu 0\n" );
		puts( "[Stop in ContCreatePointers]" );
		cdEXIT(EXIT_FAILURE);
	}
	if( (hydro.AsHy2nu = (float ***)MALLOC(sizeof(float *)*(unsigned)2 ) )==NULL )
	{
		fprintf( ioQQQ, 
			" ContCreatePointers could not MALLOC hydro.AsHy2nu 0\n" );
		puts( "[Stop in ContCreatePointers]" );
		cdEXIT(EXIT_FAILURE);
	}
	/* now loop over the two iso-sequences with two photon continua */
	for( ipISO=0; ipISO<2; ++ipISO )
	{
		if( (hydro.ipSymHy2nu[ipISO] = (long **)MALLOC(sizeof(long *)*(unsigned)LIMELM ) )==NULL )
		{
			fprintf( ioQQQ, 
				" ContCreatePointers could not MALLOC hydro.ipHy2nu 1\n" );
			puts( "[Stop in ContCreatePointers]" );
			cdEXIT(EXIT_FAILURE);
		}
		if( (hydro.AsHy2nu[ipISO] = (float **)MALLOC(sizeof(float *)*(unsigned)LIMELM ) )==NULL )
		{
			fprintf( ioQQQ, 
				" ContCreatePointers could not MALLOC hydro.AsHy2nu 1\n" );
			puts( "[Stop in ContCreatePointers]" );
			cdEXIT(EXIT_FAILURE);
		}
	}

	/* set up two photon emission for the h-like */
	ipISO = ipHYDROGEN;
	for( nelem=0; nelem<LIMELM; ++nelem )
	{
		if( abundances.lgElmtOn[nelem] )
		{
			double eLa = 0.75*(1.+nelem)*(1.+nelem);
			/* >>chng 01 sep 18, from charge^4 to charge^6 */
			double charge6 = (1.+nelem)*(1.+nelem)*(1.+nelem)*(1.+nelem)*(1.+nelem)*(1.+nelem);

			/* half the energy of La */
			hydro.ipHalfLya[ipISO][nelem] = ipoint(eLa / 2.);
			if( (hydro.ipSymHy2nu[ipISO][nelem] = (long *)MALLOC(sizeof(long)*(unsigned)hydro.ipHalfLya[ipISO][nelem] ) )==NULL )
				bad_malloc();

			for( i=0; i < hydro.ipHalfLya[ipISO][nelem]; i++ )
			{
				/* energy is symmetric energy, the other side of half lya */
				energy = eLa - rfield.anu[i];
				/* find index for this symmetric energy */
				hydro.ipSymHy2nu[ipISO][nelem][i] = ipoint(energy);
				/* >>chng 00 dec 15, do not include Lya itself in the blue end of the integral,
				 * because resulting rates are far too large */
				hydro.ipSymHy2nu[ipISO][nelem][i] = MIN2( EmisLines[ipH_LIKE][nelem][ipH2p][ipH1s].ipCont-1, hydro.ipSymHy2nu[ipISO][nelem][i]);
			}

			/* hydrogen two photon emission 
			 * ipCont-1 is the cell holding Lya itself, and we do not want
			 * to include that in the following sum */
			limit = EmisLines[ipH_LIKE][nelem][ipH2p][ipH1s].ipCont-1;
			if( (hydro.AsHy2nu[ipISO][nelem] = (float *)MALLOC(sizeof(float)*(unsigned)limit ) )==NULL )
				bad_malloc();

			for( i=0; i < limit; i++ )
			{
				/* the factor of widflx is not a mistake - when used for induced two-photon
				 * emission the sum will only go up to half of Lya, so only one factor
				 * of widflx will ever appear in the sum */
				/* the energy argument to eva2nu is because that routine works for H itself,
				 * and this reposes the energy scale to one relative to H */
				/* this AsHy2nu function will integrate up to the spontaneous rate if the
				 * integral goes from 0 to half of La, since it includes both of the produced photons,
				 * factor of two forces integral from 0 to half La, to be Aul */
				/* units returned by eva2nu are those used by Spitzer & Greenstein,
				 * and integrate up correctly when the integral is from 0 to 0.75 */
				/* >>chng 01 sep 16, the division by the energy of the line converts the
				 * integral over photon energy, which will be to eLa, to on equivalent to
				 * one to unity, as done in Spitzer & Greenstein */
				xnew = eva2nu(0.75/eLa*rfield.AnuOrg[i])/eLa;
				/* this will add up to the A if multiplied by TWO_PHOT_CONST=2.183134,
				 * the set of atomic constants appearing to the left of the right hand
				 * integral in equation 4 of Spitzer & Greenstein */
				/* >>refer	HI	2nu	Spitzer, L., & Greenstein, J., 1951, ApJ, 114, 407 */
				hydro.AsHy2nu[ipISO][nelem][i] = (float)(xnew*rfield.widflx[i]*charge6);
			}
		}
	}

	/* this loop is only for the helium-like sequence */
	ipISO = ipHELIUM;
	for( nelem=1; nelem<LIMELM; ++nelem )
	{
		if( abundances.lgElmtOn[nelem] )
		{
			double eLa =EmisLines[ipHE_LIKE][nelem][ipHe2s1S][ipHe1s1S].EnergyWN * WAVNRYD;

			double charge4 = (1.+nelem)*(1.+nelem)*(1.+nelem)*(1.+nelem);
			/* half the energy of La */
			hydro.ipHalfLya[ipISO][nelem] = ipoint(eLa / 2.);
			if( (hydro.ipSymHy2nu[ipISO][nelem] = (long *)MALLOC(sizeof(long)*(unsigned)hydro.ipHalfLya[ipISO][nelem] ) )==NULL )
				bad_malloc();

			/* ipCont is -1 for this two -photon continuum, must get index here */
			limit = ipLineEnergy(EmisLines[ipHE_LIKE][nelem][ipHe2s1S][ipHe1s1S].EnergyWN * WAVNRYD,"2 nu",0) - 1;

			for( i=0; i < hydro.ipHalfLya[ipISO][nelem]; i++ )
			{
				/* energy is symmetric energy, the other side of half lya */
				energy = eLa - rfield.anu[i];
				/* find index for this symmetric energy */
				hydro.ipSymHy2nu[ipISO][nelem][i] = ipoint(energy);
				/* >>chng 00 dec 15, do not include Lya itself in the blue end of the integral,
				 * because resulting rates are far too large */
				hydro.ipSymHy2nu[ipISO][nelem][i] = MIN2( limit , hydro.ipSymHy2nu[ipISO][nelem][i]);
			}

			/* hydrogen two photon emission 
			 * ipCont-1 is the cell holding Lya itself, and we do not want
			 * to include that in the following sum */
			/* this is the helium like iso sequence loop, so following is correct but ugly */
			if( (hydro.AsHy2nu[ipISO][nelem] = (float *)MALLOC(sizeof(float)*(unsigned)limit ) )==NULL )
				bad_malloc();

			for( i=0; i < limit; i++ )
			{
				/* the factor of widflx is not a mistake - when used for induced two-photon
				 * emission the sum will only go up to half of Lya, so only one factor
				 * of widflx will ever appear in the sum */
				/* the energy argument to eva2nu is because that routine works for H itself,
				 * and this reposes the energy scale to one relative to H */
				/* this AsHy2nu function will integrate up to the spontaneous rate if the
				 * integral goes from 0 to half of La, since it includes both of the produced photons,
				 * factor of two forces integral from 0 to half La, to be Aul */
				/* >>chng 00 aug 22, added fac */
				/* ratio of hei to h two-photon A's */
				double fac = 51./8.23;
				xnew = eva2nu(0.75*rfield.AnuOrg[i]/eLa)*2.*fac;
				hydro.AsHy2nu[ipISO][nelem][i] = (float)(xnew*rfield.widflx[i]*charge4);
			}
		}
	}
	{
		/* this is an option to print out one of the two photon continua */
		/*@-redef@*/
		enum {DEBUG=FALSE};
		/*@+redef@*/
		if( DEBUG )
		{	
#			define	NCRS	21
			double ener[NCRS]={
			  0.,     0.03738,  0.07506,  0.1124,  0.1498,  0.1875,
			  0.225,  0.263,    0.300,    0.3373,  0.375,   0.4127,
			  0.4500, 0.487,    0.525,    0.5625,  0.6002,  0.6376,
			  0.6749, 0.7126,   0.75};

			nelem = ipHYDROGEN;
			ipISO = ipHYDROGEN;
			limit = EmisLines[ipH_LIKE][nelem][ipH2p][ipH1s].ipCont-1;

			for( i=0; i < NCRS; i++ )
			{
				fprintf(ioQQQ,"%.3e\t%.3e\n", ener[i] , eva2nu(ener[i]) );
			}

			xnew = 0.;
			for( i=0; i < limit; i++ )
			{
				double fach = hydro.AsHy2nu[ipISO][nelem][i]/2.*rfield.anu2[i]/rfield.widflx[i]*EN1RYD;
				fprintf(ioQQQ,"%.3e\t%.3e\t%.3e\n", 
					rfield.anu[i] , 
					hydro.AsHy2nu[ipISO][nelem][i] / rfield.widflx[i] , 
					fach );
				xnew += hydro.AsHy2nu[ipISO][nelem][i];
			}
			fprintf(ioQQQ," sum is %.3e\n", xnew*TWO_PHOT_CONST );
			puts( "[Stop in ContCreatePointers]" );
			cdEXIT(EXIT_FAILURE);
		}
	}

	if( (helike.he12nu = (float *)MALLOC(sizeof(double)*(size_t)rfield.nupper ) )==NULL )
		bad_malloc();
	/* HeI two photon emission */
	for( i=0; i < iphe1lCom.iphe1l[0][1]; i++ )
	{
		/* >>chng 00 aug 22, added fac */
		/* ratio of hei to h two-photon A's */
		double fac = 51./8.23;
		helike.he12nu[i] = (float)(ehe12p(rfield.AnuOrg[i])*rfield.widflx[i]*fac );
	}

	/* ================================================================================== */

	/* option to print out whole thing with "trace lines" command */
	if( trace.lgTrLine )
	{
		fprintf( ioQQQ, "       WL(Ang)   E(RYD)   IP   gl  gu      gf       A        damp     abs K\n" );
		for( i=1; i <= nLevel1; i++ )
		{
			strcpy( chLab, chLineLbl(&TauLines[i]) );
			iWL_Ang = (long)TauLines[i].WLAng;
			if( iWL_Ang > 1000000 )
			{
				iWL_Ang /= 10000;
			}
			else if( iWL_Ang > 10000 )
			{
				iWL_Ang /= 1000;
			}

			fprintf( ioQQQ, " %10.10s%5ld%10.3e %4i%4ld%4ld%10.2e%10.2e%10.2e%10.2e\n", 
			  chLab, iWL_Ang, RYDLAM/TauLines[i].WLAng, 
			  TauLines[i].ipCont, (long)(TauLines[i].gLo), 
			  (long)(TauLines[i].gHi), TauLines[i].gf, 
			  TauLines[i].Aul, TauLines[i].damprel, 
			  TauLines[i].opacity );
		}

		/* C12O16 lines */
		for( i=0; i < nCORotate; i++ )
		{
			strcpy( chLab, chLineLbl(&C12O16Rotate[i]) );

			iWL_Ang = (long)C12O16Rotate[i].WLAng;

			if( iWL_Ang > 1000000 )
			{
				iWL_Ang /= 10000;
			}
			else if( iWL_Ang > 10000 )
			{
				iWL_Ang /= 1000;
			}
			fprintf( ioQQQ, " %10.10s%5ld%10.3e %4i%4ld%4ld%10.2e%10.2e%10.2e%10.2e\n", 
			  chLab, iWL_Ang, RYDLAM/C12O16Rotate[i].WLAng, 
			  C12O16Rotate[i].ipCont, (long)(C12O16Rotate[i].gLo), 
			  (long)(C12O16Rotate[i].gHi), C12O16Rotate[i].gf, 
			  C12O16Rotate[i].Aul, C12O16Rotate[i].damprel, 
			  C12O16Rotate[i].opacity );
		}

		/* C13O16 lines */
		for( i=0; i < nCORotate; i++ )
		{
			strcpy( chLab, chLineLbl(&C13O16Rotate[i]) );

			iWL_Ang = (long)C13O16Rotate[i].WLAng;

			if( iWL_Ang > 1000000 )
			{
				iWL_Ang /= 10000;
			}
			else if( iWL_Ang > 10000 )
			{
				iWL_Ang /= 1000;
			}
			fprintf( ioQQQ, " %10.10s%5ld%10.3e %4i%4ld%4ld%10.2e%10.2e%10.2e%10.2e\n", 
			  chLab, iWL_Ang, RYDLAM/C13O16Rotate[i].WLAng, 
			  C13O16Rotate[i].ipCont, (long)(C13O16Rotate[i].gLo), 
			  (long)(C13O16Rotate[i].gHi), C13O16Rotate[i].gf, 
			  C13O16Rotate[i].Aul, C13O16Rotate[i].damprel, 
			  C13O16Rotate[i].opacity );
		}

		for( i=0; i < nWindLine; i++ )
		{
			strcpy( chLab, chLineLbl(&TauLine2[i]) );

			iWL_Ang = (long)TauLine2[i].WLAng;

			if( iWL_Ang > 1000000 )
			{
				iWL_Ang /= 10000;
			}
			else if( iWL_Ang > 10000 )
			{
				iWL_Ang /= 1000;
			}
			fprintf( ioQQQ, " %10.10s%5ld%10.3e %4i%4ld%4ld%10.2e%10.2e%10.2e%10.2e\n", 
			  chLab, iWL_Ang, RYDLAM/TauLine2[i].WLAng, 
			  TauLine2[i].ipCont, (long)(TauLine2[i].gLo), 
			  (long)(TauLine2[i].gHi), TauLine2[i].gf, 
			  TauLine2[i].Aul, TauLine2[i].damprel, 
			  TauLine2[i].opacity );
		}
		for( i=0; i < nHFLines; i++ )
		{
			strcpy( chLab, chLineLbl(&HFLines[i]) );

			iWL_Ang = (long)HFLines[i].WLAng;

			if( iWL_Ang > 1000000 )
			{
				iWL_Ang /= 10000;
			}
			else if( iWL_Ang > 10000 )
			{
				iWL_Ang /= 1000;
			}
			fprintf( ioQQQ, " %10.10s%5ld%10.3e %4i%4ld%4ld%10.2e%10.2e%10.2e%10.2e\n", 
			  chLab, iWL_Ang, RYDLAM/HFLines[i].WLAng, 
			  HFLines[i].ipCont, (long)(HFLines[i].gLo), 
			  (long)(HFLines[i].gHi), HFLines[i].gf, 
			  HFLines[i].Aul, HFLines[i].damprel, 
			  HFLines[i].opacity );
		}
	}

	/* this is an option to kill fine structure line optical depths */
	if( !rt.lgFstOn )
	{
		for( i=1; i <= nLevel1; i++ )
		{
			if( TauLines[i].EnergyWN < 10000. )
			{
				TauLines[i].opacity = 0.;
			}
		}
	}

#	ifdef DEBUG_FUN
	fputs( " <->ContCreatePointers()\n", debug_fp );
#	endif
	return;
}

/*fiddle adjust energy bounds of cell with index ipnt so that lower energy
 * matchs ionization edges exactly, called by createpoint */
/* ipnt is index on c scale */
static void fiddle(long int ipnt, 
  double exact)
{
	float Ehi, 
	  Elo,
	  OldEner ;

#	ifdef DEBUG_FUN
	fputs( "<+>fiddle()\n", debug_fp );
#	endif

	/* make low edge of cell exact for photo integrals */
	ASSERT( ipnt >= 0 );
	ASSERT( ipnt < rfield.nupper-1 );

	/* upper edge of higher cell*/
	Ehi = rfield.anu[ipnt] + rfield.widflx[ipnt]*0.5f;
	/* lower edge of lower cell */
	Elo = rfield.anu[ipnt-1] - rfield.widflx[ipnt-1]*0.5f;

	OldEner = rfield.anu[ipnt];

	/* centroid of desired lower energy and upper edge */
	rfield.anu[ipnt] = (float)((Ehi + exact)/2.);
	/* same for lower */
	rfield.anu[ipnt-1] = (float)((exact + Elo)/2.);

	rfield.widflx[ipnt] = (float)(Ehi - exact);
	rfield.widflx[ipnt-1] = (float)(exact - Elo);

	/* bring upper cell down a bit too, since we dont want large change in widflx */
	rfield.anu[ipnt+1] -= (OldEner - rfield.anu[ipnt])/2.f;

	/* sanity check */
	ASSERT( rfield.widflx[ipnt-1] > 0. );
	ASSERT( rfield.widflx[ipnt] > 0. );

#	ifdef DEBUG_FUN
	fputs( " <->fiddle()\n", debug_fp );
#	endif
	return;
}


/*eina convert a gf into an Einstein A */
static double eina(double gf, 
	  double enercm, 
	  double gup)
{
	double eina_v;

#	ifdef DEBUG_FUN
	fputs( "<+>eina()\n", debug_fp );
#	endif

	/* derive the transition prob, given the following
	 * call to function is gf, ener in cm^-1, g_up
	 * gf is product of g and oscilator strength
	 * eina = ( gf / 1.499e-8 ) / (wl/1e4)**2 / gup  */
	eina_v = (gf/gup)/1.4992e-8/POW2(1e4/enercm);


#	ifdef DEBUG_FUN
	fputs( " <->eina()\n", debug_fp );
#	endif
	return( eina_v );
}
