/*ContCreatePointers create pointers for lines and continua, one time per coreload */
void ContCreatePointers(void);

/*ContSetIntensity derive intensity of incident continuum */
void ContSetIntensity(int *lgOK);

/* set up continuum energy mesh if first call, otherwise reset to original mesh */
void ContCreateMesh(void);

EXTERN struct t_continuum {
	/* this is information needed to set the energy binning,
	 * full continuum is described by series of ranges where resolution is
	 * constant over that range */
	float *filbnd, 

	  *fildel, 

	  *filres;

	long int *ifill0, 
	  /*number of ranges entered for this continuum source*/
	  nrange; 

	/* each of these is the upper bound of an energy band,
	 * the first lowest bound is the low-energy limit of the code */
	double *StoredEnergy,
		/* the resolution, dE/E for each band */
		*StoredResolution;

	/* the number of bands read in */
	long int nStoredBands;

	/* factor to reset continuum resolution set in continuum_mesh.dat,
	 * default is unity, reset with set resolution command */
	double ResolutionScaleFactor;

	}	continuum;
