/*ContSetIntensity derive intensity of incident continuum */
/*extin do extinction of incident continuum as set by extinguish command */
/*sumcon sums L and Q for net incident continuum */
/*ptrcer show continuum pointers in real time following drive pointers command */
#include "cddefines.h"
#include "iso.h"
#include "physconst.h"
#include "nhe1lvl.h"
#include "nhe3lvl.h"
#include "ionfracs.h"
#include "extinc.h"
#include "egray.h"
#include "prhd.h"
#include "noexec.h"
#include "smbeta.h"
#include "ionrec.h"
#include "hextra.h"
#include "trace.h"
#include "pmp2s.h"
#include "heavy.h"
#include "rfield.h"
#include "he.h"
#include "phycon.h"
#include "called.h"
#include "occ1hi.h"
#include "hydrogenic.h"
#include "phe1lv.h"
#include "habing.h"
#include "tenden.h"
#include "timesc.h"
#include "totlum.h"
#include "neutrn.h"
#include "occmax.h"
#include "con0.h"
#include "nhe1.h"
#include "plasnu.h"
#include "bit32.h"
#include "hionrad.h"
#include "secondaries.h"
#include "abundances.h"
#include "opacity.h"
#include "he3n.h"
#include "thermal.h"
#include "ffun.h"
#include "ipoint.h"
#include "cfit.h"
#include "hydro_vs_rates.h"
#include "tfidle.h"
#include "rt.h"
#include "nsset.h"
#include "pressure.h"
#include "conorm.h"
#include "continuum.h"

/*sumcon sums L and Q for net incident continuum */
static void sumcon(long int il, 
  long int ih, 
  float *q, 
  float *p, 
  float *panu);

/*extin do extinction of incident continuum as set by extinguish command */
static void extin(float *ex1ryd);

/*ptrcer show continuum pointers in real time following drive pointers command */
static void ptrcer(void);

void ContSetIntensity(int *lgOK)
{
	int lgCheckOK;

	long int i, 
	  ip, 
	  j, 
	  n;

	float EdenHeav, 
	  ex1ryd, 
	  factor, 
	  occ1, 
	  p, 
	  p1, 
	  p2, 
	  p3, 
	  p4, 
	  p5, 
	  p6, 
	  p7, 
	  pgn, 
	  phe, 
	  pheii, 
	  qgn, 
	  temp;

	float xIoniz;

	double rec,
	  wanu[4],
	  alf, 
	  bet, 
	  fntest, 
	  fsum, 
	  ecrit, 
	  tcompr, 
	  tcomp, 
	  r2ov1, 
	  r3ov2;

	static double aweigh[4], 
	  fweigh[4];

	double amean, 
	  amean2, 
	  amean3, 
	  peak, 
	  wfun[4];

	static int _aini = 1;
	if( _aini )
	{ /* Do 1 TIME INITIALIZATIONS! */
		aweigh[0] = -0.4305682;
		aweigh[1] = -0.1699905;
		aweigh[2] = 0.1699905;
		aweigh[3] = 0.4305682;
		fweigh[0] = 0.1739274;
		fweigh[1] = 0.3260726;
		fweigh[2] = 0.3260726;
		fweigh[3] = 0.1739274;
		_aini = 0;
	}

#	ifdef DEBUG_FUN
	fputs( "<+>ContSetIntensity()\n", debug_fp );
#	endif

	/* set continuum */
	if( trace.lgTrace )
	{
		fprintf( ioQQQ, " ContSetIntensity called.\n" );
	}

	/* find normalization factors for the continua */
	conorm();

	/* define factors to convert rfeld.flux array into photon occupation array OCCNUM
	 * by multiplication */
	factor = (float)(EN1RYD/PI4/FR1RYD/HNU3C2);

	/*------------------------------------------------------------- */
	lgCheckOK = TRUE;
	for( i=0; i < rfield.nupper; i++ )
	{
		/* this was original anu array with no continuum averaging */
		rfield.anu[i] = rfield.AnuOrg[i];
		rfield.ContBoltz[i] = 0.;
		fsum = 0.;
		amean = 0.;
		amean2 = 0.;
		amean3 = 0.;

		for( j=0; j < 4; j++ )
		{
			wanu[j] = rfield.anu[i] + rfield.widflx[i]*aweigh[j];
			wfun[j] = fweigh[j]*ffun(wanu[j]);
			fsum += wfun[j];
			amean += wanu[j]*wfun[j];
			amean2 += wanu[j]*wanu[j]*wfun[j];
			amean3 += wanu[j]*wanu[j]*wanu[j]*wfun[j];
		}

		rfield.flux[i] = (float)(fsum*rfield.widflx[i]);
		if( rfield.flux[i] > 0. )
		{
			rfield.anu[i] = (float)(amean2/amean);
			rfield.anu2[i] = (float)(amean3/amean);
			/* fix conversion factor for occupation number */
		}

		else if( rfield.flux[i] == 0. )
		{
			rfield.anu2[i] = rfield.anu[i]*rfield.anu[i];
		}

		else
		{
			rfield.anu2[i] = rfield.anu[i]*rfield.anu[i];
			fprintf( ioQQQ, " negative continuum returned at%6ld%10.2e%10.2e\n", 
			  i, rfield.anu[i], rfield.flux[i] );
			lgCheckOK = FALSE;
		}
		rfield.anu3[i] = rfield.anu2[i]*rfield.anu[i];

		rfield.ConEmitReflec[i] = 0.;
		rfield.ConEmitOut[i] = 0.;
		rfield.convoc[i] = factor/rfield.widflx[i]/rfield.anu2[i];

		/* following are Compton exchange factors from Tarter */
		alf = 1./(1. + rfield.anu[i]*(1.1792e-4 + 7.084e-10*rfield.anu[i]));
		bet = 1. - alf*rfield.anu[i]*(1.1792e-4 + 2.*7.084e-10*rfield.anu[i])/
		  4.;
		rfield.csigh[i] = (float)(alf*rfield.anu2[i]*3.858e-25);
		rfield.csigc[i] = (float)(alf*bet*rfield.anu[i]*3.858e-25);
	}

#if 0
	/* commented out since we must conserve energy, and continuum was set with old widflx */
	/* now fix widflx array so that it is correct */
	for( i=1; i<rfield.nupper-1; ++i )
	{
		/*rfield.widflx[i] = rfield.anu[i+1] - rfield.anu[i];*/
		rfield.widflx[i] = ((rfield.anu[i+1] - rfield.anu[i]) + (rfield.anu[i] - rfield.anu[i-1]))/2.f;
	}
#endif

	if( !lgCheckOK )
	{
		ShowMe();
		puts( "[Stop in ContSetIntensity]" );
		cdEXIT(EXIT_FAILURE);
	}

	if( trace.lgTrace && trace.lgComBug )
	{
		fprintf( ioQQQ, "\n\n Compton heating, cooling coefficients \n" );
		for( i=0; i < rfield.nupper; i += 2 )
		{
			fprintf( ioQQQ, "%6ld%10.2e%10.2e%10.2e", i, rfield.anu[i], 
			  rfield.csigh[i], rfield.csigc[i] );
		}
		fprintf( ioQQQ, "\n" );
	}

	/* option to check frequencies in real time, drive pointers command,
	 * routine is below, is file static */
	if( trace.lgPtrace )
		ptrcer();

	for( i=0; i < rfield.nupper; i++ )
	{
		/* define array of LOG10( nu(ryd)) */
		rfield.anulog[i] = (float)log10(rfield.anu[i]);
	}

	/* extinguish continuum if set on */
	extin(&ex1ryd);

	/* now find peak of hydrogen ionizing continuum - for PDR calculations
	 * this will remain equal to 1 since the loop will not execute */
	prhd.ipeak = 1;
	peak = 0.;

	for( i=iso.ipIsoLevNIonCon[ipH_LIKE][ipHYDROGEN][ipH1s]-1; i < rfield.nupper; i++ )
	{
		if( rfield.flux[i]*rfield.anu[i]/rfield.widflx[i] > (float)peak )
		{
			/* prhd.ipeak points to largest f_nu at H-ionizing energies
			 * and is passed to other parts of code */
			/* i+1 to keep ipeak on fortran version of energy array */
			prhd.ipeak = i+1;
			peak = rfield.flux[i]*rfield.anu[i]/rfield.widflx[i];
		}
	}

	/* say what type of cpu this is, if desired */
	if( trace.lgTrace )
	{
		fprintf( ioQQQ, " ContSetIntensity: The peak of the H-ion continuum is at%10.3e\n", 
		  rfield.anu[prhd.ipeak-1] );
		if( bit32.lgBit32 )
		{
			fprintf( ioQQQ, " ContSetIntensity: this is a 32-bit cpu.\n" );
		}
		else
		{
			fprintf( ioQQQ, " ContSetIntensity: this is a long-word cpu.\n" );
		}
	}

	/* find highest energy to consider in continuum flux array
	 * peak is the peak product nu*flux */
	peak = rfield.flux[prhd.ipeak-1]/rfield.widflx[prhd.ipeak-1]*
	  rfield.anu2[prhd.ipeak-1];

	if( peak > 1e38 && bit32.lgBit32 )
	{
		fprintf( ioQQQ, " ContSetIntensity: this appears to be a 32-bit cpu.\n" );
		fprintf( ioQQQ, " The continuum is too intense to compute with this cpu.  Use a long-word cpu or a fainter continuum. (This is the nu*f_nu test)\n" );
		fprintf( ioQQQ, " Sorry.\n" );
		puts( "[Stop in ContSetIntensity]" );
		cdEXIT(EXIT_FAILURE);
	}

	/* FluxFaint set in zero.c; normally 1e-10 */
	/* this will be faiintest level of continuum we want to consider.
	 * peak was set above, is peak of hydrogen ionizing radiation field, 
	 * and is zero if no H-ionizing radiation */
	fntest = peak*rfield.FluxFaint;
	{
		/*@-redef@*/
		enum {DEBUG=FALSE};
		/*@+redef@*/
		/* print flux array then quit */
		if( DEBUG )
		{
			for( i=0; i<rfield.nupper; ++i )
			{
				fprintf(ioQQQ," consetintensityBUGGG\t%.2e\t%.2e\n" , 
					rfield.anu[i] , rfield.flux[i]/rfield.widflx[i] );
			}
			cdEXIT(EXIT_SUCCESS);
		}
	}

	if( fntest > 0. )
	{
		/* this test is not done in pdr conditions where NO H-ionizing radiation,
		 * since fntest is zero*/
		i = rfield.nupper;
		while( i > prhd.ipeak && 
			rfield.flux[i-1]*rfield.anu2[i-1]/rfield.widflx[i-1] < (float)fntest )
		{
			--i;
		}
	}
	else
	{
		/* when no H-ionizing radiation set to Lyman edge */
		i = iso.ipIsoLevNIonCon[ipH_LIKE][0][ipH1s];
	}

	/* 
	 * this line of code dates from 1979 and IOA Cambridge.  removed july 19 95
	 * I think it was the last line of the original Cambridge source
	   nflux = MAX( ineon(1)+4 , i )
	 */

	/* >>chng 99 apr 28, reinstate the rfield.FluxFaint limit with nflux */
	rfield.nflux = i;

	/* trim down nflux, was set to rfield.nupper, the dimension of all vectors, in zero.c,
	 * in ContCreatePointers was set to nupper, the number of cells needed to get up to the
	 * high energy limit of the code */
	while( rfield.flux[rfield.nflux-1] < SMALLFLOAT && rfield.nflux > 1 )
	{
		--rfield.nflux;
	}

	if( rfield.nflux == 1 )
	{
		fprintf( ioQQQ, " This incident continuum appears to have no radiation.\n" );
		fprintf( ioQQQ, " Sorry.\n" );
		puts( "[Stop in ContSetIntensity]" );
		cdEXIT(EXIT_FAILURE);
	}

	/* check that continuum defined everywhere - look for zero's and comment if present */
	con0.lgCon0 = FALSE;
	ip = 0;
	for( i=0; i < rfield.nflux; i++ )
	{
		if( rfield.flux[i] == 0. )
		{
			if( called.lgTalk && !con0.lgCon0 )
			{
				fprintf( ioQQQ, " Setcon: continuum has zero intensity starting at %11.4e Ryd.\n", 
				  rfield.anu[i] );
				con0.lgCon0 = TRUE;
			}
			ip += 1;
		}
	}

	if( con0.lgCon0 && called.lgTalk )
	{
		fprintf( ioQQQ, 
			"%6ld cells in the incident continuum have zero intensity.  Problems???\n", 
		  ip );
	}

	/*begin sanity check */
	lgCheckOK = TRUE;
	for( i=1; i < rfield.nflux; i++ )
	{
		if( rfield.flux[i] < 0. )
		{
			fprintf( ioQQQ, 
				" Continuum has negative intensity at%11.4e Ryd=%10.2e %4.4s %4.4s\n", 
			  rfield.anu[i], rfield.flux[i], rfield.chLineLabel[i]
			  , rfield.chContLabel[i] );
			lgCheckOK = FALSE;
		}
		else if( rfield.anu[i] <= rfield.anu[i-1] )
		{
			fprintf( ioQQQ, 
				" Continuum energies not in increasing order: energies follow\n" );
			fprintf( ioQQQ, 
				"%3ld %10.2e%3ld %10.2e%3ld %10.2e\n", 
			  i -1 , rfield.anu[i-1], i, rfield.anu[i], i +1, rfield.anu[i+1] );
			lgCheckOK = FALSE;
		}
	}

	if( !lgCheckOK )
	{
		ShowMe();
		puts( "[Stop in ContSetIntensity]" );
		cdEXIT(EXIT_FAILURE);
	}
	/*end sanity check */

	/* turn off recoil ionization if high energy < 190R */
	if( rfield.anu[rfield.nflux-1] <= 190 )
	{
		ionrec.lgCompRecoil = FALSE;
	}

	/* sum photons and energy, save mean */

	/* sum from low energy to Balmer edge */
	sumcon(1,iso.ipIsoLevNIonCon[ipH_LIKE][0][ipH2p]-1,&rfield.qrad,&prhd.pradio,&p1);

	/* sum over Balmer continuum */
	sumcon(iso.ipIsoLevNIonCon[ipH_LIKE][0][2],iso.ipIsoLevNIonCon[ipH_LIKE][0][ipH1s]-1,&rfield.qbal,&prhd.pbal,&p1);

	/* sum from Lyman edge to HeI edge */
	sumcon(iso.ipIsoLevNIonCon[ipH_LIKE][0][ipH1s],nhe1Com.nhe1[0]-1,&prhd.q,&p,&p2);

	/* sum from HeI to HeII edges */
	sumcon(nhe1Com.nhe1[0],iso.ipIsoLevNIonCon[ipH_LIKE][1][ipH1s]-1,&rfield.qhe,&phe,&p3);

	/* sum from Lyman edge to carbon k-shell */
	sumcon(iso.ipIsoLevNIonCon[ipH_LIKE][1][ipH1s],opac.ipCKshell-1,&rfield.qheii,&pheii,&p4);

	/* sum from c k-shell to gamma ray - where pairs start */
	sumcon( opac.ipCKshell , egray.ipEnerGammaRay-1 , &prhd.qx,
		&prhd.xpow ,  &p5);

	/* complete sum up to high energy limit */
	sumcon(egray.ipEnerGammaRay,rfield.nflux,&prhd.qgam,&prhd.GammaLumin, &p6);

	/* find to estimate photoerosion timescale */
	n = ipoint(7.35e5);
	sumcon(n,rfield.nflux,&qgn,&pgn,&p7);
	timesc.TimeErode = qgn;

	/* find Compton temp */
	tcompr = (p1 + p2 + p3 + p4 + p5 + p6)/(prhd.pradio + prhd.pbal + 
	  p + phe + pheii + prhd.xpow + prhd.GammaLumin);

	tcomp = tcompr/(4.*6.272e-6);

	if( trace.lgTrace )
	{
		fprintf( ioQQQ, 
			" mean photon energy=%10.3eR =%10.3eK low, high nu=%12.4e%12.4e\n", 
		  tcompr, tcomp, rfield.anu[0] - rfield.widflx[0]/2., rfield.anu[rfield.nflux-1] + 
		  rfield.widflx[rfield.nflux-1]/2. );
	}

	/* this is total power in ionizing radiation */
	prhd.powion = p + phe + pheii + prhd.xpow + prhd.GammaLumin;

	/* this is the total photon luminosity */
	totlum.TotalLumin = prhd.pradio + prhd.powion + prhd.pbal;

	/* this is placed into the line stack on the first zone, then
	 * reset to zero, to end up with luminosity in the emission lines array.
	 * at end of iteration it is reset to TotalLumin */
	totlum.totlsv = totlum.TotalLumin;

	/* total H-ionizing photon number, */
	rfield.qhtot = prhd.q + rfield.qhe + rfield.qheii + prhd.qx + prhd.qgam;

	/* ftotal photon number, all energies  */
	rfield.qtot = rfield.qhtot + rfield.qbal + rfield.qrad;

	if( prhd.powion <= 0. && called.lgTalk )
	{
		HionRad.lgHionRad = TRUE;
		fprintf( ioQQQ, " >>>>There is no hydrogen-ionizing radiation.<<<<\n" );
		fprintf( ioQQQ, " >>>>Was this intended?<<<<\n" );
		fprintf( ioQQQ, "  \n" );
		/* >>chng 97 mar 18, add following sanity check - stop if no Paschen
		 * ionizing radiaion since even metals will be totally neutral */
		sumcon(iso.ipIsoLevNIonCon[ipH_LIKE][0][3],iso.ipIsoLevNIonCon[ipH_LIKE][0][2]-1,&factor,&temp,&p1);
		if( factor <= 0. )
		{
			fprintf( ioQQQ, " >>>>There is no sodium-ionizing radiation.<<<<\n" );
			fprintf( ioQQQ, " >>>>This code is not approriate for these conditions.<<<<\n" );
			/* punch out before we crash */
			*lgOK = FALSE;
			
#			ifdef DEBUG_FUN
			fputs( " <->ContSetIntensity()\n", debug_fp );
#			endif
			return;
		}
	}

	else
	{
		HionRad.lgHionRad = FALSE;
	}

	/* option to add energy deposition due to fast neutrons, as frc of tot lum
	 * efficiency default is unity */
	if( neutrn.lgNeutrnHeatOn )
	{
		neutrn.totneu = (float)(neutrn.effneu*totlum.TotalLumin*pow(10.f,neutrn.frcneu));
	}
	else
	{
		neutrn.totneu = (float)0.;
	}

	/* temp correspond to energy density, printed in STARTR */
	tenden.TEnerDen = (float)pow(totlum.TotalLumin/SPEEDLIGHT/7.56464e-15,0.25);

	/* sanity check for single blackbody, that energy density temperature
	 * is smaller than black body temperature */
	if( rfield.nspec==1 && 
		strcmp( rfield.chSpType[rfield.nspec-1], "BLACK" )==0 )
	{
		/* single black body, now confirm that TEnerDen is less than this temperature,
		 * >>>chng 99 may 02,
		 * in lte these are very very close, factor of 1.00001 allows for numerical
		 * errors, and apparently slightly different atomic coef in different parts
		 * of code.  eventaully all mustuse physonst.h and agree exactly */
		if( tenden.TEnerDen > 1.0001f*rfield.slope[rfield.nspec-1] )
		{
			fprintf( ioQQQ,
				"\n WARNING:  The energy density temperature (%g) is greater than the"
				" black body temperature (%g).  This is unphysical.\n\n",
				tenden.TEnerDen , rfield.slope[rfield.nspec-1]);
		}
	}

	/* simple estimate of Hbeta flux if all phot go to H */
	smbeta.SimHBeta = (float)(rfield.qhtot*4.75e-13);

	/* incident continuum nu*f_nu at Hbeta and Ly-alpha */
	smbeta.cn4861 = (float)(ffun(0.1875)*HPLANCK*FR1RYD*0.1875*0.1875);
	smbeta.cn1216 = (float)(ffun(0.75)*HPLANCK*FR1RYD*0.75*0.75);
	smbeta.sv4861 = smbeta.cn4861;
	smbeta.sv1216 = smbeta.cn1216;

	/* flux density nu*Fnu = erg / s / cm2
	 * EX1RYD is optional extinction factor at 1 ryd */
	prhd.fx1ryd = (float)(ffun(1.000)*HPLANCK*ex1ryd*FR1RYD);

	/* check for plasma frequency - then zero out incident continuum
	 * for energies below this
	 * this is critical electron density, shielding of incident continuum
	 * if electron density is greater than this */
	ecrit = POW2(rfield.anu[0]/2.729e-12);

	if( phycon.hden*1.2 > ecrit )
	{
		plasnu.lgPlasNu = TRUE;
		plasnu.plsfrq = (float)(2.729e-12*sqrt(phycon.hden*1.2));
		plasnu.plsfrqmax = plasnu.plsfrq;
		plasnu.ipPlasma = ipoint(plasnu.plsfrq);

		/* save max pointer too */
		plasnu.ipPlasmax = plasnu.ipPlasma;

		/* now loop over all affected energies, setting incident continuum
		 * to zero there, and counting all as reflected */
		/* >>chng 01 jul 14, from i < ipPlasma to ipPlasma-1 - 
		 * when ipPlasma is 1 plasma freq is not on energy scale */
		for( i=0; i < plasnu.ipPlasma-1; i++ )
		{
			/* count as reflected incident continuum */
			rfield.ConRefIncid[i] = rfield.flux[i];
			/* set continuum to zero there */
			rfield.flux[i] = 0.;
		}
	}
	else
	{
		plasnu.lgPlasNu = FALSE;
		/* >>chng 01 jul 14, from 0 to 1 - 1 is the first array element on the F scale,
		 * ipoint would return this, so rest of code assumes ipPlasma is 1 plus correct index */
		plasnu.ipPlasma = 1;
		plasnu.plsfrqmax = 0.;
		plasnu.plsfrq = 0.;
	}

	if( plasnu.ipPlasma > 1 && called.lgTalk )
	{
		fprintf( ioQQQ, 
			"           !The plasma frequency is %.2e Ryd.  The incident continuum is set to 0 below this.\n", 
		  plasnu.plsfrq );
	}

	occmaxCom.occmax = 0.;
	occmaxCom.tbrmax = 0.;
	for( i=0; i < rfield.nupper; i++ )
	{
		/* set up occupation number array */
		rfield.OccNumbIncidCont[i] = rfield.flux[i]*rfield.convoc[i];
		if( rfield.OccNumbIncidCont[i] > occmaxCom.occmax )
		{
			occmaxCom.occmax = rfield.OccNumbIncidCont[i];
			occmaxCom.occmnu = rfield.anu[i];
		}
		/* following product is continuum brightness temperature */
		if( rfield.OccNumbIncidCont[i]*TE1RYD*rfield.anu[i] > occmaxCom.tbrmax )
		{
			occmaxCom.tbrmax = (float)(rfield.OccNumbIncidCont[i]*TE1RYD*rfield.anu[i]);
			occmaxCom.tbrmnu = rfield.anu[i];
		}
		/* save continuum for next iteration */
		rfield.FluxSave[i] = rfield.flux[i];
	}

	/* if continuum brightness temp is large, where does it fall below
	 * 1e4k??? */
	if( occmaxCom.tbrmax > 1e4 )
	{
		i = ipoint(occmaxCom.tbrmnu);
		while( i < rfield.nupper && (rfield.OccNumbIncidCont[i-1]*TE1RYD*
		  rfield.anu[i-1] > 1e4) )
		{
			i += 1;
		}
		occmaxCom.tbr4nu = rfield.anu[i-1];
	}
	else
	{
		occmaxCom.tbr4nu = 0.;
	}

	/* if continuum occ num is large, where does it fall below 1? */
	if( occmaxCom.occmax > 1. )
	{
		i = ipoint(occmaxCom.occmnu)-1;
		while( i < rfield.nupper && (rfield.OccNumbIncidCont[i] > 1.) )
		{
			++i;
		}
		occmaxCom.occ1nu = rfield.anu[i];
	}
	else
	{
		occmaxCom.occ1nu = 0.;
	}

	/* remember if incident radiation field is less than 10*Habing ISM */
	if( totlum.TotalLumin < 1.8e-2 )
	{
		habing.lgHabing = TRUE;
	}

	/* fix ionization parameter (per hydrogen) at inner edge */
	rfield.uh = (float)(rfield.qhtot/phycon.hden/SPEEDLIGHT);
	rfield.uheii = (float)((rfield.qheii + prhd.qx)/phycon.hden/SPEEDLIGHT);

	/* guess first temperature and neutral h density */
	if( thermal.ForceTemp > 0. )
	{
		phycon.te = thermal.ForceTemp;
	}
	else
	{
		if( rfield.uh > 0. )
		{
			phycon.te = (float)(20000.+log10(rfield.uh)*5000.);
			phycon.te = (float)MAX2(8000. , phycon.te );
		}
		else
		{
			phycon.te = (float)1000.;
		}
	}

	/* this is an option to stop after printing header only */
	if( noexec.lgNoExec )
	{ 
		return;
	}

	/* following needed for tfidle */
	phycon.eden = phycon.hden;
	xIonFracs[ipHYDROGEN][0] = 0.;
	/* this must be zero sinze PressureTotalDo will do radiation pressure due to H */
	iso.Pop2Ion[ipH_LIKE][0][ipH1s] = 0.;

	/* next two just to make sure some values are set */
	rec = PressureTotalDo();
	tfidle(FALSE);

	/* estimate secondary ionization rate - probably 0, but possible extra
	 * SetCsupra set with "set csupra" */
	/* >>>chng 99 apr 29, added cosmic ray ionization since this is used to get
	 * helium ionization fraction, and was zero in pdr, so He turned off at start,
	 * and never turned back on */
	/* coef on cryden is from highen.c */
	Secondaries.csupra = Secondaries.SetCsupra + hextra.cryden*2e-9f;

	/*********************************************************************
	 *                                                                   *
	 * esimate hydrogen's level of ionization                            *
	 *                                                                   *
	 *********************************************************************/

	/* first estimate level of hydrogen ionization */
	rec = (-9.9765209 + 0.158607055*phycon.telogn[0] + 0.30112749*
	  phycon.telogn[1] - 0.063969007*phycon.telogn[2] + 0.0012691546*
	  phycon.telogn[3])/(1. + 0.035055422*phycon.telogn[0] - 
	  0.037621619*phycon.telogn[1] + 0.0076175048*phycon.telogn[2] - 
	  0.00023432613*phycon.telogn[3]);

	rec = pow(10.,rec)/phycon.te*phycon.eden;
	xIoniz = (float)(rfield.qhtot*2e-18 + hydro_vs_ioniz(1)*phycon.eden);
	r2ov1 = xIoniz/rec;
	xIonFracs[ipHYDROGEN][0] = (float)(phycon.hden/(1. + r2ov1));
	/* >>chng 00 aug 26 add following logic, had used difference between
	 * hden and hi, as in second branch.  this was zero for very low
	 * ionization conditions */
	if( r2ov1 > 0. )
	{
		xIonFracs[ipHYDROGEN][1] = (float)(phycon.hden/( 1. + 1./r2ov1 ) );
	}
	else
	{
		xIonFracs[ipHYDROGEN][1] = (float)phycon.hden - xIonFracs[ipHYDROGEN][0];
	}
	phycon.EdenFFSum = abundances.gas_phase[ipCARBON];

	if( xIonFracs[ipHYDROGEN][1] > 1e-30 )
	{
		iso.Pop2Ion[ipH_LIKE][0][ipH1s] = xIonFracs[ipHYDROGEN][0]/xIonFracs[ipHYDROGEN][1];
	}
	else
	{
		iso.Pop2Ion[ipH_LIKE][0][ipH1s] = 0.;
	}

	/* now save estimates of whether induced recombination is going
	 * to be important -this is a code pacesetter since GammaBn is slower
	 * than GammaK */
	hydro.lgHInducImp = FALSE;
	for( i=ipH1s; i < iso.numLevels[ipH_LIKE][ipHYDROGEN]; i++ )
	{
		if( rfield.OccNumbIncidCont[iso.ipIsoLevNIonCon[ipH_LIKE][ipHYDROGEN][i]-1] > 0.01 )
			hydro.lgHInducImp = TRUE;
	}

	/*********************************************************************
	 *                                                                   *
	 * esimate helium's level of ionization                            *
	 *                                                                   *
	 *********************************************************************/

	/* only if helium is turned on */
	if( abundances.lgElmtOn[1] )
	{
		/* next estimate level of helium singly ionized */
		xIoniz = (float)cfit(2,2,phycon.te);
		xIoniz = (float)(xIoniz*phycon.eden + rfield.qhe*1e-18);
		r2ov1 = xIoniz/rec;

		/* now estimate level of helium doubly ionized */
		xIoniz = (float)cfit(2,1,phycon.te);
		xIoniz = (float)(xIoniz*phycon.eden + rfield.qheii*1e-18);

		/* rough charge dependence */
		rec *= 4.;
		r3ov2 = xIoniz/rec;

		/* now set level of helium ionization */
		if( r2ov1 > 0. )
		{
			xIonFracs[ipHELIUM][1] = (float)(abundances.gas_phase[ipHELIUM]/(1./r2ov1 + 1. + r3ov2));
			xIonFracs[ipHELIUM][0] = (float)(xIonFracs[ipHELIUM][1]/r2ov1);
		}
		else
		{
			/* no He ionizing radiation */
			xIonFracs[ipHELIUM][1] = 0.;
			xIonFracs[ipHELIUM][0] = abundances.gas_phase[ipHELIUM];
		}

		xIonFracs[ipHELIUM][2] = (float)(xIonFracs[ipHELIUM][1]*r3ov2);

		he.hei1 = xIonFracs[ipHELIUM][0];

		if( xIonFracs[ipHELIUM][2] > 1e-30 )
		{
			iso.Pop2Ion[ipH_LIKE][1][ipH1s] = xIonFracs[ipHELIUM][1]/xIonFracs[ipHELIUM][2];
		}
		else
		{
			iso.Pop2Ion[ipH_LIKE][1][ipH1s] = 0.;
		}
	}
	else
	{
		/* case where helium is turned off */
		xIonFracs[ipHELIUM][1] = 0.;
		xIonFracs[ipHELIUM][0] = 0.;
		xIonFracs[ipHELIUM][2] = 0.;
		he.hei1 = 0.;
		iso.Pop2Ion[ipH_LIKE][1][ipH1s] = 0.;
	}

	/* estimate electrons from heavies, assuming each at least
	 * 1 times ionized */
	EdenHeav = 0.;
	for( i=2; i < LIMELM; i++ )
	{
		if( abundances.lgElmtOn[i] )
		{
			EdenHeav += abundances.gas_phase[i];
		}
	}

	/* estimate of electron density */
	phycon.eden = 
		xIonFracs[ipHYDROGEN][1] + xIonFracs[ipHELIUM][1] + 
	  2.*xIonFracs[ipHELIUM][2] + EdenHeav + phycon.EdenExtra;

	if( phycon.EdenSet > 0. )
	{
		phycon.eden = phycon.EdenSet;
	}

	phycon.EdenHCorr = phycon.eden;

	if( phycon.eden < 0. )
	{
		fprintf( ioQQQ, " Negative electron density results in ContSetIntensity.\n" );
		fprintf( ioQQQ, "%10.2e%10.2e%10.2e%10.2e%10.2e%10.2e\n", 
		  phycon.eden, xIonFracs[ipHYDROGEN][1], xIonFracs[ipHELIUM][1], 
		  xIonFracs[ipHELIUM][2], abundances.gas_phase[ipCARBON], phycon.EdenExtra );
		ShowMe();
		puts( "[Stop in ContSetIntensity]" );
		cdEXIT(EXIT_FAILURE);
	}

	phycon.EdenTrue = phycon.eden;

	if( trace.lgTrace && trace.lgNeBug )
	{
		fprintf( ioQQQ, "     EDEN set to%12.4e by ContSetIntensity.\n", 
		  phycon.eden );
	}

	/* he triplets only one that needs eden */
	/* >>>chng 00 apr 13 protect against eden zero, by PvF */
	if( phycon.eden > 0. )
	{
		he.hei3 = 
			(float)(xIonFracs[ipHELIUM][1]*5.79e-2/phycon.te*(1. + 3110*
			pow(phycon.te/1e4,-0.51)/phycon.eden));
	}
	else
	{
		he.hei3 = 0.;
	}

	/* for later line opacities we need ratioal estimates  */
	if( xIonFracs[ipHELIUM][1] > 0. )
	{
		/* if heii is 0 then leave at values set in block data */
		phe1lv.he1n[0] = xIonFracs[ipHELIUM][0]/xIonFracs[ipHELIUM][1];
		he3nCom.he3n[0] = he.hei3/xIonFracs[ipHELIUM][1];
	}

	occ1 = (float)(prhd.fx1ryd/HNU3C2/PI4/FR1RYD);

	/* what is occupation number at 1 Ryd? */
	if( occ1 > 1. )
	{
		occ1hi.lgOcc1Hi = TRUE;
	}
	else
	{
		occ1hi.lgOcc1Hi = FALSE;
	}

	if( trace.lgTrace && trace.lgConBug )
	{
		/*  print some useful pointers to ionization edges */
		fprintf( ioQQQ, " H2,1=%5ld%5ld NX=%5ld IRC=%5ld\n", 
		  iso.ipIsoLevNIonCon[ipH_LIKE][0][2], 
		  iso.ipIsoLevNIonCon[ipH_LIKE][0][ipH1s],
		  opac.ipCKshell, 
		  ionrec.ipCompRecoil[ipHYDROGEN][0] );

		fprintf( ioQQQ, " HE3, 1=%5ld%5ld HE2=%5ld\n", he.nhei3, 
		  nhe1Com.nhe1[0], iso.ipIsoLevNIonCon[ipH_LIKE][1][ipH1s] );

		fprintf( ioQQQ, " CARBON" );
		for( i=0; i < 6; i++ )
		{
			fprintf( ioQQQ, "%5ld", Heavy.ipHeavy[ipCARBON][i] );
		}
		fprintf( ioQQQ, "\n" );

		fprintf( ioQQQ, " OXY" );
		for( i=0; i < 8; i++ )
		{
			fprintf( ioQQQ, "%5ld", Heavy.ipHeavy[ipOXYGEN][i] );
		}
		fprintf( ioQQQ, "%5ld%5ld%5ld\n", opac.ipo3exc[0], 
		  pmp2s.i2d, pmp2s.i2p );

		fprintf( ioQQQ, 
			"\n\n                                                  PHOTONS PER CELL (NOT RYD)\n" );
		fprintf( ioQQQ, 
			"\n\n                                        nu, flux, wid, occ \n" );
		fprintf( ioQQQ, 
			" " );

		for( i=0; i < rfield.nflux; i++ )
		{
			fprintf( ioQQQ, "%4ld%10.2e%10.2e%10.2e%10.2e", i, 
			  rfield.anu[i], rfield.flux[i], rfield.widflx[i], 
			  rfield.OccNumbIncidCont[i] );
		}
		fprintf( ioQQQ, " \n" );
	}

	/* zero out some continua related to the ots rates,
	 * prototype and routine in RT_OTS_Update.  This is done here since summed cont will
	 * be set to rfield */
	RT_OTS_Zero();

	/* set upper and lower stages of ionization of heavies */
	nsset();

	if( trace.lgTrace )
	{
		fprintf( ioQQQ, " ContSetIntensity returns, nflux=%5ld anu(nflux)=%11.4e eden=%10.2e\n", 
		  rfield.nflux, rfield.anu[rfield.nflux-1], phycon.eden );
	}

	*lgOK = TRUE;

#	ifdef DEBUG_FUN
	fputs( " <->ContSetIntensity()\n", debug_fp );
#	endif
	return;
}

/*sumcon sums L and Q for net incident continuum */
static void sumcon(long int il, 
  long int ih, 
  float *q, 
  float *p, 
  float *panu)
{
	long int i, 
	  iupper; /* used as upper limit to the sum */

#	ifdef DEBUG_FUN
	fputs( "<+>sumcon()\n", debug_fp );
#	endif

	*q = 0.;
	*p = 0.;
	*panu = 0.;

	/* soft continua may not go as high as the requested bin */
	iupper = MIN2(rfield.nflux,ih);

	/* n.b. - in F77 loop IS NOT executed when IUPPER < IL */
	for( i=il-1; i < iupper; i++ )
	{
		/* sum photon number */
		*q += rfield.flux[i];
		/* en1ryd is needed to stop overflow */
		/* sum flux */
		*p += (float)(rfield.flux[i]*(rfield.anu[i]*EN1RYD));
		/* this sum needed for means */
		*panu += (float)(rfield.flux[i]*(rfield.anu2[i]*EN1RYD));
	}

#	ifdef DEBUG_FUN
	fputs( " <->sumcon()\n", debug_fp );
#	endif
	return;
}

/*ptrcer show continuum pointers in real time following drive pointers command */
static void ptrcer(void)
{
	char chCard[INPUT_LINE_LENGTH];
	/* in case of checking everything, will write errors to this file */
	FILE * ioERRORS=NULL;
	int lgEOL;
	char chKey;
	long int i, 
	  ipnt, 
	  j;
	double pnt, 
	  t1, 
	  t2;

#	ifdef DEBUG_FUN
	fputs( "<+>ptrcer()\n", debug_fp );
#	endif

	fprintf( ioQQQ, " There are two ways to do this:\n");
	fprintf( ioQQQ, " do you want me to test all the pointers (enter y)\n");
	fprintf( ioQQQ, " or do you want to enter energies yourself? (enter n)\n" );

	if( fgets( chCard , (int)sizeof(chCard) , stdin ) == NULL )
	{
		fprintf( ioQQQ, " error getting input \n" );
		puts( "[Stop in ptrcer]" );
		cdEXIT(EXIT_FAILURE);
	}

	/* this must be either y or n */
	chKey = chCard[0];

	if( chKey == 'n' )
	{
		/* this branck, enter energies by hand, and see what happens */
		fprintf( ioQQQ, " Enter energy (Ryd); 0 to stop; negative is log.\n" );
		pnt = 1.;
		while( pnt!=0. )
		{
			if( fgets( chCard , (int)sizeof(chCard) , stdin ) == NULL )
			{
				fprintf( ioQQQ, " error getting input2 \n" );
				puts( "[Stop in ptrcer]" );
				cdEXIT(EXIT_FAILURE);
			}
			/* now get the number off the line */
			i = 1;
			pnt = FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);

			/* bail if no number at all, or it is zero*/
			if( lgEOL || pnt==0. )
			{
				break;
			}

			/* if number negative then interpret as log */
			if( pnt < 0. )
			{
				pnt = pow(10.,pnt);
			}

			/* get pointer to call */
			ipnt = ipoint(pnt);
			fprintf( ioQQQ, " Cell num%4ld center:%10.2e width:%10.2e low:%10.2e hi:%10.2e convoc:%10.2e\n", 
			  ipnt, rfield.anu[ipnt-1], rfield.widflx[ipnt-1], 
			  rfield.anu[ipnt-1] - rfield.widflx[ipnt-1]/2., 
			  rfield.anu[ipnt-1] + rfield.widflx[ipnt-1]/2., 
			  rfield.convoc[ipnt-1] );
		}
	}

	else if( chKey == 'y' )
	{
		/* first check that ipoint will not crash due to out of range call*/
		if( rfield.anu[0] - rfield.widflx[0]/2.*0.9 < continuum.filbnd[0] )
		{
			fprintf( ioQQQ," ipoint would crash since lowest desired energy of %e ryd is below limit of %e\n",
				rfield.anu[0] - rfield.widflx[0]/2.*0.9 , continuum.filbnd[0] );
			fprintf( ioQQQ," width of cell is %e\n",rfield.widflx[0]);
			puts( "[Stop in ptrcer]" );
			cdEXIT(EXIT_FAILURE);
		}

		else if( rfield.anu[rfield.nflux-1] + rfield.widflx[rfield.nflux-1]/2.*0.9 > 
			continuum.filbnd[continuum.nrange] )
		{
			fprintf( ioQQQ," ipoint would crash since highest desired energy of %e ryd is above limit of %e\n",
				rfield.anu[rfield.nflux-1] + rfield.widflx[rfield.nflux-1]/2.*0.9 , 
				continuum.filbnd[continuum.nrange-1] );
			fprintf( ioQQQ," width of cell is %e\n",rfield.widflx[rfield.nflux]);
			fprintf( ioQQQ," this, previous cells are %e %e\n",
				rfield.anu[rfield.nflux-1],rfield.anu[rfield.nflux-2]);
			puts( "[Stop in ptrcer]" );
			cdEXIT(EXIT_FAILURE);
		}

		/* this branch check everything, write errors to error file */
		fprintf( ioQQQ, " errors output on errors.txt\n");
		fprintf( ioQQQ, " IP(cor),IP(fount),nu lower, upper of found, desired cell.\n" );

		/* error file not open, set to null so we can check later */
		ioERRORS = NULL;
		for( i=0; i < rfield.nflux-1; i++ )
		{
			t1 = rfield.anu[i] - rfield.widflx[i]/2.*0.9;
			t2 = rfield.anu[i] + rfield.widflx[i]/2.*0.9;

			j = ipoint(t1);
			if( j != i+1 )
			{
				/* open file for errors if not already open */
				if( ioERRORS == NULL )
				{
					ioERRORS = fopen("errors.txt" , "w" );
					if( ioERRORS==NULL ) 
					{
						fprintf( ioQQQ," could not create1 errors.txt file\n");
						puts( "[Stop in ptrcer]" );
						cdEXIT(EXIT_FAILURE);
					}
					else
					{
						fprintf( ioQQQ," created errors.txt file with error summary\n");
					}
				}

				fprintf( ioQQQ, " Pointers do not agree for lower bound of cell%4ld, %e\n",
					i, rfield.anu[i]);
				fprintf( ioERRORS, " Pointers do not agree for lower bound of cell%4ld, %e\n",
					i, rfield.anu[i] );
			}

			j = ipoint(t2);
			if( j != i+1 )
			{
				/* open file for errors if not already open */
				if( ioERRORS == NULL )
				{
					ioERRORS = fopen("errors.txt" , "w" );
					if( ioERRORS==NULL ) 
					{
						fprintf( ioQQQ," could not create2 errors.txt file\n");
						puts( "[Stop in ptrcer]" );
						cdEXIT(EXIT_FAILURE);
					}
					else
					{
						fprintf( ioQQQ," created errors.txt file with error summary\n");
					}
				}
				fprintf( ioQQQ, " Pointers do not agree for upper bound of cell%4ld, %e\n", 
					i , rfield.anu[i]);
				fprintf( ioERRORS, " Pointers do not agree for upper bound of cell%4ld, %e\n", 
					i , rfield.anu[i]);
			}

		}
	}

	else
	{
		fprintf( ioQQQ, " This key is not understood, sorry.  %c\n", 
		  chKey );
		puts( "[Stop in ptrcer]" );
		cdEXIT(EXIT_FAILURE);
	}

	if( ioERRORS!=NULL )
		fclose( ioERRORS );
	puts( "[Stop in ptrcer]" );
	cdEXIT(EXIT_FAILURE);
}

/*extin do extinction of incident continuum as set by extinguish command */
static void extin(float *ex1ryd)
{
	long int i, 
	  low;
	double absorb, 
	  factor;

#	ifdef DEBUG_FUN
	fputs( "<+>extin()\n", debug_fp );
#	endif


	/* modify input continuum by leaky absorber
	 * power law fit to 
	 * >>refer	XUV	extinction	Cruddace et al. 1974 ApJ 187, 497.
	 * */
	if( extinc.excolm == 0. )
	{
		*ex1ryd = 1.;
	}
	else
	{
		absorb = 1. - extinc.exleak;
		/*factor = extinc.excolm*6.22e-18;*/
		/* >>chng 01 dec 19, use variable for the constant that gives extinction */
		factor = extinc.excolm*extinc.cnst_col2optdepth;
		/* extinction at 1 and 4 Ryd */
		*ex1ryd = (float)(extinc.exleak + absorb*sexp(factor));

		low = ipoint(extinc.exlow);
		for( i=low-1; i < rfield.nflux; i++ )
		{
			rfield.flux[i] *= (float)(extinc.exleak + absorb*sexp(factor*
			  /* >>chng 01 dec 19, use var with this constant */
			  /*(pow(rfield.anu[i],-2.43))));*/
			  (pow(rfield.anu[i],extinc.cnst_power))));
		}

	}

#	ifdef DEBUG_FUN
	fputs( " <->extin()\n", debug_fp );
#	endif
	return;
}

