/*ConvEdenIoniz called by ConvTempIonz, calls ConvIoniz solving for eden */
/*esum sum free electron density over all species, sets variable erredn.EdenTrue
 *called by ConvEdenIoniz which actually controls the electron density updates */
#include "cddefines.h"
#include "tfidle.h"
#include "phycon.h"
#include "trace.h"
#include "converge.h"
/* limit to how many loops we will do */
#define	LOOPMAX	25

void ConvEdenIoniz(void)
{
	long int LoopEden ,
		/* this will be LOOPMAX at first, then doubled if no oscillations occur*/
		LoopLimit ;
	int lgFailLastTry;

	static double PreviousEden;
	double 
		/* upper and lower limits to the range of the change we want to consider */
		EdenUpperLimit,
		EdenLowerLimit ,
		factor ,
		PreviousChange ;
	double EdenAssumed0=0., 
		EdenAssumed1=0., 
		/*EdenAssumed2=0.,
		EdenAssumed3=0.,*/
		EdenObtained0=0., 
		EdenObtained1=0./*, 
		EdenObtained2=0.,
		EdenObtained3=0.*/;

#	ifdef DEBUG_FUN
	fputs( "<+>ConvEdenIoniz()\n", debug_fp );
#	endif

	/* this routine is called by ConvTempIonz, it calls ConvIonize
	 * and changes the electron density until it converges */

	if( trace.lgTrace )
	{
		fprintf( ioQQQ, "  \n" );
		fprintf( ioQQQ, " ConvEdenIoniz entered \n" );
	}

	/* >>chng 01 apr 13, move next to calls from here, removing from calling
	 * routines, which had then called here */
	/* update density - temperature variables which may have changed */
	tfidle(FALSE);
	/* this flag says wether we converged the density but failed after final tweek,
	 * need to use smaller steps */
	lgFailLastTry = FALSE;

	/* the old default solver */
	if( strcmp( conv.chSolverEden , "simple" )== 0 )
	{
		LoopEden = 0;
		conv.nConvIonizFails = 0;

		/* this will be increased by 2x if, at the end, no oscillations have occurred */
		LoopLimit = LOOPMAX;

		/* will be set true if sign of change, ever changes */
		conv.lgEdenOscl = FALSE;

		/* will be used to look for oscillations in the electron density */
		PreviousChange = 0.;

		strcpy( conv.chConvIoniz, " NONE!!!!!" );

		/* this is ionization/electron density convergence loop
		 * keep calling ionize until lgIonDone is true */
		do 
		{
			/* this flag will be set false below if electron density not within tolerance 
			 * after ionization is recomputed */
			conv.lgConvEden = TRUE;

			/* remember the old electron density for possible printout */
			PreviousEden = phycon.eden;

			/* converge the current level of ionization, this calls esum which updates EdenTrue */
			ConvIoniz();

			/* >>chng 02 may 29, move esum call to ConvIoniz to check on change in EdenTrue to
			 * converge ionizaiton */
			/* ESUM sets variable EdenTrue to true elec den but does not change eden
			esum(); */

			/* following block is to not let electron density change by
			 * too much
			 * phycon.EdenError is allowed error
			 * the default value of EdenError is 0.01 in zerologic
			 * is changed with the SET EdenError command
			 * PreviousEden was incoming value of eden
			 * EdenTrue is correct value from esum for current ionization
			 * new eden will be set using these, trying to prevent oscillations */

			/* is error larger than the tolerance we are trying to beat? */
			if( 
				(float)fabs(phycon.eden-phycon.EdenTrue)/MIN2((float)phycon.eden,phycon.EdenTrue) >= 
				phycon.EdenError )
			{
				/* diference is assumed and true electron density is larger
				 * than tolerance, we are not yet converged, default is 0.01 */
				conv.lgConvEden = FALSE;
				strcpy( conv.chConvIoniz, "Ne big chg" );

				/* SEARCH is TRUE if this is only search for first solution */
				if( conv.lgSearch )
				{
					phycon.eden = pow(10.,
						(log10(phycon.eden) + log10(phycon.EdenTrue))/ 2.);
				}
				else
				{

					/* was the sign of the change in the electron density changing,
					 * or has it ever changed? Also use are we close to converged? */
					if( conv.lgConvEden || PreviousChange*(phycon.EdenTrue-phycon.eden) < 0. )
					{
						/* remember that oscillations are happening  */
						conv.lgEdenOscl = TRUE;

						/* changes in electron density are changing sign - be careful,
						 * factor multiplies the error tolerance on the electron density,
						 * largest change allowed is related to this */
						factor = 0.5;
					}
					else if( lgFailLastTry )
					{
						/* this is case where last evaluation of eden, after solution, 
						 * caused failure */
						factor = 0.5;
					}
					else
					{
						/* stable so far . .. */
						/* factor = 2.;*/
						/* had been 2, change to 1 stopped oscillations from developing in 
						 * loc blr grid */
						factor = 1.;
					}

					/* use larger factor if not oscillating and change in eden is large */
					if( !conv.lgEdenOscl && 
						fabs( (phycon.EdenTrue-phycon.eden)/phycon.eden) > 3.*phycon.EdenError)
					{
						/* use 3x larger factor */
						factor *= 3.;
					}

					/* now remember this change for the next time through the loop  */
					PreviousChange = phycon.EdenTrue - phycon.eden ;

					/* is the correct electron density - is it too different? 
					 * default on EdenError is 0.01, dyanmics is 0.001 */
					EdenUpperLimit = phycon.eden * (1. + phycon.EdenError*factor);
					EdenLowerLimit = phycon.eden / (1. + phycon.EdenError*factor);
					
					/* get the new electron density */
					if( phycon.EdenTrue > EdenUpperLimit )
					{
						/* this branch, proposed eden too big */
						phycon.eden = EdenUpperLimit;
					}
					else if( phycon.EdenTrue < EdenLowerLimit )
					{
						/* proposed eden too small */
						phycon.eden = EdenLowerLimit;
					}
					else
					{
						/* eden was within fac of the correct value, use it */
						phycon.eden = phycon.EdenTrue;
					}

					if( trace.lgTrace && trace.lgNeBug )
					{
						fprintf( ioQQQ, 
							"     ConvEdenIoniz, chg ne to%10.3e PreviousEden%10.3e ratio%10.3e EdenTrue=%10.3e\n", 
						  phycon.eden, PreviousEden, phycon.eden/PreviousEden,  phycon.EdenTrue );
					}
				}
				/* we now have the proposed new electron density */

				/* update density and temperature related variables */
				tfidle(FALSE);
			}
			/* >>chng 00 oct 21, did not have this branch before so did not make small changes to
			 * electron density (smaller than size that determined eden not converged */
			/* this branch electron density was pretty close, we just need to make a small update */
			else
			{
				int lgCallConvIoniz = FALSE;


				/* this is test for whether will call ConvIoniz again - check how close old and correct
				 * electron densities are before updating EdenTrue */
				if( fabs(phycon.eden-phycon.EdenTrue)/phycon.EdenTrue  > phycon.EdenError/10. )
					lgCallConvIoniz = TRUE;

				/* now update eden to EdenTrue, since we are so close to is */
				phycon.eden = phycon.EdenTrue;

				if( trace.lgTrConvg>=3 )
				{
					fprintf( ioQQQ, 
						"   ConvEdenIoniz3 converged eden, call ConvIoniz with final density? %c\n",
						TorF(lgCallConvIoniz) );
				}

				/* we have changed the density slightly, so now must reevaluate ionization with this new value */
				/* converge the current level of ioinization
				 * but only do this if change was significant */
				/* >>chng 02 may 31, always call ConvIoniz (basically did so anyway) and remove esum from here*/
				/* , this calls esum which updates EdenTrue */
				ConvIoniz();

				/* ESUM sets variable EdenTrue to true elec den but does not change eden
				esum(); */

				/* >>chng 01 mar 14, check whether electron density is no longer converged 
				 * after reevaluating ionization */
				if( 
					(float)fabs(phycon.eden-phycon.EdenTrue)/MIN2((float)phycon.eden,phycon.EdenTrue) >= 
					phycon.EdenError )
				{
					/* diference is assumed and true electron density is larger
					 * than tolerance, we are not yet converged, default is 0.01 */
					conv.lgConvEden = FALSE;
					/* make steps smaller by setting this flag */
					conv.lgEdenOscl = TRUE;
					lgFailLastTry = TRUE;
				}
			}
			{
				/*@-redef@*/
				/* debug print statement for change in electron density */
				enum {DEBUG=FALSE};
				/*@+redef@*/
				if( DEBUG )
				{
					fprintf(ioQQQ,"edendebugg %li\t%.2e\t%.2e\t%.2e\t%.2e\n", 
						nzone,phycon.eden ,PreviousEden, (phycon.eden-PreviousEden)/phycon.eden, phycon.EdenTrue);
				}
			}
			if( trace.lgTrace && trace.lgNeBug )
			{
				fprintf( ioQQQ, 
					"     ConvEdenIoniz, chg ne to%10.3e PreviousEden%10.3e ratio%10.3e EdenTrue=%10.3e converge=%c\n", 
				  phycon.eden, PreviousEden, phycon.eden/PreviousEden,  phycon.EdenTrue ,TorF( conv.lgConvEden));
				/* update density and temperature related variables */
				tfidle(FALSE);
			}

			if( trace.lgTrConvg>=3 )
			{
				fprintf( ioQQQ, "   ConvEdenIoniz3 %4ld new ne=%12.4e true=%12.4e", 
				  LoopEden, phycon.eden ,  phycon.EdenTrue );

				/* this is flag says whether or not eden/eden has converged */
				if( conv.lgConvEden )
				{
					fprintf( ioQQQ, " converged, eden rel error is %g ", 
						(phycon.EdenTrue-phycon.eden)/phycon.EdenTrue );
				}
				else
				{
					fprintf( ioQQQ, " NOT Converged! corr:%7.3f prop:%7.3f ", 
					   (phycon.EdenTrue-PreviousEden)/PreviousEden , 
						(phycon.eden-PreviousEden)/PreviousEden );
				}
				if( conv.lgEdenOscl )
					fprintf( ioQQQ, " EDEN OSCIL \n");
			}

			/* loop until converged, or we give up */
			++LoopEden;

			/* if last iteration through here and not converged, and no oscillations, 
			 * and no ionization failures ,
			 * then increase limit by 2x */
			if( LoopEden == (LOOPMAX-1) && !conv.lgEdenOscl && conv.nConvIonizFails==0)
				/* double the limit, but only one time, and only if no oscillations */
				LoopLimit *= 2;

		}	while( !conv.lgConvEden && LoopEden < LoopLimit );
	}
	/* turned on with set eden solver new */
	else if( strcmp( conv.chSolverEden , "new" )== 0 )
	{
		/* will be used to look for bracketing in the electron density */
		double PreviousEdenError = 0.;
		double ChangeEdenLast = 0.;
		double CurrentEdenError = 0.;
		double CurrentEden = 0.;
		double ProposedEden,
			FractionChangeEden = 0. ;

		/* new method of converging electron density */
		LoopEden = 0;
		conv.nConvIonizFails = 0;

		/* this will be increased by 2x if, at the end, no oscillations have occurred */
		LoopLimit = LOOPMAX;

		/* will be set true if sign of change, ever changes */
		conv.lgEdenOscl = FALSE;

		/* this is relative change in electron density that we will permit - it will become
		 * smaller each time we bracket the true electron density */
		factor = 0.02;

		strcpy( conv.chConvIoniz, " NONE!!!!!" );

		/* this is ionization/electron density convergence loop
		 * keep calling ionize until lgIonDone is true */
		do 
		{

			/* this flag will be set false below if electron density not within tolerance 
			 * after ionization is recomputed */
			conv.lgConvEden = TRUE;

			if( trace.lgTrConvg>=3 )
				fprintf( ioQQQ, "   ConvEdenIoniz3 calling ConvIoniz with eden= %.4e\n",phycon.eden);

			/* converge the current level of ioinization , this calls esum which updates EdenTrue */
			ConvIoniz();
			/* converge the current level of ioinization , this calls esum which updates EdenTrue */
			/* ConvIoniz();broken();remove second call */

			/* >>chng 02 may 29, move esum call to ConvIoniz to check on change in EdenTrue to
			 * converge ionizaiton */
			/* ESUM sets variable EdenTrue to true electron density for resulting
			 * level of ionization, but it does not change phycon.eden, the current
			 * assumed electron density
			esum(); */

			/* the history of how we got here 
			EdenAssumed3 = EdenAssumed2,
			EdenObtained3 = EdenObtained2;
			EdenAssumed2 = EdenAssumed1,
			EdenObtained2 = EdenObtained1,*/
			EdenAssumed1 = EdenAssumed0, 
			EdenObtained1 = EdenObtained0, 

			EdenAssumed0 = phycon.eden;
			EdenObtained0 = phycon.EdenTrue, 

			/* remember the old electron density for possible printout */
			CurrentEden = phycon.eden;

			/* this is the current error in the electron density */
			CurrentEdenError = phycon.EdenTrue - phycon.eden;

			/* phycon.EdenError is allowed error
			 * the default value of EdenError is 0.01 in zerologic
			 * is changed with the SET Eden Error command
			 * PreviousEden was incoming value of eden
			 * EdenTrue is correct value from esum for current ionization
			 * new eden will be set using these, trying to prevent oscillations */

			/* is error larger than the tolerance we are trying to beat?
			 * first check is whether error is very small after very first check, since
			 * ionization soln may not have settled down yet */
			if( 
				(LoopEden==0 && fabs(CurrentEdenError)/phycon.EdenTrue <= phycon.EdenError/2.) ||
				(LoopEden>0 && fabs(CurrentEdenError)/phycon.EdenTrue <= phycon.EdenError 
				&& FractionChangeEden < phycon.EdenError / 2.) )
				break;

			/* diference is assumed and true electron density is larger
			 * than tolerance, we are not yet converged, default is 0.01 */
			conv.lgConvEden = FALSE;
			strcpy( conv.chConvIoniz, "Ne big chg" );

			/* SEARCH is TRUE if this is only search for first solution */
			if( conv.lgSearch )
			{
				phycon.eden = pow(10.,
					(log10(phycon.eden) + log10(phycon.EdenTrue))/ 2.);
			}
			else
			{

				/* was the sign of the change in the electron density changing,
				 * if so then we have bracked the target */
				if( PreviousEdenError*CurrentEdenError < 0. )
				{
					/* we have bracketed the correct electron density, 
					 * make changes smaller, also solve linear equation for zero error */
					double slope = (PreviousEdenError - CurrentEdenError ) /
						( PreviousEden - CurrentEden );

					ProposedEden = PreviousEden - PreviousEdenError / slope;
					/* as sanity check, this must be between the two limits we examined,
					 * since zero was between them */
					ASSERT( ProposedEden >= MIN2( PreviousEden , CurrentEden ) );
					ASSERT( ProposedEden <= MAX2( PreviousEden , CurrentEden ) );

					factor *= 0.25;
					if( trace.lgTrConvg>=3 )
						fprintf( ioQQQ, 
						"   ConvEdenIoniz3 bracketed electron density factor now %.3e error is %.4f proposed ne %.4e\n",
						factor,
						(phycon.EdenTrue-phycon.eden)/phycon.EdenTrue, ProposedEden);
				}
				else
				{
					/* did not bracket the target, keep moving in its direction */

					/* the correct electron density - is it too different? */
					EdenUpperLimit = phycon.eden * (1. + factor);
					EdenLowerLimit = phycon.eden / (1. + factor);

					/* get the new electron density */
					if( phycon.EdenTrue > EdenUpperLimit )
					{
						/* this branch, proposed eden too big */
						ProposedEden = EdenUpperLimit;
					}
					else if( phycon.EdenTrue < EdenLowerLimit )
					{
						/* proposed eden too small */
						ProposedEden = EdenLowerLimit;
					}
					else
					{
						/* eden was within fac of the correct value, use it */
						ProposedEden = phycon.EdenTrue;
					}
					if( trace.lgTrConvg>=3 )
						fprintf( ioQQQ, 
						"   ConvEdenIoniz3 electron density factor %.3e error is %.4f proposed ne %.4e\n",
						factor,
						(phycon.EdenTrue-phycon.eden)/phycon.EdenTrue ,
						ProposedEden);
				}

				/* now remember this change for the next time through the loop  */
				PreviousEdenError = CurrentEdenError ;
				PreviousEden = CurrentEden;
				FractionChangeEden = fabs( phycon.eden - ProposedEden ) / phycon.EdenTrue;
				phycon.eden = ProposedEden;

				ChangeEdenLast = fabs( phycon.eden - PreviousEden ) / phycon.EdenTrue;

				if( trace.lgTrace && trace.lgNeBug )
				{
					fprintf( ioQQQ, 
						"     ConvEdenIoniz, chg ne to%10.3e PreviousEden%10.3e ratio%10.3e EdenTrue=%10.3e\n", 
					  phycon.eden, PreviousEden, phycon.eden/PreviousEden,  phycon.EdenTrue );
				}
			}
			/* loop until we give up  --  normal exit is break in center of loop */
			++LoopEden;
		}	while( LoopEden < LoopLimit &&  !conv.lgAbort );

		/* we now have the proposed new electron density */

		/* update density and temperature related variables */
		tfidle(FALSE);

		/* we have changed the density slightly, so now must reevaluate ionization with this new value */
		/* converge the current level of ioinization
		 * but only do this if change was significant */
		if( trace.lgTrConvg>=3 )
			fprintf( ioQQQ, 
			"   ConvEdenIoniz3 converged eden, current error is %.4f, calling ConvIoniz with final density\n",
			(phycon.EdenTrue - phycon.eden)/phycon.EdenTrue);
		phycon.eden = phycon.EdenTrue;
		/* , this calls esum which updates EdenTrue */
		/* >>chng 02 may 31, always call ConvIoniz (basically did so anyway) and remove esum from here*/
		ConvIoniz();

		/* ESUM sets variable EdenTrue to true elec den but does not change eden
		esum(); */

		/* >>chng 01 mar 14, check whether electron density is no longer converged 
		 * after reevaluating ionization */
		if( 
			(float)fabs(phycon.eden-phycon.EdenTrue)/phycon.EdenTrue > 
			phycon.EdenError )
		{
			/* diference is assumed and true electron density is larger
			 * than tolerance, we are not yet converged, default is 0.01 */
			conv.lgConvEden = FALSE;
			if( trace.lgTrConvg>=3 )
				fprintf( ioQQQ, 
				"   ConvEdenIoniz3 setting eden not converged, error %.4f, exiting\n",
				(phycon.eden-phycon.EdenTrue)/phycon.EdenTrue );
		}
		else
		{
			conv.lgConvEden = TRUE;
		}

		if( trace.lgTrace && trace.lgNeBug )
		{
			fprintf( ioQQQ, 
				"     ConvEdenIoniz, chg ne to%10.3e PreviousEden%10.3e ratio%10.3e EdenTrue=%10.3e converge=%c\n", 
			  phycon.eden, PreviousEden, phycon.eden/PreviousEden,  phycon.EdenTrue ,TorF( conv.lgConvEden));
			/* update density and temperature related variables */
			tfidle(FALSE);
		}

		if( trace.lgTrConvg>=3 )
		{
			fprintf( ioQQQ, "   ConvEdenIoniz3 %4ld new ne=%12.4e true=%12.4e", 
			  LoopEden, phycon.eden ,  phycon.EdenTrue );

			/* this is flag says whether or not eden/eden has converged */
			if( conv.lgConvEden )
			{
				fprintf( ioQQQ, " converged, eden rel error is %g ", 
					(phycon.EdenTrue-phycon.eden)/phycon.EdenTrue );
			}
			else
			{
				fprintf( ioQQQ, " NOCONV corr:%7.3f prop:%7.3f ", 
				   (phycon.EdenTrue-PreviousEden)/PreviousEden , 
					(phycon.eden-PreviousEden)/PreviousEden );
			}
			if( conv.lgEdenOscl )
				fprintf( ioQQQ, " EDEN OSCIL \n");
		}

	}
	else
	{
		fprintf( ioQQQ, "ConvEdenIoniz finds insane solver%s \n" , conv.chSolverEden );
		ShowMe();
		puts( "[Stop in ConvEdenIoniz]" );
		cdEXIT(EXIT_FAILURE);
	}

	if( trace.lgTrConvg>=3 )
	{
		fprintf( ioQQQ, "   ConvEdenIoniz3 exits, lgConvEden=%1c \n" , TorF(conv.lgConvEden ) );
	}

#	ifdef DEBUG_FUN
	fputs( " <->ConvEdenIoniz()\n", debug_fp );
#	endif
	return;
}

