/*ConvIonizeOpacityDo main routine to drive ionization solution for all species, find total opacity
 * called by ConvIoniz */
/*lgConverg check whether ionization of element nelem has converged */
/*esum sum free electron density over all species, sets variable erredn.EdenTrue
 *called by ConvEdenIoniz which actually controls the electron density updates */
#include "cddefines.h"
#include "dynamics.h"
#include "hydrogenic.h"
#include "thermal.h"
#include "trace.h"
#include "heat.h"
#include "phycon.h"
#include "abundances.h"
#include "cooling.h"
#include "secondaries.h"
#include "highen.h"
#include "helium.h"
#include "hmi.h"
#include "hevmolec.h"
#include "chargtran.h"
#include "helike.h" 
#include "heatsum.h"
#include "rt.h"
#include "grainvar.h"
#include "ionheavy.h"
#include "freeht.h"
#include "iiibod.h"
#include "grain.h"
#include "dielsupres.h"
#include "ionrange.h"
#include "ionfracs.h"
#include "opacity.h"
#include "coolr.h"
#include "co.h"
#include "trimstages.h"
#include "converge.h"

/*lgConverg check whether ionization of element nelem has converged */
static int lgIonizConverg(
	/* atomic number of element on C scale, 0 for H */
	long int nelem ,
	/* allowed fractional change before we announce not converged */
	double delta);

/*esum sum free electron density over all species, sets variable erredn.EdenTrue
 *called by ConvEdenIoniz which actually controls the electron density updates */
static void esum(void);

void ConvIonizeOpacityDo( 
	/* this is zero the first time ConvIonizeOpacityDo is called by convIoniz,
	 * counts number of call thereafter */
	 long loopi )
{
	double O_HIonRate_New , O_HIonRate_Old ;
	double HeatOld , edensave;
	static double SecondOld;
	long int ipOTSchange,
		nelem, 
		ion;
	static double SumOTS=0. , OldSumOTS[2] ;

#	ifdef DEBUG_FUN
	fputs( "<+>ConvIonizeOpacityDo()\n", debug_fp );
#	endif

	if( loopi==0 )
	{
		/* these will be used to look for oscillating ots rates */
		OldSumOTS[0] = 0.;
		OldSumOTS[1] = 0.;
	}

	if( trace.lgTrace )
	{
		fprintf( ioQQQ, 
			"   IONIZE called.  TE:%9.3e  HI:%8.2e  HII:%8.2e  Ne:%9.3e  CSUP:%8.2e\n", 
		  phycon.te, xIonFracs[ipHYDROGEN][0], xIonFracs[ipHYDROGEN][1], phycon.eden, Secondaries.csupra);
	}

	/* this routine is in sumheat, and zeroes out the heating array */
	HeatZero();

	/* if this is very first call, say not converged, since no meaningful way to
	 * check on changes in quantities.  this counter is false only on very first
	 * call, when equal to zero */
	if( !conv.nTotalIoniz )
	{
		conv.lgConvIoniz = FALSE;
		strcpy( conv.chConvIoniz, "first call" );
	}

	/* this will be flag to check whether any ionization stages
	 * were trimed down */
	conv.lgIonStageTrimed = FALSE;

	/* must redo photoionizaiton rates for all species on second and later tries */
	/* always reevaluate the rates when . . . */
	/* this flag says not to redo opac and photo rates, and following test will set
	 * true if one of several tests not done*/
	opac.lgRedoStatic = FALSE;
	if( 
		/* opac.lgOpacStatic (usually TRUE), is set FALSE with no static opacity command */
		!opac.lgOpacStatic || 
		/* we are in search mode */
		conv.lgSearch || 
		/* this is the first call to this zone */
		conv.nPres2Ioniz == 0 )
	{
		/* we need to redo ALL photoionization rates */
		opac.lgRedoStatic = TRUE;
	}

	/* this adjusts the lowest and highest stages of ionization we will consider,
	 * only safe to call when lgRedoStatic is true since this could lower the 
	 * lowest stage of ionization, which needs all its photo rates */

	/* conv.nTotalIoniz is only 0 (FALSE) on the very first call to ConvIonizeOpacityDo,
	 * when we do not know what the ionization distribution is, since not yet done */
	if( conv.nTotalIoniz )
	{
		/* we will never trim hydrogen itself (ipZ==0) down.  
		 * Criteria for helium are different
		 * from rest since He+ CT with CO is so important - keep He+ going
		 * far longer than we would expect */
		if( abundances.lgElmtOn[ipHELIUM] )
		{
			if( IonRange.IonHigh[ipHELIUM] == 2 )
			{
				/* fully stripped helium is present - how abundant is it? 
				 * this limit is the one used in C90, probably not carefully thought out */
				if( xIonFracs[ipHELIUM][2]/abundances.gas_phase[ipHELIUM] < 1e-6F )
				{
					/* decrement the counter to the highest stage, and zero its abundance */
					--IonRange.IonHigh[ipHELIUM];
					xIonFracs[ipHELIUM][2] = 0.;
				}
			}
			else if( IonRange.IonHigh[ipHELIUM] == 1 )
			{
				/* no stripped ion, but check on single ion.  this is the limit that
				 * was present in c90, small for CO destruction 
				if( xIonFracs[ipHELIUM][1]/abundances.gas_phase[ipHELIUM] < 1e-12F )*/
				/* >>chng 02 apr 10, change to very small number for CO dest in mole clouds */
				if( xIonFracs[ipHELIUM][1]/abundances.gas_phase[ipHELIUM] < 1e-20F )
				{
					/* decrement the counter to the highest stage, and zero its abundance */
					--IonRange.IonHigh[ipHELIUM];
					xIonFracs[ipHELIUM][1] = 0.;
				}
			}
		}

		/* TrimStages only used for Li and heavier, not H or He */
		for( nelem=2; nelem<LIMELM; ++nelem )
		{
			if( abundances.lgElmtOn[nelem] )
			{
				/* TrimStages will set conv.lgIonStageTrimed TRUE is any ion has its
				 * lowest stage of ionization dropped */
				TrimStages(nelem);
			}
		}
		/* check that proper abundances are either positive or zero */
		for( nelem=ipHYDROGEN; nelem<LIMELM; ++nelem)
		{
			if( abundances.lgElmtOn[nelem] )
			{
				for( ion=0; ion<IonRange.IonLow[nelem]; ++ion )
				{
					ASSERT( xIonFracs[nelem][ion] == 0. );
				}
				for( ion=IonRange.IonLow[nelem]; ion<=IonRange.IonHigh[nelem]; ++ion )
				{
					/* >>chng 02 feb 06, had been > o., chng to > SMALLFLOAT to
					* trip over VERY small floats that failed on alphas, but not 386
					* 
					* in case where lower ionization stage was just lowered the abundance
					* was set to SMALLFLOAT so test must be < SMALLFLOAT */
					/* >>chng 02 feb 19, add check for search phase.  During this search
					* models with extreme ionization (all neutral or all ionized) can
					*& have extreme but non-zero abundances far from the ionization peak for
					* element with lots of electons.  These will go away once the model
					* becomes stable */
					ASSERT( conv.lgSearch || 
						xIonFracs[nelem][ion] >= SMALLFLOAT || 
						xIonFracs[nelem][ion]/abundances.gas_phase[nelem] >= SMALLFLOAT );
				}
				for( ion=IonRange.IonHigh[nelem]+1; ion<nelem+1; ++ion )
				{
					ASSERT( xIonFracs[nelem][ion] == 0. );
				}
			}
		}
	}

	/* now check if anything trimed down */
	if( conv.lgIonStageTrimed )
	{
		/* something was trimed down, so say that ionization not yet stable */
		/* say that ionization has not converged, secondaries changed by too much */
		conv.lgConvIoniz = FALSE;
		strcpy( conv.chConvIoniz, "IonTrimmed" );
	}

#	if 0
	if( opac.lgRedoStatic )
	{
		fprintf(ioQQQ," start ioniz, redo opacities\n");
	}
	else
	{
		fprintf(ioQQQ," start ioniz, DO NOT redo opacities\n");
	}
#	endif

	/* reevaluate advective terms if turned on */
	if( dynamics.lgAdvection )
	{
		DynaIonize();
	}

	/* >>chng 01 apr 29, move charge transfer evaluation here, had been just before
	 * HeLike, but needs to be here so that same rate coef used for H ion and other recomb */
	/* fill in master charge transfer array, and zero out some arrays that track effects,
	 * O_HIonRateis rate oxygen ionizes hydrogen - need to converge this */
	ChargTranEval( &O_HIonRate_Old );

	/* do all hydrogenic species, and fully do hydrogen itself */
	Hydrogenic();

	/* evaluate Compton heating, bound E compton, cosmic rays */
	highen();

	/* evaluate free-free heating rate */
	freeht();

	/* find corrections for three-body rec - collisional ionization */
	iiibod();

	/* deduce dielctronic supression factors */
	DielSupres();

	/* >>chng 02 mar 08 move helike to before helium */
	/* do all he-like species */
	HeLike();

	/* helium ionization balance */
	helium();

	/* find grain temperature, charge, and gas heating rate */
	grain();

	/* do the ionization balance */
	IonLithi();
	IonBeryl();
	IonBoron();
	IonCarbo();
	IonOxyge();
	/* do carbon monoxide after oxygen */
	codriv();
	IonNitro();
	IonFluor();
	IonNeon();
	IonSodiu();
	IonMagne();
	IonAlumi();
	IonSilic();
	IonPhosi();
	IonSulph();
	IonChlor();
	IonArgon();
	IonPotas();
	IonCalci();
	IonScand();
	IonTitan();
	IonVanad();
	IonChrom();
	IonManga();
	IonIron();
	IonCobal();
	IonNicke();
	IonCoppe();
	IonZinc();

#	if 0
	fprintf(ioQQQ,"ionionion\t%li\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\n",
		nzone,phycon.EdenHCorr,
		xIonFracs[ipHYDROGEN][0],xIonFracs[ipHYDROGEN][1],
		xIonFracs[ipHELIUM][0],xIonFracs[ipHELIUM][1],xIonFracs[ipHELIUM][2]);
#	endif

	/* redo Oxygen ct ion rate of H to see if it changed */
	ChargTranEval( &O_HIonRate_New );

	/*fprintf(ioQQQ," O HIOndebugg \t%li\t%.4e\t%.4e\n", nzone, O_HIonRate_Old, O_HIonRate_New);*/
	/* lgIonizConverg is a function to check whether ionization has converged */
	/* check whether oxygen ionization changed by more than relative error
	 * given by second number */
	if( !lgIonizConverg(1, 0.05 ) )
	{
		conv.lgConvIoniz = FALSE;
		strcpy( conv.chConvIoniz, "Helium Ion" );
	}

	if( !lgIonizConverg(7, 0.15 ) )
	{
		conv.lgConvIoniz = FALSE;
		strcpy( conv.chConvIoniz, "Oxygen Ion" );
	}

	/* check whether iron ionization changed by much */
	if( !lgIonizConverg(25 , 0.15 ) )
	{
		conv.lgConvIoniz = FALSE;
		strcpy( conv.chConvIoniz, "Iron Ioniz" );
	}
		
	/* >>chng 02 may 29, move esum here from one level up, so that change in EdenTrue
	 * can be monitored */
	edensave = phycon.EdenTrue;
	esum();
	/* the /4 really was needed in a primordial abundance test case, where secondary
	 * ionizaiton was very important - needs to be very well converged. */
	if( fabs( phycon.EdenTrue - edensave )/phycon.EdenTrue > phycon.EdenError/4. )
	{
		conv.lgConvIoniz = FALSE;
		strcpy( conv.chConvIoniz, " eden chng" );
		conv.BadConvIoniz[0] = edensave;
		conv.BadConvIoniz[1] = phycon.EdenTrue;
	}

	/* get total cooling, this can add heat */
	coolr(&cooling.ctot );
		
	/* get total heating rate */
	HeatOld = heat.htot;

	/* HeatSum will update ElecFrac, 
	 * secondary electron ionization and excitation efficiencies,
	 * and sum up current secondary rates - remember old values before we enter */
	SecondOld = Secondaries.csupra;

	HeatSum();

	/* test whether we can just set the rate to the new one, or whether we should
	 * take average and do it again.  Secondaries.sec2total was set in hydrogenic, and
	 * is ratio of secondary to total hydrogen destruction rates */
	if( (Secondaries.sec2total>0.001) && 
		fabs( 1. - SecondOld/MAX2(SMALLFLOAT,Secondaries.csupra) ) > 0.1 && 
		SecondOld > 0. &&  Secondaries.csupra > 0.)
	{
		/* say that ionization has not converged, secondaries changed by too much */
		conv.lgConvIoniz = FALSE;
		strcpy( conv.chConvIoniz, "SecIonRate" );
		conv.BadConvIoniz[0] = SecondOld;
		conv.BadConvIoniz[1] = Secondaries.csupra;
	}

	if( HeatOld > 0. && !thermal.lgTSetOn )
	{
		/* check if heating has converged - toler is final match */
		if( fabs(1.-heat.htot/HeatOld) > conv.HeatCoolRelError*.5 )
		{
			conv.lgConvIoniz = FALSE;
			strcpy( conv.chConvIoniz, "Big d Heat" );
			conv.BadConvIoniz[0] = HeatOld;
			conv.BadConvIoniz[1] = heat.htot;
		}
	}

	/* evaluate current opacities, OpacityAddTotal is called only here during actual calculation */
	OpacityAddTotal();

	/* conv.nTotalIoniz was set to zero in zero and reset, and incremented below,
	 * and so counts the number of times this routine has been called during current iteration.  
	 * the very first time we are called this is zero, false, so ots routines not called, 
	 * since both opacities and dest prob are junk */
	if( conv.nTotalIoniz > 0 )
	{
		/* do hydrogenic OTS rates for H lines and all continua since
		 * we now have ionization balance of all species.  Note that this is not
		 * entirely self-consistnet, since dest probs here are not the same as
		 * the ones used in the model atoms.  Problems??  if near convergence
		 * then should be nearly identical */
		/* line dest rates are evaluated in HydroPesc */
		/* >>chng 01 apr 10, move HydroOTS to RT_OTS */
		RT_OTS();
	}

	/* remember old ots rates */
	OldSumOTS[0] = OldSumOTS[1];
	OldSumOTS[1] = SumOTS;

	/* now update several components of the continuum, this only happens after
	 * we have gone through entire soln for this zone at least one time. 
	 * this var is 0 on very first call to this zone 
	 * done due to wild oscillation in ots on first call */
	RT_OTS_Update(&SumOTS , &ipOTSchange , 0.10 );

	/* now check whether the ots rates changed */
	if( SumOTS> 0. )
	{
		/* the ots rate must be converged to the error in the electron density */
		/* how fine should this be converged?? orginally had above, 10%, but take
		 * smaller ratio?? */
		if( fabs(1.-OldSumOTS[1]/SumOTS) > phycon.EdenError )
		{
			/* this branch, ionization not converged due to large change in ots rates.
			 * check whether ots rates are oscillating, if loopi > 1 so we have enough info*/
			if( loopi > 1 )
			{
				/* here we have three values, are they changing sign? */
				if( (OldSumOTS[0]-OldSumOTS[1]) * ( OldSumOTS[1] - SumOTS ) < 0. )
				{
					/* ots rates are oscillating, if so then use small fraction of new dest rates 
					 * when updating Lyman line dest probs in HydroPesc*/
					conv.lgOscilOTS = TRUE;
				}
			}

			conv.lgConvIoniz = FALSE;
			strcpy( conv.chConvIoniz, "OTSRatChng" );
			conv.BadConvIoniz[0] = OldSumOTS[1];
			conv.BadConvIoniz[1] = SumOTS;
			{
				/*@-redef@*/
				enum {DEBUG=FALSE};
				/*@+redef@*/
				if( DEBUG && (iteration==2)/**/ )
				{
					/* last par 'l' for line, 'c' for continua, 'b' for both */
					RT_OTS_PrtRate(SumOTS*0.01 , 'l' );
				}
			}
		}
	}

	/* >>chng 01 aug 18, moved up to convpres ... since pace setter */
	/* this is only a sanity check that the summed continua accurately reflect
	 * all of the individual components.  Only include this when NDEBUG is not set,
	 * we are in not debug compile 
#	if !defined(NDEBUG)
	RT_OTS_ChkSum(0);
#	endif*/

	/* option to print OTS continuum with TRACE OTS */
	if( trace.lgTrace && trace.lgOTSBug )
	{
		/* find ots rates here, so we only print fraction of it,
		 * SumOTS is both line and continuum contributing to ots, and is mult by opacity */
		/* number is weakest rate to print */
		RT_OTS_PrtRate(SumOTS*0.05 , 'b' );
	}

	/* now reevaluate only destruction probabilities */
	RTMake(FALSE);

	if( trace.lgTrace )
	{
		fprintf( ioQQQ, "   IONIZE retrn, HI:%10.3e  HII:%10.3e  EDEN:%10.3e HTOT:%10.3e lgIonDone=%3c\n", 
		  xIonFracs[ipHYDROGEN][0], xIonFracs[ipHYDROGEN][1], phycon.eden, heat.htot, TorF(conv.lgConvIoniz) );
	}
	
	/* this counts number of times we are called by PressureChange, in this zone */
	++conv.nPres2Ioniz;

	/* this counts how many times we have been called in this model,
	 * located here at bottom of routine so that number is false on very first
	 * call, since set to 0 in zero */
	++conv.nTotalIoniz;

#	ifdef DEBUG_FUN
	fputs( " <->ConvIonizeOpacityDo()\n", debug_fp );
#	endif
	return;
}

/*lgIonizConverg check whether ionization of element nelem has converged, called by ionize */

static int lgIonizConverg(
	/* atomic number on the C scale, 0 for H, 25 for Fe */
	long int nelem ,
	/* this is allowed error as a fractional change.  Most are 0.15 */
	double delta )
{
	int lgConverg_v;
	long int nstage;
	double Abund, 
	  change ,
	  one ;

	/* this is fractions [ion stage][nelem], ion stage = 1 for atom, nelem=0 for H*/
	static float OldFracs[LIMELM+2][LIMELM+2];

#	ifdef DEBUG_FUN
	fputs( "<+>lgIonizConverg()\n", debug_fp );
#	endif

	/* args are atomic number, ionization stage
	 * OldFracs[nelem][0] is abundances of nelem (cm^-3) */

	/* this function returns true if ionization of element
	 * with atomic number nelem+ has not changed by more than delta,*/

	/* check whether abundances exist yet, only do this for after first zone */
	if( nzone > 0 )
	{
		change = 0.;
		Abund = abundances.gas_phase[nelem];

		/* loop is from 1 since 0 stores total abundance */
		for( nstage=1; nstage <= (nelem + 2); nstage++ )
		{
			/*lint -e727 OlsdFracs not initialized */
			if( OldFracs[nelem][nstage]/Abund > 1e-4 && 
				xIonFracs[nelem][nstage-1]/Abund > 1e-4 )
			/*lint +e727 OlsdFracs not initialized */
			{
				/* check change in old to new value */
				one = fabs(xIonFracs[nelem][nstage-1]-OldFracs[nelem][nstage])/
					OldFracs[nelem][nstage];
				change = MAX2(change, one );
			}
			/* now set new value */
			OldFracs[nelem][nstage] = xIonFracs[nelem][nstage-1];
		}

		if( change < delta )
		{
			lgConverg_v = TRUE;
		}
		else
		{
			lgConverg_v = FALSE;
		}
	}
	else
	{
		for( nstage=1; nstage <= (nelem + 2); nstage++ )
		{
			OldFracs[nelem][nstage] = xIonFracs[nelem][nstage-1];
		}

		lgConverg_v = TRUE;
	}

#	ifdef DEBUG_FUN
	fputs( " <->lgIonizConverg()\n", debug_fp );
#	endif
	return( lgConverg_v );
}

/*esum sum free electron density over all species, sets variable erredn.EdenTrue
 *called by ConvEdenIoniz which actually controls the electron density updates */
static void esum(void)
{
	long int n, 
	  ion, 
	  nelem;

	double csum, 
	  edmole, 
	  edsave[LIMELM], 
	  osum;

#	ifdef DEBUG_FUN
	fputs( "<+>esum()\n", debug_fp );
#	endif

	/* EdenExtra is normally zero, set with EDEN command, to add extra e-
	 * EdenSet is normally zero, set with SET EDEN command, to set e- */
	phycon.EdenTrue = xIonFracs[ipHYDROGEN][1] + xIonFracs[ipHELIUM][1] + 
		2.*xIonFracs[ipHELIUM][2] + phycon.EdenExtra;

	/* add on molecules */
	edmole = phycon.EdenTrue;

	phycon.EdenTrue += hmi.h2plus + hevmolec.hevmol[ipCHP] + hevmolec.hevmol[ipOHP] + 
	  hevmolec.hevmol[ipCOP] + hevmolec.hevmol[ipH2OP] + hevmolec.hevmol[ipO2P] + 
	  hevmolec.hevmol[ipC2P] + hevmolec.hevmol[ipH3OP] + hevmolec.hevmol[ipCH2P] + 
	  hmi.h3plus;

	/* remember electron density from molecules */
	edmole = phycon.EdenTrue - edmole;

	/* pgrains */
	/* >>chng 00 dec 19, include electrons on grains in total sum */
	phycon.EdenTrue += gv.TotalEden;

	/* sum over all metals */
	/* free free sum should not include hydrogenic since already done
	 * indpenedently in coolr*/
	phycon.EdenFFSum = 0.;
	for( nelem=2; nelem < LIMELM; nelem++ )
	{
		edsave[nelem] = 0.;
		for( ion=2; ion <= nelem; ion++ )
		{
			/* >>chng 96 oct 27, save all contributors to electron density */
			edsave[nelem] += (ion-1)*xIonFracs[nelem][ion-1];
			phycon.EdenFFSum += POW2( (float)(ion-1) )*xIonFracs[nelem][ion-1];
		}
		/* add on hydrogenic specides since now counted in free free sum */
		edsave[nelem] += (float)(nelem)*xIonFracs[nelem][nelem];
		/* >>chng 02 apr 18, from EdenMet to EdenTrue, get rid of EdenMet */
		phycon.EdenTrue += edsave[nelem];
	}

	/* this variable is set with the set eden command, 
	 * is supposed to override physical electron density */
	if( phycon.EdenSet > 0. )
	{
		phycon.EdenTrue = phycon.EdenSet;
	}

	if( phycon.EdenTrue < 0. )
	{
		fprintf(ioQQQ,"ESUM finds EdenTrue negative before H-, =%e\n", phycon.EdenTrue);
		ShowMe();
		puts( "[Stop in esum]" );
		cdEXIT(EXIT_FAILURE);
	}

	/* >>chng 01 jan 08, following logic added to stop H- from forcing
	 * negative electron density during very first search, when H- is off */
	/* correct for hminus, and flag error if we go negative */
	if( hmi.hminus > phycon.EdenTrue )
	{
		phycon.EdenTrue -= MIN2(phycon.EdenTrue*0.05,hmi.hminus);
	}
	else
	{
		phycon.EdenTrue -= hmi.hminus;
	}

 	if( trace.lgTrace )
	{
		csum = 0.;
		for( ion=1; ion <= 6; ion++ )
		{
			csum += (ion)*xIonFracs[ipCARBON][ion];
		}

		osum = 0.;
		for( ion=1; ion <= 8; ion++ )
		{
			osum += (float)(ion)*xIonFracs[ipOXYGEN][ion];
		}

		fprintf( ioQQQ, 
			"     ESUM: zone %li True:%11.4e old:%11.4e hcorr:%.2e ff sum:%10.3e HII:%8.2e He2+3:%8.2e\n",
		  nzone,
		  phycon.EdenTrue, 
		  phycon.eden, 
		  phycon.EdenHCorr,
		  phycon.EdenFFSum, 
		  xIonFracs[ipHYDROGEN][1], 
		  xIonFracs[ipHELIUM][1] + 2.*xIonFracs[ipHELIUM][2]);

		fprintf( ioQQQ, 
			"     ESUM: cont C:%8.2e O:%8.2e mol:%8.2e\n", 
		  csum, osum, edmole );

		if( trace.lgNeBug )
		{
			fprintf( ioQQQ, "     ESUM: heav" );
			for(n=2; n < LIMELM; n++)
			{
				fprintf( ioQQQ, " %8.1e", edsave[n] );
			}
			fprintf( ioQQQ, "\n" );
		}
	}

	if( phycon.EdenTrue <= 0. )
	{
		fprintf( ioQQQ, "ESUM finds non-positive electron density.\n" );
		fprintf( ioQQQ, 
			"     ESUM: EdenTrue to%12.4e fm%12.4e ff sum;%10.3e Ne(H):%10.2e Ne(He):%10.2e Ne(C):\n", 
		  phycon.EdenTrue, 
		  phycon.eden, 
		  phycon.EdenFFSum, 
		  xIonFracs[ipHYDROGEN][1], 
		  xIonFracs[ipHELIUM][1] + 2.*xIonFracs[ipHELIUM][2] );
		ShowMe();
		puts( "[Stop in esum]" );
		cdEXIT(EXIT_FAILURE);
	}

	if(  gv.TotalEden/phycon.EdenTrue > 0.01 )
	{
		fprintf(ioQQQ," esum finds grains have %g percent of the electrons.\n",
			gv.TotalEden/phycon.EdenTrue*100.);
	}

	{
		/*@-redef@*/
		enum {DEBUG=FALSE};
		/*@+redef@*/
		if( DEBUG )
		{
			fprintf(ioQQQ,"esumdebugg\t%li\t%.2e\t%.2e\n",
				nzone,
			  phycon.eden, phycon.EdenTrue);
		}
	}

#	ifdef DEBUG_FUN
	fputs( " <->esum()\n", debug_fp );
#	endif
	return;
}

