/*ConvPresTempEdenIoniz solve for current pressure, calls PressureChange, ConvTempEdenIonize,
 * called by cloudy */
/*ConvFail handle conergece failure */
#include "cddefines.h"
#include "phycon.h"
#include "prtzone.h"
#include "mappar.h"
#include "called.h"
#include "thermal.h"
#include "rt.h"
#include "punt.h"
#include "wind.h"
#include "cooling.h"
#include "heat.h"
#include "pressure.h"
#include "trace.h"
#include "converge.h"

/* the limit to the number of loops */
#define LOOPMAX 40

/* ----------------------------------------------------------------------------- */

/*ConvFail handle conergece failure */
static void ConvFail(char chMode[]); /* chMode[5] */

void ConvPresTempEdenIoniz(void)
{
	long int loop,
		LoopMax=LOOPMAX;
	double Error,
		OscFac,
		hden_old ,
		hden_chng_old ,
		hden_chng;
	double OldChange;
	int lgPresOscil;
	long int nPresConverged;
	float TemperatureInitial;

#	ifdef DEBUG_FUN
	fputs( "<+>ConvPresTempEdenIoniz()\n", debug_fp );
#	endif

	/* this will count number of times we call ConvIonizeOpacityDo in this zone,
	 * counter is incremented there */
	conv.nPres2Ioniz = 0;
	loop = 0;
	conv.lgConvPres = FALSE;

	/* >>chng 01 oct 31, add this variable and test, idea is to
	 * evaluate constant pressure or dynamic models one more time beyond the
	 * first hit where pressure was within error */
	if( strcmp(pressure.chCPres,"CPRE") == 0 || wind.windv != 0. )
	{
		/* constant pressure, we will want two good solutions */
		nPresConverged = 0;
	}
	else
	{
		/* not constant pressure, first solution will be all we want */
		nPresConverged = 1;
	}

	/* this will be the limit, which we will increase if no oscillations occur */
	LoopMax = LOOPMAX;
	OldChange = 0.;

	/* set the initial temperature to the current value, so we will know
	 * if we are trying to jump over a thermal front */
	TemperatureInitial = phycon.te;

	/* this will be flag to check for pressure oscillations */
	lgPresOscil = FALSE;

	/* this could be set true somewhere, if we implode */
	conv.lgAbort = FALSE;

	/* factor mult changes in density, will make smaller each time we oscillate about soln */
	OscFac = 1.0;

	/* we will use these to check whether hden oscillating - would need to decrease step size */
	hden_old = phycon.hden;
	hden_chng = 0.;

	/* >>chng 01 apr 01, add test for at least 2 loops to get better pressure convergence */
	/* >>chng 01 oct 31, add test for number of times converged, for constant
	 * pressure will get two valid solutions */
	while( (loop < LoopMax) && !(conv.lgConvPres  &&nPresConverged > 1) &&  !conv.lgAbort )
	{

		/* >>chng 01 aug 24, if large change in temperature allow lots more loops */
		if( fabs( TemperatureInitial - phycon.te )/phycon.te > 0.3 )
			LoopMax = 2*LOOPMAX;

		/* change current densities of all constituents if necessary, 
		 * PressureChange evaluates lgPresOK, true if pressure is now ok
		 * sets CurrentPressure and CorrectPressure */
		hden_old = phycon.hden;
		PressureChange( lgPresOscil );

		/* if product of these two is negative then hden is oscillating */
		hden_chng_old = hden_chng;
		hden_chng = hden_old - phycon.hden;

		/* heating cooling balance while doing ionization,
		 * this is where the heavy lifting is done*/
		ConvTempEdenIoniz();

		/* reevaluate total pressure for this location, and current conditions
		 * may have changed after previous call to ionize */
		pressure.PressureCurrent = PressureTotalDo();
		{
			/*@-redef@*/
			enum{DEBUG=FALSE};
			/*@+redef@*/
			if( DEBUG && nzone > 150 && iteration > 1 )
			{
				fprintf(ioQQQ,"%li\t%.2e\t%.2e\t%.2e\n", 
					nzone,
					pressure.PressureCurrent, 
					pressure.PressureCorrect,
					(pressure.PressureCorrect - pressure.PressureCurrent)*100./pressure.PressureCorrect
					) ;
			}
		}

		/* check whether pressure is oscillating */
		/* >>chng 02 may 31, add check on sign on hden changes */
		if( ( (pressure.PressureCurrent - pressure.PressureCorrect ) * OldChange < 0. )
			|| (hden_chng*hden_chng_old<0.))
			

		{
			/* the sign of the change in pressure has changed, so things
			 * are oscillating.  This would be a problem */
			lgPresOscil = TRUE;
			OscFac *= 0.5;
		}
		/* this is only used to check whether sign of error is changing */
		OldChange = pressure.PressureCurrent - pressure.PressureCorrect ;

		/* convergence trace at this level */
		if( trace.lgTrConvg>=1  )
		{
			fprintf( ioQQQ, 
				" ConvPresTempEdenIoniz1 %4ld Curr Pres:%.2e Corr Pres:%.2e Hden:%.2e Te:%.2e Osc:%c\n", 
			  loop, 
			  pressure.PressureCurrent, 
			  pressure.PressureCorrect, 
			  phycon.hden, 
			  phycon.te,
			  TorF(lgPresOscil)  );
		}

		/* >>chng 01 oct 31, increment number of times we have seen converged pressure */
		if( conv.lgConvPres )
			++nPresConverged;


		/* >>chng 01 apr 02, if not constant density, then make sure at least two loops are done */
		if( (strcmp( pressure.chCPres,"CDEN") != 0 ) && (loop  == 1 ) )
			conv.lgConvPres = FALSE;

		/* increment loop counter */
		++loop;

		/* if we hit limit of loop, but no oscillations have happened, then we are
		 * making progress, and can keep going */
		if( loop == LoopMax && !lgPresOscil )
		{
			LoopMax = MIN2( 100 , LoopMax*2 );
		}
	}

	/* >>chng 01 mar 14, only call ConvFail one time, no matter how
	 * many failures occured below.  Had been series of if, so multiple
	 * calls per failure possible.  This change means that logic in ConvFail
	 * for abort is simpler. This may be set true in PressureChange */
	if( !conv.lgConvPres )
	{
		/* announce the pressure failure */
		ConvFail("pres");
	}

	else if( !conv.lgConvTemp )
	{
		/* announce the temperature failure */
		ConvFail("temp");
	}

	/* say something if we did not converge */
	else if( !conv.lgConvEden )
	{
		ConvFail("eden") ;
	}

	/* say something if we did not converge */
	else if( !conv.lgConvIoniz )
	{
		ConvFail("ioni") ;
	}

	/* remember mean and largest errors on electron density */
	Error = fabs(phycon.eden - phycon.EdenTrue)/phycon.EdenTrue;
	if( Error > conv.BigEdenError )
	{
		conv.BigEdenError = (float)Error;
		phycon.nzEdenBad = nzone;
	}
	conv.AverEdenError += (float)Error;

	/* remember mean and largest errors between heating and cooling */
	Error = fabs(cooling.ctot - heat.htot) / cooling.ctot;
	conv.BigHeatCoolError = MAX2((float)Error , conv.BigHeatCoolError );
	conv.AverHeatCoolError += (float)Error;

	/* remember mean and largest pressure errors */
	Error = fabs(pressure.PressureCurrent - pressure.PressureCorrect) / pressure.PressureCorrect;
	conv.BigPressError = MAX2((float)Error , conv.BigPressError );
	conv.AverPressError += (float)Error;

	/* this is only a sanity check that the summed continua accurately reflect
	 * all of the individual components.  Only include this when NDEBUG is not set,
	 * we are in not debug compile */
#	if !defined(NDEBUG)
	RT_OTS_ChkSum(0);
#	endif

#	ifdef DEBUG_FUN
	fputs( " <->ConvPresTempEdenIoniz()\n", debug_fp );
#	endif
	return;
}

/* ----------------------------------------------------------------------------- */

/*ConvFail handle conergece failure */
static void ConvFail(char chMode[]) /* chMode[5] */
{
	double relerror ;

#	ifdef DEBUG_FUN
	fputs( "<+>ConvFail()\n", debug_fp );
#	endif

	/* pressure failure */
	if( strcmp( chMode , "pres" )==0 )
	{
		/* record number of pressure failures */
		++conv.nPreFail;
		if( called.lgTalk )
		{
			fprintf( ioQQQ, 
				" PROBLEM: pressure not converged; zone%4ld Te:%11.2e Hden:%10.2e curr Pres:%10.2e Corr Pres%10.2e\n", 
			  nzone, 
			  phycon.te, 
			  phycon.hden, 
			  pressure.PressureCurrent, 
			  pressure.PressureCorrect );

			/* this identifies new dynamics that failed near the sonic point */
			if( fabs(pressure.PressureGas - pressure.PressureRam)/pressure.PressureGas < 0.1 &&
				((strcmp(pressure.chCPres,"WIND") == 0) && wind.windv < 0. ) )
			{
				fprintf( ioQQQ, 
					"\n PROBLEM: pressure not converged; we are stuck at the sonic point.\n\n");
				pressure.lgSonicPoint = TRUE;
			}
		}
	}

	/* electron ensity failure */
	else if( strcmp( chMode, "eden" ) == 0 )
	{
		/* record number of electron density failures */
		++conv.nNeFail;

		if( called.lgTalk )
		{
			fprintf( ioQQQ, 
				" PROBLEM: electron density fails, correct=%11.3e "
				" assumed=%11.3e zone=%3ld.", 
			  phycon.EdenTrue, phycon.eden, nzone );

			/* some extra information that may be printed */
			/* heating cooling failure */
			if( !conv.lgConvTemp )
			{
				fprintf( ioQQQ, "  Temperature failure also." );
			}

			/* heating cooling failure */
			if( !conv.lgConvIoniz )
			{
				fprintf( ioQQQ, "  Ionization failure also." );
			}

			/* electron density is oscillating */
			if( conv.lgEdenOscl )
			{
				fprintf( ioQQQ, "  Electron density oscillating." );
			}

			/* heating cooling oscillating */
			if( conv.lgCmHOsc )
			{
				fprintf( ioQQQ, "  Heating-cooling oscillating." );
			}
		}
		fprintf( ioQQQ, " \n");
	}

	else if( strcmp( chMode, "ioni" ) == 0 )
	{
		/* ionization failure */
		++conv.nIonFail;
		if( called.lgTalk )
		{
			fprintf( ioQQQ, " PROBLEM: ionization not converged %3ld Z=%4ld \n", 
			  conv.nIonFail, nzone );
		}
	}

	/* rest of routine is temperature failure */
	else if( strcmp( chMode, "temp" ) == 0 )
	{
		++conv.nTeFail;
		if( called.lgTalk )
		{
			fprintf( ioQQQ, 
				" PROBLEM te fail %2ld Z=%4ld TE=%10.4e ERROR=%10.2e"
				" HTOT=%10.2e CTOT=%10.2e DERR=%10.2e DTe=%10.2e IonDone%1c\n", 
			  conv.nTeFail, nzone, phycon.te, (heat.htot - cooling.ctot)/
			  heat.htot, heat.htot, cooling.ctot, cooling.dCoolmHeatdT, thermal.dTemper, 
			  TorF(conv.lgConvIoniz) );

			if( conv.lgTOscl && conv.lgCmHOsc )
			{
				fprintf( ioQQQ, " Temperature and d(Cool-Heat)/dT were both oscillating.\n" );
			}

			else if( conv.lgTOscl )
			{
				fprintf( ioQQQ, " Temperature was oscillating.\n" );
			}

			else if( conv.lgCmHOsc )
			{
				fprintf( ioQQQ, " d(Cool-Heat)/dT was oscillating.\n" );
			}

			/* not really a temperature failure, but something else */
			if( !conv.lgConvIoniz )
			{
				fprintf( ioQQQ, " Solution not converged due to %10.10s\n", 
				  conv.chConvIoniz );
			}
		}
	}
	else
	{
		fprintf( ioQQQ, " ConvFail called with insane mode %s \n", 
		  chMode );
		ShowMe();
		puts( "[Stop in ConvFail]" );
		cdEXIT(EXIT_FAILURE);
	}

	/* increment total number of failures */
	++conv.nTotalFailures;

	/* now see how many total failures we have, and if it is time to abort */
	/* remember which zone this is */
	conv.ifailz[MIN2(conv.nTotalFailures,10)-1] = nzone;

	/* remember the relative error
	 * convert to single precision for following max, abs (vax failed here) */
	relerror = fabs((heat.htot-cooling.ctot)/ heat.htot);

	conv.failmx = MAX2(conv.failmx,(float)relerror);
	/*conv.failmx = (float)fmax(conv.failmx,fabs((float)((heat.htot-cooling.ctot)/
	  heat.htot)));*/

	if( conv.nTotalFailures < conv.LimFail )
	{ 
#		ifdef DEBUG_FUN
		fputs( " <->ConvFail()\n", debug_fp );
#		endif
		return;
	}

	/* punt */
	if( called.lgTalk )
	{
		fprintf( ioQQQ, " Stop after%3ld convergence failures.\n", 
		  conv.LimFail );
		fprintf( ioQQQ, " This limit can be reset with the FAILURES command.\n" );

		/* only do map if requested */
		/* adjust range of punting map */
		MapPar.RangeMap[0] = (float)(phycon.te/100.);
		MapPar.RangeMap[1] = (float)MIN2(phycon.te*100.,9e9);

		if( conv.lgMap )
		{
			/* need to make printout out now, before disturbing soln with map */
			PrtZone();
			punt("punt");
		}
	}

	/* return out from here and let lgEndFun catch lgBusted set,
	 * and generate normal output there */
	called.lgBusted = TRUE;
	if( called.lgTalk )
	{
		fprintf( ioQQQ, " ConvFail sets lgBusted since nTeFail>=LimFail%5ld%5ld\n", 
		  conv.nTeFail, conv.LimFail );
	}

#	ifdef DEBUG_FUN
	fputs( " <->ConvFail()\n", debug_fp );
#	endif
	return;
}
#undef LOOPMAX 
