/*CoolMang compute manganese cooling */
#include "cddefines.h"
#include "taulines.h"
#include "level2.h"
#include "cooling.h"
#include "putcs.h"

void CoolMang()
{

#	ifdef DEBUG_FUN
	fputs( "<+>CoolMang()\n", debug_fp );
#	endif

	/* [Mn IX] 7968.5A
	 * Y(ik) from 
	 *  >>refer Pelan, J., & Berrington, K.A. 1995, A&A Suppl, 110, 209 */
	PutCS(2.48,&TauLines[ipxMn0979]);
	level2(&TauLines[ipxMn0979]);

	/* [Mn 17] 1169.59, cs from 
	 *  >>refer Saraph, H.E. & Tully, J.A. 1994, A&AS, 107, 29 */
	PutCS(0.12,&TauLines[ipxMn1712]);
	level2(&TauLines[ipxMn1712]);

#	ifdef DEBUG_FUN
	fputs( " <->CoolMang()\n", debug_fp );
#	endif
	return;
}

