#include "cddefines.h"
#include "rfield.h"
#include "grainvar.h"
#include "grain.h"
#include "dustop.h"
#include "atomcwgt.h"
#include "physconst.h"


#ifdef INCLUDE_OLD_GRAINS

/* comment this out to use C84 AGB silicates */
#define C80_AGB_SIL 1

/* used to interpolate on grain opacity */
double crsdst(
		/* energy in ryd */
		double freq, 
		/* which grain species this is */
		long int nd, 
		/* 4 char + null string saying "ABSO" or "SCAT" */
		char *chAbedo,
		/* pinter within energy array */
		long int ipAnu);
/*lint do linear interpolation, used for grains opacity */
void lint(float xarray[], 
	  float yarray[], 
	  long int n, 
	  double xval, 
	  float *yval);


#define NINT(X) ((long)((X) < 0. ? (X)-0.5 : (X)+0.5))


/* new style grains read these constants in from the .opc file
 * old style grains have to initialize them explicitly */

/* these are the average grain areas 4pi<a^2> in cm^2 */
#define AVE_AREA_ISM    1.348728e-11
#define AVE_AREA_ORION  3.714492e-10
#define AREA_0M01       1.256637e-11
#define AREA_0M10       1.256637e-09
#define AREA_1M00       1.256637e-07
/* these are equivalent areas assuming PAH's are spherical (which they are not of course) */
#define AREA_PAH100     5.096649e-14
#define AREA_PAH035     1.300678e-14

/* these are the average grain volumes 4/3pi<a^3> in cm^3 */
#define AVE_VOL_ISM     1.589492e-17
#define AVE_VOL_ORION   1.072282e-15
#define VOL_0M01        4.188790e-18
#define VOL_0M10        4.188790e-15
#define VOL_1M00        4.188790e-12
/* these are equivalent volumes assuming PAH's are spherical (which they are not of course) */
#define VOL_PAH100      1.081934e-21
#define VOL_PAH035      1.394854e-22

/* these are the integrated grain radii per hydrogen, in cm/H */
#define INT_RAD_GRA_ISM   1.284530e-16
#define INT_RAD_SIL_ISM   1.486234e-16
#define INT_RAD_GRA_ORION 1.103527e-17
#define INT_RAD_SIL_ORION 1.276809e-17
#define INT_RAD_SIL_0M01  6.786465e-16
#define INT_RAD_SIL_0M10  6.786465e-18
#define INT_RAD_SIL_1M00  6.786465e-20
#define INT_RAD_PAH100    4.324683e-15
#define INT_RAD_PAH035    6.052629e-15

/* these are the integrated grain volumes per hydrogen, in cm^3/H */
#define INT_VOL_GRA     2.456911e-27
#define INT_VOL_SIL     2.842708e-27
#define INT_VOL_PAH100  7.347130e-29
#define INT_VOL_PAH035  2.624175e-29

/* these are the mean molecular weights per atom for MgSiFeO4 and SiO2 in amu */
#define MW_SIL      24.6051
/*#define MW_SIO2     20.0283*/
/* this is the molecular weight of C */
#define MW_C        12.0000

/* these are the average grain areas */
static double AveArea[NDOLD]={
	AVE_AREA_ISM, AVE_AREA_ISM, AVE_AREA_ORION, AVE_AREA_ORION, AREA_0M01,
	AREA_0M10, AVE_AREA_ISM, AVE_AREA_ISM, AREA_PAH100, AREA_PAH035, AREA_1M00};

/* these are the average grain volumes */
static double AveVol[NDOLD]={
	AVE_VOL_ISM, AVE_VOL_ISM, AVE_VOL_ORION, AVE_VOL_ORION, VOL_0M01,
	VOL_0M10, AVE_VOL_ISM, AVE_VOL_ISM, VOL_PAH100, VOL_PAH035, VOL_1M00};

/* these are the integrated grain radii */
static double IntRadius[NDOLD]={
	INT_RAD_GRA_ISM, INT_RAD_SIL_ISM, INT_RAD_GRA_ORION, INT_RAD_SIL_ORION,
	INT_RAD_SIL_0M01, INT_RAD_SIL_0M10, INT_RAD_SIL_ISM, INT_RAD_SIL_ISM,
	INT_RAD_PAH100, INT_RAD_PAH035, INT_RAD_SIL_1M00};

/* these are the integrated grain volumes */
static double IntVol[NDOLD]={
	INT_VOL_GRA, INT_VOL_SIL, INT_VOL_GRA, INT_VOL_SIL, INT_VOL_SIL,
	INT_VOL_SIL, INT_VOL_SIL, INT_VOL_SIL, INT_VOL_PAH100, INT_VOL_PAH035,
	INT_VOL_SIL};

/* this defines grain material */
static mat_type GrainType[NDOLD]={
	MAT_CAR, MAT_SIL, MAT_CAR, MAT_SIL, MAT_SIL, MAT_SIL,
	MAT_SIL, MAT_SIL, MAT_CAR, MAT_CAR, MAT_SIL};

/* these are the number of H per single (average) grain at standard depletion */
static double NumHperGrain[NDOLD] = {
	AVE_VOL_ISM/INT_VOL_GRA,
	AVE_VOL_ISM/INT_VOL_SIL,
	AVE_VOL_ORION/INT_VOL_GRA,
	AVE_VOL_ORION/INT_VOL_SIL,
	VOL_0M01/INT_VOL_SIL,
	VOL_0M10/INT_VOL_SIL,
	AVE_VOL_ISM/INT_VOL_SIL,
	AVE_VOL_ISM/INT_VOL_SIL,
	VOL_PAH100/INT_VOL_PAH100,
	VOL_PAH035/INT_VOL_PAH035,
	VOL_1M00/INT_VOL_SIL};

/* this is the mean molecular weight per atom for each grain species */
double MeanMolWeight[NDOLD] = {
	MW_C, MW_SIL, MW_C, MW_SIL, MW_SIL, MW_SIL, MW_SIL, MW_SIL, 10.0411, 7.875, MW_SIL};



/* block data for peter martin's grain opacitiers */
/*lint -e736 */
#ifdef _MSC_VER
#	pragma warning( disable : 4305 )/* disable bogus const double to float warning in MS VS*/
#endif


void OldStyleGrainBlockDataInit(void)
{
	long int i, 
	  j,
	  nd,
	  _r;
	/* >>chng 01 dec 05, changed dstela[4] -> dstela[NDOLD][4], dstelz[4] -> dstelz[NDOLD][4], PvH */
	float dstelz[NDOLD][4],
	  dstela[NDOLD][4];

#	ifdef DEBUG_FUN
	fputs( "<+>OldStyleGrainBlockDataInit()\n", debug_fp );
#	endif

	/* >>chng 01 sep 11, make sure we start with a clean slate, PvH */
	ReturnGrainBins();

	nd = NewGrainBin();
	strcpy( gv.bin[nd]->chDstLab, " Gra-ISM    " );
	{ static float _itmp0[] = {2.260e00,1.200e01,4.800e-04,5.800e-01};
	for( i=1, _r = 0; i <= 4; i++ )
	{
		gv.bin[nd]->dustp[i-1] = (float)_itmp0[_r++];
		}
	}
	gv.bin[nd]->ndpts = 157;
	gv.bin[nd]->IntArea = 2.085e-21;
	gv.bin[nd]->AvRadius = 3.536e-06;
	{ static float _itmp1[] = {6.000e00,0.000e00,0.000e00,0.000e00};
	for( i=1, _r = 0; i <= 4; i++ )
	{
		dstelz[nd][i-1] = (float)_itmp1[_r++];
		}
	}
	{ static float _itmp2[] = {2.784e-04,0.000e00,0.000e00,0.000e00};
	for( i=1, _r = 0; i <= 4; i++ )
	{
		dstela[nd][i-1] = (float)_itmp2[_r++];
		}
	}
	/* >>chng 00 apr 27, updated work function to Weingartner & Draine value, by PvH */
	gv.bin[nd]->DustWorkFcn = 0.3235;
	gv.bin[nd]->Tsublimat = 1750.;
	{ static float _itmp3[] = {-5.000,-2.999,-2.950,-2.901,-2.851,
	  -2.802,-2.752,-2.703,-2.654,-2.604,-2.555,-2.505,-2.456,
	  -2.407,-2.357,-2.308,-2.258,-2.209,-2.160,-2.110,-2.061,
	  -2.011,-1.962,-1.913,-1.863,-1.814,-1.764,-1.715,-1.666,
	  -1.616,-1.567,-1.517,-1.468,-1.418,-1.369,-1.320,-1.270,
	  -1.221,-1.171,-1.122,-1.073,-1.023,-0.974,-0.924,-0.875,
	  -0.826,-0.776,-0.727,-0.677,-0.628,-0.579,-0.529,-0.480,
	  -0.430,-0.381,-0.332,-0.282,-0.233,-0.183,-0.134,-0.085,
	  -0.035,0.014,0.064,0.113,0.162,0.212,0.261,0.311,0.360,0.409,
	  0.459,0.508,0.558,0.607,0.656,0.706,0.755,0.805,0.854,0.894,
	  0.932,0.970,1.008,1.044,1.079,1.112,1.144,1.174,1.201,1.225,
	  1.245,1.262,1.275,1.285,1.292,1.297,1.301,1.304,1.306,1.308,
	  1.309,1.310,1.311,1.312,1.313,1.314,1.315,1.316,1.317,1.318,
	  1.319,1.320,1.366,1.412,1.458,1.501,1.543,1.582,1.621,1.659,
	  1.696,1.733,1.769,1.805,1.841,1.876,1.911,1.946,1.981,2.016,
	  2.051,2.086,2.121,2.156,2.191,2.225,2.260,2.296,2.331,2.366,
	  2.400,2.437,2.472,2.508,2.542,2.580,2.616,2.655,2.689,2.723,
	  2.763,2.793,2.834,2.863,2.866,4.866};
	for( i=1, _r = 0; i <= 157; i++ )
	{
		gv.bin[nd]->eev[i-1] = (float)_itmp3[_r++];
		}
	}
	{ static double _itmp4[] = {-28.465,-24.449,-24.346,-24.242,
	  -24.140,-24.040,-23.947,-23.863,-23.792,-23.741,-23.713,
	  -23.712,-23.731,-23.764,-23.800,-23.828,-23.842,-23.837,
	  -23.812,-23.769,-23.713,-23.645,-23.568,-23.487,-23.400,
	  -23.317,-23.227,-23.136,-23.044,-22.952,-22.859,-22.766,
	  -22.674,-22.582,-22.493,-22.406,-22.324,-22.249,-22.180,
	  -22.114,-22.050,-21.990,-21.929,-21.868,-21.810,-21.754,
	  -21.699,-21.646,-21.594,-21.547,-21.506,-21.461,-21.412,
	  -21.316,-21.158,-21.279,-21.434,-21.512,-21.505,-21.408,
	  -21.290,-21.159,-21.111,-21.072,-21.120,-21.256,-21.362,
	  -21.453,-21.535,-21.566,-21.570,-21.613,-21.622,-21.662,
	  -21.702,-21.757,-21.834,-21.903,-21.959,-22.028,-22.094,
	  -22.151,-22.204,-22.266,-22.334,-22.402,-22.467,-22.532,
	  -22.596,-22.656,-22.711,-22.756,-22.795,-22.825,-22.848,
	  -22.864,-22.876,-22.885,-22.892,-22.896,-22.901,-22.903,
	  -22.905,-22.908,-22.910,-22.912,-22.914,-22.916,-22.918,
	  -22.920,-22.922,-22.923,-21.776,-21.836,-21.908,-21.993,
	  -22.073,-22.154,-22.234,-22.319,-22.404,-22.494,-22.578,
	  -22.672,-22.764,-22.860,-22.953,-23.048,-23.144,-23.245,
	  -23.343,-23.441,-23.542,-23.644,-23.746,-23.848,-23.948,
	  -24.053,-24.161,-24.264,-24.369,-24.472,-24.585,-24.693,
	  -24.804,-24.908,-25.027,-25.141,-25.264,-25.371,-25.479,
	  -25.607,-25.704,-25.840,-25.932,-25.941,-32.417};
	for( i=1, _r = 0; i <= 157; i++ )
	{
		gv.bin[nd]->sab[i-1] = (float)_itmp4[_r++];
		}
	}
	{ static float _itmp5[] = {-37.538,-29.541,-29.345,-29.149,
	  -28.954,-28.761,-28.570,-28.383,-28.199,-28.019,-27.840,
	  -27.660,-27.476,-27.287,-27.093,-26.897,-26.698,-26.499,
	  -26.299,-26.099,-25.900,-25.701,-25.502,-25.303,-25.104,
	  -24.905,-24.703,-24.501,-24.298,-24.092,-23.885,-23.676,
	  -23.467,-23.260,-23.060,-22.874,-22.710,-22.573,-22.462,
	  -22.368,-22.284,-22.216,-22.163,-22.122,-22.089,-22.065,
	  -22.044,-22.022,-21.997,-21.969,-21.931,-21.876,-21.796,
	  -21.709,-21.754,-22.008,-22.256,-22.268,-22.073,-21.886,
	  -21.725,-21.630,-21.640,-21.583,-21.631,-21.751,-21.863,
	  -21.970,-22.115,-22.306,-22.432,-22.551,-22.684,-22.781,
	  -22.909,-23.030,-23.175,-23.342,-23.507,-23.668,-23.806,
	  -23.942,-24.079,-24.218,-24.355,-24.493,-24.629,-24.768,
	  -24.908,-25.046,-25.184,-25.320,-25.462,-25.603,-25.749,
	  -25.890,-26.028,-26.181,-26.342,-26.486,-26.684,-26.814,
	  -26.974,-27.172,-27.389,-27.486,-27.280,-26.930,-26.583,
	  -26.254,-25.915,-25.409,-25.254,-25.300,-25.375,-25.499,
	  -25.635,-25.771,-25.907,-26.043,-26.181,-26.319,-26.456,
	  -26.592,-26.730,-26.869,-27.004,-27.140,-27.276,-27.412,
	  -27.548,-27.686,-27.822,-27.958,-28.095,-28.230,-28.366,
	  -28.503,-28.639,-28.777,-28.913,-29.049,-29.193,-29.329,
	  -29.464,-29.605,-29.750,-29.893,-30.030,-30.165,-30.313,
	  -30.449,-30.597,-30.704,-30.879,-30.885,-37.180};
	for( i=1, _r = 0; i <= 157; i++ )
	{
		gv.bin[nd]->sse[i-1] = (float)_itmp5[_r++];
		}
	}

	nd = NewGrainBin();
	strcpy( gv.bin[nd]->chDstLab, " Sil-ISM    " );
	/* >>chng 00 apr 27, updated molecular weight, by PvH */
	{ static float _itmp6[] = {3.300e00,1.722e02,4.000e-05,8.200e-01};
	for( i=1, _r = 0; i <= 4; i++ )
	{
		gv.bin[nd]->dustp[i-1] = (float)_itmp6[_r++];
		}
	}
	gv.bin[nd]->ndpts = 157;
	gv.bin[nd]->IntArea = 2.412e-21;
	gv.bin[nd]->AvRadius = 3.536e-06;
	{ static float _itmp7[] = {8.000e00,1.200e01,1.400e01,2.600e01};
	for( i=1, _r = 0; i <= 4; i++ )
	{
		dstelz[nd][i-1] = (float)_itmp7[_r++];
		}
	}
	{ static float _itmp8[] = {1.312e-04,3.280e-05,3.280e-05,3.280e-05};
	for( i=1, _r = 0; i <= 4; i++ )
	{
		dstela[nd][i-1] = (float)_itmp8[_r++];
		}
	}
	gv.bin[nd]->DustWorkFcn = 0.5883;
	gv.bin[nd]->Tsublimat = 1400.;
	{ static float _itmp9[] = {-5.000,-2.481,-2.431,-2.382,-2.332,
	  -2.283,-2.234,-2.209,-2.184,-2.160,-2.135,-2.110,-2.085,
	  -2.036,-2.011,-1.987,-1.962,-1.937,-1.913,-1.888,-1.863,
	  -1.838,-1.814,-1.789,-1.764,-1.740,-1.715,-1.666,-1.616,
	  -1.567,-1.517,-1.468,-1.418,-1.369,-1.320,-1.270,-1.221,
	  -1.171,-1.122,-1.073,-1.023,-0.974,-0.924,-0.875,-0.826,
	  -0.776,-0.727,-0.677,-0.628,-0.579,-0.529,-0.480,-0.430,
	  -0.381,-0.356,-0.332,-0.307,-0.282,-0.233,-0.208,-0.159,
	  -0.109,-0.060,-0.010,0.039,0.088,0.138,0.162,0.187,0.212,
	  0.261,0.311,0.360,0.409,0.459,0.508,0.558,0.607,0.656,0.706,
	  0.755,0.805,0.854,0.866,0.911,0.957,1.002,1.048,1.093,1.135,
	  1.175,1.212,1.247,1.281,1.314,1.346,1.378,1.409,1.440,1.469,
	  1.496,1.522,1.546,1.567,1.582,1.589,1.591,1.592,1.593,1.604,
	  1.650,1.683,1.706,1.720,1.724,1.725,1.771,1.815,1.851,1.884,
	  1.915,1.945,1.972,2.009,2.042,2.073,2.102,2.127,2.133,2.173,
	  2.206,2.237,2.267,2.297,2.327,2.357,2.387,2.415,2.446,2.473,
	  2.505,2.537,2.566,2.598,2.627,2.658,2.685,2.712,2.718,2.719,
	  2.720,2.761,2.793,2.836,2.864,2.866,4.866};
	for( i=1, _r = 0; i <= 157; i++ )
	{
		gv.bin[nd]->eev[i-1] = (float)_itmp9[_r++];
		}
	}
	{ static float _itmp10[] = {-28.457,-23.345,-23.241,-23.124,
	  -23.014,-22.997,-23.120,-23.187,-23.208,-23.119,-22.990,
	  -22.868,-22.748,-22.572,-22.544,-22.703,-22.953,-23.219,
	  -23.459,-23.628,-23.693,-23.685,-23.658,-23.649,-23.654,
	  -23.659,-23.654,-23.621,-23.582,-23.550,-23.518,-23.483,
	  -23.442,-23.399,-23.353,-23.302,-23.248,-23.191,-23.129,
	  -23.060,-22.984,-22.908,-22.842,-22.774,-22.701,-22.637,
	  -22.568,-22.505,-22.439,-22.378,-22.319,-22.262,-22.213,
	  -22.137,-22.004,-21.859,-21.714,-21.585,-21.420,-21.288,
	  -21.258,-21.207,-21.152,-21.112,-21.102,-21.083,-21.100,
	  -21.164,-21.261,-21.302,-21.337,-21.387,-21.409,-21.422,
	  -21.435,-21.453,-21.474,-21.495,-21.491,-21.502,-21.527,
	  -21.551,-21.578,-21.601,-21.570,-21.597,-21.628,-21.654,
	  -21.690,-21.732,-21.779,-21.827,-21.875,-21.924,-21.975,
	  -22.026,-22.078,-22.131,-22.189,-22.250,-22.307,-22.355,
	  -22.393,-22.432,-22.470,-22.488,-22.492,-22.396,-22.125,
	  -22.100,-22.185,-22.254,-22.303,-22.331,-22.300,-22.117,
	  -22.205,-22.271,-22.347,-22.421,-22.492,-22.562,-22.625,
	  -22.606,-22.686,-22.762,-22.834,-22.897,-22.784,-22.882,
	  -22.966,-23.046,-23.125,-23.204,-23.285,-23.367,-23.449,
	  -23.526,-23.611,-23.686,-23.776,-23.868,-23.950,-24.040,
	  -24.123,-24.214,-24.291,-24.366,-24.363,-24.074,-23.841,
	  -23.939,-24.022,-24.136,-24.220,-24.228,-29.744};
	for( i=1, _r = 0; i <= 157; i++ )
	{
		gv.bin[nd]->sab[i-1] = (float)_itmp10[_r++];
		}
	}
	{ static float _itmp11[] = {-37.697,-27.642,-27.453,-27.268,
	  -27.123,-27.082,-27.019,-26.909,-26.743,-26.560,-26.407,
	  -26.274,-26.154,-26.017,-26.055,-26.370,-26.729,-26.729,
	  -26.467,-26.222,-26.025,-25.864,-25.726,-25.601,-25.482,
	  -25.365,-25.251,-25.031,-24.820,-24.614,-24.410,-24.209,
	  -24.011,-23.815,-23.624,-23.438,-23.260,-23.095,-22.948,
	  -22.819,-22.701,-22.579,-22.464,-22.369,-22.284,-22.206,
	  -22.132,-22.068,-22.005,-21.948,-21.893,-21.839,-21.781,
	  -21.719,-21.710,-21.714,-21.734,-21.767,-21.772,-21.793,
	  -21.881,-21.850,-21.800,-21.817,-21.830,-21.799,-21.765,
	  -21.779,-21.902,-22.042,-22.185,-22.332,-22.467,-22.607,
	  -22.688,-22.783,-22.891,-23.024,-23.132,-23.195,-23.304,
	  -23.423,-23.552,-23.695,-23.673,-23.762,-23.875,-23.989,
	  -24.096,-24.210,-24.326,-24.441,-24.554,-24.668,-24.782,
	  -24.895,-25.011,-25.125,-25.241,-25.355,-25.468,-25.584,
	  -25.698,-25.813,-25.934,-26.055,-26.186,-26.251,-26.070,
	  -25.955,-26.016,-26.132,-26.246,-26.373,-26.528,-26.343,
	  -26.365,-26.479,-26.594,-26.708,-26.822,-26.937,-27.053,
	  -27.167,-27.282,-27.398,-27.511,-27.625,-27.649,-27.763,
	  -27.881,-27.997,-28.111,-28.225,-28.340,-28.454,-28.568,
	  -28.683,-28.798,-28.912,-29.039,-29.162,-29.279,-29.400,
	  -29.514,-29.639,-29.753,-29.869,-29.904,-29.922,-29.919,
	  -30.032,-30.177,-30.282,-30.451,-30.455,-37.596};
	for( i=1, _r = 0; i <= 157; i++ )
	{
		gv.bin[nd]->sse[i-1] = (float)_itmp11[_r++];
		}
	}

	nd = NewGrainBin();
	strcpy( gv.bin[nd]->chDstLab, " Gra-Ori    " );
	{ static float _itmp12[] = {2.260e00,1.200e01,4.800e-04,5.800e-01};
	for( i=1, _r = 0; i <= 4; i++ )
	{
		gv.bin[nd]->dustp[i-1] = (float)_itmp12[_r++];
		}
	}
	gv.bin[nd]->ndpts = 157;
	gv.bin[nd]->IntArea = 8.511e-22;
	gv.bin[nd]->AvRadius = 8.660e-06;
	{ static float _itmp13[] = {6.000e00,0.000e00,0.000e00,0.000e00};
	for( i=1, _r = 0; i <= 4; i++ )
	{
		dstelz[nd][i-1] = (float)_itmp13[_r++];
		}
	}
	{ static float _itmp14[] = {2.784e-04,0.000e00,0.000e00,0.000e00};
	for( i=1, _r = 0; i <= 4; i++ )
	{
		dstela[nd][i-1] = (float)_itmp14[_r++];
		}
	}
	gv.bin[nd]->DustWorkFcn = 0.3235;
	gv.bin[nd]->Tsublimat = 1750.;
	{ static float _itmp15[] = {-5.000,-2.999,-2.950,-2.901,-2.851,
	  -2.802,-2.752,-2.703,-2.654,-2.604,-2.555,-2.505,-2.456,
	  -2.407,-2.357,-2.308,-2.258,-2.209,-2.160,-2.110,-2.061,
	  -2.011,-1.962,-1.913,-1.863,-1.814,-1.764,-1.715,-1.666,
	  -1.616,-1.567,-1.517,-1.468,-1.418,-1.369,-1.320,-1.270,
	  -1.221,-1.171,-1.122,-1.073,-1.023,-0.974,-0.924,-0.875,
	  -0.826,-0.776,-0.727,-0.677,-0.628,-0.579,-0.529,-0.480,
	  -0.430,-0.381,-0.332,-0.282,-0.233,-0.183,-0.134,-0.085,
	  -0.035,0.014,0.064,0.113,0.162,0.212,0.261,0.311,0.360,0.409,
	  0.459,0.508,0.558,0.607,0.656,0.706,0.755,0.805,0.854,0.894,
	  0.932,0.970,1.008,1.044,1.079,1.112,1.143,1.172,1.199,1.223,
	  1.244,1.261,1.274,1.284,1.291,1.297,1.301,1.304,1.306,1.308,
	  1.309,1.310,1.311,1.312,1.313,1.314,1.315,1.316,1.317,1.318,
	  1.319,1.320,1.366,1.412,1.458,1.503,1.546,1.586,1.626,1.664,
	  1.701,1.738,1.774,1.809,1.845,1.881,1.916,1.951,1.986,2.021,
	  2.057,2.092,2.127,2.161,2.197,2.233,2.268,2.303,2.339,2.374,
	  2.410,2.447,2.479,2.514,2.551,2.591,2.631,2.667,2.702,2.741,
	  2.783,2.821,2.844,2.845,2.866,4.866};
	for( i=1, _r = 0; i <= 157; i++ )
	{
		gv.bin[nd]->eev[i-1] = (float)_itmp15[_r++];
		}
	}
	{ static float _itmp16[] = {-28.460,-24.447,-24.343,-24.239,
	  -24.136,-24.037,-23.943,-23.859,-23.788,-23.737,-23.710,
	  -23.708,-23.726,-23.758,-23.792,-23.817,-23.828,-23.820,
	  -23.792,-23.746,-23.687,-23.616,-23.537,-23.454,-23.365,
	  -23.279,-23.186,-23.094,-22.999,-22.905,-22.809,-22.713,
	  -22.618,-22.525,-22.433,-22.345,-22.263,-22.188,-22.120,
	  -22.056,-21.995,-21.937,-21.880,-21.822,-21.769,-21.717,
	  -21.667,-21.622,-21.583,-21.553,-21.532,-21.521,-21.526,
	  -21.522,-21.507,-21.565,-21.598,-21.606,-21.575,-21.532,
	  -21.548,-21.579,-21.596,-21.625,-21.685,-21.740,-21.768,
	  -21.793,-21.810,-21.800,-21.790,-21.804,-21.800,-21.817,
	  -21.836,-21.867,-21.919,-21.969,-22.013,-22.072,-22.130,
	  -22.181,-22.230,-22.288,-22.352,-22.417,-22.480,-22.541,
	  -22.601,-22.660,-22.713,-22.760,-22.799,-22.828,-22.851,
	  -22.867,-22.880,-22.889,-22.896,-22.901,-22.905,-22.907,
	  -22.910,-22.912,-22.914,-22.916,-22.918,-22.920,-22.923,
	  -22.925,-22.926,-22.927,-21.860,-21.906,-21.964,-22.037,
	  -22.111,-22.188,-22.264,-22.348,-22.430,-22.516,-22.600,
	  -22.692,-22.781,-22.875,-22.971,-23.065,-23.161,-23.261,
	  -23.358,-23.460,-23.560,-23.662,-23.761,-23.866,-23.972,
	  -24.077,-24.182,-24.288,-24.393,-24.502,-24.616,-24.715,
	  -24.822,-24.936,-25.062,-25.189,-25.302,-25.412,-25.537,
	  -25.672,-25.797,-25.873,-25.876,-25.941,-32.417};
	for( i=1, _r = 0; i <= 157; i++ )
	{
		gv.bin[nd]->sab[i-1] = (float)_itmp16[_r++];
		}
	}
	{ static float _itmp17[] = {-37.420,-29.423,-29.227,-29.031,
	  -28.836,-28.643,-28.452,-28.265,-28.081,-27.901,-27.722,
	  -27.542,-27.358,-27.169,-26.975,-26.778,-26.580,-26.380,
	  -26.181,-25.981,-25.782,-25.583,-25.384,-25.185,-24.986,
	  -24.787,-24.584,-24.383,-24.179,-23.974,-23.767,-23.558,
	  -23.349,-23.142,-22.942,-22.756,-22.592,-22.455,-22.344,
	  -22.250,-22.166,-22.098,-22.046,-22.005,-21.972,-21.949,
	  -21.929,-21.910,-21.888,-21.865,-21.835,-21.793,-21.737,
	  -21.701,-21.812,-22.027,-22.254,-22.287,-22.155,-22.095,
	  -22.062,-22.021,-22.052,-22.034,-22.039,-22.107,-22.194,
	  -22.287,-22.425,-22.621,-22.760,-22.876,-23.015,-23.107,
	  -23.228,-23.338,-23.468,-23.625,-23.786,-23.943,-24.078,
	  -24.213,-24.349,-24.486,-24.621,-24.759,-24.894,-25.029,
	  -25.163,-25.300,-25.437,-25.578,-25.718,-25.856,-25.998,
	  -26.132,-26.294,-26.447,-26.607,-26.751,-26.949,-27.078,
	  -27.239,-27.436,-27.653,-27.751,-27.545,-27.195,-26.848,
	  -26.518,-26.179,-25.672,-25.614,-25.647,-25.711,-25.823,
	  -25.957,-26.092,-26.226,-26.363,-26.499,-26.636,-26.771,
	  -26.907,-27.041,-27.180,-27.318,-27.454,-27.591,-27.730,
	  -27.867,-28.007,-28.144,-28.282,-28.420,-28.556,-28.702,
	  -28.842,-28.981,-29.116,-29.250,-29.386,-29.520,-29.654,
	  -29.790,-29.962,-30.113,-30.248,-30.383,-30.567,-30.743,
	  -30.827,-30.962,-31.008,-31.156,-31.198,-37.250};
	for( i=1, _r = 0; i <= 157; i++ )
	{
		gv.bin[nd]->sse[i-1] = (float)_itmp17[_r++];
		}
	}

	nd = NewGrainBin();
	strcpy( gv.bin[nd]->chDstLab, " Sil-Ori    " );
	{ static float _itmp18[] = {3.300e00,1.722e02,4.000e-05,8.200e-01};
	for( i=1, _r = 0; i <= 4; i++ )
	{
		gv.bin[nd]->dustp[i-1] = (float)_itmp18[_r++];
		}
	}
	gv.bin[nd]->ndpts = 157;
	gv.bin[nd]->IntArea = 9.847e-22;
	gv.bin[nd]->AvRadius = 8.660e-06;
	{ static float _itmp19[] = {8.000e00,1.200e01,1.400e01,2.600e01};
	for( i=1, _r = 0; i <= 4; i++ )
	{
		dstelz[nd][i-1] = (float)_itmp19[_r++];
		}
	}
	{ static float _itmp20[] = {1.312e-04,3.280e-05,3.280e-05,
	  3.280e-05};
	for( i=1, _r = 0; i <= 4; i++ )
	{
		dstela[nd][i-1] = (float)_itmp20[_r++];
		}
	}
	gv.bin[nd]->DustWorkFcn = 0.5883;
	gv.bin[nd]->Tsublimat = 1400.;
	{ static float _itmp21[] = {-5.000,-2.481,-2.431,-2.382,-2.332,
	  -2.283,-2.234,-2.209,-2.184,-2.160,-2.135,-2.110,-2.085,
	  -2.036,-2.011,-1.987,-1.962,-1.937,-1.913,-1.888,-1.863,
	  -1.838,-1.814,-1.789,-1.764,-1.740,-1.715,-1.690,-1.641,
	  -1.591,-1.542,-1.493,-1.443,-1.394,-1.344,-1.295,-1.246,
	  -1.196,-1.147,-1.097,-1.048,-0.999,-0.949,-0.900,-0.850,
	  -0.801,-0.752,-0.702,-0.653,-0.603,-0.554,-0.505,-0.455,
	  -0.406,-0.381,-0.356,-0.332,-0.307,-0.257,-0.208,-0.159,
	  -0.109,-0.060,-0.010,0.039,0.088,0.138,0.187,0.212,0.261,
	  0.311,0.360,0.409,0.459,0.508,0.558,0.607,0.656,0.706,0.755,
	  0.805,0.854,0.866,0.911,0.957,1.002,1.048,1.093,1.137,1.178,
	  1.216,1.252,1.287,1.321,1.354,1.386,1.417,1.447,1.476,1.503,
	  1.528,1.551,1.571,1.584,1.590,1.592,1.593,1.604,1.650,1.683,
	  1.706,1.719,1.723,1.724,1.725,1.771,1.815,1.851,1.883,1.914,
	  1.943,1.970,1.981,2.026,2.057,2.086,2.114,2.131,2.177,2.210,
	  2.239,2.269,2.301,2.332,2.363,2.389,2.417,2.450,2.484,2.507,
	  2.535,2.569,2.592,2.619,2.642,2.677,2.703,2.718,2.719,2.720,
	  2.755,2.788,2.831,2.845,2.846,2.866,4.866};
	for( i=1, _r = 0; i <= 157; i++ )
	{
		gv.bin[nd]->eev[i-1] = (float)_itmp21[_r++];
		}
	}
	{ static float _itmp22[] = {-28.457,-23.345,-23.241,-23.124,
	  -23.013,-22.997,-23.120,-23.187,-23.208,-23.118,-22.989,
	  -22.868,-22.747,-22.571,-22.544,-22.703,-22.953,-23.219,
	  -23.459,-23.627,-23.692,-23.684,-23.656,-23.647,-23.652,
	  -23.657,-23.652,-23.638,-23.597,-23.561,-23.529,-23.495,
	  -23.455,-23.411,-23.364,-23.313,-23.258,-23.198,-23.136,
	  -23.066,-22.987,-22.904,-22.828,-22.760,-22.684,-22.612,
	  -22.545,-22.475,-22.409,-22.346,-22.282,-22.223,-22.161,
	  -22.124,-22.067,-21.937,-21.799,-21.666,-21.503,-21.452,
	  -21.457,-21.468,-21.484,-21.500,-21.513,-21.539,-21.586,
	  -21.660,-21.655,-21.655,-21.666,-21.666,-21.664,-21.667,
	  -21.672,-21.679,-21.685,-21.680,-21.685,-21.695,-21.706,
	  -21.719,-21.730,-21.713,-21.728,-21.746,-21.762,-21.786,
	  -21.817,-21.854,-21.893,-21.934,-21.978,-22.025,-22.072,
	  -22.120,-22.170,-22.224,-22.284,-22.337,-22.378,-22.414,
	  -22.453,-22.486,-22.500,-22.409,-22.151,-22.128,-22.207,
	  -22.272,-22.320,-22.345,-22.353,-22.317,-22.144,-22.226,
	  -22.289,-22.361,-22.431,-22.500,-22.566,-22.628,-22.653,
	  -22.654,-22.729,-22.799,-22.868,-22.898,-22.896,-22.979,
	  -23.054,-23.132,-23.217,-23.300,-23.384,-23.455,-23.532,
	  -23.623,-23.717,-23.782,-23.863,-23.958,-24.023,-24.101,
	  -24.167,-24.269,-24.342,-24.363,-24.074,-23.841,-23.923,
	  -24.010,-24.123,-24.161,-24.163,-24.228,-29.742};
	for( i=1, _r = 0; i <= 157; i++ )
	{
		gv.bin[nd]->sab[i-1] = (float)_itmp22[_r++];
		}
	}
	{ static float _itmp23[] = {-37.578,-27.524,-27.335,-27.150,
	  -27.004,-26.964,-26.901,-26.791,-26.625,-26.442,-26.289,
	  -26.155,-26.036,-25.898,-25.937,-26.252,-26.611,-26.610,
	  -26.349,-26.104,-25.907,-25.746,-25.608,-25.483,-25.364,
	  -25.247,-25.133,-25.022,-24.807,-24.598,-24.393,-24.191,
	  -23.991,-23.794,-23.601,-23.412,-23.229,-23.058,-22.901,
	  -22.763,-22.642,-22.522,-22.401,-22.297,-22.208,-22.127,
	  -22.052,-21.983,-21.921,-21.863,-21.809,-21.757,-21.708,
	  -21.650,-21.627,-21.626,-21.642,-21.682,-21.796,-21.951,
	  -22.074,-22.112,-22.122,-22.169,-22.213,-22.206,-22.168,
	  -22.236,-22.372,-22.527,-22.675,-22.820,-22.972,-23.064,
	  -23.163,-23.271,-23.402,-23.519,-23.582,-23.683,-23.798,
	  -23.923,-24.058,-24.055,-24.138,-24.243,-24.352,-24.451,
	  -24.561,-24.672,-24.783,-24.893,-25.006,-25.119,-25.231,
	  -25.344,-25.455,-25.566,-25.680,-25.794,-25.905,-26.016,
	  -26.132,-26.250,-26.382,-26.545,-26.381,-26.268,-26.325,
	  -26.438,-26.550,-26.660,-26.782,-26.833,-26.660,-26.677,
	  -26.789,-26.901,-27.011,-27.122,-27.234,-27.345,-27.457,
	  -27.527,-27.641,-27.751,-27.865,-27.976,-28.085,-28.204,
	  -28.315,-28.426,-28.552,-28.664,-28.775,-28.893,-29.005,
	  -29.134,-29.246,-29.357,-29.470,-29.582,-29.700,-29.811,
	  -29.921,-30.032,-30.173,-30.234,-30.252,-30.249,-30.360,
	  -30.476,-30.557,-30.583,-30.731,-30.769,-37.665};
	for( i=1, _r = 0; i <= 157; i++ )
	{
		gv.bin[nd]->sse[i-1] = (float)_itmp23[_r++];
		}
	}

	nd = NewGrainBin();
	strcpy( gv.bin[nd]->chDstLab, " Sil-0.01   " );
	{ static float _itmp24[] = {3.300e00,1.722e02,4.000e-05,8.200e-01};
	for( i=1, _r = 0; i <= 4; i++ )
	{
		gv.bin[nd]->dustp[i-1] = (float)_itmp24[_r++];
		}
	}
	gv.bin[nd]->ndpts = 157;
	gv.bin[nd]->IntArea = 8.528e-21;
	gv.bin[nd]->AvRadius = 1.000e-06;
	{ static float _itmp25[] = {8.000e00,1.200e01,1.400e01,2.600e01};
	for( i=1, _r = 0; i <= 4; i++ )
	{
		dstelz[nd][i-1] = (float)_itmp25[_r++];
		}
	}
	{ static float _itmp26[] = {1.312e-04,3.280e-05,3.280e-05,
	  3.280e-05};
	for( i=1, _r = 0; i <= 4; i++ )
	{
		dstela[nd][i-1] = (float)_itmp26[_r++];
		}
	}
	gv.bin[nd]->DustWorkFcn = 0.5883;
	gv.bin[nd]->Tsublimat = 1400.;
	{ static float _itmp27[] = {-5.000,-2.481,-2.431,-2.382,-2.332,
	  -2.283,-2.234,-2.209,-2.184,-2.160,-2.135,-2.110,-2.085,
	  -2.036,-2.011,-1.987,-1.962,-1.937,-1.913,-1.888,-1.863,
	  -1.838,-1.814,-1.789,-1.764,-1.740,-1.690,-1.641,-1.591,
	  -1.542,-1.493,-1.443,-1.394,-1.344,-1.295,-1.246,-1.196,
	  -1.147,-1.097,-1.048,-0.999,-0.949,-0.900,-0.850,-0.801,
	  -0.752,-0.702,-0.653,-0.603,-0.554,-0.505,-0.455,-0.430,
	  -0.406,-0.381,-0.356,-0.332,-0.307,-0.282,-0.257,-0.233,
	  -0.208,-0.159,-0.134,-0.085,-0.060,-0.010,0.039,0.088,0.138,
	  0.162,0.187,0.212,0.261,0.311,0.360,0.409,0.459,0.508,0.558,
	  0.607,0.656,0.706,0.755,0.805,0.854,0.866,0.911,0.957,1.002,
	  1.045,1.090,1.129,1.170,1.206,1.241,1.277,1.309,1.342,1.375,
	  1.407,1.438,1.467,1.495,1.522,1.547,1.569,1.583,1.590,1.592,
	  1.593,1.605,1.651,1.684,1.707,1.720,1.724,1.725,1.771,1.816,
	  1.853,1.886,1.918,1.948,1.975,2.016,2.049,2.080,2.110,2.131,
	  2.177,2.210,2.242,2.273,2.304,2.335,2.366,2.397,2.428,2.459,
	  2.489,2.519,2.549,2.579,2.609,2.639,2.669,2.698,2.718,2.719,
	  2.720,2.766,2.798,2.830,2.861,2.866,4.866};
	for( i=1, _r = 0; i <= 157; i++ )
	{
		gv.bin[nd]->eev[i-1] = (float)_itmp27[_r++];
		}
	}
	{ static float _itmp28[] = {-28.457,-23.345,-23.242,-23.125,
	  -23.014,-22.998,-23.121,-23.188,-23.209,-23.120,-22.992,
	  -22.870,-22.750,-22.573,-22.545,-22.703,-22.953,-23.220,
	  -23.461,-23.630,-23.696,-23.688,-23.662,-23.654,-23.659,
	  -23.665,-23.649,-23.611,-23.579,-23.552,-23.523,-23.490,
	  -23.455,-23.419,-23.380,-23.339,-23.297,-23.254,-23.209,
	  -23.162,-23.115,-23.069,-23.022,-22.974,-22.927,-22.880,
	  -22.832,-22.785,-22.739,-22.694,-22.653,-22.607,-22.603,
	  -22.597,-22.546,-22.395,-22.214,-22.007,-21.790,-21.633,
	  -21.469,-21.080,-20.952,-20.902,-20.755,-20.646,-20.537,
	  -20.505,-20.467,-20.487,-20.564,-20.696,-20.767,-20.830,
	  -20.912,-20.955,-20.983,-21.004,-21.035,-21.074,-21.114,
	  -21.112,-21.131,-21.176,-21.218,-21.266,-21.307,-21.256,
	  -21.302,-21.354,-21.394,-21.449,-21.510,-21.580,-21.647,
	  -21.714,-21.785,-21.849,-21.915,-21.982,-22.047,-22.115,
	  -22.186,-22.253,-22.309,-22.352,-22.398,-22.438,-22.457,
	  -22.354,-22.045,-22.016,-22.118,-22.198,-22.254,-22.283,
	  -22.248,-22.036,-22.139,-22.218,-22.305,-22.387,-22.466,
	  -22.541,-22.608,-22.599,-22.683,-22.763,-22.840,-22.881,
	  -22.879,-22.966,-23.050,-23.133,-23.217,-23.302,-23.387,
	  -23.473,-23.559,-23.645,-23.729,-23.815,-23.901,-23.985,
	  -24.071,-24.158,-24.245,-24.327,-24.363,-24.073,-23.839,
	  -23.951,-24.034,-24.119,-24.207,-24.227,-29.755};
	for( i=1, _r = 0; i <= 157; i++ )
	{
		gv.bin[nd]->sab[i-1] = (float)_itmp28[_r++];
		}
	}
	{ static float _itmp29[] = {-41.112,-31.058,-30.868,-30.684,
	  -30.538,-30.497,-30.435,-30.325,-30.159,-29.976,-29.823,
	  -29.690,-29.570,-29.431,-29.468,-29.781,-30.140,-30.140,
	  -29.879,-29.634,-29.438,-29.277,-29.139,-29.014,-28.895,
	  -28.778,-28.553,-28.337,-28.128,-27.923,-27.719,-27.517,
	  -27.316,-27.117,-26.918,-26.719,-26.521,-26.323,-26.126,
	  -25.928,-25.730,-25.532,-25.334,-25.135,-24.936,-24.735,
	  -24.534,-24.331,-24.125,-23.916,-23.704,-23.484,-23.372,
	  -23.254,-23.130,-23.001,-22.870,-22.733,-22.597,-22.464,
	  -22.293,-22.093,-22.021,-21.900,-21.694,-21.541,-21.405,
	  -21.309,-21.188,-21.125,-21.170,-21.337,-21.480,-21.600,
	  -21.738,-21.862,-22.003,-22.101,-22.221,-22.354,-22.494,
	  -22.577,-22.624,-22.744,-22.879,-22.998,-23.143,-23.123,
	  -23.218,-23.329,-23.447,-23.550,-23.667,-23.787,-23.904,
	  -24.023,-24.144,-24.261,-24.380,-24.500,-24.619,-24.738,
	  -24.855,-24.974,-25.094,-25.213,-25.335,-25.458,-25.601,
	  -25.759,-25.567,-25.449,-25.519,-25.636,-25.755,-25.876,
	  -26.030,-25.837,-25.862,-25.980,-26.100,-26.217,-26.334,
	  -26.452,-26.572,-26.692,-26.809,-26.926,-27.046,-27.176,
	  -27.278,-27.397,-27.516,-27.633,-27.751,-27.870,-27.989,
	  -28.109,-28.229,-28.349,-28.466,-28.583,-28.700,-28.818,
	  -28.936,-29.055,-29.174,-29.295,-29.406,-29.425,-29.422,
	  -29.541,-29.658,-29.778,-29.895,-29.912,-37.618};
	for( i=1, _r = 0; i <= 157; i++ )
	{
		gv.bin[nd]->sse[i-1] = (float)_itmp29[_r++];
		}
	}

	nd = NewGrainBin();
	strcpy( gv.bin[nd]->chDstLab, " Sil-0.1    " );
	{ static float _itmp30[] = {3.300e00,1.722e02,4.000e-05,8.200e-01};
	for( i=1, _r = 0; i <= 4; i++ )
	{
		gv.bin[nd]->dustp[i-1] = (float)_itmp30[_r++];
		}
	}
	gv.bin[nd]->ndpts = 157;
	gv.bin[nd]->IntArea = 8.528e-22;
	gv.bin[nd]->AvRadius = 1.000e-05;
	{ static float _itmp31[] = {8.000e00,1.200e01,1.400e01,2.600e01};
	for( i=1, _r = 0; i <= 4; i++ )
	{
		dstelz[nd][i-1] = (float)_itmp31[_r++];
		}
	}
	{ static float _itmp32[] = {1.312e-04,3.280e-05,3.280e-05,
	  3.280e-05};
	for( i=1, _r = 0; i <= 4; i++ )
	{
		dstela[nd][i-1] = (float)_itmp32[_r++];
		}
	}
	gv.bin[nd]->DustWorkFcn = 0.5883;
	gv.bin[nd]->Tsublimat = 1400.;
	{ static float _itmp33[] = {-5.000,-2.481,-2.431,-2.382,-2.332,
	  -2.283,-2.234,-2.209,-2.184,-2.160,-2.135,-2.110,-2.085,
	  -2.036,-2.011,-1.987,-1.962,-1.937,-1.913,-1.888,-1.863,
	  -1.838,-1.814,-1.789,-1.764,-1.740,-1.715,-1.690,-1.666,
	  -1.616,-1.567,-1.517,-1.468,-1.418,-1.369,-1.320,-1.270,
	  -1.221,-1.171,-1.122,-1.073,-1.023,-0.974,-0.924,-0.875,
	  -0.826,-0.776,-0.727,-0.677,-0.628,-0.579,-0.529,-0.480,
	  -0.430,-0.406,-0.381,-0.332,-0.307,-0.282,-0.257,-0.208,
	  -0.159,-0.109,-0.060,-0.010,0.039,0.088,0.138,0.187,0.212,
	  0.261,0.311,0.360,0.409,0.459,0.508,0.558,0.607,0.656,0.706,
	  0.755,0.805,0.854,0.866,0.911,0.957,1.002,1.048,1.093,1.138,
	  1.180,1.219,1.256,1.291,1.325,1.357,1.389,1.420,1.450,1.478,
	  1.504,1.529,1.552,1.571,1.584,1.590,1.592,1.593,1.604,1.650,
	  1.683,1.706,1.719,1.723,1.724,1.725,1.771,1.815,1.850,1.883,
	  1.913,1.942,1.968,1.981,2.026,2.057,2.085,2.113,2.131,2.133,
	  2.172,2.203,2.231,2.262,2.292,2.321,2.350,2.379,2.409,2.438,
	  2.471,2.503,2.525,2.556,2.589,2.614,2.640,2.663,2.696,2.718,
	  2.719,2.720,2.763,2.805,2.832,2.866,4.866};
	for( i=1, _r = 0; i <= 157; i++ )
	{
		gv.bin[nd]->eev[i-1] = (float)_itmp33[_r++];
		}
	}
	{ static float _itmp34[] = {-28.457,-23.345,-23.241,-23.124,
	  -23.014,-22.997,-23.120,-23.187,-23.208,-23.119,-22.990,
	  -22.869,-22.749,-22.572,-22.544,-22.703,-22.953,-23.220,
	  -23.460,-23.629,-23.694,-23.686,-23.659,-23.650,-23.655,
	  -23.661,-23.656,-23.643,-23.624,-23.586,-23.555,-23.524,
	  -23.490,-23.452,-23.410,-23.366,-23.318,-23.267,-23.212,
	  -23.154,-23.090,-23.022,-22.952,-22.879,-22.802,-22.721,
	  -22.634,-22.532,-22.402,-22.281,-22.269,-22.258,-22.085,
	  -22.118,-22.120,-21.934,-21.753,-21.586,-21.529,-21.524,
	  -21.553,-21.550,-21.568,-21.588,-21.604,-21.617,-21.643,
	  -21.689,-21.744,-21.730,-21.721,-21.723,-21.718,-21.711,
	  -21.712,-21.713,-21.716,-21.717,-21.712,-21.714,-21.720,
	  -21.725,-21.732,-21.738,-21.727,-21.736,-21.748,-21.760,
	  -21.779,-21.807,-21.841,-21.879,-21.921,-21.966,-22.013,
	  -22.060,-22.109,-22.160,-22.217,-22.276,-22.328,-22.370,
	  -22.406,-22.444,-22.478,-22.493,-22.400,-22.136,-22.112,
	  -22.194,-22.260,-22.309,-22.334,-22.342,-22.305,-22.128,
	  -22.213,-22.277,-22.349,-22.422,-22.490,-22.557,-22.617,
	  -22.648,-22.649,-22.724,-22.793,-22.862,-22.895,-22.785,
	  -22.880,-22.959,-23.031,-23.112,-23.191,-23.269,-23.348,
	  -23.427,-23.510,-23.590,-23.680,-23.770,-23.834,-23.922,
	  -24.015,-24.086,-24.161,-24.228,-24.322,-24.363,-24.074,
	  -23.841,-23.944,-24.053,-24.125,-24.228,-29.744};
	for( i=1, _r = 0; i <= 157; i++ )
	{
		gv.bin[nd]->sab[i-1] = (float)_itmp34[_r++];
		}
	}
	{ static float _itmp35[] = {-38.111,-28.058,-27.868,-27.684,
	  -27.538,-27.497,-27.435,-27.325,-27.159,-26.976,-26.823,
	  -26.690,-26.570,-26.431,-26.468,-26.782,-27.141,-27.141,
	  -26.880,-26.635,-26.438,-26.277,-26.140,-26.015,-25.895,
	  -25.779,-25.665,-25.553,-25.444,-25.233,-25.026,-24.821,
	  -24.619,-24.418,-24.218,-24.019,-23.821,-23.623,-23.427,
	  -23.231,-23.038,-22.846,-22.659,-22.478,-22.308,-22.157,
	  -22.035,-21.950,-21.884,-21.756,-21.614,-21.586,-21.568,
	  -21.531,-21.501,-21.459,-21.662,-21.819,-22.086,-22.226,
	  -22.205,-22.308,-22.310,-22.289,-22.315,-22.348,-22.324,
	  -22.271,-22.327,-22.464,-22.620,-22.768,-22.914,-23.068,
	  -23.160,-23.259,-23.366,-23.497,-23.616,-23.677,-23.776,
	  -23.888,-24.010,-24.143,-24.144,-24.224,-24.324,-24.430,
	  -24.525,-24.633,-24.742,-24.852,-24.963,-25.073,-25.183,
	  -25.291,-25.403,-25.512,-25.622,-25.732,-25.841,-25.953,
	  -26.064,-26.174,-26.292,-26.424,-26.588,-26.428,-26.317,
	  -26.371,-26.483,-26.595,-26.705,-26.827,-26.877,-26.708,
	  -26.724,-26.834,-26.944,-27.055,-27.164,-27.272,-27.381,
	  -27.501,-27.571,-27.685,-27.794,-27.906,-28.022,-27.998,
	  -28.106,-28.215,-28.327,-28.441,-28.562,-28.671,-28.781,
	  -28.889,-29.017,-29.131,-29.261,-29.370,-29.479,-29.599,
	  -29.709,-29.832,-29.941,-30.052,-30.162,-30.241,-30.259,
	  -30.255,-30.460,-30.536,-30.645,-30.709,-37.149};
	for( i=1, _r = 0; i <= 157; i++ )
	{
		gv.bin[nd]->sse[i-1] = (float)_itmp35[_r++];
		}
	}

#ifdef C80_AGB_SIL
	/* this is the C80.08 version of AGB silicates */
	nd = NewGrainBin();
	strcpy( gv.bin[nd]->chDstLab, " SilicaAGB  " );
	{ static float _itmp36[] = {3.300e00,1.722e02,4.000e-05,8.200e-01};
	for( i=1, _r = 0; i <= 4; i++ )
	{
		gv.bin[nd]->dustp[i-1] = (float)_itmp36[_r++];
		}
	}
	gv.bin[nd]->ndpts = 233;
	gv.bin[nd]->IntArea = 2.412e-21;
	gv.bin[nd]->AvRadius = 3.536e-06;
	{ static float _itmp37[] = {8.000e00,1.200e01,1.400e01,2.600e01};
	for( i=1, _r = 0; i <= 4; i++ )
	{
		dstelz[nd][i-1] = (float)_itmp37[_r++];
		}
	}
	{ static float _itmp38[] = {1.312e-04,3.280e-05,3.280e-05,
	  3.280e-05};
	for( i=1, _r = 0; i <= 4; i++ )
	{
		dstela[nd][i-1] = (float)_itmp38[_r++];
		}
	}
	gv.bin[nd]->DustWorkFcn = 0.5883;
	gv.bin[nd]->Tsublimat = 1400.;
	{ static float _itmp39[149] = {
	 -5.040,-4.970,-4.885,-4.781,-4.664,
	 -4.532,-4.421,-4.296,-4.154,-4.040,-3.970,-3.885,-3.781,
	 -3.664,-3.532,-3.421,-3.296,-3.154,-3.040,-2.970,-2.873,
	 -2.756,-2.597,-2.517,-2.472,-2.421,-2.411,-2.402,-2.393,
	 -2.383,-2.373,-2.363,-2.352,-2.341,-2.330,-2.319,-2.308,         
	 -2.296,-2.283,-2.271,-2.258,-2.244,-2.231,-2.216,-2.202,
	 -2.186,-2.180,-2.174,-2.167,-2.161,-2.154,-2.148,-2.141,
	 -2.134,-2.127,-2.120,-2.116,-2.112,-2.109,-2.105,-2.101,
	 -2.097,-2.093,-2.090,-2.086,-2.082,-2.078,-2.074,-2.070,
	 -2.066,-2.062,-2.057,-2.053,-2.049,-2.045,-2.040,-2.036,
	 -2.032,-2.027,-2.023,-2.018,-2.013,-2.009,-2.004,-1.999,
	 -1.995,-1.990,-1.985,-1.980,-1.975,-1.970,-1.965,-1.959,
	 -1.937,-1.913,-1.888,-1.863,-1.838,-1.814,-1.789,-1.764,
	 -1.740,-1.715,-1.666,-1.616,-1.567,-1.517,-1.468,-1.418,
	 -1.369,-1.320,-1.270,-1.221,-1.171,-1.122,-1.073,-1.023,
	 -0.974,-0.924,-0.875,-0.826,-0.776,-0.727,-0.677,-0.628,
	 -0.579,-0.529,-0.480,-0.430,-0.381,-0.356,-0.332,-0.307,
	 -0.282,-0.233,-0.208,-0.159,-0.109,-0.060,-0.011, 0.039,
	  0.088, 0.138, 0.162, 0.187, 0.212, 0.261, 0.311, 0.360};
	for( j=1, _r = 0; j <= 149; j++ )
	{
		gv.bin[nd]->eev[j-1] = (float)_itmp39[_r++];
		}
	}
	{ static double _itmp40[84] = {
         0.409,0.459,0.508,0.558,0.607,0.656,0.706,0.755,
         0.805,0.854,0.866,0.911,0.957,1.002,1.048,1.093,
         1.135,1.175,1.212,1.247,1.281,1.314,1.346,1.378,
         1.409,1.440,1.469,1.496,1.522,1.546,1.567,1.582,
         1.589,1.591,1.592,1.593,1.604,1.650,1.683,1.706,
         1.720,1.724,1.725,1.771,1.815,1.851,1.884,1.915,
         1.945,1.972,2.009,2.042,2.073,2.102,2.127,2.133,        
         2.173,2.206,2.237,2.267,2.297,2.327,2.357,2.387,
         2.415,2.446,2.473,2.505,2.537,2.566,2.598,2.627, 
         2.658,2.685,2.712,2.718,2.719,2.720,2.761,2.793,
         2.836,2.864,2.866,3.866};
	for( j=150, _r = 0; j <= 233; j++ )
	{
		gv.bin[nd]->eev[j-1] = (float)_itmp40[_r++];
		}
	}
	{ static double _itmp41[149] = {
	 -28.546,-28.405,-28.224,-28.026,-27.792,
	 -27.528,-27.306,-27.056,-26.774,-26.546,-26.405,-26.224,-26.026,
	 -25.792,-25.528,-25.306,-25.056,-24.774,-24.546,-24.405,-24.211,
	 -23.978,-23.658,-23.515,-23.475,-23.376,-23.353,-23.329,-23.305,
	 -23.283,-23.262,-23.241,-23.222,-23.211,-23.200,-23.189,-23.173,
	 -23.171,-23.180,-23.204,-23.239,-23.277,-23.342,-23.363,-23.349,          
	 -23.336,-23.331,-23.326,-23.321,-23.316,-23.295,-23.264,-23.223,
	 -23.177,-23.127,-23.092,-23.059,-23.026,-22.994,-22.965,-22.947, 
	 -22.933,-22.916,-22.907,-22.893,-22.884,-22.869,-22.859,-22.843,
	 -22.824,-22.811,-22.802,-22.796,-22.789,-22.789,-22.788,-22.797,
	 -22.827,-22.859,-22.882,-22.905,-22.945,-23.000,-23.050,-23.106,
	 -23.157,-23.198,-23.269,-23.337,-23.428,-23.470,-23.493,-23.518,
	 -23.552,-23.589,-23.628,-23.693,-23.685,-23.658,-23.649,-23.654,
	 -23.659,-23.654,-23.621,-23.582,-23.550,-23.518,-23.483,-23.442,
	 -23.399,-23.353,-23.302,-23.248,-23.191,-23.129,-23.060,-22.984,
	 -22.908,-22.842,-22.774,-22.701,-22.637,-22.568,-22.505,-22.439,
	 -22.378,-22.319,-22.262,-22.213,-22.137,-22.004,-21.859,-21.714,          
	 -21.585,-21.420,-21.288,-21.258,-21.207,-21.152,-21.112,-21.102,
	 -21.083,-21.100,-21.164,-21.261,-21.302,-21.337,-21.387,-21.409};
	for( j=1, _r = 0; j <= 149; j++ )
	{
		gv.bin[nd]->sab[j-1] = (float)_itmp41[_r++];
		}
	}
	{ static double _itmp42[84] = {
	 -21.422,-21.435,-21.453,-21.474,-21.495,-21.491,-21.502,-21.527,
	 -21.551,-21.578,-21.601,-21.570,-21.597,-21.628,-21.654,-21.690,
	 -21.732,-21.779,-21.827,-21.875,-21.924,-21.975,-22.026,-22.078,
	 -22.131,-22.189,-22.250,-22.307,-22.355,-22.393,-22.432,-22.470,
	 -22.488,-22.492,-22.396,-22.125,-22.100,-22.185,-22.254,-22.303,
	 -22.331,-22.300,-22.117,-22.205,-22.271,-22.347,-22.421,-22.492,
	 -22.562,-22.625,-22.606,-22.686,-22.762,-22.834,-22.897,-22.784,
	 -22.882,-22.966,-23.046,-23.125,-23.204,-23.285,-23.367,-23.449,          
	 -23.526,-23.611,-23.686,-23.776,-23.868,-23.950,-24.040,-24.123,
	 -24.214,-24.291,-24.366,-24.363,-24.074,-23.841,-23.939,-24.022, 
	 -24.136,-24.220,-24.228,-26.986};
	for( j=150, _r = 0; j <= 233; j++ )
	{
		gv.bin[nd]->sab[j-1] = (float)_itmp42[_r++];
		}
	}
	{ static double _itmp43[149] = {
	 -37.858,-37.576,-37.240,-36.822,-36.354,
	 -35.828,-35.384,-34.885,-34.321,-33.866,-33.585,-33.248,-32.830,
	 -32.363,-31.836,-31.392,-30.894,-30.330,-29.875,-29.593,-29.206,
	 -28.741,-28.104,-27.788,-27.607,-27.414,-27.379,-27.344,-27.308,
	 -27.271,-27.241,-27.212,-27.181,-27.150,-27.122,-27.112,-27.103,
	 -27.093,-27.082,-27.066,-27.050,-27.032,-27.004,-26.942,-26.861,
	 -26.760,-26.714,-26.666,-26.617,-26.567,-26.525,-26.484,-26.442,          
	 -26.401,-26.363,-26.325,-26.305,-26.286,-26.267,-26.249,-26.231,
	 -26.213,-26.194,-26.176,-26.157,-26.145,-26.134,-26.123,-26.111, 
	 -26.100,-26.088,-26.077,-26.065,-26.053,-26.041,-26.029,-26.017,
	 -26.024,-26.030,-26.037,-26.044,-26.051,-26.083,-26.145,-26.207,
	 -26.270,-26.334,-26.401,-26.472,-26.544,-26.617,-26.691,-26.729,
	 -26.729,-26.467,-26.222,-26.025,-25.864,-25.726,-25.601,-25.482,
	 -25.365,-25.251,-25.031,-24.820,-24.614,-24.410,-24.209,-24.011,
	 -23.815,-23.624,-23.438,-23.260,-23.095,-22.948,-22.819,-22.701,
	 -22.579,-22.464,-22.369,-22.284,-22.206,-22.132,-22.068,-22.005,
	 -21.948,-21.893,-21.839,-21.781,-21.719,-21.710,-21.714,-21.734,
	 -21.767,-21.772,-21.793,-21.881,-21.850,-21.800,-21.817,-21.830,          
	 -21.799,-21.765,-21.779,-21.902,-22.042,-22.185,-22.332,-22.467};
	for( j=1, _r = 0; j <= 149; j++ )
	{
		gv.bin[nd]->sse[j-1] = (float)_itmp43[_r++];
		}
	}
	{ static double _itmp44[84] = {
         -22.607,-22.688,-22.783,-22.891,-23.024,-23.132,-23.195,-23.304,
	 -23.423,-23.552,-23.695,-23.673,-23.762,-23.875,-23.989,-24.096,
	 -24.210,-24.326,-24.441,-24.554,-24.668,-24.782,-24.895,-25.011,
	 -25.125,-25.241,-25.355,-25.468,-25.584,-25.698,-25.813,-25.934,
	 -26.055,-26.186,-26.251,-26.070,-25.955,-26.016,-26.132,-26.246,
	 -26.373,-26.528,-26.343,-26.365,-26.479,-26.594,-26.708,-26.822,
	 -26.937,-27.053,-27.167,-27.282,-27.398,-27.511,-27.625,-27.649,
	 -27.763,-27.881,-27.997,-28.111,-28.225,-28.340,-28.454,-28.568,
	 -28.683,-28.798,-28.912,-29.039,-29.162,-29.279,-29.400,-29.514,          
	 -29.639,-29.753,-29.869,-29.904,-29.922,-29.919,-30.032,-30.177,
	 -30.282,-30.451,-30.455,-34.596};
	for( j=150, _r = 0; j <= 233; j++ )
	{
		gv.bin[nd]->sse[j-1] = (float)_itmp44[_r++];
		}
	}
#else
	/* this is the C84.12a version of AGB silicates */
	nd = NewGrainBin();
	strcpy( gv.bin[nd]->chDstLab, " SilicaAGB  " );
	{ static float _itmp36[] = {3.300e00,1.722e02,4.000e-05,8.200e-01};
	for( i=1, _r = 0; i <= 4; i++ )
	{
		gv.bin[nd]->dustp[i-1] = (float)_itmp36[_r++];
		}
	}
	gv.bin[nd]->ndpts = 233;
	gv.bin[nd]->IntArea = 2.412e-21;
	gv.bin[nd]->AvRadius = 3.536e-06;
	{ static float _itmp37[] = {8.000e00,1.200e01,1.400e01,2.600e01};
	for( i=1, _r = 0; i <= 4; i++ )
	{
		dstelz[nd][i-1] = (float)_itmp37[_r++];
		}
	}
	{ static float _itmp38[] = {1.312e-04,3.280e-05,3.280e-05,
	  3.280e-05};
	for( i=1, _r = 0; i <= 4; i++ )
	{
		dstela[nd][i-1] = (float)_itmp38[_r++];
		}
	}
	gv.bin[nd]->DustWorkFcn = 0.5883;
	gv.bin[nd]->Tsublimat = 1400.;
	{ static float _itmp39[] = {-5.040,-4.970,-4.885,-4.781,-4.664,
	  -4.532,-4.421,-4.296,-4.154,-4.040,-3.970,-3.885,-3.781,
	  -3.664,-3.532,-3.421,-3.296,-3.154,-3.040,-2.970,-2.873,
	  -2.756,-2.597,-2.517,-2.472,-2.421,-2.411,-2.402,-2.393,
	  -2.383,-2.373,-2.363,-2.352,-2.341,-2.330,-2.319,-2.308,
	  -2.296,-2.283,-2.271,-2.258,-2.244,-2.231,-2.216,-2.202,
	  -2.186,-2.180,-2.174,-2.167,-2.161,-2.154,-2.148,-2.141,
	  -2.134,-2.127,-2.120,-2.116,-2.112,-2.109,-2.105,-2.101,
	  -2.097,-2.093,-2.090,-2.086,-2.082,-2.078,-2.074,-2.070,
	  -2.066,-2.062,-2.057,-2.053,-2.049,-2.045,-2.040,-2.036,
	  -2.032,-2.027,-2.023,-2.018,-2.013,-2.009,-2.004,-1.999,
	  -1.995,-1.990,-1.985,-1.980,-1.975,-1.970,-1.965,-1.959,
	  -1.937,-1.913,-1.888,-1.863,-1.838,-1.814,-1.789,-1.764,
	  -1.740,-1.715,-1.666,-1.616,-1.567,-1.517,-1.468,-1.418,
	  -1.369,-1.320,-1.270,-1.221,-1.171,-1.122,-1.073,-1.023,
	  -0.974,-0.924,-0.875,-0.826,-0.776,-0.727,-0.677,-0.628,
	  -0.579,-0.529,-0.480,-0.430,-0.381,-0.356,-0.332,-0.307,
	  -0.282,-0.233,-0.208,-0.159,-0.109,-0.060,-0.011,0.039,0.088,
	  0.138,0.162,0.187,0.212,0.261,0.311,0.360};
	for( j=1, _r = 0; j <= 149; j++ )
	{
		gv.bin[nd]->eev[j-1] = (float)_itmp39[_r++];
		}
	}
	{ static double _itmp40[] = {0.409,0.459,0.508,0.558,0.607,
	  0.656,0.706,0.755,0.805,0.854,0.866,0.911,0.957,1.002,1.048,
	  1.093,1.135,1.175,1.212,1.247,1.281,1.314,1.346,1.378,1.409,
	  1.440,1.469,1.496,1.522,1.546,1.567,1.582,1.589,1.591,1.592,
	  1.593,1.604,1.650,1.683,1.706,1.720,1.724,1.725,1.771,1.815,
	  1.851,1.884,1.915,1.945,1.972,2.009,2.042,2.073,2.102,2.127,
	  2.133,2.173,2.206,2.237,2.267,2.297,2.327,2.357,2.387,2.415,
	  2.446,2.473,2.505,2.537,2.566,2.598,2.627,2.658,2.685,2.712,
	  2.718,2.719,2.720,2.761,2.793,2.836,2.864,2.866,3.866};
	for( j=150, _r = 0; j <= 233; j++ )
	{
		gv.bin[nd]->eev[j-1] = (float)_itmp40[_r++];
		}
	}
	{ static double _itmp41[] = {-28.202,-28.062,-27.881,-27.684,
	  -27.450,-27.186,-26.964,-26.714,-26.430,-26.202,-26.062,
	  -25.881,-25.684,-25.450,-25.186,-24.964,-24.714,-24.430,
	  -24.202,-24.060,-23.868,-23.634,-23.316,-23.172,-23.132,
	  -23.034,-23.010,-22.986,-22.964,-22.941,-22.919,-22.900,
	  -22.879,-22.868,-22.857,-22.847,-22.831,-22.828,-22.838,
	  -22.861,-22.896,-22.937,-22.997,-23.020,-23.007,-22.993,
	  -22.988,-22.983,-22.978,-22.973,-22.951,-22.923,-22.882,
	  -22.836,-22.787,-22.752,-22.717,-22.681,-22.655,-22.624,
	  -22.604,-22.589,-22.572,-22.565,-22.551,-22.542,-22.527,
	  -22.517,-22.501,-22.483,-22.470,-22.459,-22.453,-22.447,
	  -22.447,-22.447,-22.455,-22.481,-22.517,-22.538,-22.563,
	  -22.608,-22.655,-22.709,-22.767,-22.810,-22.853,-22.923,
	  -22.993,-23.082,-23.125,-23.148,-23.176,-23.228,-23.352,
	  -23.521,-23.548,-23.553,-23.558,-23.558,-23.559,-23.559,
	  -23.541,-23.514,-23.483,-23.451,-23.421,-23.377,-23.340,
	  -23.305,-23.258,-23.208,-23.156,-23.097,-23.040,-22.974,
	  -22.911,-22.839,-22.762,-22.689,-22.600,-22.510,-22.390,
	  -22.257,-22.167,-22.147,-22.102,-22.039,-21.947,-21.762,
	  -21.697,-21.639,-21.580,-21.530,-21.454,-21.435,-21.449,
	  -21.462,-21.474,-21.486,-21.500,-21.522,-21.545,-21.555,
	  -21.565,-21.575,-21.593,-21.595,-21.596};
	for( j=1, _r = 0; j <= 149; j++ )
	{
		gv.bin[nd]->sab[j-1] = (float)_itmp41[_r++];
		}
	}
	{ static double _itmp42[] = {-21.601,-21.605,-21.608,-21.611,
	  -21.614,-21.617,-21.619,-21.621,-21.623,-21.625,-21.625,
	  -21.627,-21.628,-21.684,-21.710,-21.746,-21.788,-21.835,
	  -21.883,-21.931,-21.980,-22.031,-22.082,-22.134,-22.187,
	  -22.245,-22.306,-22.363,-22.411,-22.449,-22.488,-22.526,
	  -22.544,-22.548,-22.452,-22.181,-22.156,-22.241,-22.310,
	  -22.359,-22.387,-22.356,-22.173,-22.261,-22.327,-22.403,
	  -22.477,-22.548,-22.618,-22.681,-22.662,-22.742,-22.818,
	  -22.890,-22.953,-22.840,-22.938,-23.022,-23.102,-23.181,
	  -23.260,-23.341,-23.423,-23.505,-23.582,-23.667,-23.742,
	  -23.832,-23.924,-24.006,-24.096,-24.179,-24.270,-24.347,
	  -24.422,-24.419,-24.130,-23.897,-23.995,-24.078,-24.192,
	  -24.276,-24.284,-27.042};
	for( j=150, _r = 0; j <= 233; j++ )
	{
		gv.bin[nd]->sab[j-1] = (float)_itmp42[_r++];
		}
	}
	{ static double _itmp43[] = {-36.921,-36.642,-36.302,-35.888,
	  -35.420,-34.894,-34.451,-33.952,-33.384,-32.930,-32.651,
	  -32.310,-31.896,-31.429,-30.902,-30.459,-29.960,-29.393,
	  -28.938,-28.652,-28.272,-27.803,-27.170,-26.851,-26.673,
	  -26.481,-26.443,-26.409,-26.375,-26.337,-26.307,-26.278,
	  -26.247,-26.215,-26.187,-26.178,-26.168,-26.158,-26.147,
	  -26.132,-26.115,-26.097,-26.070,-26.005,-25.927,-25.821,
	  -25.778,-25.732,-25.679,-25.633,-25.589,-25.552,-25.509,
	  -25.467,-25.430,-25.393,-25.371,-25.350,-25.335,-25.315,
	  -25.296,-25.277,-25.258,-25.243,-25.224,-25.211,-25.200,
	  -25.189,-25.178,-25.166,-25.155,-25.141,-25.130,-25.119,
	  -25.108,-25.094,-25.083,-25.088,-25.096,-25.102,-25.110,
	  -25.120,-25.148,-25.212,-25.278,-25.330,-25.396,-25.464,
	  -25.536,-25.608,-25.679,-25.751,-25.795,-25.836,-26.028,
	  -26.374,-26.235,-26.094,-25.976,-25.818,-25.707,-25.627,
	  -25.460,-25.261,-25.053,-24.871,-24.667,-24.363,-24.199,
	  -24.054,-23.829,-23.626,-23.417,-23.199,-23.015,-22.815,
	  -22.644,-22.443,-22.242,-22.071,-21.876,-21.715,-21.545,
	  -21.368,-21.215,-21.117,-21.076,-21.009,-20.975,-21.086,
	  -21.149,-21.184,-21.171,-21.159,-21.138,-21.133,-21.141,
	  -21.148,-21.154,-21.322,-21.445,-21.442,-21.445,-21.450,
	  -21.456,-21.462,-21.473,-21.490,-21.506};
	for( j=1, _r = 0; j <= 149; j++ )
	{
		gv.bin[nd]->sse[j-1] = (float)_itmp43[_r++];
		}
	}
	{ static double _itmp44[] = {-21.512,-21.519,-21.524,-21.530,
	  -21.534,-21.538,-21.542,-21.546,-21.549,-21.551,-21.552,
	  -21.554,-21.556,-21.569,-21.683,-21.790,-21.904,-22.020,
	  -22.135,-22.248,-22.362,-22.476,-22.589,-22.705,-22.819,
	  -22.935,-23.049,-23.162,-23.278,-23.392,-23.507,-23.628,
	  -23.749,-23.880,-23.945,-23.764,-23.649,-23.710,-23.826,
	  -23.940,-24.067,-24.222,-24.037,-24.059,-24.173,-24.288,
	  -24.402,-24.516,-24.631,-24.747,-24.861,-24.976,-25.092,
	  -25.205,-25.319,-25.343,-25.457,-25.575,-25.691,-25.805,
	  -25.919,-26.034,-26.148,-26.262,-26.377,-26.492,-26.606,
	  -26.733,-26.856,-26.973,-27.094,-27.208,-27.333,-27.447,
	  -27.563,-27.598,-27.616,-27.613,-27.726,-27.871,-27.976,
	  -28.145,-28.149,-32.290};
	for( j=150, _r = 0; j <= 233; j++ )
	{
		gv.bin[nd]->sse[j-1] = (float)_itmp44[_r++];
		}
	}
#endif

	nd = NewGrainBin();
	strcpy( gv.bin[nd]->chDstLab, " Grey       " );
	{ static double _itmp45[] = {3.300e00,1.722e02,4.000e-05,8.200e-01};
	for( i=1, _r = 0; i <= 4; i++ )
	{
		gv.bin[nd]->dustp[i-1] = (float)_itmp45[_r++];
		}
	}
	gv.bin[nd]->ndpts = 233;
	gv.bin[nd]->IntArea = 2.412e-21;
	gv.bin[nd]->AvRadius = 3.536e-06;
	{ static double _itmp46[] = {8.000e00,1.200e01,1.400e01,2.600e01};
	for( i=1, _r = 0; i <= 4; i++ )
	{
		dstelz[nd][i-1] = (float)_itmp46[_r++];
		}
	}
	{ static double _itmp47[] = {1.312e-04,3.280e-05,3.280e-05,
	  3.280e-05};
	for( i=1, _r = 0; i <= 4; i++ )
	{
		dstela[nd][i-1] = (float)_itmp47[_r++];
		}
	}
	gv.bin[nd]->DustWorkFcn = 0.5883;
	gv.bin[nd]->Tsublimat = 2000.;
	{ static double _itmp48[] = {-5.040,-4.970,-4.885,-4.781,-4.664,
	  -4.532,-4.421,-4.296,-4.154,-4.040,-3.970,-3.885,-3.781,
	  -3.664,-3.532,-3.421,-3.296,-3.154,-3.040,-2.970,-2.873,
	  -2.756,-2.597,-2.517,-2.472,-2.421,-2.411,-2.402,-2.393,
	  -2.383,-2.373,-2.363,-2.352,-2.341,-2.330,-2.319,-2.308,
	  -2.296,-2.283,-2.271,-2.258,-2.244,-2.231,-2.216,-2.202,
	  -2.186,-2.180,-2.174,-2.167,-2.161,-2.154,-2.148,-2.141,
	  -2.134,-2.127,-2.120,-2.116,-2.112,-2.109,-2.105,-2.101,
	  -2.097,-2.093,-2.090,-2.086,-2.082,-2.078,-2.074,-2.070,
	  -2.066,-2.062,-2.057,-2.053,-2.049,-2.045,-2.040,-2.036,
	  -2.032,-2.027,-2.023,-2.018,-2.013,-2.009,-2.004,-1.999,
	  -1.995,-1.990,-1.985,-1.980,-1.975,-1.970,-1.965,-1.959,
	  -1.937,-1.913,-1.888,-1.863,-1.838,-1.814,-1.789,-1.764,
	  -1.740,-1.715,-1.666,-1.616,-1.567,-1.517,-1.468,-1.418,
	  -1.369,-1.320,-1.270,-1.221,-1.171,-1.122,-1.073,-1.023,
	  -0.974,-0.924,-0.875,-0.826,-0.776,-0.727,-0.677,-0.628,
	  -0.579,-0.529,-0.480,-0.430,-0.381,-0.356,-0.332,-0.307,
	  -0.282,-0.233,-0.208,-0.159,-0.109,-0.060,-0.011,0.039,0.088,
	  0.138,0.162,0.187,0.212,0.261,0.311,0.360};
	for( j=1, _r = 0; j <= 149; j++ )
	{
		gv.bin[nd]->eev[j-1] = (float)_itmp48[_r++];
		}
	}
	{ static double _itmp49[] = {0.409,0.459,0.508,0.558,0.607,
	  0.656,0.706,0.755,0.805,0.854,0.866,0.911,0.957,1.002,1.048,
	  1.093,1.135,1.175,1.212,1.247,1.281,1.314,1.346,1.378,1.409,
	  1.440,1.469,1.496,1.522,1.546,1.567,1.582,1.589,1.591,1.592,
	  1.593,1.604,1.650,1.683,1.706,1.720,1.724,1.725,1.771,1.815,
	  1.851,1.884,1.915,1.945,1.972,2.009,2.042,2.073,2.102,2.127,
	  2.133,2.173,2.206,2.237,2.267,2.297,2.327,2.357,2.387,2.415,
	  2.446,2.473,2.505,2.537,2.566,2.598,2.627,2.658,2.685,2.712,
	  2.718,2.719,2.720,2.761,2.793,2.836,2.864,2.866,3.866};
	for( j=150, _r = 0; j <= 233; j++ )
	{
		gv.bin[nd]->eev[j-1] = (float)_itmp49[_r++];
		}
	}
	for( j=1; j <= 233; j++ )
	{
		gv.bin[nd]->sab[j-1] = -22.882;
		}
	for( j=1; j <= 233; j++ )
	{
		gv.bin[nd]->sse[j-1] = -22.581;
		}

	nd = NewGrainBin();
	strcpy( gv.bin[nd]->chDstLab, " PAH 1.0nm  " ); /* C120H26 */
	{ static float _itmp50[] = {2.250e00,1.466e03,6.791e-08,1.000e00};
	for( i=1, _r = 0; i <= 4; i++ )
	{
		gv.bin[nd]->dustp[i-1] = (float)_itmp50[_r++];
		}
	}
	gv.bin[nd]->ndpts = 259;
	gv.bin[nd]->IntArea = 3.461e-21;
	gv.bin[nd]->AvRadius = 6.368504e-8;
	{ static double _itmp246[] = {1.000e00,6.000e00,0.000e00,0.000e00};
	for( i=1, _r = 0; i <= 4; i++ )
	{
		dstelz[nd][i-1] = (float)_itmp246[_r++];
		}
	}
	{ static double _itmp247[] = {1.766e-06,8.149e-06,0.000e00,0.000e00};
	for( i=1, _r = 0; i <= 4; i++ )
	{
		dstela[nd][i-1] = (float)_itmp247[_r++];
		}
	}
	gv.bin[nd]->DustWorkFcn = 0.706;
	gv.bin[nd]->Tsublimat = 2000.;
	{ static float _itmp51[] = {-28.962,-28.892,-28.807,-28.703,
	  -28.586,-28.454,-28.343,-28.218,-28.076,-27.962,-27.892,
	  -27.807,-27.703,-27.586,-27.454,-27.344,-27.219,-27.079,
	  -26.966,-26.898,-26.804,-26.694,-26.552,-26.487,-26.453,
	  -26.418,-26.412,-26.406,-26.401,-26.395,-26.389,-26.383,
	  -26.377,-26.372,-26.366,-26.361,-26.357,-26.352,-26.347,
	  -26.343,-26.339,-26.336,-26.334,-26.271,-26.072,-26.002,
	  -25.985,-25.755,-25.424,-25.421,-25.421,-25.418,-25.418,
	  -25.419,-25.755,-25.932,-25.925,-25.920,-25.472,-25.410,
	  -25.408,-25.408,-25.407,-25.407,-25.409,-25.466,-25.665,
	  -25.910,-25.909,-24.949,-24.931,-24.897,-24.898,-24.901,
	  -24.960,-24.919,-26.141,-26.346,-26.365,-26.368,-26.371,
	  -26.374,-26.377,-26.381,-26.385,-26.388,-26.392,-26.397,
	  -26.405,-26.414,-26.424,-26.433,-26.436,-26.103,-25.950,
	  -25.814,-25.711,-25.644,-25.610,-25.526,-25.501,-25.501,
	  -25.501,-25.502,-25.503,-25.504,-25.505,-25.513,-25.362,
	  -25.112,-25.113,-25.115,-25.665,-25.672,-25.758,-25.484,
	  -25.482,-25.488,-25.503,-25.514,-26.003,-26.190,-26.494,
	  -27.550,-27.888};
	for( j=1, _r = 0; j <= 125; j++ )
	{
		gv.bin[nd]->sab[j-1] = (float)_itmp51[_r++];
		}
	}
	{ static float _itmp52[] = {-28.227,-28.117,-26.484,-25.760,
	  -25.753,-25.752,-25.760,-27.239,-26.835,-26.457,-26.117,
	  -25.804,-25.509,-25.241,-24.989,-24.759,-24.545,-24.341,
	  -24.155,-23.978,-23.815,-23.664,-23.520,-23.390,-23.267,
	  -23.158,-23.061,-22.977,-22.914,-22.879,-22.879,-22.879,
	  -22.879,-22.879,-22.879,-22.846,-22.785,-22.591,-22.345,
	  -22.099,-21.863,-21.783,-21.757,-21.742,-21.740,-21.741,
	  -21.747,-21.770,-21.814,-21.878,-21.967,-22.085,-22.232,
	  -22.416,-22.636,-22.898,-23.214,-23.577,-24.008,-24.493,
	  -24.622,-25.142,-25.730,-26.353,-27.020,-27.684,-28.308,
	  -28.917,-29.511,-30.111,-30.738,-31.393,-32.078,-32.815,
	  -33.582,-34.406,-35.232,-36.052,-36.892,-37.713,-38.469,
	  -39.032,-39.302,-39.380,-39.419,-39.458,-39.894,-41.844,
	  -43.375,-44.514,-45.237,-45.448,-45.501,-48.077,-50.810,
	  -53.261,-55.694,-58.154,-60.000,-60.000,-60.000,-60.000,
	  -60.000,-60.000,-60.000,-60.000,-60.000,-60.000,-60.000,
	  -60.000,-60.000,-60.000,-60.000,-60.000,-60.000,-60.000,
	  -60.000,-60.000,-60.000,-60.000,-60.000,-60.000,-60.000,
	  -60.000,-60.000,-60.000,-60.000,-60.000,-60.000,-60.000,
	  -60.000,-60.000,-60.000,-60.000};
	for( j=126, _r = 0; j <= 259; j++ )
	{
		gv.bin[nd]->sab[j-1] = (float)_itmp52[_r++];
		}
	}
	for( j=1; j <= 259; j++ )
	{
		gv.bin[nd]->sse[j-1] = -30.000;
		}
	{ static float _itmp53[] = {-5.040,-4.970,-4.885,-4.781,-4.664,
	  -4.532,-4.421,-4.296,-4.154,-4.040,-3.970,-3.885,-3.781,
	  -3.664,-3.532,-3.421,-3.296,-3.154,-3.040,-2.970,-2.873,
	  -2.756,-2.597,-2.517,-2.472,-2.421,-2.411,-2.402,-2.393,
	  -2.383,-2.373,-2.363,-2.352,-2.341,-2.330,-2.319,-2.308,
	  -2.296,-2.283,-2.271,-2.258,-2.244,-2.231,-2.216,-2.202,
	  -2.186,-2.180,-2.174,-2.16988,-2.16704,-2.167,-2.161356,
	  -2.161,-2.15845,-2.154,-2.148,-2.141,-2.134,-2.127,-2.12582,
	  -2.12267,-2.120,-2.116375,-2.116,-2.11316,-2.112,-2.109,
	  -2.105,-2.101,-2.09714,-2.097,-2.09527,-2.093,-2.09158,-2.08969,
	  -2.090,-2.086,-2.082,-2.078,-2.074,-2.070,-2.066,-2.062,
	  -2.057,-2.053,-2.049,-2.045,-2.040,-2.036,-2.032,-2.027,
	  -2.023,-2.018,-2.013,-2.009,-2.004,-1.999,-1.995,-1.990,
	  -1.985,-1.98330,-1.980,-1.97907,-1.975,-1.97059,-1.970,-1.96623,
	  -1.96572,-1.959,-1.94669,-1.937,-1.92002,-1.91303,-1.888,
	  -1.863,-1.83852,-1.838,-1.83491,-1.82774,-1.82404,-1.814,
	  -1.789,-1.764,-1.740,-1.715,-1.666,-1.616,-1.567,-1.5620807,
	  -1.560445,-1.55729,-1.55563,-1.517,-1.468,-1.418,-1.369,
	  -1.320,-1.270,-1.221,-1.171,-1.122,-1.073,-1.023,-0.974,
	  -0.924,-0.875};
	for( j=1, _r = 0; j <= 146; j++ )
	{
		gv.bin[nd]->eev[j-1] = (float)_itmp53[_r++];
		}
	}
	{ static float _itmp54[] = {-0.826,-0.776,-0.727,-0.677,-0.628,
	  -0.579,-0.529,-0.480,-0.430,-0.381,-0.356,-0.332,-0.307,
	  -0.282,-0.233,-0.208,-0.159,-0.109,-0.060,-0.011,0.039,0.088,
	  0.138,0.162,0.187,0.212,0.261,0.311,0.360,0.409,0.459,0.508,
	  0.558,0.607,0.656,0.706,0.755,0.805,0.854,0.866,0.911,0.957,
	  1.002,1.048,1.093,1.135,1.175,1.212,1.247,1.281,1.314,1.346,
	  1.378,1.409,1.440,1.469,1.496,1.522,1.546,1.567,1.582,1.589,
	  1.591,1.592,1.593,1.604,1.650,1.683,1.706,1.720,1.724,1.725,
	  1.771,1.815,1.851,1.884,1.915,1.945,1.972,2.009,2.042,2.073,
	  2.102,2.127,2.133,2.173,2.206,2.237,2.267,2.297,2.327,2.357,
	  2.387,2.415,2.446,2.473,2.505,2.537,2.566,2.598,2.627,2.658,
	  2.685,2.712,2.718,2.719,2.720,2.761,2.793,2.836,2.864,2.866,
	  3.866};
	for( j=147, _r = 0; j <= 259; j++ )
	{
		gv.bin[nd]->eev[j-1] = (float)_itmp54[_r++];
		}
	}

	nd = NewGrainBin();
	strcpy( gv.bin[nd]->chDstLab, " PAH .35nm  " ); /* C15H9 */
	{ static float _itmp55[] = {2.250e00,1.890e02,1.881e-07,1.000e00};
	for( i=1, _r = 0; i <= 4; i++ )
	{
		gv.bin[nd]->dustp[i-1] = (float)_itmp55[_r++];
		}
	}
	gv.bin[nd]->ndpts = 259;
	gv.bin[nd]->IntArea = 2.447e-21;
	gv.bin[nd]->AvRadius = 3.217215e-8;
	{ static double _itmp346[] = {1.000e00,6.000e00,0.000e00,0.000e00};
	for( i=1, _r = 0; i <= 4; i++ )
	{
		dstelz[nd][i-1] = (float)_itmp346[_r++];
		}
	}
	{ static double _itmp347[] = {1.693e-06,2.822e-06,0.000e00,0.000e00};
	for( i=1, _r = 0; i <= 4; i++ )
	{
		dstela[nd][i-1] = (float)_itmp347[_r++];
		}
	}
	gv.bin[nd]->DustWorkFcn = 0.706;
	gv.bin[nd]->Tsublimat = 2000.;
	{ static float _itmp56[] = {-29.113,-29.043,-28.958,-28.854,
	  -28.737,-28.605,-28.494,-28.369,-28.227,-28.113,-28.043,
	  -27.958,-27.854,-27.737,-27.605,-27.494,-27.370,-27.229,
	  -27.117,-27.049,-26.955,-26.845,-26.703,-26.638,-26.604,
	  -26.569,-26.562,-26.557,-26.551,-26.545,-26.539,-26.534,
	  -26.528,-26.522,-26.517,-26.512,-26.507,-26.502,-26.498,
	  -26.494,-26.490,-26.487,-26.484,-26.422,-26.222,-26.152,
	  -26.135,-25.670,-25.213,-25.210,-25.210,-25.209,-25.209,
	  -25.211,-25.694,-26.082,-26.076,-26.071,-25.285,-25.207,
	  -25.205,-25.205,-25.204,-25.204,-25.206,-25.280,-25.563,
	  -26.060,-26.060,-24.680,-24.660,-24.624,-24.624,-24.625,
	  -24.684,-24.642,-26.292,-26.496,-26.516,-26.518,-26.521,
	  -26.524,-26.528,-26.532,-26.535,-26.539,-26.543,-26.548,
	  -26.556,-26.564,-26.575,-26.583,-26.586,-26.254,-26.100,
	  -25.964,-25.862,-25.795,-25.712,-25.522,-25.473,-25.473,
	  -25.473,-25.474,-25.474,-25.474,-25.476,-25.490,-25.487,
	  -25.263,-25.264,-25.265,-25.815,-25.823,-25.908,-25.634,
	  -25.633,-25.639,-25.654,-25.664,-26.153,-26.340,-26.644,
	  -27.686,-27.982};
	for( j=1, _r = 0; j <= 125; j++ )
	{
		gv.bin[nd]->sab[j-1] = (float)_itmp56[_r++];
		}
	}
	{ static float _itmp57[] = {-28.091,-27.786,-26.182,-25.459,
	  -25.451,-25.451,-25.459,-26.983,-26.627,-26.292,-25.989,
	  -25.710,-25.445,-25.205,-24.976,-24.768,-24.573,-24.386,
	  -24.215,-24.052,-23.902,-23.761,-23.627,-23.505,-23.391,
	  -23.288,-23.198,-23.119,-23.060,-23.029,-23.029,-23.029,
	  -23.029,-23.029,-23.029,-22.997,-22.935,-22.741,-22.495,
	  -22.249,-22.013,-21.934,-21.907,-21.893,-21.890,-21.892,
	  -21.897,-21.921,-21.965,-22.029,-22.117,-22.236,-22.382,
	  -22.567,-22.786,-23.048,-23.365,-23.728,-24.158,-24.644,
	  -24.773,-25.292,-25.880,-26.503,-27.171,-27.835,-28.458,
	  -29.068,-29.662,-30.261,-30.888,-31.544,-32.228,-32.965,
	  -33.732,-34.557,-35.383,-36.203,-37.042,-37.863,-38.620,
	  -39.183,-39.452,-39.530,-39.569,-39.608,-40.045,-41.994,
	  -43.526,-44.664,-45.387,-45.598,-45.651,-48.227,-50.960,
	  -53.412,-55.845,-58.305,-60.000,-60.000,-60.000,-60.000,
	  -60.000,-60.000,-60.000,-60.000,-60.000,-60.000,-60.000,
	  -60.000,-60.000,-60.000,-60.000,-60.000,-60.000,-60.000,
	  -60.000,-60.000,-60.000,-60.000,-60.000,-60.000,-60.000,
	  -60.000,-60.000,-60.000,-60.000,-60.000,-60.000,-60.000,
	  -60.000,-60.000,-60.000,-60.000};
	for( j=126, _r = 0; j <= 259; j++ )
	{
		gv.bin[nd]->sab[j-1] = (float)_itmp57[_r++];
		}
	}
	for( j=1; j <= 259; j++ )
	{
		gv.bin[nd]->sse[j-1] = -30.000;
		}
	{ static float _itmp58[] = {-5.040,-4.970,-4.885,-4.781,-4.664,
	  -4.532,-4.421,-4.296,-4.154,-4.040,-3.970,-3.885,-3.781,
	  -3.664,-3.532,-3.421,-3.296,-3.154,-3.040,-2.970,-2.873,
	  -2.756,-2.597,-2.517,-2.472,-2.421,-2.411,-2.402,-2.393,
	  -2.383,-2.373,-2.363,-2.352,-2.341,-2.330,-2.319,-2.308,
	  -2.296,-2.283,-2.271,-2.258,-2.244,-2.231,-2.216,-2.202,
	  -2.186,-2.180,-2.174,-2.16988,-2.16704,-2.167,-2.161356,
	  -2.161,-2.15845,-2.154,-2.148,-2.141,-2.134,-2.127,-2.12582,
	  -2.12267,-2.120,-2.116375,-2.116,-2.11316,-2.112,-2.109,
	  -2.105,-2.101,-2.09714,-2.097,-2.09527,-2.093,-2.09158,-2.08969,
	  -2.090,-2.086,-2.082,-2.078,-2.074,-2.070,-2.066,-2.062,
	  -2.057,-2.053,-2.049,-2.045,-2.040,-2.036,-2.032,-2.027,
	  -2.023,-2.018,-2.013,-2.009,-2.004,-1.999,-1.995,-1.990,
	  -1.985,-1.98330,-1.980,-1.97907,-1.975,-1.97059,-1.970,-1.96623,
	  -1.96572,-1.959,-1.94669,-1.937,-1.92002,-1.91303,-1.888,
	  -1.863,-1.83852,-1.838,-1.83491,-1.82774,-1.82404,-1.814,
	  -1.789,-1.764,-1.740,-1.715,-1.666,-1.616,-1.567,-1.5620807,
	  -1.560445,-1.55729,-1.55563,-1.517,-1.468,-1.418,-1.369,
	  -1.320,-1.270,-1.221,-1.171,-1.122,-1.073,-1.023,-0.974,
	  -0.924,-0.875};
	for( j=1, _r = 0; j <= 146; j++ )
	{
		gv.bin[nd]->eev[j-1] = (float)_itmp58[_r++];
		}
	}
	{ static float _itmp59[] = {-0.826,-0.776,-0.727,-0.677,-0.628,
	  -0.579,-0.529,-0.480,-0.430,-0.381,-0.356,-0.332,-0.307,
	  -0.282,-0.233,-0.208,-0.159,-0.109,-0.060,-0.011,0.039,0.088,
	  0.138,0.162,0.187,0.212,0.261,0.311,0.360,0.409,0.459,0.508,
	  0.558,0.607,0.656,0.706,0.755,0.805,0.854,0.866,0.911,0.957,
	  1.002,1.048,1.093,1.135,1.175,1.212,1.247,1.281,1.314,1.346,
	  1.378,1.409,1.440,1.469,1.496,1.522,1.546,1.567,1.582,1.589,
	  1.591,1.592,1.593,1.604,1.650,1.683,1.706,1.720,1.724,1.725,
	  1.771,1.815,1.851,1.884,1.915,1.945,1.972,2.009,2.042,2.073,
	  2.102,2.127,2.133,2.173,2.206,2.237,2.267,2.297,2.327,2.357,
	  2.387,2.415,2.446,2.473,2.505,2.537,2.566,2.598,2.627,2.658,
	  2.685,2.712,2.718,2.719,2.720,2.761,2.793,2.836,2.864,2.866,
	  3.866};
	for( j=147, _r = 0; j <= 259; j++ )
	{
		gv.bin[nd]->eev[j-1] = (float)_itmp59[_r++];
		}
	}

	/* >>chng 99 jul 28, add 1 micron silicate from Peter Martin */
	nd = NewGrainBin();
	strcpy( gv.bin[nd]->chDstLab, " Sil-1.0    " );
	/*fchrncpy( gv.bin[nd]->chDstLab, 10, "Sil - 1.0 " );*/
	{ static float _itmp60[] = {3.300e00,1.722e02,4.000e-05,8.200e-01};
	for( i=1, _r = 0; i <= 4; i++ )
	{
		gv.bin[nd]->dustp[i-1] = _itmp60[_r++];
		}
	}
	gv.bin[nd]->ndpts = 157;
	gv.bin[nd]->IntArea = 8.528e-23;
	gv.bin[nd]->AvRadius = 1.000e-04;
	{ static float _itmp61[] = {8.000e00,1.200e01,1.400e01,2.600e01};
	for( i=1, _r = 0; i <= 4; i++ )
	{
		dstelz[nd][i-1] = _itmp61[_r++];
		}
	}
	{ static float _itmp62[] = {1.312e-04,3.280e-05,3.280e-05,
	  3.280e-05};
	for( i=1, _r = 0; i <= 4; i++ )
	{
		dstela[nd][i-1] = _itmp62[_r++];
		}
	}
	gv.bin[nd]->DustWorkFcn = 0.5883;
	gv.bin[nd]->Tsublimat = 2000.;
	{ static float _itmp63[] = {-5.000,-2.481,-2.431,-2.382,-2.332,
	  -2.283,-2.234,-2.209,-2.184,-2.160,-2.135,-2.110,-2.061,
	  -2.011,-1.987,-1.962,-1.937,-1.913,-1.888,-1.863,-1.838,
	  -1.814,-1.764,-1.715,-1.666,-1.616,-1.567,-1.517,-1.468,
	  -1.418,-1.369,-1.320,-1.270,-1.221,-1.171,-1.122,-1.073,
	  -1.023,-0.974,-0.924,-0.875,-0.826,-0.776,-0.727,-0.677,
	  -0.628,-0.579,-0.529,-0.480,-0.430,-0.381,-0.332,-0.282,
	  -0.233,-0.208,-0.183,-0.134,-0.085,-0.035,0.014,0.064,0.113,
	  0.162,0.187,0.212,0.261,0.311,0.360,0.409,0.459,0.508,0.558,
	  0.607,0.656,0.706,0.755,0.805,0.854,0.866,0.900,0.933,0.967,
	  1.001,1.035,1.068,1.102,1.135,1.169,1.203,1.237,1.271,1.304,
	  1.338,1.371,1.405,1.439,1.473,1.504,1.532,1.557,1.576,1.587,
	  1.591,1.617,1.650,1.683,1.708,1.721,1.724,1.729,1.762,1.795,
	  1.829,1.863,1.896,1.930,1.959,1.981,2.014,2.048,2.070,2.096,
	  2.097,2.129,2.130,2.132,2.133,2.140,2.141,2.174,2.208,2.209,
	  2.210,2.244,2.278,2.311,2.345,2.379,2.412,2.445,2.479,2.512,
	  2.546,2.580,2.614,2.648,2.681,2.715,2.718,2.719,2.720,2.753,
	  2.786,2.819,2.853,2.866,3.866};
	for( i=1, _r = 0; i <= 157; i++ )
	{
		gv.bin[nd]->eev[i-1] = _itmp63[_r++];
		}
	}
	{ static float _itmp64[] = {-28.457,-23.308,-23.199,-23.080,
	  -22.971,-22.959,-23.072,-23.126,-23.127,-23.019,-22.883,
	  -22.765,-22.591,-22.580,-22.743,-22.959,-23.186,-23.388,
	  -23.525,-23.562,-23.531,-23.483,-23.436,-23.381,-23.271,
	  -23.169,-23.160,-23.155,-23.036,-23.029,-22.998,-22.939,
	  -22.906,-22.907,-22.813,-22.784,-22.798,-22.779,-22.752,
	  -22.774,-22.761,-22.747,-22.735,-22.720,-22.708,-22.709,
	  -22.704,-22.695,-22.695,-22.695,-22.693,-22.686,-22.698,
	  -22.715,-22.731,-22.714,-22.723,-22.731,-22.746,-22.744,
	  -22.759,-22.781,-22.820,-22.808,-22.779,-22.755,-22.741,
	  -22.728,-22.716,-22.711,-22.707,-22.704,-22.699,-22.694,
	  -22.694,-22.692,-22.690,-22.689,-22.686,-22.686,-22.686,
	  -22.685,-22.685,-22.684,-22.684,-22.684,-22.684,-22.684,
	  -22.684,-22.684,-22.685,-22.687,-22.689,-22.692,-22.697,
	  -22.705,-22.718,-22.732,-22.745,-22.758,-22.773,-22.784,
	  -22.788,-22.695,-22.703,-22.715,-22.727,-22.734,-22.725,
	  -22.695,-22.703,-22.710,-22.725,-22.745,-22.771,-22.803,
	  -22.835,-22.862,-22.847,-22.893,-22.926,-22.969,-22.970,
	  -23.026,-23.028,-22.980,-22.945,-22.956,-22.958,-23.014,
	  -23.078,-23.080,-23.082,-23.151,-23.225,-23.300,-23.381,
	  -23.465,-23.549,-23.634,-23.723,-23.813,-23.907,-24.000,
	  -24.094,-24.191,-24.285,-24.378,-24.368,-24.083,-23.856,
	  -23.930,-24.015,-24.099,-24.189,-24.234,-26.938};
	for( i=1, _r = 0; i <= 157; i++ )
	{
		gv.bin[nd]->sab[i-1] = _itmp64[_r++];
		}
	}
	{ static float _itmp65[] = {-35.111,-25.048,-24.857,-24.673,
	  -24.530,-24.499,-24.439,-24.326,-24.155,-23.968,-23.816,
	  -23.689,-23.529,-23.618,-23.950,-24.292,-24.273,-23.999,
	  -23.751,-23.561,-23.417,-23.306,-23.139,-23.026,-22.951,
	  -22.829,-22.695,-22.662,-22.664,-22.637,-22.608,-22.632,
	  -22.639,-22.692,-22.721,-22.800,-22.896,-23.011,-23.123,
	  -23.182,-23.192,-23.207,-23.238,-23.309,-23.385,-23.430,
	  -23.459,-23.505,-23.533,-23.549,-23.564,-23.593,-23.539,
	  -23.456,-23.379,-23.495,-23.466,-23.454,-23.412,-23.462,
	  -23.419,-23.367,-23.294,-23.375,-23.519,-23.682,-23.837,
	  -23.993,-24.160,-24.255,-24.359,-24.472,-24.614,-24.742,
	  -24.803,-24.909,-25.030,-25.162,-25.313,-25.288,-25.342,
	  -25.412,-25.495,-25.580,-25.652,-25.730,-25.813,-25.902,
	  -25.994,-26.090,-26.187,-26.283,-26.383,-26.482,-26.585,
	  -26.689,-26.797,-26.907,-27.018,-27.129,-27.238,-27.358,
	  -27.537,-27.429,-27.478,-27.567,-27.675,-27.796,-27.942,
	  -27.827,-27.798,-27.873,-27.952,-28.040,-28.130,-28.239,
	  -28.353,-28.500,-28.513,-28.592,-28.729,-28.714,-28.860,
	  -28.859,-29.082,-29.112,-28.898,-28.891,-29.113,-29.103,
	  -29.105,-29.105,-29.282,-29.295,-29.316,-29.344,-29.379,
	  -29.421,-29.465,-29.513,-29.567,-29.621,-29.679,-29.740,
	  -29.803,-29.868,-29.935,-30.021,-30.042,-30.064,-30.067,
	  -30.076,-30.129,-30.186,-30.247,-30.270,-32.016};
	for( i=1, _r = 0; i <= 157; i++ )
	{
		gv.bin[nd]->sse[i-1] = _itmp65[_r++];
		}
	}

	/* all the old style grains have been initialized
	 * now reset lowest energy point to current low energy of code */
	for( nd=0; nd < gv.nBin; nd++ )
	{
		long nelem;
		float powersab , powersse;
		/* this is slope for lowest two energy points */
		powersab = (gv.bin[nd]->sab[1] - gv.bin[nd]->sab[0])/(gv.bin[nd]->eev[1] - gv.bin[nd]->eev[0]);
		powersse = (gv.bin[nd]->sse[1] - gv.bin[nd]->sse[0])/(gv.bin[nd]->eev[1] - gv.bin[nd]->eev[0]);
		/*fprintf(ioQQQ,"%ld %e %e %e\n", nd, gv.bin[nd]->eev[0] , powersab , powersse );*/

		/* extrapolate log of cross sections to current lowest energy point */
		/*fprintf(ioQQQ," old %e", gv.bin[nd]->sab[0]);*/
		gv.bin[nd]->sab[0] += powersab * ( (float)log10(rfield.emm) - gv.bin[nd]->eev[0] );
		/*fprintf(ioQQQ," new %e", gv.bin[nd]->sab[0]);
		  fprintf(ioQQQ," old %e", gv.bin[nd]->sse[0]);*/
		gv.bin[nd]->sse[0] += powersse * ( (float)log10(rfield.emm) - gv.bin[nd]->eev[0] );
		/*fprintf(ioQQQ," new %e\n", gv.bin[nd]->sse[0]);*/
		gv.bin[nd]->eev[0] = (float)log10(rfield.emm);

		/* indicate old style grain */
		gv.bin[nd]->lgOldGrain1 = TRUE;

		/* initialize some other grain data */
		gv.bin[nd]->AvArea = (float)AveArea[nd];
		gv.bin[nd]->AvVol = (float)AveVol[nd];
		gv.bin[nd]->IntRadius = (float)IntRadius[nd];
		gv.bin[nd]->IntVol = (float)IntVol[nd];
		gv.bin[nd]->matType = GrainType[nd];
		gv.bin[nd]->cnv_H_pGR = NumHperGrain[nd];
		gv.bin[nd]->cnv_GR_pH = 1./gv.bin[nd]->cnv_H_pGR;
		gv.bin[nd]->atomWeight = (float)MeanMolWeight[nd];
		/* none of these grains are size resolved -> all mass in this bin */
		gv.bin[nd]->dustp[4] = 1.;
		/* copy elemental abundances to new structure, initialize accomodation coef */
		for( nelem=0; nelem < LIMELM; nelem++ ) 
		{
			gv.bin[nd]->elmAbund[nelem] = 0.;
			/* this coefficient is defined at the end of appendix A.10 of BFM */
			gv.bin[nd]->AccomCoef[nelem] = 2.*gv.bin[nd]->atomWeight*AtomcWgt.AtomicWeight[nelem]/
				POW2(gv.bin[nd]->atomWeight+AtomcWgt.AtomicWeight[nelem]);
		}
		for( i=0; i < 4; i++ ) 
		{
			nelem = NINT(dstelz[nd][i]) - 1;
			if( nelem >= 0 && nelem < LIMELM ) 
			{
				gv.bin[nd]->elmAbund[nelem] = dstela[nd][i];
			}
		}
		/* guesstimate */
		gv.bin[nd]->ThermEff = 0.5;
		if( gv.bin[nd]->matType == MAT_SIL ) 
		{
			gv.bin[nd]->BandGap = 0.3676f;
		}
		else 
		{
			gv.bin[nd]->BandGap = 0.f;
		}
		/* this is capacity per grain, in Farad per grain */
		gv.bin[nd]->Capacity = PI4*ELECTRIC_CONST*gv.bin[nd]->IntRadius/100.*gv.bin[nd]->cnv_H_pGR;
	}

	/*block data with grains data from P.G. Martin */

	/* gv.nBin is the number of grain species
	 * LIMCRS is upper limit to number of cross sections
	 * chDstLab is the character label for the grain species
	 * DustWorkFcn is the grain photoionization threshold in Ryd
	 * DUSTP 1 - 4 are density, molecular wt, normalizing abundance, depletion
	 * EEV is energy in log10 Ryd (despite name)
	 * SAB is log10 absorption cross section per H nucleon
	 * SSE is log10 scattering cross section per H nucleon TIMES (1 - g)
	 * so SSE is effective scattering cross section
	 * and SAB + SSE gives radiation pressure cross section
	 * NDPTS is number of energies
	 * DAREA is surface area cm**2 per hydrogen nucleon
	 * projected area is a quarter of this
	 * DSIZE is effective size (r32) in cm
	 * DSTELA is the relative number of an element depleted in grains, wrt H
	 * DSTELZ is the atomic number of this element
	 * Tsublimat is grain sublimation temperature
	 */
	/* grain type 1: graphite - mrn/dl power law */

	/* grain type 2: silicate - mrn/dl power law */

	/* grain type 3: gra - mrn/dl truncat power law */

	/* grain type 4: sil - mrn/dl truncat power law */

	/* grain type 5: silicate - radius 0.01 micron */

	/* grain type 6: silicate - radius 0.1 micron */

	/* grain type 7: silicate from Kevin Volk */

	/*******************
	 *  this is the version of Kevin Volk's pn grains that he sent
	 *  in November of 92.  He says that the dust mass to gas ratio is 1/223,
	 *  and that this is about 2/3 of ism. */


	/* grain type 8: grey opacity grains to test CLOUDY against DUSTCD
	 * other constants as for grain 7  (K Volk) */


	/* Scattering efficiency set to half the absorption efficiency */

	/* (K Volk) added PAH grains 30 April 1993
	 *
	 * The following is for PAHs with 120 C atoms (and 26 H atoms) based on
	 * the paper of Desert, Boulanger, and Puget (1990) with some values taken
	 * from the paper of Schutte, Tielens, and Allamdolla (1993).  The PAHs are
	 * of radius 0.001 microns.
	 *
	 * These grains take up about 0.25 to 0.5% of the available carbon assuming
	 * solar abundances, so there is no depletion of other elements. */
	/* Assume no scattering from the PAH moelcules.  This is not really true, but
	 * I assume any scattering is coherent and therefore of no concern */

	/* grain type 10: 0.354 nm radius PAH grains (15 C atoms)
	 *
	 * (K Volk) added PAH grains 30 April 1993
	 *
	 * The following is for PAHs with 15 C atoms (and 9 H atoms) based on
	 * the paper of Desert, Boulanger, and Puget (1990) with some values taken
	 * from the paper of Schutte, Tielens, and Allamdolla (1993).  The PAHs are
	 * of radius 0.000354 microns.
	 *
	 * These grains take up about 0.25 to 0.5% of the available carbon assuming
	 * solar abundances, so there is no depletion of other elements. */
	/* Assume no scattering from the PAH moelcules.  This is not really true, but
	 * I assume any scattering is coherent and therefore of no concern */


#	ifdef DEBUG_FUN
	fputs( " <->OldStyleGrainBlockDataInit()\n", debug_fp );
#	endif
	return;
}
/*lint +e736 */


void OldStyleGrainCSInit(long nd)
{
	long i;

#	ifdef DEBUG_FUN
	fputs( "<+>OldStyleGrainCSInit()\n", debug_fp );
#	endif

	for( i=0; i < rfield.nupper; i++ )
	{
		gv.bin[nd]->dstab1[i] = crsdst(rfield.anu[i],nd,"ABSO",i);
		gv.bin[nd]->dstsc1[i] = crsdst(rfield.anu[i],nd,"SCAT",i);
		ASSERT( gv.bin[nd]->dstab1[i] > 0. );
		ASSERT( gv.bin[nd]->dstsc1[i] > 0. );
	}

#	ifdef DEBUG_FUN
	fputs( " <->OldStyleGrainCSInit()\n", debug_fp );
#	endif
	return;
}


/*crsdst interpolate on grains cross section, called once per calculation */
double crsdst(
		/* energy in ryd */
		double freq, 
		/* which grain species this is */
		long int nd, 
		/* 4 char + null string saying "ABSO" or "SCAT" */
		char *chAbedo,
		/* pointer within energy array in case of direct copy of cs */
		long int ipAnu )
{
	static int lgNew;
	long int i;
	static long int ncrs;
	double crsdst_v, 
	  x;
	float y;
	static float crs1[LIMCRS], 
	  xlog[LIMCRS];
	static int lgFirst = TRUE;
	static long ndold = -1;
	static char chScat[5] = "NONE";

#	ifdef DEBUG_FUN
	fputs( "<+>crsdst()\n", debug_fp );
#	endif

	if( gv.bin[nd]->ndpts< 0 )
	{
		/* negative number of points indicated just return cross section read
		 * in from file */
		if( strcmp(chAbedo,"ABSO") == 0 )
		{
			crsdst_v = gv.bin[nd]->dstab1[ipAnu];
		}
		else if( strcmp(chAbedo,"SCAT") == 0 )
		{
			crsdst_v = gv.bin[nd]->dstsc1[ipAnu];
		}
		else
		{
			fprintf(ioQQQ,"crsdst_v insanity\n");
			cdEXIT(EXIT_FAILURE);
		}

#		ifdef DEBUG_FUN
		fputs( " <->crsdst()\n", debug_fp );
#		endif
		return( crsdst_v );
	}

	if( lgFirst )
	{
		lgNew = TRUE;
		ndold = nd;
		strcpy( chScat, chAbedo );
		lgFirst = FALSE;
	}
	else
	{
		if( nd != ndold || strcmp(chScat,chAbedo) != 0 )
		{
			lgNew = TRUE;
			ndold = nd;
			strcpy( chScat, chAbedo );
		}
		else
		{
			lgNew = FALSE;
		}
	}

	if( lgNew )
	{
		ncrs = gv.bin[nd]->ndpts;
		if( strcmp(chAbedo,"ABSO") == 0 )
		{
			/* do absorption cross sections */
			for( i=0; i < ncrs; i++ )
			{
				xlog[i] = gv.bin[nd]->eev[i];
				/* dust scross section with log of depletion scale factor
				 * >>chng 97 july 17, now remove depletion, so physical quantity
				 * crs1(i) = sab(i,nd) * dstfactor(nd) */
				crs1[i] = gv.bin[nd]->sab[i];
			}
		}
		else if( strcmp(chAbedo,"SCAT") == 0 )
		{
			/* do scattering cross sections */
			for( i=0; i < ncrs; i++ )
			{
				xlog[i] = gv.bin[nd]->eev[i];
				/* dust scross section with scale factor
				 * >>chng 97 july 17, now remove depletion, so physical quantity
				 * crs1(i) = sse(i,nd) * dstfactor(nd) */
				crs1[i] = gv.bin[nd]->sse[i];
			}
		}
		else
		{
			puts( "[Stop in crsdst]" );
			cdEXIT(EXIT_FAILURE);
		}
	}

	x = log10(freq);
	if( x < gv.bin[nd]->eev[0] )
	{
		/* this is impossible since we extrap energy scale down, but harmless */
		crsdst_v = 0.;
	}
	else if( x > gv.bin[nd]->eev[ncrs-1] )
	{
		/* >>chng 99 jun 16, assume nu^-3 high energy tail, had set to zero */
		crsdst_v = crs1[ncrs-1] + 3.*(gv.bin[nd]->eev[ncrs-1]- x);
		crsdst_v = pow(10.,crsdst_v);
	}
	else
	{
		lint(xlog,crs1,ncrs,x,&y);
		crsdst_v = pow(10.f,y);
	}

#	ifdef DEBUG_FUN
	fputs( " <->crsdst()\n", debug_fp );
#	endif
	return( crsdst_v );
}


/*lint do linear interpolation, used for grains opacity */

void lint(float xarray[], 
	  float yarray[], 
	  long int n, 
	  double xval, 
	  float *yval)
{
	long int i;

#	ifdef DEBUG_FUN
	fputs( "<+>lint()\n", debug_fp );
#	endif

	for( i=0; i < (n - 1); i++ )
	{
		if( xval <= xarray[i+1] )
		{
			*yval = (float)((xval - xarray[i])/(xarray[i+1] - xarray[i])*
			  (yarray[i+1] - yarray[i]) + yarray[i]);
			
#			ifdef DEBUG_FUN
			fputs( " <->lint()\n", debug_fp );
#			endif
			return;
		}
	}

#	ifdef DEBUG_FUN
	fputs( " <->lint()\n", debug_fp );
#	endif
	return;
}

#endif
