/*EmLineJunk set all elements of EmLine struc to dangerous values */
/*EmLineZero zeros out the emission line structure,
 * declarations are in taulines.h */
#include "cddefines.h"
#include "taulines.h"

void EmLineJunk( EmLine * t )
{

#	ifdef DEBUG_FUN
	fputs( "<+>EmLineJunk()\n", debug_fp );
#	endif

	/* optical depth in continuum to ill face */
	t->TauCon = -FLT_MAX;

	/* inward and total line optical depths */
	t->TauIn = -FLT_MAX;
	t->TauTot = -FLT_MAX ;

	/* type of redistribution function, */
	t->iRedisFun = INT_MIN ;

	/* pointer to line within continuum array */
	t->ipCont = -10000;

	/* inward fraction */
	t->FracInwd = -FLT_MAX;

	/* continuum pumping rate */
	t->pump = -FLT_MAX ;

	/* line intensity */
	t->xIntensity = -FLT_MAX ;

	/* number of photons emitted per sec in the line */
	t->phots = -FLT_MAX;

	/* gf value */
	t->gf = -FLT_MAX ;

	/* escape and destruction probs */
	t->Pesc = -FLT_MAX;
	t->Pdest = -FLT_MAX;
	t->Pelec_esc = -FLT_MAX;

	/* damping constant, and number related to it */
	t->damp = -FLT_MAX;
	t->damprel = -FLT_MAX ;

	/* total opacity (cm^-1) in transition*/
	t->dTau = -FLT_MAX;

	/* cooling and heating due to collisional excitation */
	t->cool = -FLT_MAX;
	t->heat = -FLT_MAX ;

	/* ratio of collisional to radiative excitation*/
	t->ColOvTot = -FLT_MAX ;

	/* collision strength for transition */
	t->cs = -FLT_MAX;

	 /* ion stage of element, 1 for atom, 2 ion, etc */
	t->IonStg = -10000;

	 /* atomic number of element, 1 for H, 2 for He, etc */
	t->nelem = -10000;

	/* wavelentgh, usually in A, used for printout */
	t->WLAng = -FLT_MAX;

	/* transition energy in degrees kelvin*/
	t->EnergyK = -FLT_MAX;
	/* transition energy in ergs */
	t->EnergyErg = -FLT_MAX;
	/* transition energy in wavenumbers */
	t->EnergyWN = -FLT_MAX;

	/* line opacity */
	t->opacity = -FLT_MAX;

	/* lower and upper statistical weights */
	t->gLo = -FLT_MAX;
	t->gHi = -FLT_MAX ;

	/* populations of lower and upper levels, and pop that enters net opacity */
	t->PopLo = -FLT_MAX ;
	t->PopHi = -FLT_MAX ;
	t->PopOpc = -FLT_MAX ;

	/* transition prob, Einstein A upper to lower */
	t->Aul = -FLT_MAX ;

	/* ratio A21/(A21+C21) */
	t->AovTot = -FLT_MAX ;

	/* type of transition for Mewe collision strength*/
	/* in general first parameter for CS expansion*/
	/* this parameter zero indicates high quality line */
	t->cs1 = -FLT_MAX;

	/* ots rate */
	t->ots = -FLT_MAX;

#	ifdef DEBUG_FUN
	fputs( " <->EmLineJunk()\n", debug_fp );
#	endif

	return;
}

/*EmLineZero zeros out the emission line structure */
void EmLineZero( EmLine * t )
{

#	ifdef DEBUG_FUN
	fputs( "<+>EmLineZero()\n", debug_fp );
#	endif

	/* optical depth in continuum to ill face */
	t->TauCon = 0.;

	/* inward and total line optical depths */
	t->TauIn = 0.;
	t->TauTot = 0. ;

	/* type of redistribution function, */
	t->iRedisFun = 0 ;

	/* pointer to line within continuum array */
	t->ipCont = 0;

	/* inward fraction */
	t->FracInwd = 0.;

	/* continuum pumping rate */
	t->pump = 0. ;

	/* line intensity */
	t->xIntensity = 0. ;

	/* number of photons emitted per sec in the line */
	t->phots = 0.;

	/* gf value */
	t->gf = 0. ;

	/* escape and destruction probs */
	t->Pesc = 0.;
	t->Pdest = 0.;
	t->Pelec_esc = 0.;

	/* damping constant, and number related to it */
	t->damp = 0.;
	t->damprel = 0. ;

	/* total opacity (cm^-1) in transition*/
	t->dTau = 0.;

	/* cooling and heating due to collisional excitation */
	t->cool = 0.;
	t->heat = 0. ;

	/* ratio of collisional to radiative excitation*/
	t->ColOvTot = 0. ;

	/* collision strength for transition */
	t->cs = 0.;

	 /* ion stage of element, 1 for atom, 2 ion, etc */
	t->IonStg = 0;

	 /* atomic number of element, 1 for H, 2 for He, etc */
	t->nelem = 0;

	/* integer wavelentgh, usually in A, used for printout */
	t->WLAng = 0.;

	/* transition energy in degrees kelvin*/
	t->EnergyK = 0.;
	/* transition energy in ergs */
	t->EnergyErg = 0.;
	/* transition energy in wavenumbers */
	t->EnergyWN = 0.;

	/* line opacity */
	t->opacity = 0.;

	/* lower and upper statistical weights */
	t->gLo = 0.;
	t->gHi = 0. ;

	/* populations of lower and upper levels, and pop that enters net opacity */
	t->PopLo = 0. ;
	t->PopHi = 0. ;
	t->PopOpc = 0. ;

	/* transition prob, Einstein A upper to lower */
	t->Aul = 0. ;

	/* ratio A21/(A21+C21) */
	t->AovTot = 0. ;

	/* type of transition for Mewe collision strength*/
	/* in general first parameter for CS expansion*/
	/* this parameter zero indicates high quality line */
	t->cs1 = 0.;

	/* ots rate */
	t->ots = 0.;

#	ifdef DEBUG_FUN
	fputs( " <->EmLineZero()\n", debug_fp );
#	endif

	return;
}
