/*freeht evaluate free-free heating due to incident continuum */
#include "cddefines.h"
#include "physconst.h"
#include "hydrogenic.h"
#include "freeon.h"
#include "opacity.h"
#include "phycon.h"
#include "rfield.h"
#include "ionfracs.h"
#include "iso.h"
#include "heat.h"
#include "freeht.h"

void freeht(void)
{
	long int i;

	double damper, 
	  fac, 
	  fac1, 
	  fachmi, 
	  fachmi1;
	double dfactor;
	static double oldfac = 0.;

#	ifdef DEBUG_FUN
	fputs( "<+>freeht()\n", debug_fp );
#	endif

	if( !freeon.lgFreeOn )
	{
		hydro.FreeFreeHeat = 0.;
#		ifdef DEBUG_FUN
		fputs( " <->freeht()\n", debug_fp );
#		endif
		return;
	}

	/* must constantly reevaluate if free free heating is important */
	if( opac.lgRedoStatic || hydro.FreeFreeHeat/heat.htot > 0.05 )
	{
		if( nzone < 1 )
		{
			damper = 1.;
		}
		else
		{
			damper = 0.5;
		}

		/* OPSV is missing factor of 1E-20 to avoid underflow */
		/* >>chng 00 jun 05 descale by 1e10 */
		fac = (phycon.eden/1e20) *
			((xIonFracs[ipHYDROGEN][1] + xIonFracs[ipHELIUM][1] + 4.*xIonFracs[ipHELIUM][2] + phycon.EdenFFSum)/1e10)/phycon.sqrte;
		fac1 = fac*TE1RYD/phycon.te;

		/* >>chng 96 oct 30, put following after fac1 defn */
		fac = damper*fac + oldfac*(1. - damper);
		fachmi = (phycon.eden/1e20)*(xIonFracs[ipHYDROGEN][1]*iso.Pop2Ion[ipH_LIKE][0][ipH1s]/1e10)/
		  phycon.sqrte;
		fachmi1 = fachmi*TE1RYD/phycon.te;
		fixit();/* this needs to be sum over all elements and ions */

		for( i=0; i < rfield.nflux; i++ )
		{
			if( rfield.ContBoltz[i] < 0.995 )
			{
				ASSERT( rfield.gff[0][i] > 0. );
				/* use 1-exp(hn/kT)) only if exp is small
				 * last term is scaled h minus brems free-free absorption */
				dfactor = opac.OpacStack[i-1+opac.ipBrems]*
					(1. - rfield.ContBoltz[i])*rfield.gff[0][i];
				opac.FreeFreeOpacity[i] = dfactor*fac;
				/* this is the H- part, opac here is ratio of H- to ff */
				opac.FreeFreeOpacity[i] += dfactor*fachmi*opac.OpacStack[i-1+opac.iphmra];
			}
			else
			{
				dfactor = opac.OpacStack[i-1+opac.ipBrems]*rfield.anu[i]*
				  rfield.gff[0][i];
				opac.FreeFreeOpacity[i] = dfactor*fac1;
				/* h- free free absorption */
				opac.FreeFreeOpacity[i] += dfactor*fachmi1*opac.OpacStack[i-1+opac.iphmra];
			}
		}
		oldfac = fac;

		/* now integrate over this */
		hydro.FreeFreeHeat = 0.;
		for( i=0; i < rfield.nflux; i++ )
		{
			hydro.FreeFreeHeat += opac.FreeFreeOpacity[i]*rfield.flux[i]*
			  rfield.anu[i];
		}
		hydro.FreeFreeHeat *= EN1RYD;
	}

#	ifdef DEBUG_FUN
	fputs( " <->freeht()\n", debug_fp );
#	endif
	return;
}

