/* create H2 molecules, called by ContCreatePointers */
void H2_Create(void);

/* set the ipCont struc element for the H2 molecule, called by ContCreatePointers */
void H2_ContPoint( void );

/* radiative acceleration due to H2 called in forlin */
double H2_Accel(void);

/* rad pre due to h2 lines called in PressureTotalDo*/
double H2_RadPress(void);

/* add in explicit lines from the large H2 molecule, called by lines_molecules */
void H2_AddLines(void);

/* internal energy of H2 called in PressureTotalDo */
double H2_InterEnergy(void);

/* punch H2 line data */
void H2_PunData(
	/* io unit for punch */
	FILE* ioPUN ,
	/* punch all levels if true, only subset if false */
	int lgDoAll );

/* include H2 lines in punched optical depths, etc, called from PunchLineStuff */
void H2_PunchLineStuff( FILE * io , float xLimit  , long index);

/* do emission from H2 - called from RTDiffuse */
void H2_EmitOut(double VolFac, 
  double ref);

/* do RT for H2 - called from RTMake */
void H2_RTMake( int lgDoEsc );

/* increment optical depth for the H2 molecule, called from RTOptDepthIncre */
void H2_TauInc(void);

/* initialize optical depths in H2, called from RTOptDepthInit */
void H2_TauInit( void );

/* the large H2 molecule, called from RTOptDepthReset */
void H2_TauAver( void );

/* do level populations for H2, called by Hydrogenic */
void H2_LevelPops( void );

/* flag saying whether molecular data have been read in yet */
extern int lgH2_READ_DATA;

/* this is the number of electronic levels */
#define N_H2_ELEC	7

EXTERN struct t_h2 {

	/* flag saying whether to bother with the large H2 molecule at all,
	 * default is FALSE, set true with atom h2 on command */
	int lgH2ON;

	/* limit to the ratio H2/Htot - if ratio is below this, large atom is not called */
	double H2_to_H_limit;

	/* the number of electronic quantum states to include.
	 * To do both Lyman and Werner bands want nelec = 3 */
	long int nelec;

	}	h2;
