/* following two macros used to define recombination coef arrays */
/* Max n desired in RRCoef file.	*/
/* >>chng 02 jan 28, from 10 to 20 so large HeI tests are fast */
/* this is the number of levels used with the
 * atom he-like levels large command */
/* Helium itself will have precompiled recombination coefficients up to this maximum n.	*/
#define HE_RREC_MAXN		40

/* Ions of the sequence will go up to this n.	*/
#define HE_LIKE_RREC_MAXN		10

/* He-like main routine to call HeLevel and determine 
 * model he-like species atom level balance	*/
void HeLike(void);

/* create he-like series */
void HeCreate(void);

/* routine to print departure coefficients for he-like species */
void prt_He_like_DeparCoef(long int nelem );

/* routine to print level pops for he-like species */
void prt_He_like_Pops(long int nelem );

/* Calculate "EnergyWN" for 4 autoionizing levels of each
 * "turned-on" element.	*/
void He1Autoionize(void);

/*HelikeCheckRecomb - called by SanityCheck to confirm that recombination coef are ok,
 * return value is relative error between new calculation of recom, and interp value */
double HelikeCheckRecomb(
	/* the chemical element, 1 for He */
	long nelem ,
	/* the level, 0 for ground */
	long level ,
	/* the temperature to be used */
	double temperature );

/* routine to punch table needed for AGN3 - collision strengths of HeI */
void AGN_He1_CS( FILE *ioPun );

/*He_cross_section returns cross section (cm^-2), 
 * given EgammaRyd, the photon energy in Ryd,
 * ipLevel, the index of the level, 0 is ground, 3 within 2 3P,
 * ipZ is charge, equal to 1 for Helium,
 * this is a wrapper for cross_section */
double He_cross_section( double EgammaRyd , long ipLevel , long ipZ );

/* all of these are initialized in zero */
EXTERN struct t_helike 
{

	/* flag saying whether to use a set of physics meant to 
	 * replicate the Benjamin et al. HeI results 
	 * set with ATOM HE-LIKE BENJAMIN command */
	int lgSetBenjamin;

	/* number of CS in the above array */
	long int nCS;

	/* Hy2nu is hydrogen two photon, others He1 and He2 */
	 float *he12nu/*[NC_ELL]*/;

	 /* this is the rate for the Aul given to bogus transitions,
	  * set to 1e-20 in zero */
	 float SmallA;

	 /* flag set by compile he-like command, says to regenerate table of recombination coef */
	 int lgCompileRecomb;

	 /* use the old or new model for the real neutral density */
	 int lgUseOld;

}	helike;
