/* hevmolec.h */

/* molecules of the heavy elements.  order must exactly match that in hevcolumn
 * number of molecules in heavy element network */

#define	NHEVML	18

#define	ipCH	0
#define	ipCHP	1
#define	ipOH	2
#define	ipOHP	3
#define	ipOTWO	4
#define	ipCTWO	5
#define	ipCO	6
#define	ipCOP	7
#define	ipH2O	8
#define	ipH2OP	9
#define	ipO2P	10
#define	ipC2P	11
#define	ipH3P	12
#define	ipH3OP	13
#define	ipCH2P	14
#define	ipCH2	15
#define	ipCH3	16
#define	ipCP	17

EXTERN struct t_hevmolec {
	float hevmol[NHEVML], 
	  hevcol[NHEVML], 
	  HevMolSav[NHEVML];

	/* abundance ratio C12O16 to C13O16, init in zero.c  */
	float RatioC12O16_2_C13O16;

	/* flag set true if H2O deEXTERN struction rate went to zero */
	int lgH2Ozer;

	}	hevmolec;
