/*hmrate compile molecular rates using Hollenback and Mckee fits,
 * called by hmole and comole  */
#include "cddefines.h"
#include "phycon.h"
#include "hmrate.h"

double hmrate(double a, 
	  double b, 
	  double c)
{
	double bfac, 
	  cfac, 
	  hmrate_v;

#	ifdef DEBUG_FUN
	fputs( "<+>hmrate()\n", debug_fp );
#	endif

	/* function to evaluate 
	 * >>refer	chemistry		Hollenbach and McKee ApJ 342, 306.
	 * A is leading coef, B is power temp depen, and C is exponential
	 * rate = a * (te/300K)^b * EXP(-c/te)
	 * */
	if( c/phycon.te > 50. )
	{
		hmrate_v = 0.;
		
#		ifdef DEBUG_FUN
		fputs( " <->hmrate()\n", debug_fp );
#		endif
		return( hmrate_v );
	}

	if( c == 0. )
	{
		cfac = 1.;
	}
	else
	{
		cfac = exp(-c/phycon.te);
	}

	if( b == 0. )
	{
		bfac = 1.;
	}
	else
	{
		bfac = pow(phycon.te/300.,b);
	}

	hmrate_v = a*bfac*cfac;


#	ifdef DEBUG_FUN
	fputs( " <->hmrate()\n", debug_fp );
#	endif
	return( hmrate_v );
}

