/*hydro_vs_deexcit compute collision strength for collisional deexcitation for hydrogen atom, 
 * from Vriens and Smeets */
double hydro_vs_deexcit(long int ihigh, 
	  long int ilow);

/*hydro_vs_excit compute collision rate for collisional excitation for hydrogen atom, 
 * from Vriens and Smeets */
double hydro_vs_excit(long int nhigh, 
	  long int nlow);

/*hydro_vs_ioniz generate hydrogenic collisional ionization rate coefficients 
 * for quantum number n */
double hydro_vs_ioniz(long int n);


/*Hion_coll_ioniz_ratecoef calculate hydrogenic ionization rates for all n, and Z*/
double Hion_coll_ioniz_ratecoef(
		/* the isoelectronic sequence */
		long int ipISO ,
		/* element, >=1 since only used for ions 
		 * nelem = 1 is helium the least possible charge */
		long int nelem,
		/* principal quantum number, > 1
		 * since only used for excited states */
		long int n);

/*Hion_colldeexc_cs collision strength for collisional de-excitation for any levels of hydrogenic Z*/
double Hion_colldeexc_cs(long int ipHi, 
  long int ipLo, 
  long int nelem,
  long int ipISO );
