/****************************************************************************
 *                                                                          *
 * hydrogenic.h -                                                           *
 * this file contains the variables for the model hydrogen ions,            *
 * and prototypes for the series of routines that drive the atom            *
 * the EXTERN structure hydro is defined here -                             *
 * all H variables should migrate here                                      *
 *                                                                          *
 * the hydrogenic lines, EmisLines[ipH_LIKE] are in taulines.h                       *
 *                                                                          *
 ****************************************************************************/

/* the routine that calls the hydrogenic routines */
void Hydrogenic(void);

/*HydroLevel solve for ionization balance level populations of model hydrogen atom */
void HydroLevel(long int ipZ);

/*HydroLevelPop solve for departure coefs in hydrogen ionization balance */
void HydroLevelPop(long int ipZ ,
	double **SaveZ/*[iso.numLevels[ipH_LIKE]+2][iso.numLevels[ipH_LIKE]+2]*/, 
	double *bvec/*[iso.numLevels[ipH_LIKE]+2]*/, 
	double *error/*[iso.numLevels[ipH_LIKE]+2]*/, 
	double *work/*[iso.numLevels[ipH_LIKE]+2]*/, 
	double **z/*[iso.numLevels[ipH_LIKE]+2][iso.numLevels[ipH_LIKE]+2]*/ ,
	long int *ipiv , /* MALLOC out to [iso.numLevels[ipH_LIKE]+1] */
	double *totcap/* MALLOC out to [iso.numLevels[ipH_LIKE]+1]*/);

/*HydroPesc evaluate escape and deEXTERN struction probabilities for hydrogen lines,
 * second parameter is flag saying whether to also do escape prob (TRUE) or
 * just the deEXTERN struction probabilites (FALSE) */
void HydroPesc(long int ipZ, int lgDoEsc);

/*HydroCollid evaluate collision rate for model hydrogen atom */
void HydroCollid(long int ipZ);

/*HydroT2Low called to do hydrogenic level populations when temp too low for matrix */
void HydroT2Low(long int ipZ, 
  double rfac);

/*HydroRecCool hydrogen recombination cooling */
double HydroRecCool(long int n, long int ipZ);

/* returns the ratio of recombination cooling to recombination coefficient */
double HCoolRatio( 
	/* the scaled temperature, T * n^2 / Z^2, n is prin quant number, Z is charge, 1 for H */
	double t );

/*HydroBranch compute branching ratios for Jason's model hydrogen atom */
double HydroBranch(long int ihigh, 
  long int ilow, 
  long int iz);

/*HydroRecom photoionization, recombination, radiative rates for model hydrogen atom */
void HydroRecom(long int ipZ);

/* all of these are initialized in zero */
EXTERN struct t_hydro {

	/* >>chng 99 nov 29 from float to double */
	/* cooling due to various hydrogenic species, evaluated in iso_cool */
	/* cooling due to Lya */
	/* double coola[LIMELM], 
	  collisional ionization
	  chion[LIMELM],  */
	  /* hydrogen radiative recombination cooling 
	  HRadRecCool[LIMELM], */
	  /*hrest[LIMELM], */
	  /*barest[LIMELM], */
	  /*restly[LIMELM] ,
	  HLineTotCool[LIMELM], 
	  dHLTot[LIMELM];*/

	/* an array of indices that point to the energy that is half of La
	 * used to two photon emission */
	long int ipHalfLya[2][LIMELM];
	/* ip2pht will become array of indices for induced two photon,
	 * series of symmetric indices 
	 * ipHy2nu[ipISO][ipZ][energy] */
	long int ***ipSymHy2nu;
	/* will become array of two photon emission cross sections,
	 * Hy2nu[ipISO][ipZ][energy] */
	float ***AsHy2nu;

	/* flag to say (true) to produce emissivity for hydrogenic species,
	 * rather than intensity (the default).  Set with 
	 * hydrogen emissivity commmand.  default is false */
	int lgHydEmiss;

	/* flag saying whether H atom is photo=false or collis ionized=true */
	int lgHColionImp;

	/* FreFreHeat is free-free heating, evaluated in freeht*/
	double FreeFreeHeat, 
	  /* total free free heating integrated over model */
	  FreeFreeTotHeat,
	  /* FreeFreeCool is cooling, evaluated in coolr*/
	  FreeFreeCool , 
	  /* HFFNet is net cooling, negative if heating*/
	  /* heating stored in heating[11,0]*/
	  HFFNet;

	/* lgHiPop2 flag set if H n=2 population gets large relative to ground
	 * pop2mx is maximum population of n=2 relative to ground */
	int lgHiPop2;
	float pop2mx;

	/* arrays for stark broadening in Puetter formalism */
	float **strkar/*strkar[LMHLVL+1][LMHLVL+1]*/;
	float **pestrk/*pestrk[LMHLVL+1][LMHLVL+1]*/;

	/* the total level destruction rate, s-1 */
	double **DestRate;/*[LIMELM][LMHLVL+1]*/

	/* dstfe2lya is destruction probability for Lya onto FeII,
	 * net deexcitation of Lya but not ots destruction */
	float dstfe2lya;

	/* flag to say which type of solution to do for level pops, departure or pops */
	char chTypeAtom[5];

	/* width of Lya */
	float HLineWidth;

	/* TexcLya is the excitation temperature of Lya */
	float TexcLya;

	/* nLyaHot is counts how ofter Lya hotter than gas */
	long int nLyaHot;

	/* TLyaMax is hottest */
	float TLyaMax, 
	/* TeLyaMax is electron temp at point where Lya max  */
	  TeLyaMax;

	/* nZTLaMax is the zone where this happened */
	long int nZTLaMax;

	/* flag saying that Lya mased */
	int lgHLyaMased;

	/* smallest Lya optical depth that occured in the calculation */
	float xLaMase;

	/* set true if collisional recombination is important for hydrogen */
	int lgHColRec;

	/* set true if lya heating is important in heatsum */
	int lgHCoolng;

	/* types of redistribution functions for Lya, other resonances, and subordinate lines */
	int ipLya , ipReso , ipSub ;

	/* chHTopType is the method.used to top off the H atom */
	char chHTopType[5];

	/* relative importance of photo ioniz from n=2 of H */
	float photn2;

	/* largest fraction of ground state H destruction due to collisional ionization */
	float HCollIonMax;

	/* fraction of H ionizations due to ground collisions */
	float HCollIonFrac;

	/* array of lifetimes for HI levels, not including Lyman lines
	 * lifetime for principal quantum numbers
	 * [0] and [1] are set to -1e37, no defined,
	 * [2] is lya 
	 *
	 * this is used for full H iso sequence, so
	 * must be defined up through most number of levels
	 * needed for any atom on this sequence
	 */
	float HyLife[NHYDRO_MAX_LEVEL];

	/* cintot is total induced cooling over model */
	double cintot;

	/* lgHInducImp says whether or not induced recombination is important*/
	int lgHInducImp;

	/* this is the D/H ratio, set with SET D/H command */
	double D2H_ratio;

	} hydro;
