/* ionfracs.h */
/*
 * args are atomic number, ionization stage
 *
 * second index is ionization stage, 
 * 0 for atom, 1 for first ion
 * 0 is total abundance all species
 *
 * abundances.gas_phase[nelem1] is gas phase density of element nelem (cm^-3),
 * it includes elements in molecules but not grains
 * xIonFracs[nelem][i] is density of ith ionization stage (cm^-3),
 * [nelem][0] is atom, [][1]) the first ion
 * nelem = 0 for H, 1 for he, etc
 *
 * with this scheme, 
 * OIII is [ipOXYGEN][2]
 * HII is [ipHYDROGEN][1]
 *
 */
/* at the moment 12CO, 13CO, and H2 are xIonFracs[LIMELM][2], [L+1][3] and [L+2][1] */
EXTERN float xIonFracs[LIMELM+3][LIMELM+1];

/* >>chng 01 dec 07, add array of some of gas phase elements locked in molecular abundances */
EXTERN float xMolFracs[LIMELM];

