/*lindst add local line intensity to line luminosity stack */
/*PntForLine generate pointer for forbidden line */
#include "cddefines.h"
#include "physconst.h"
#include "linesave.h"
#include "grainvar.h"
#include "opacity.h"
#include "rfield.h"
#include "radius.h"
#include "ipoint.h"
#include "lindst.h"

/* this is energy in ryd as set by call to PntForLine */
static double EnergyRyd;
/* this is flag saying that EnergyRyd has been set */
static int lgEnergyRydSet=FALSE;

void lindst(double xInten, 
  float wavelength, 
  char *chLab, 
  long int ipnt, 
  char chInfo, 
  int lgOutToo)
{
	double e2fn;

#	ifdef DEBUG_FUN
	fputs( "<+>lindst()\n", debug_fp );
#	endif

	if( LineSave.ipass > 0 )
	{
		/* not first pass, sum lines only */
		ASSERT( xInten >= 0.);
		LineSv[LineSave.nsum].sumlin += xInten*radius.dVeff;
		LineSv[LineSave.nsum].emslin = xInten;

		/* add line to outward beam */
		/* there are lots of lines that are sums of other lines, or
		 * just for info of some sort.  These have this flag false.
		 * Note that the EnergyRyd variable only has a rational
		 * value if PntForLine was called just before this - in all
		 * cases where this did not happen the flag is false. */
		if( lgOutToo )
		{

			/* >>chng 97 sep 02, add tmn */
			/*rfield.outlin[ipnt-1] += (float)(xInten/(rfield.anu[ipnt-1]*EN1RYD)*
			  radius.dVolOutwrd*opac.tmn[ipnt-1]);*/
			/* >>chng 00 jan 01, from tmn to ExpZone, since now this is thrown into
			 * outward beam AFTER attenuation of field across zone.  This attenuation
			 * is still needed */
			rfield.outlin[ipnt-1] += (float)(xInten/(rfield.anu[ipnt-1]*EN1RYD)*
			  radius.dVolOutwrd*opac.ExpZone[ipnt-1]);
			rfield.reflin[ipnt-1] += (float)(xInten/(rfield.anu[ipnt-1]*EN1RYD)*
			  radius.dVolReflec);
		}
	}
	else if( LineSave.ipass == 0 )
	{
		/* >>chng 01 apr 16, remove assert, don't understand why it was here */
		/* confirm that either the energy in rydbergs was previously set,
		 * or we don't care 
		ASSERT( lgEnergyRydSet || !lgOutToo );*/
		/* if energy was not previously set in call to PntForLine then use
		 * array index ipnt that was sent down here, for energy */
		/* >>chng 01 apr 16, if energy not previously set use array index */
		if( !lgEnergyRydSet )
			EnergyRyd = rfield.anu[ipnt-1];

		LineSv[LineSave.nsum].xLineEnergy = (float)EnergyRyd;
		/* first call to suff lines in array, confirm that label is one of
		 * the four correct ones */
		ASSERT( (chInfo == 'c') || (chInfo == 'h') || (chInfo != 'i') || (chInfo != 'r' ) );
		LineSv[LineSave.nsum].chSumTyp = (char)chInfo;
		/* number of lines ok, set parameters for first pass */
		LineSv[LineSave.nsum].sumlin = 0.;
		LineSv[LineSave.nsum].emslin = 0.;
		LineSv[LineSave.nsum].wavelength = wavelength;

		strcpy( LineSv[LineSave.nsum].chALab, chLab );
	}

	/* this is dust part */
	if( gv.lgDustOn )
	{
		if( LineSave.ipass > 0 )
		{
			/* main production pass, sum lines only
			 * evaluate 2nd exponential integral function
			 * >>chng 97 nov 05, some variables not defined above nflux */
			if( ipnt <= rfield.nflux )
			{
				/* >>chng 01 aug 23, replace e2 with stored vlue */
				/*e2fn = e2(opac.TauAbsGeo[0][ipnt-1],opac.ExpmTau[ipnt-1]);*/
				e2fn = opac.e2TauAbs[ipnt-1];
				/* DSTOTH was unit vol energy lost onto dust by cooling lines
				 * dstoth = dstoth + xInten * (1.-e2fn) */
				LineDSv[LineSave.ndsum].smdlin += (float)(xInten*radius.dVeff/
				  2.*(1. + opac.albedo[ipnt-1])*e2fn);
			}
		}
		else if( LineSave.ipass == 0 )
		{
			/* set parameters for first pass */
			LineDSv[LineSave.ndsum].smdlin = 0.;
			LineDSv[LineSave.ndsum].wavelength = wavelength;
			strcpy( LineDSv[LineSave.ndsum].chSMDLab, chLab );
		}
		/* there is also case where ipass is negative, in this one we just add counter
		 * since space for array has not been malloced yet */
		/* increment the counter to the number of lines */
		++LineSave.ndsum;
	}

	/* increment the line counter */
	++LineSave.nsum;

	/* say that energy is not set */
	lgEnergyRydSet = FALSE;
	EnergyRyd = 0.;

#	ifdef DEBUG_FUN
	fputs( " <->lindst()\n", debug_fp );
#	endif
	return;
}

/*PntForLine generate pointer for forbidden line */
void PntForLine(double wavelength, 
  char *chLabel,
  /* this is array index on the f, not c scale,
   * for the continuum cell holding the line */
  long int *ipnt)
{
	/* 
	 * maximum number of forbidden lines - this is a good bet since
	 * new lines do not go into this group, and lines are slowly 
	 * moving to level 1 
	 */
#	define	MAXFORLIN	1000
	static long int ipForLin[MAXFORLIN]={0};

	/* number of forbidden lines entered into continuum array */
	static long int nForLin;

#	ifdef DEBUG_FUN
	fputs( "<+>PntForLine()\n", debug_fp );
#	endif

	/* must be 0 or greater */
	ASSERT( wavelength >= 0. );

	if( wavelength == 0. )
	{
		/* zero is special flag to initialize */
		nForLin = 0;
		/* ipLineEnergy will only put in line label if nothing already there */
		EnergyRyd = 0.;
		/* say that energy is not set */
		lgEnergyRydSet = FALSE;
	}
	else
	{

		if( LineSave.ipass > 0 )
		{
			/* not first pass, sum lines only */
			*ipnt = ipForLin[nForLin];
		}
		else if( LineSave.ipass == 0 )
		{
			/* check if number of lines in arrays exceeded */
			if( nForLin >= MAXFORLIN )
			{
				fprintf( ioQQQ, "%5ld lines is too many for PntForLine.\n", 
				  nForLin );
				fprintf( ioQQQ, " Increase the value of maxForLine everywhere in the code.\n" );
				puts( "[Stop in pntforline]" );
				cdEXIT(EXIT_FAILURE);
			}

			/* ipLineEnergy will only put in line label if nothing already there */
			EnergyRyd = RYDLAM/wavelength;
			/* say that energy is not set */
			lgEnergyRydSet = TRUE;
			ipForLin[nForLin] = ipLineEnergy(EnergyRyd,chLabel , 0);
			*ipnt = ipForLin[nForLin];
		}
		else
		{
			/* this is case where we are only counting lines */
			*ipnt = 0;
		}
		++nForLin;
	}


#	ifdef DEBUG_FUN
	fputs( " <->PntForLine()\n", debug_fp );
#	endif
	return;
}

