/*lines main routine to put emission line intensities into line stack,
 * calls lineset1, 2, 3, 4 */
/*Drive_cdLine do the drive cdLine command */
#include "cddefines.h"
#include "taulines.h"
#include "linesave.h"
#include "ionfracs.h"
#include "cooling.h"
#include "cddrive.h"
#include "trace.h"
#include "heat.h"
#include "prtlinesum.h"
#include "rfield.h"
#include "phycon.h"
#include "hmi.h"
#include "extramax.h"
#include "holod.h"
#include "elementnames.h"
#include "iso.h"
#include "reccno.h"
#include "hydrogenic.h"
#include "linadd.h"
#include "lindst.h"
#include "linefit.h"
#include "lines.h"
#include "radius.h"
#include "putline.h"
static void Drive_cdLine( void );

void lines(void)
{
	char chLabel[5];
	static int lgRecOn;
	long int i, 
	  ipnt,
	  nelem;
	double BigstExtra, 
	  ExtraCool,  
	  f2, sum; 

#	ifdef DEBUG_FUN
	fputs( "<+>lines()\n", debug_fp );
#	endif

	/* major routines used here:
	 *
	 * PutLine( tarray )
	 * this uses information in tarray to give various
	 * contributions to lines, and their intensities
	 *
	 * PutExtra( extra )
	 * extra is some extra intensity to add to the line
	 * it will go into the totl contribution put out by PutLine,
	 * and this contriibution should be indicated by independent
	 * call to linadd
	 * */

	if( trace.lgTrace )
	{
		fprintf( ioQQQ, " lines called\n" );
	}

	/* the drive cdline command, which checks that all lines can be pulled out by cdLine */
	if( trace.lgDrv_cdLine  && LineSave.ipass > 0 )
		Drive_cdLine();

	heat.power += heat.htot*radius.dVeff;

	/* total compton heating - cooling */
	rfield.comtot += rfield.cmheat*radius.dVeff;
	hmi.hmitot += hmi.hmihet*radius.dVeff;
	cooling.totcol += cooling.ctot*radius.dVeff;
	cooling.GrossHeat += holod.feheat*radius.dVeff;

	/*remember largest fraction of heating due to H2 vib deexcitation */
	hmi.HeatH2DexcMax = MAX2((float)(hmi.HeatH2Dexc/heat.htot),hmi.HeatH2DexcMax);


	/* up up induced recom cooling */
	for( nelem=0; nelem<LIMELM; ++nelem )
	{
		hydro.cintot += iso.RecomInducCool_Rate[ipH_LIKE][nelem]*(float)radius.dVeff;
	}

	/* nsum is line pointer within large stack of line intensities */
	LineSave.nsum = 0;
	LineSave.ndsum = 0;
	LineSave.nComment = 0;

	/* last arg in call to lindst and linadd is info on line
	 * info is char variable indicating type of line this is
	 * 'c' cooling
	 * 'h' heating
	 * 'i' information only
	 * 'r' recombination line
	 *
	 * all components of lines are entered into the main line stack here
	 * when printing, filters exist to not print Inwd component */
	 
	/* initialize routine that can generate pointers for forbidden lines,
	 * these are lines that are not transferred otherwise,
	 * in following routines there will be pairs of calls, first to
	 * PntForLine to get pointer, then lindst to add to stack */
	PntForLine(0.,"FILL",&i);

	/* evaluate rec coef for rec lines of C, N, O
	 * some will be used in LineSet2 and then zeroed out,
	 * others left alone and used below */
	LineFit(phycon.te,RecCNO.RecCoefCNO);

	/* initialize ExtraInten with a zero */
	PutExtra(0.);

	/* put in something impossible in element 0 of line stack */
	linadd(0.f,0,"zero",'i');

	/* integrate the volume as a sanity check,
	 * this is compared with true volume in final.  The number can't
	 * actualy be unity since this would overflow on a 32 bit machine */
	linadd( 1.e-10 , 1 , "Unit" , 'i' );

	/* initial set of general properties */
	lines_general();

	/* do all continua */
	lines_continuum();

	/* now do all molecules */
	lines_molecules();

	/* information about grains */
	lines_grains();

	/* do all hydrogenic ions */
	lines_hydro();

	/* enter He-iso sequence lines */
	lines_helium();

	/* do heavies, lithium through neon */
	lines_lv1_li_ne();

	/* do heavies, sodium through argon */
	lines_lv1_na_ar();

	/* do heavies, potasium through zinc */
	lines_lv1_k_zn();

	/* add up line intensities for certain set of lines */
	sum = PrtLineSum( " SUM" );
	/* zero out the location that will receive this information, 
	 * remember that memory not allocated until ipass >= 0 */
	if( LineSave.ipass > 0 )
		LineSv[LineSave.nsum].sumlin = 0.;
	/* optional sum of certain emission lines, set with "print sum" */
	linadd(sum/radius.dVeff,0,"Stoy",'i' );

	/* next come some recombination lines */
	i = StuffComment( "recombination" );
	linadd( 0., (float)i , "####", 'i' );

	/***********************************************************************
	 * large number of C, N, and O recombination lines                     *
	 *************************************************************************/

	if( LineSave.ipass <= 0 )
	{
		/* initialize to TRUE, may be set false if density is very high below */
		lgRecOn = TRUE;
	}

	for( i=0; i < 471; i++ )
	{
		/* generate label for the line */
		strcpy( chLabel, elementnames.chElementSym[(long)(RecCNO.RecCoefCNO[0][i])-1] );
		strcat( chLabel, elementnames.chIonStage[(long)(RecCNO.RecCoefCNO[0][i]-
			RecCNO.RecCoefCNO[1][i]+1.01)-1] );

		/* number of rec per unit vol
		 * >>chng 97 aug 28, do not predict rec intensities at high densities
		 * blr.in and oldblr.in go nuts if this is added in outward beam */
		if( phycon.eden < 1e8 && lgRecOn )
		{
#			if 0
			f2 = RecCNO.RecCoefCNO[3][i]*phycon.eden*xIonFracs[(long)(RecCNO.RecCoefCNO[0][i]-
			  RecCNO.RecCoefCNO[1][i]+2)][(long)(RecCNO.RecCoefCNO[0][i])-1];
#			endif
			f2 = RecCNO.RecCoefCNO[3][i]*phycon.eden*
				xIonFracs[(long)(RecCNO.RecCoefCNO[0][i])-1][(long)(RecCNO.RecCoefCNO[0][i]-RecCNO.RecCoefCNO[1][i]+2)-1];

			/* convert to intensity */
			f2 = f2*1.99e-8/RecCNO.RecCoefCNO[2][i];
		}
		else
		{
			lgRecOn = FALSE;
			f2 = 0.;
		}
		/* finally stuff it into the stack */
		PntForLine(RecCNO.RecCoefCNO[2][i],chLabel,&ipnt);
		lindst(f2,RecCNO.RecCoefCNO[2][i],chLabel,ipnt, 'r',TRUE );
	}

	/* next come the level2 lines */
	i = StuffComment( "level2 lines" );
	linadd( 0., (float)i , "####", 'i' );

	/* add in all the other level 2 wind lines
	 * Dima'a 6k lines */
	ExtraCool = 0.;
	BigstExtra = 0.;
	for( i=0; i < nWindLine; i++ )
	{
		if( TauLine2[i].nelem != TauLine2[i].IonStg )
		{
			PutLine(&TauLine2[i]);
			if( TauLine2[i].cool > BigstExtra )
			{
				BigstExtra = TauLine2[i].cool;
				ExtraMax.ipMaxExtra = i+1;
			}
			ExtraCool += TauLine2[i].cool;
		}
	}
	ExtraMax.GBarMax = MAX2(ExtraMax.GBarMax,(float)(ExtraCool/cooling.ctot));

	/* next come the hyperfine structure lines */
	i = StuffComment( "hyperfine structure" );
	linadd( 0., (float)i , "####", 'i' );

	/*TODO these two should be removed when hyperfine set is complete */
	PutLine(&TauLines[ipH21cm]);
	PutLine(&TauLines[ipHe3cm]);

	for( i=0; i < nHFLines; i++ )
	{
		PutLine(&HFLines[i]);
	}

	if( trace.lgTrace )
	{
		fprintf( ioQQQ, " lines returns\n" );
	}

#	ifdef DEBUG_FUN
	fputs( " <->lines()\n", debug_fp );
#	endif
	return;
}

/*Drive_cdLine do the drive cdLine command */
static void Drive_cdLine( void )
{
	long int j;
	int lgMiss = FALSE;
	double absval , rel ;

#	ifdef DEBUG_FUN
	fputs( "<+>Drive_cdLine()\n", debug_fp );
#	endif

	for( j=1; j < LineSave.nsum; j++ )
	{
		if( cdLine( LineSv[j].chALab , LineSv[j].wavelength , &absval , &rel ) <= 0 )
		{
			/* print header if first miss */
			if( !lgMiss )
				fprintf(ioQQQ,"n\tlab\twl\n");
			++lgMiss;

			fprintf(ioQQQ,"%li\t%s\t%f\n", j, LineSv[j].chALab , LineSv[j].wavelength );
		}
	}
	fprintf( ioQQQ, " Thanks for checking on the cdLine routine!\n" );
	puts( "[Stop in Drive_cdLine]" );
	cdEXIT(EXIT_FAILURE);
}
