/*lines_general put general information and energetics into line intensity stack */
#include "cddefines.h"
#include "taulines.h"
#include "linesave.h"
#include "coolheavy.h"
#include "hydrogenic.h"
#include "cooling.h"
#include "abundances.h"
#include "totlum.h"
#include "heat.h"
#include "heatlmax.h"
#include "he1ex.h"
#include "phycon.h"
#include "ionfracs.h"
#include "sphere.h"
#include "dynamics.h"
#include "iso.h"
#include "rfield.h"
#include "trace.h"
#include "ionrec.h"
#include "ionrange.h"
#include "linadd.h"
#include "lindst.h"
#include "radius.h"
#include "getmaxhline.h"
#include "lines.h"

void lines_general(void)
{
	long int i, 
	  ipHi, 
	  ipLo, 
	  nelem, 
	  ipnt;

	double 
	  EmisFac ,/* used for hydrogenic emissivity or intensity */
	  hbetac, 
	  HeatMetal ,
	  ee511, 
	  hlalph;

#	ifdef DEBUG_FUN
	fputs( "<+>lines_general()\n", debug_fp );
#	endif

	if( trace.lgTrace )
	{
		fprintf( ioQQQ, "   lines_general called\n" );
	}

	/* start of general properties */
	i = StuffComment( "general properties" );
	linadd( 0., (float)i , "####", 'i');

	/* do we want intensity/luminosity or emissivity */
	if( hydro.lgHydEmiss )
	{
		/* option to print emissivity, not intensity */
		EmisFac = 1./phycon.eden;
	}
	else
	{
		EmisFac = xIonFracs[ipHYDROGEN][1];
	}
	/* total H-beta from multi-level atom */
	nelem = 0;
	ipHi = 4;
	ipLo = ipH2p;
	hbetac = 
		(EmisLines[ipH_LIKE][nelem][ipHi][ipH2s].Aul * 
		EmisLines[ipH_LIKE][nelem][ipHi][ipH2s].Pesc +
		EmisLines[ipH_LIKE][nelem][ipHi][ipH2p].Aul *
		EmisLines[ipH_LIKE][nelem][ipHi][ipH2p].Pesc ) *
		EmisLines[ipH_LIKE][nelem][ipHi][ipLo].PopHi*
		EmisLines[ipH_LIKE][nelem][ipHi][ipLo].EnergyErg*
		EmisFac ;
	/*fprintf(ioQQQ,"nzonehbeta\t%li\t%.3e\n", nzone, hbetac);*/
	/* total H-beta from multi-level atom */
	/*hbetac = EmisLines[ipH_LIKE][ipHYDROGEN][4][ipH2s].xIntensity + */
		/*EmisLines[ipH_LIKE][ipHYDROGEN][4][ipH2p].xIntensity;*/

	/* these lines added to outlin in metdif - following must be false 
	 * this passes array index for line energy in continuum mesh - in rest
	 * of code this is set by a previous call to PntForLine, this index
	 * is on the f not c scale */
	/*linadd(hbetac,4861,"TOTL",'i' );*/
	lindst(hbetac,4861,"TOTL",EmisLines[ipH_LIKE][nelem][ipHi][ipH2s].ipCont,'i',FALSE );

	/* total Ly-a from multi-level atom */
	ipHi = ipH2p;
	ipLo = ipH1s;
	hlalph = 
		EmisLines[ipH_LIKE][nelem][ipHi][ipLo].Aul* 
		EmisLines[ipH_LIKE][nelem][ipHi][ipLo].PopHi*
		EmisLines[ipH_LIKE][nelem][ipHi][ipLo].Pesc*
		EmisLines[ipH_LIKE][nelem][ipHi][ipLo].EnergyErg*
		EmisFac ;
	/*hlalph = EmisLines[ipH_LIKE][ipHYDROGEN][ipH2p][ipH1s].xIntensity;*/
	linadd(hlalph,1216,"TOTL",'i');

	totlum.totlsv = totlum.totlsv/(float)radius.dVeff*sphere.covgeo;

	/* H 21 cm, A from 
	 * >>refer	H1	A	Gould, ApJ 423, 522
	 * =2.88426e-15 s-1 */
	
	/* total luminosity in incident continuum */
	linadd(totlum.totlsv,0,"Inci",'i');
	totlum.totlsv = totlum.totlsv*(float)radius.dVeff/sphere.covgeo;

	/* ipass is flag to indicate whether to only set up line array
	 * (ipass=0) or actually evaluate lines intensities (ipass=1) */
	if( LineSave.ipass > 0 )
	{
		totlum.totlsv = 0.;
	}

	/* total heating, all forms, information since individuals added later */
	linadd(heat.htot,0,"TotH",'i');
	/* total cooling, all forms, information since individuals added later */
	linadd(cooling.ctot,0,"TotC",'i');

	/* hydrogen photoionization heating, ground state only */
	linadd(heat.heating[0][0],0,"BFH1",'h');

	/* net hydrogen photoionization heating less rec cooling, all excited states
	 * normally zero, positive if excited states are net heating */
	linadd(heat.heating[0][1],0,"BFHx",'h');
	if( heat.htot > 0. )
	{
		if( heat.heating[0][22]/heat.htot > heatlmax.HeatLineMax )
		{
			heatlmax.HeatLineMax = (float)(heat.heating[0][22]/heat.htot);
			GetMaxhLine();
		}
	}

	/* heating due to induced lines absorption of continuum */
	linadd(heat.heating[0][22],0,"Line",'h');

	/* net cooling due to collisional ionization of Heo */
	linadd(MAX2(0.,he1exCOM.he1ex*xIonFracs[ipHELIUM][1]),0,"He1i",'c');

	/* this is the heating due to 3-body recombination */
	linadd(MAX2(-he1exCOM.he1ex*xIonFracs[ipHELIUM][1],0.),0,"3He1",'h');

	/* total helium photoionization heating, all stages */
	linadd(heat.heating[1][0]+heat.heating[1][1]+heat.heating[1][2],
	  0,"BFHe",'h');

	HeatMetal = 0.;
	/* some sums that will be printed in the stack */
	for( nelem=2; nelem<LIMELM; ++nelem)
	{
		/* we now have final solution for this element */
		for( i=IonRange.IonLow[nelem]; i < IonRange.IonHigh[nelem]; i++ )
		{
			/* total metal photo heating for LINES */
			HeatMetal += heat.heating[nelem][i];
		}
	}
	/* total heavy element photoionization heating, all stages */
	linadd(HeatMetal,0,"TotM",'h');

	/* heating due to pair production */
	linadd(heat.heating[0][21],0,"pair",'h');

	/* ipass is flag to indicate whether to only set up line array
	 * (ipass=0) or actually evaluate lines intensities (ipass=1) */
	if( LineSave.ipass > 0 )
	{
		/* this will be max local heating due to bound compton */
		ionrec.CompHeating_Max = MAX2( ionrec.CompHeating_Max , ionrec.CompRecoilHeatLocal/heat.htot);
	}
	else
	{
		ionrec.CompHeating_Max = 0.;
	}

	/* heating due to bound compton scattering */
	linadd(ionrec.CompRecoilHeatLocal,0,"Cbnd",'h');

	/* Compton heating */
	linadd(rfield.cmheat,0,"ComH",'h');

	/* total Compton cooling */
	linadd(CoolHeavy.tccool,0,"ComC",'c');

	/* record max local heating due to advection */
	dynamics.HeatMax = MAX2( dynamics.HeatMax , MAX2(0.,-dynamics.CoolHeat) /heat.htot );
	/* record max local cooling due to advection */
	dynamics.CoolMax = MAX2( dynamics.CoolMax , MAX2(0.,dynamics.CoolHeat) /heat.htot );

	/* cooling due to advection */
	linadd(MAX2(0.,dynamics.CoolHeat)  , 0 , "advC" , 'c' );
	/* heating due to advection */
	linadd(MAX2(0.,-dynamics.CoolHeat) , 0 , "advH" , 'c' );

	/* heating/cooling due to charge transfer */
	linadd(MAX2(0.,heat.heating[0][24]),0,"CT H",'h');
	linadd(MAX2(0.,-heat.heating[0][24]),0,"CT C",'c');

	/* "extra" heat added to this zone, from HEXTRA command */
	linadd(heat.heating[0][20],0,"extH",'h');

	/* "extra" cooling added to this zone, from CEXTRA command */
	linadd(CoolHeavy.cextxx,0,"extC",'c');

	/* 511keV annihilation line */
	ee511 = (phycon.hden + 4.*abundances.gas_phase[ipHELIUM])*ionrec.PairProducPhotoRate[0]*2.*8.20e-7;
	PntForLine(2.427e-2,"e-e+",&ipnt);
	lindst(ee511,511,"e-e+",ipnt,'i',TRUE );

	/* expansion cooling, only non-zero for wind */
	linadd(CoolHeavy.expans,0,"Expn",'c');

	/* H radiative recombination cooling */
	linadd(iso.RadRecCool[ipH_LIKE][0],0,"H FB",'i');

	/* net free-bound cooling and heating */
	linadd(MAX2(0.,iso.FreeBnd_net_Cool_Rate[ipH_LIKE][0]),0,"HFBc",'c');
	linadd(MAX2(0.,-iso.FreeBnd_net_Cool_Rate[ipH_LIKE][0]),0,"HFBh",'h');

	/* cooling due to induced rec of hydrogen */
	linadd(iso.RecomInducCool_Rate[ipH_LIKE][0],0,"Hind",'c');

	/* cooling due to induced rec of fully ionized helium */
	linadd(CoolHeavy.c3ind,0,"3He2",'c');

	/* cyclotron cooling */
	linadd(CoolHeavy.cyntrn,0,"Cycn",'c');

#	ifdef DEBUG_FUN
	fputs( " <->lines_general()\n", debug_fp );
#	endif
	return;
}

