/*lines_helium put energetics, H, and He lines into line intensity stack */
#include "cddefines.h"
#include "taulines.h"
#include "nhe1lvl.h"
#include "coolheavy.h"
#include "abundances.h"
#include "heots.h"
#include "phycon.h"
#include "ionfracs.h"
#include "phe1lv.h"
#include "iso.h"
#include "heinwd.h"
#include "he3c.h"
#include "he3tau.h"
#include "he3lines.h"
#include "linesave.h"
#include "sphere.h"
#include "cionhe.h"
#include "rfield.h"
#include "trace.h"
#include "ip626.h"
#include "iphe1l.h"
#include "linadd.h"
#include "lindst.h"
#include "putline.h"
#include "lines.h"

void lines_helium(void)
{
	long int i, 
	  ipHi, 
	  ipLo, 
	  ipnt,
	  nelem;
	char chLabel[5];
	double 
	  cb206, 
	  cb5016, 
	  col, 
	  e228, 
	  e504, 
	  e584, 
	  e626, 
	  e911, 
	  eff, 
	  em, 
	  f10830, 
	  pop, 
	  rec, 
	  sum,
	  totl;

#	ifdef DEBUG_FUN
	fputs( "<+>lines_helium()\n", debug_fp );
#	endif

	/* HeI */
	i = StuffComment( "He-like iso-sequence" );
	linadd( 0., (float)i , "####", 'i');

	/* He I triplet net collisional ionization cooling */
	linadd(MAX2(0.,cionhe.He3IonCool),0,"He3I",'c');

	/* He I triplet net 3-body heating */
	linadd(MAX2(0.,-cionhe.He3IonCool),0,"He3b",'h');

	/* He I 584, collisional excitation cooling */
	linadd(MAX2(0.,CoolHeavy.c584),584,"HeIC",'c');

	/* He I 584, collisional de-excitation heating */
	linadd(MAX2(0.,-CoolHeavy.c584),584,"HeIH",'h');

	/* total 584 emergent from cloud in inner direction
	 * now compute emergent Helium emergent flux */
	if( sphere.lgSphere )
	{
		e911 = 0.;
		e584 = 0.;
		e626 = 0.;
		e228 = 0.;
		e504 = 0.;
	}
	else
	{
		if( strncmp( rfield.chDffTrns , "OU" , 2) == 0 )
		{
			eff = 0.5;
		}
		else
		{
			eff = 1.;
		}

		e504 = heots.esc504/2.*3.95e-11*eff;

		/* this is inward looking tau but no fac of two in original defn */
		e584 = heots.esc584/2.*3.41e-11/2.;

		/* this looked to illuminated face and does not need extra factor */
		e626 = heots.esc626*3.18e-11;
		e911 = heots.esc911*2.18e-11*eff;
		e228 = heots.esc228*8.72e-11*eff;
	}

	/* He I rec to ground escaping cloud */
	linadd(e504,504,"He I",'i');

	/* He I Ly alpha escaping cloud
	 * call linadd( e584 , 584, 'esc ' ,'i')
	 * these lines added to outlin in metdif - following must be false */
	lindst(e584,584,"esc ",iphe1lCom.iphe1l[0][1],'i',FALSE );

	/* He I 2^3S-ground emission escaping lluminated face of cloud
	 * call linadd( e626 , 626 , 'esc ' ,'i')
	 * these lines added to outlin in metdif - following must be false */
	lindst(e626,626,"esc ",ip626.ipHe23sGrnd,'i',FALSE );

	/* He I 4471, */
	if( phycon.te <= 1e4 )
	{
		em = 2.42e-22/(phycon.te/phycon.te10);
	}
	else
	{
		em = 8.79e-22/phycon.te/phycon.te03/phycon.te01;
	}

	/* >>chng 97 jan 04, label was HeI, changed to Ca B for symmetry with others
	 * He I 4471 recombination only, fit to Brocklehurst '72 */
	rec = phycon.eden*xIonFracs[ipHELIUM][1]*em;
	PntForLine(4471.,"He 1",&ipnt);
	lindst(rec,4471,"Ca B",ipnt,'i',TRUE );

	/* He I total 5876, from n-level atom
	 * these lines added to outlin in metdif - following must be false */
	lindst(he3lines.p5876,5876,"TOTL",he3lines.ipHe3l[1],'i',FALSE );

	/* inward part of 5876 */
	linadd(he3lines.p5876*he3tau[IPT5876-1].FracInwd,
	  5876,"Inwd",'i');

	/* He I 5876 REC, simple fit to Brocklehurst */
	linadd(phycon.eden*xIonFracs[ipHELIUM][1]*4.22e-21/(phycon.te*phycon.te10),
	  5876,"Ca B",'r');

	/* He I 6678 REC, simple fit to Brocklehurst */
	rec = phycon.eden*xIonFracs[ipHELIUM][1]*1.32e-21/(phycon.te*phycon.te10*phycon.te01);
	PntForLine(6678.,"He 1",&ipnt);
	lindst(rec,6678,"Ca B",ipnt,'i',TRUE );

	/* 10830 from n-level atom
	 * these lines added to outlin in metdif - following must be false */
	lindst(he3lines.p10830,10830,"TOTL",he3lines.ipHe3l[0],'i',FALSE );

	f10830 = 1.02e7*he3tau[IPT10830-1].Pesc/(1.02e7*
	  he3tau[IPT10830-1].Pesc + 2.51e-9*phycon.sqrte*
	  phycon.eden);

	/* He I 10830 produced by radiative recombination */
	rec = xIonFracs[ipHELIUM][1]*phycon.eden*5.13e-22/(phycon.te70*phycon.te10*
	  phycon.te01*phycon.te01)*f10830;
	linadd(rec,10830,"reco",'i');

	/* following expression from Clegg 1987 */
	pop = xIonFracs[ipHELIUM][1]*5.79e-6*(pow(phycon.te/1e4,-1.18))/(1. + 3110./phycon.eden*
	  (pow(phycon.te/1e4,-0.51)));

	col = pop*he3c.c2s2p*1.84e-12*f10830;

	/* collisionally excited 10830 estimated from Clegg 1987 (not model atom) */
	linadd(col,10830,"coll",'i');

	/* inward escaping HeI 10830 */
	linadd(heinwd.he10in,10830,"Inwd",'i');

	/* He I 3889 from n-level atom
	 * these lines added to outlin in metdif - following must be false */
	lindst(he3lines.p3889,3889,"TOTL",he3lines.ipHe3l[3],'i',FALSE );

	/* He I 7065 from n-level atom
	 * these lines added to outlin in metdif - following must be false */
	lindst(he3lines.p7065,7065,"TOTL",he3lines.ipHe3l[2],'i',FALSE );

	/* total collisional He I triplet line cooling, from n-level atom */
	linadd(MAX2(0.,he3lines.he3clx),0,"CcHE",'c');

	/* total collisional de-exec He I heating, from n-level atom */
	linadd(MAX2(0.,-he3lines.he3clx),0,"ChHE",'h');

	em = phycon.eden*xIonFracs[ipHELIUM][1];
	cb206 = 1.064e-22/phycon.te70/phycon.te10/phycon.te03/phycon.te03*
	  em;

	/* case B He I 2.06 micron - new or old wavelength scaling?  */
	linadd(cb206,20600.,"Ca B",'i');

	/* He I 2.06 micron from model atom, all physics in */
	totl = xIonFracs[ipHELIUM][1]*phe1lv.he12p*t206.Aul*t206.Pesc*
	  9.66e-13;
	PntForLine(20600.,"He 1",&ipnt);
	lindst(totl,20600,"TOTL",ipnt,'i',TRUE );

	/* Case B He I 5016 */
	cb5016 = 5.43e-23/phycon.te70/phycon.te10*em;
	PntForLine(5016.,"He 1",&ipnt);
	lindst(cb5016,5016,"Ca B",ipnt,'i',TRUE );

	/* He II Lyman continuum */
	linadd(e228,228,"HeII",'i');

	/* He II Balmer continuum escaping from cloud */
	linadd(e911,911,"He2C",'i');

	/* this is the main printout, where line intensities are entered into the stack */
	for( nelem=1; nelem < LIMELM; nelem++ )
	{
		if( abundances.lgElmtOn[nelem] )
		{
			/* do not print more than first 50 levels */
			/* NB NB - low and high must be in this order so that all balmer, paschen,
			 * etc series line up correctly in final printout */
			/* >>chng 01 jun 13, bring 23P lines back together */
			/* two photon is special, not a line and no ipCont array index, add here */

			EmisLines[ipHE_LIKE][nelem][ipHe2s1S][ipHe1s1S].xIntensity = 
				(double)EmisLines[ipHE_LIKE][nelem][ipHe2s1S][ipHe1s1S].Aul*
				(double)EmisLines[ipHE_LIKE][nelem][ipHe2s1S][ipHe1s1S].PopHi*
				(double)EmisLines[ipHE_LIKE][nelem][ipHe2s1S][ipHe1s1S].Pesc*
				(double)xIonFracs[nelem][nelem]*
				(double)EmisLines[ipHE_LIKE][nelem][ipHe2s1S][ipHe1s1S].EnergyErg;
			if( LineSave.ipass == 0 )
			{
				/* chIonLbl is function that generates a null terminated 4 char string, of form "C  2" 
				 * the result, chLable, is only used when ipass == 0, can be undefined otherwise */
				chIonLbl(chLabel, &EmisLines[ipHE_LIKE][nelem][ipHe2s1S][ipHe1s1S]);
			}
			linadd( EmisLines[ipHE_LIKE][nelem][ipHe2s1S][ipHe1s1S].xIntensity , 0,chLabel,'r');

			/* now do real permitted lines */
			for( ipLo=0; ipLo < ipHe2p3P0; ipLo++ )
			{
				for( ipHi=ipLo+1; ipHi < iso.numPrintLevels[ipHE_LIKE][nelem]; ipHi++ )
				{
					/* >>chng 01 may 30, do not add fake he-like lines (majority) to line stack */
					/* >>chng 01 dec 11, use variable for smallest A */
					if( EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].ipCont < 1 ) 
						continue;

					if( ipLo==ipHe2s3S && ipHi == ipHe2p3P0 )
					{
						/* here we will create an entry for the three lines 
						 * coming from 2 3P to 2 3S - the entry called TOTL will
						 * appear before the lines of the multiplet 
						 * for He I this is 10830 */

						sum = 0.;
						for( i=ipHe2p3P0; i <= ipHe2p3P2; i++ )
						{
							sum += 
								(double)EmisLines[ipHE_LIKE][nelem][i][ipLo].Aul*
								(double)EmisLines[ipHE_LIKE][nelem][i][ipLo].PopHi*
								(double)EmisLines[ipHE_LIKE][nelem][i][ipLo].Pesc*
								(double)xIonFracs[nelem][nelem]*
								(double)EmisLines[ipHE_LIKE][nelem][i][ipLo].EnergyErg;
						}

						/* add to line stack */
						linadd(sum,EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].WLAng,"TOTL",'i' );
					}

					/* find number of photons escaping cloud */
					EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].phots = 
						EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].Aul*
						EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].PopHi*
						EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].Pesc*
						xIonFracs[nelem][nelem];

					/* now find line intensity */
					/* >>chng 01 jan 15, put cast double to force double evaluation */
					EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].xIntensity = 
						(double)EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].Aul*
						(double)EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].PopHi*
						(double)EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].Pesc*
						(double)xIonFracs[nelem][nelem]*
						(double)EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].EnergyErg;
					/* this will enter .xIntensity into the line stack
					fprintf(ioQQQ,"1 loop %li %li %.1f\n", ipLo,ipHi, 
						EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].WLAng ); */
					PutLine(&EmisLines[ipHE_LIKE][nelem][ipHi][ipLo]);
					{
						/* option to print particulars of some line when called
						 * a prettier print statement is near where chSpin is defined below*/
						/*@-redef@*/
						enum {DEBUG=FALSE};
						/*@+redef@*/
						if( DEBUG )
						{
							if( nelem==1 && ipLo==0 && ipHi==1 )
							{
								fprintf(ioQQQ,"he1 626 %.2e %.2e \n", 
									EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].TauIn,
									EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].TauTot
									);
							}
						}
					}
				}
			}

			/* this sum will bring together the three lines going to J levels within 23P */
			for( ipHi=ipHe2p3P2+1; ipHi < iso.numPrintLevels[ipHE_LIKE][nelem]; ipHi++ )
			{
				double sumcool , sumheat ,
					save , savecool , saveheat;

				sum = 0;
				sumcool = 0.;
				sumheat = 0.;
				for( ipLo=ipHe2p3P0; ipLo <= ipHe2p3P2; ++ipLo )
				{
					/* find number of photons escaping cloud */
					EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].phots = 
						EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].Aul*
						EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].PopHi*
						EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].Pesc*
						xIonFracs[nelem][nelem];

					/* now find line intensity */
					/* >>chng 01 jan 15, put cast double to force double evaluation */
					EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].xIntensity = 
						(double)EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].Aul*
						(double)EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].PopHi*
						(double)EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].Pesc*
						(double)xIonFracs[nelem][nelem]*
						(double)EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].EnergyErg;

					sumcool += EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].cool;
					sumheat += EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].heat;
					sum += EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].xIntensity;
				}

				/* >>chng 01 dec 11, use variable for smallest A */
				/* >>chng 02 feb 10, replaced check on A with ipCont */
				if( EmisLines[ipHE_LIKE][nelem][ipHi][ipHe2p3P2].ipCont < 1 ) 
					continue;
				/* this will enter .xIntensity into the line stack */
				save = EmisLines[ipHE_LIKE][nelem][ipHi][ipHe2p3P2].xIntensity;
				savecool = EmisLines[ipHE_LIKE][nelem][ipHi][ipHe2p3P2].cool;
				saveheat = EmisLines[ipHE_LIKE][nelem][ipHi][ipHe2p3P2].heat;

				EmisLines[ipHE_LIKE][nelem][ipHi][ipHe2p3P2].xIntensity = sum;
				EmisLines[ipHE_LIKE][nelem][ipHi][ipHe2p3P2].cool = sumcool;
				EmisLines[ipHE_LIKE][nelem][ipHi][ipHe2p3P2].heat = sumheat;

				/*fprintf(ioQQQ,"2 loop %li %li %.1f\n", ipHe2p3P2,ipHi, 
					EmisLines[ipHE_LIKE][nelem][ipHi][ipHe2p3P2].WLAng );*/
				PutLine(&EmisLines[ipHE_LIKE][nelem][ipHi][ipHe2p3P2]);

				EmisLines[ipHE_LIKE][nelem][ipHi][ipHe2p3P2].xIntensity = save;
				EmisLines[ipHE_LIKE][nelem][ipHi][ipHe2p3P2].cool = savecool;
				EmisLines[ipHE_LIKE][nelem][ipHi][ipHe2p3P2].heat = saveheat;
			}
			for( ipLo=ipHe2p3P2+1; ipLo < iso.numPrintLevels[ipHE_LIKE][nelem]-1; ipLo++ )
			{
				for( ipHi=ipLo+1; ipHi < iso.numPrintLevels[ipHE_LIKE][nelem]; ipHi++ )
				{
					/* >>chng 01 may 30, do not add fake he-like lines (majority) to line stack */
					/* >>chng 01 dec 11, use variable for smallest A */
					/* >>chng 02 feb 12, use ipCont to find bogus lines */
					/*if( EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].Aul <= helike.SmallA )*/
					if( EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].ipCont < 1 ) 
						continue;

					/* find number of photons escaping cloud */
					EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].phots = 
						EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].Aul*
						EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].PopHi*
						EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].Pesc*
						xIonFracs[nelem][nelem];

					/* now find line intensity */
					/* >>chng 01 jan 15, put cast double to force double evaluation */
					EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].xIntensity = 
						(double)EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].Aul*
						(double)EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].PopHi*
						(double)EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].Pesc*
						(double)xIonFracs[nelem][nelem]*
						(double)EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].EnergyErg;
					/* this will enter .xIntensity into the line stack 
					fprintf(ioQQQ,"2 loop %li %li %.1f\n", ipLo,ipHi, 
						EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].WLAng );*/
					PutLine(&EmisLines[ipHE_LIKE][nelem][ipHi][ipLo]);
				}
			}
		}
	}

	/* ====================================================
	 * end helium
	 * ====================================================*/

	if( trace.lgTrace )
	{
		fprintf( ioQQQ, "   lines_helium returns\n" );
	}

#	ifdef DEBUG_FUN
	fputs( " <->lines_helium()\n", debug_fp );
#	endif
	return;
}
