/*ParseDont parse the dont command - do not do something */
#include "cddefines.h"
#include "taulines.h"
#include "opacity.h"
#include "physok.h"
#include "printit.h"
#include "secondaries.h"
#include "pressure.h"
#include "recom.h"
#include "phycon.h"
#include "freeon.h"
#include "rfield.h"
#include "nomole.h"
#include "rt.h"
#include "strkon.h"
#include "pop371.h"
#include "yield.h"
#include "ionrec.h"
#include "chargtran.h"
#include "grainvar.h"
#include "parse.h"

void ParseDont(char *chCard )
{
	long int nelem, 
	  nshell, 
	  nstage;

#	ifdef DEBUG_FUN
	fputs( "<+>ParseDont()\n", debug_fp );
#	endif

	if( lgMatch("AUGE",chCard) )
	{
		/*  turn off auger effect by killing its block data */
		physok.lgPhysOK = FALSE;
		for( nelem=0; nelem < LIMELM; nelem++ )
		{
			for( nstage=0; nstage < nelem; nstage++ )
			{
				for( nshell=0; nshell < 7; nshell++ )
				{
					/* only one electron comes out */
					yield.nyield[nelem][nstage][nshell] = 1;
					yield.vyield[nelem][nstage][nshell][0] = 1.;
				}
			}
		}
	}

	else if( lgMatch("BUFF",chCard) )
	{
		/* NO BUFFERING turn off buffered io for standard output, 
		 * used to get output when code crashes */
		setbuf( ioQQQ , NULL );
	}


	else if( lgMatch("CHAR",chCard) )
	{
		/* turn off charge transfer */
		ChargTran.HCTOn = 0.;
		physok.lgPhysOK = FALSE;
	}
	else if( lgMatch("CTHE",chCard) )
	{
		/* turn off charge transfer heating */
		ChargTran.HCharHeatOn = 0.;
		physok.lgPhysOK = FALSE;
	}

	else if( lgMatch("COMP",chCard) )
	{
		/* turn off both recoil ionization and compton heating of free electron */
		rfield.comoff = 0.;
		physok.lgPhysOK = FALSE;
	}

	else if( lgMatch("FEII",chCard) )
	{
		/* turn off feii ly-alpha pumping */
		FeII.lgLyaPumpOn = FALSE;
		physok.lgPhysOK = FALSE;
	}

	else if( lgMatch("FILE",chCard) && lgMatch("OPAC",chCard) )
	{
		/* no file opacities, generate them on the fly even if file present */
		opac.lgUseFileOpac = FALSE;
	}

	else if( lgMatch("DIFF",chCard) && lgMatch("LINE",chCard) && lgMatch("PUMP",chCard) )
	{
		/* no diffuse line pumping, 
		 * turn off pumping of lines by diffuse continuum*/
		rfield.DiffPumpOn = 0.;
	}

	else if( lgMatch("FINE",chCard) )
	{
		/* turn off fine structure optical depths */
		rt.lgFstOn = FALSE;
		physok.lgPhysOK = FALSE;
	}

	else if( lgMatch("FREE",chCard) )
	{
		/* turn off free free heating and cooling */
		freeon.lgFreeOn = FALSE;
		physok.lgPhysOK = FALSE;
	}

	else if( lgMatch("GRAI",chCard) )
	{
		if( lgMatch("NEUT",chCard) )
		{
			/* turn off ion grain recombination "NO GRAIN NEUTRALIZATION" */
			recom.grecon = 0.;
			physok.lgPhysOK = FALSE;
		}
		else if( lgMatch("QHEA",chCard) )
		{
			/* turn off quantum heating of grains "NO GRAIN QHEAT" */
			gv.lgQHeatOn = FALSE;
			physok.lgPhysOK = FALSE;
		}
		else
		{
			fprintf( ioQQQ, " No key recognized on this line.\n" );
			puts( "[Stop in ParseDont]" );
			cdEXIT(EXIT_FAILURE);
		}
	}

	/* no induced processes */
	else if( lgMatch("INDU",chCard) )
	{
		/* turn off induced recombination, stimulated emission,
		 * continuum fluorescent excitation of lines, 
		 * stimulated emission correction to optical depths attenuation */
		rfield.lgInducProcess = FALSE;
	}

	else if( lgMatch("LEVE",chCard) )
	{
		/* turn off the set of level 2 lines, safe for lower densities 
		 * this is the upper limit to the counter that is always used,
		 * so no loops will ever occur */
		nWindLine = -1;
	}

	else if( lgMatch("MOLE",chCard) )
	{
		/* disable molecule formation, first option is to turn off only H2 part */
		if( lgMatch(" H2 ",chCard) )
		{
			/* turn off only H2 */
			nomole.lgNoH2Mole = TRUE;
		}
		else
		{
			/* turn off both CO and H2 networks */
			nomole.lgNoH2Mole = TRUE;
			nomole.lgNoCOMole = TRUE;
		}
		physok.lgPhysOK = FALSE;
	}

	else if( lgMatch("PHOT",chCard) )
	{
		/* disable photoionization */
		ionrec.lgPhotoIoniz_On = FALSE;
		physok.lgPhysOK = FALSE;
	}

	else if( lgMatch("RADI",chCard) )
	{
		/* don't include line radiation pressure */
		pressure.lgRadPrsON = FALSE;
	}

	else if( lgMatch("RECO",chCard) )
	{
		/* disable compton recoil of bound electrons - "no recoil ioniz" */
		ionrec.lgCompRecoil = FALSE;
		physok.lgPhysOK = FALSE;
	}

	else if( lgMatch("SCAT",chCard) && lgMatch("OPAC",chCard))
	{
		/* no scattering opacity, for Compton thick spherical geometry */
		opac.lgScatON = FALSE;
	}

	else if( lgMatch("SCAT",chCard) && lgMatch("ESCA",chCard))
	{
		/* no electron scattering contribution to line escape probs */
		rt.lgElecScatEscape = FALSE;
	}

	else if( lgMatch("SECO",chCard) )
	{
		/* turn off secondary electron ionizations */
		Secondaries.lgSecOFF = TRUE;
		physok.lgPhysOK = FALSE;
	}

	else if( lgMatch("SPOT",chCard) )
	{
		/* no on-the-spot; turn on all ground state rec */
		opac.otsmin = 1.;
	}

	else if( lgMatch("STAR",chCard) )
	{
		/* no stark broadening */
		strkon.lgStarkON = FALSE;
		physok.lgPhysOK = FALSE;
	}

	else if( lgMatch("STAT",chCard) )
	{
		/* no static opacities - constantly reevaluate them */
		opac.lgOpacStatic = FALSE;
	}

	else if( lgMatch("TEPR",chCard) )
	{
		/* turn off prediction of next zone's temperature, as guessed in StartZone */
		phycon.lgPredNextTe = FALSE;
	}

	else if( lgMatch("THRE",chCard) )
	{
		/* turn off Cota's three body rec subroutine */
		recom.lgNoCota = TRUE;
		physok.lgPhysOK = FALSE;
	}

	else if( lgMatch("TIME",chCard) )
	{
		/* don't print anything with a time, so that we can expect
		 * perfect agreement between separate runs */
		printit.lgPrintTime = FALSE;
	}

	/* the no vary command is parsed well before we get to this point,
	 * but we have to do something here or the parser will say that
	 * no command existed on the command line */
	else if( strncmp(chCard , "NO VARY" , 7 ) == 0 )
	{
		/* this is a no-nothing, picked up to stop optimizer */
		nshell = 0;
	}

	else
	{
		/* end of else if trap */
		fprintf( ioQQQ, " I dont understand what not to do.  STOP\n" );
		puts( "[Stop in ParseDont]" );
		cdEXIT(EXIT_FAILURE);
	}

	/* this option, if keyword (OK) appears, then do not set warning */
	if( lgMatch("(OK)",chCard) )
	{
		/* say that physical conditions are actually ok */
		physok.lgPhysOK = TRUE;
	}

#	ifdef DEBUG_FUN
	fputs( " <->ParseDont()\n", debug_fp );
#	endif
	return;
}
