/*ParseElement parse options on element command */
#include "cddefines.h"
#include "varypar.h"
#include "abundances.h"
#include "input.h"
#include "iso.h"
#include "elementnames.h"
#include "readar.h"
#include "parse.h"

void ParseElement(char *chCard )
{
	/* this will be used to remember how many levels are active in any element we turn off,
	 * so that we can retain state if turned back on  */
	static int lgFirst = TRUE;
	static long levels[NISO][LIMELM];
	char chCap[INPUT_LINE_LENGTH];
	int lgEOL, 
	  lgEnd, 
	  lgHIT;

	int lgForceLog=FALSE, lgForceLinear=FALSE;

	long int i, 
	  iel, 
	  j, 
	  k;
	double param;

#	ifdef DEBUG_FUN
	fputs( "<+>ParseElement()\n", debug_fp );
#	endif

	/* zero out this array if first call */
	if( lgFirst )
	{
		lgFirst = FALSE;
		for( i=0; i<NISO; ++i )
		{
			for( iel=0; iel<LIMELM; ++iel )
			{
				levels[i][iel] = 0;
			}
		}
	}
	/* say that abundances have been changed */
	abundances.lgAbnSolar = FALSE;

	/* read in list of elements for abundances command */
	if( lgMatch("READ",chCard) )
	{
		abundances.npSolar = 0;
		for( i=1; i < LIMELM; i++ )
		{
			readar(chCard,&lgEnd);

			if( lgEnd )
			{
				fprintf( ioQQQ, " Hit EOF while reading element list; use END to end list.\n" );
				puts( "[Stop in ParseElement]" );
				cdEXIT(EXIT_FAILURE);
			}

			strcpy( chCap, chCard );
			caps(chCap);

			/* this would be a line starting with END to say end on list */
			if( strncmp(chCap,"END",3) == 0 )
			{
				
#				ifdef DEBUG_FUN
				fputs( " <->ParseElement()\n", debug_fp );
#				endif
				return;
			}

			j = 1;
			lgHIT = FALSE;
			while( j < LIMELM && !lgHIT )
			{
				j += 1;

				if( strncmp( chCap,elementnames.chElementNameShort[j-1] , 4) == 0 )
				{
					abundances.npSolar += 1;
					abundances.ipSolar[abundances.npSolar-1] = j;
					lgHIT = TRUE;
				}
			}

			if( !lgHIT )
			{
				fprintf( ioQQQ, "%80.80s\n", chCard );
				fprintf( ioQQQ, " Sorry, but I did not recognize element name on this line.\n" );
				fprintf( ioQQQ, " Here is the list of names I recognize.\n" );
				fprintf( ioQQQ, " " );

				for( k=2; k <= LIMELM; k++ )
				{
					fprintf( ioQQQ, "%4.4s\n", elementnames.chElementNameShort[k-1] );
				}

				puts( "[Stop in ParseElement]" );
				cdEXIT(EXIT_FAILURE);
			}
		}

		/* fell through, make sure one more line, the end line */
		readar(chCard,&lgEnd);
		strcpy( chCap, chCard );
		caps(chCap);

		if( strncmp(chCap,"END",3) == 0 )
		{
			
#			ifdef DEBUG_FUN
			fputs( " <->ParseElement()\n", debug_fp );
#			endif
			return;
		}

		else
		{
			fprintf( ioQQQ, " Too many elements were entered.\n" );
			fprintf( ioQQQ, " I only know about%3ld elements.\n", 
			  LIMELM );
			fprintf( ioQQQ, " Sorry.\n" );
			puts( "[Stop in ParseElement]" );
			cdEXIT(EXIT_FAILURE);
		}
	}

	/* find which element */
	i = 0;

	/* will be used in remainder of routine to point to particular element */
	iel = GetElem(chCard );

	if( iel < 0 )
	{
		fprintf( ioQQQ, 
			" ParseElement did not find an element on the following line:\n" );
		fprintf( ioQQQ, 
			"%80.80s\n", chCard );
		puts( "[Stop in ParseElement]" );
		cdEXIT(EXIT_FAILURE);
	}
	/* iel is now the atomic number of the element, and must be correct */
	ASSERT( iel>=0 && iel < LIMELM );

	/* look for log or linear keywords */
	/* >>chng 01 jul 23, add this option to force linear (log had been tehre) */
	if( lgMatch(" LOG",chCard) )
	{
		lgForceLog = TRUE;
	}
	else if( lgMatch("LINE",chCard) )
	{
		lgForceLinear = TRUE;
	}

	i = 4;
	param = FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);

	if( lgMatch("SCAL",chCard) )
	{
		/* enter abundance as scale factor, relative to what is in now */
		if( lgEOL )
		{
			fprintf( ioQQQ, " There must be a number on this line.\n" );
			fprintf( ioQQQ, " Sorry.\n" );
			puts( "[Stop in ParseElement]" );
			cdEXIT(EXIT_FAILURE);
		}

		else
		{
			/* interpret as log unless forced linear */
			if( (lgForceLog || param <= 0.) && !lgForceLinear )
			{
				/* option for log of scale factor */
				param = pow(10.,param);
			}
			abundances.ScaleElement[iel] = (float)param;
		}
	}

	else if( lgMatch("ABUN",chCard) )
	{
		/* log of actual abundance */
		if( lgEOL )
		{
			fprintf( ioQQQ, " There must be a number on this line.\n" );
			fprintf( ioQQQ, " Sorry.\n" );
			puts( "[Stop in ParseElement]" );
			cdEXIT(EXIT_FAILURE);
		}

		else
		{
			if( lgForceLinear )
			{
				abundances.solar[iel] = (float)param;
			}
			else
			{
				abundances.solar[iel] = (float)pow(10.,param);
			}

			if( abundances.solar[iel]> 1. )
			{
				fprintf( ioQQQ, 
					" Please check the abundance of this element.  It seems high to me.\n" );
			}
		}
	}

	else if( lgMatch(" OFF",chCard) )
	{
		/* option to turn off this element, set abundance to zero */
		abundances.lgElmtOn[iel] = FALSE;
		/* set no levels for all elements that are turned off, except for helium itself, which always exists */
		if( iel > ipHELIUM )
		{
			levels[ipHYDROGEN][iel] = iso.numLevels[ipH_LIKE][iel];
			levels[ipHELIUM][iel] = iso.numLevels[ipHE_LIKE][iel];
			iso.numLevels[ipH_LIKE][iel] = 0;
			iso.numLevels[ipHE_LIKE][iel] = 0;
		}

		if( iel == 0 )
		{
			fprintf( ioQQQ, " It is not possible to turn hydrogen off.\n" );
			fprintf( ioQQQ, " Sorry.\n" );
			puts( "[Stop in ParseElement]" );
			cdEXIT(EXIT_FAILURE);
		}
	}

	/* >>chng 01 may 08, add ionization option option */
	else if( lgMatch("IONI",chCard) )
	{
		int lgLogSet = FALSE;
		int ion;

		i = 4;
		/* option to specify ionization distribution for this element */
		abundances.lgSetIoniz[iel] = TRUE;
		ion = 0;
		while( ion<iel+2 )
		{
			/* the ionization fractsions that are set when above set true,
			 * gas phase abundance is this times total aabundance
			 * Ionization fraction for [nelem][ion] */
			abundances.SetIoniz[iel][ion] = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);

			if( lgEOL ) 
				break;

			/* log is any negative */
			if( abundances.SetIoniz[iel][ion] < 0. )
				lgLogSet = TRUE;
			++ion;
		}

		/* zero out ones not specified */
		for( i=ion; i<iel+2; ++i )
		{
			abundances.SetIoniz[iel][i] = 0. ;
		}
		/* convert rest to linear if any were negative */
		if( lgLogSet )
		{
			for( i=0; i<ion; ++i )
			{
				abundances.SetIoniz[iel][i] = (float)pow(10.f, abundances.SetIoniz[iel][i]) ;
			}
		}
	}

	/* >>chng 01 mar 29, add on option */
	else if( lgMatch(" ON ",chCard) )
	{
		/* option to turn off this element, set abundance to zero */
		abundances.lgElmtOn[iel] = TRUE;
		/* reset levels to default if they were ever turned off with element off command */
		if( levels[ipHYDROGEN][iel] )
		{
			iso.numLevels[ipH_LIKE][iel] = levels[ipHYDROGEN][iel];
			iso.numLevels[ipHE_LIKE][iel] = levels[ipHELIUM][iel];
		}
	}

	else if( lgMatch("TABL",chCard) )
	{
		/* >>chng 97 jun 02, add table option
		 * when called, read in densities from input stream */
		abundances.lgAbunTabl[iel] = TRUE;

		/* general flag saying this option turned on */
		abundances.lgAbTaON = TRUE;
		if( lgMatch("DEPT",chCard) )
		{
			abundances.lgAbTaDepth[iel] = TRUE;
		}
		else
		{
			abundances.lgAbTaDepth[iel] = FALSE;
		}

		/* make sure not trying to change hydrogen */
		if( iel == 0 )
		{
			fprintf( ioQQQ, " cannot change abundance of hydrogen.\n" );
			fprintf( ioQQQ, " Sorry.\n" );
			puts( "[Stop in ParseElement]" );
			cdEXIT(EXIT_FAILURE);
		}

		readar(chCard,&lgEnd);
		i = 1;
		abundances.AbTabRad[0][iel] = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
		abundances.AbTabFac[0][iel] = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);

		if( lgEOL )
		{
			fprintf( ioQQQ, " no pairs entered - cant interpolate\n" );
			puts( "[Stop in ParseElement]" );
			cdEXIT(EXIT_FAILURE);
		}

		abundances.nAbunTabl = 2;
		lgEnd = FALSE;
		/* LIMTAB is set to 500 in abundances */
		while( !lgEnd && abundances.nAbunTabl < LIMTABD )
		{
			readar(chCard,&lgEnd);
			if( !lgEnd )
			{
				/* convert first 4 char to caps, into chCap */
				cap4(chCap , chCard);
				if( strncmp(chCap,"END",3) == 0 )
					lgEnd = TRUE;
			}

			/* lgEnd may have been set within above if, if end line encountered*/
			if( !lgEnd )
			{
				i = 1;
				abundances.AbTabRad[abundances.nAbunTabl-1][iel] = 
					(float)FFmtRead(chCard ,&i,INPUT_LINE_LENGTH,&lgEOL);

				abundances.AbTabFac[abundances.nAbunTabl-1][iel] = 
					(float)FFmtRead(chCard ,&i,INPUT_LINE_LENGTH,&lgEOL);
				abundances.nAbunTabl += 1;
			}
		}

		abundances.nAbunTabl -= 1;

		/* now chec that abundances are in increasing order */
		for( i=1; i < abundances.nAbunTabl; i++ )
		{
			/* the radius values are assumed to be strictly increasing */
			if( abundances.AbTabRad[i][iel] <= abundances.AbTabRad[i-1][iel] )
			{
				fprintf( ioQQQ, " abun radii must be in increasing order\n" );
				puts( "[Stop in ParseElement]" );
				cdEXIT(EXIT_FAILURE);
			}
		}
	}

	else
	{
		fprintf( ioQQQ, " There must be a keyword on this line.\n" );
		fprintf( ioQQQ, " The keys I know about are TABLE, SCALE, _OFF, _ON_, IONIZATION, and ABUNDANCE.\n" );
		fprintf( ioQQQ, " Sorry.\n" );
		puts( "[Stop in ParseElement]" );
		cdEXIT(EXIT_FAILURE);
	}

	/* vary option */
	if( VaryPar.lgVarOn )
	{
		VaryPar.nvarxt[VaryPar.nparm] = 1;
		/* pointer to where to write */
		VaryPar.nvfpnt[VaryPar.nparm] = input.nRead;

		if( lgMatch("SCAL",chCard) )
		{
			/* vary scale factor */
			sprintf( VaryPar.chVarFmt[VaryPar.nparm], "ELEMENT %4.4s SCALE%%f LOG", 
			  elementnames.chElementNameShort[iel] );

			/* param is linear scale factor */
			VaryPar.vparm[0][VaryPar.nparm] = (float)log10(param);
			VaryPar.vincr[VaryPar.nparm] = 0.2f;
		}

		else if( lgMatch("ABUN",chCard) )
		{
			/* vary absolute abundance */
			sprintf( VaryPar.chVarFmt[VaryPar.nparm], "ELEMENT %4.4s ABUND %%f LOG ", 
			  elementnames.chElementNameShort[iel] );

			/* param is log of abundance by number relative to hydrogen */
			VaryPar.vparm[0][VaryPar.nparm] = (float)param;
			VaryPar.vincr[VaryPar.nparm] = 0.2f;
		}
		++VaryPar.nparm;
	}

#	ifdef DEBUG_FUN
	fputs( " <->ParseElement()\n", debug_fp );
#	endif
	return;
}

