/*ParseInit bring an initialization file into input stream before parse  */
#include "cddefines.h"
#include "input.h"
#include "trace.h"
#include "path.h"
#include "parse.h"

void ParseInit(char *chCard )
{
	char *ipEndL ;
	char chLine[FILENAME_PATH_LENGTH_2], 
	  chName[FILENAME_PATH_LENGTH_2];
	long int ip, 
	  k;
	FILE *ioInitFile ; /* will use this as pointer to ini file */

#	ifdef DEBUG_FUN
	fputs( "<+>ParseInit()\n", debug_fp );
#	endif

	/*bring an initialization file into input stream before parsing  */

	/* check whether single quote on line, this was used in c90 */
	if( lgMatch( "\'" , chCard ) )
	{
		fprintf( ioQQQ, 
			" ParseInit found a single quote on this line.  This was used for file names in C90, but double quotes are used now.\n");
		fprintf( ioQQQ, " The single quote has been ignored.\n");
	}

	if( lgMatch( "\"" , chCard ) )
	{
		/* 
		 * if a quote occurs on the line then get the ini file name 
		 * this will also set the name in chCard and OrgCard to spaces
		 * so later keywords do not key off it
		 */
		GetQuote(chName , chCard );
	}
	else
	{
		/* no quote appeared, so this is the default name, cloudy.ini */
		strcpy( chName, "cloudy.ini" );
	}

	/* at this point we have init file name, now make full name 
	 * this can be a local file, or on the path if the key path appears */

	/* option to get cloudy.ini from a path */
	if( lgDataPathSet && lgMatch("PATH",chCard) )
	{
		/* make full name for file if the path has been set AND the keyword PATH occurs on the line */
		strcpy( chLine , chDataPath );
		strcat( chLine , chName ) ;
	}
	else
	{
		/* just use file name, and try to open file in current directory first */
		strcpy( chLine , chName ) ;
	}

	/* open the initialization file */
	if( (ioInitFile = fopen( chLine , "r" ) ) == NULL )
	{
		if( !lgDataPathSet )
		{
			/* file not found, path was not set */
			fprintf( ioQQQ, 
				" ParseInit could not find initialization file %s\n" ,
				chName);
			fprintf( ioQQQ, " The path I tried follows:\n" );
			fprintf( ioQQQ, " %s\n", chLine );
			puts( "[Stop in ParseInit]" );
			cdEXIT(EXIT_FAILURE);
		}
		else 
		{
			/* try to open it once more, with path included even thought not requested */
			strcpy( chLine , chDataPath );
			strcat( chLine , chName ) ;
			if( (ioInitFile = fopen( chLine , "r" ) ) == NULL )
			{
				/* still could not find it */
				fprintf( ioQQQ, " ParseInit could not find initialization file %s\n",chName );
				fprintf( ioQQQ, " The path I tried follows:\n" );
				fprintf( ioQQQ, " %s\n", chLine );
				fprintf( ioQQQ, " The path as set was:\n" );
				fprintf( ioQQQ, " %s\n", chDataPath );
				fprintf( ioQQQ, " The name was:\n" );
				fprintf( ioQQQ, " %s\n", chName );
				puts( "[Stop in ParseInit]" );
				cdEXIT(EXIT_FAILURE);
			}
		}
	}

	/* at this point the init file is open, now bring it into the command stack */
	input.nSaveIni = 1;
	ip = NKRD + 1 - input.nSaveIni;
	while( (fgets( input.chCardSav[ip-1],(int)sizeof(input.chCardSav[ip-1]),ioInitFile)!=NULL ) )
	{
		/* add extra space to be trailing space, needed for commands that end with space */
		ipEndL = strrchr( input.chCardSav[ip-1] , '\n' );
		/* make sure that we found the newline */
		if(ipEndL == NULL )
		{
			fprintf(ioQQQ," ParseInit read in a init file line that did not end with a newline\n");
			fprintf(ioQQQ," line was the following=>%s<=\n",input.chCardSav[ip-1]);
			puts( "[Stop in ParseInit]" );
			cdEXIT(EXIT_FAILURE);
		}
		/* >>chng 01 oct 22, add cast */
		k = (long)(ipEndL - input.chCardSav[ip-1]) ;
		input.chCardSav[ip-1][k] = ' ';
		/*input.chCardSav[ip-1][k+1] = '\n';*/
		input.chCardSav[ip-1][k+1] = ' ';
		input.chCardSav[ip-1][k+2] = '\0';
		/*printf( "str=%s=\n", input.chCardSav[ip-1]);*/
		if( input.chCardSav[ip-1][0]==' ' ) break  ; 
		if( input.chCardSav[ip-1][0]=='#' || input.chCardSav[ip-1][0]=='*' ||
			input.chCardSav[ip-1][0]=='%' || input.chCardSav[ip-1][0]=='/' ) 
			continue ;/* totally ignore these lines */

		/* print input lines if trace specified */
		if( trace.lgTraceInput )
		{
			fprintf( ioQQQ,"initt=%s=\n",input.chCardSav[ip-1] );
		}

		input.nSaveIni += 1;
		ip = NKRD + 1 - input.nSaveIni;
		if( ip <= input.nSave )
		{
			fprintf( ioQQQ, 
				" Too many ini lines.  Total of all input and ini lines cannot exceed NKRD, presently%4i\n", 
			  NKRD );
			puts( "[Stop in ParseInit]" );
			cdEXIT(EXIT_FAILURE);
		}
	}
	fclose(ioInitFile);
	/* last one with real data is NKRD+1-nSaveIni */
	input.nSaveIni -= 1;

#	ifdef DEBUG_FUN
	fputs( " <->ParseInit()\n", debug_fp );
#	endif
	return;
}
