/*PrtZone print out individual zone results */
/*prt_H_like_Pops print out hydrogenic populations */
/*prt_H_like_DeparCoef print out hydrogenic populations */
#include "cddefines.h"
/* following is quantum heating punch io that will need to be removed -
 * now it punches at all times */
#include "physconst.h"
#include "nhe3lvl.h"
#include "nhe1lvl.h"
#include "iso.h"
#include "grainvar.h"
#include "pressure.h"
#include "wind.h"
#include "converge.h"
#include "trace.h"
#include "helike.h"
#include "called.h"
#include "ionrec.h"
#include "printit.h"
#include "he1bn.h"
#include "he3n.h"
#include "he3lines.h"
#include "secondaries.h"
#include "opacity.h"
#include "he3bn.h"
#include "phe1lv.h"
#include "colden.h"
#include "filfac.h"
#include "hmi.h"
#include "rfield.h"
#include "thermal.h"
#include "heat.h"
#include "he.h"
#include "radius.h"
#include "phycon.h"
#include "hevmolec.h"
#include "abundances.h"
#include "fluct.h"
#include "ionfracs.h"
#include "hydrogenic.h"
#include "ionrange.h"
#include "elementnames.h"
#include "prtlinepres.h"
#include "pop371.h"
#include "prtzone.h"
/*prt_H_like_Pops print out hydrogenic populations */
static void prt_H_like_Pops( long nelem );

/*prt_H_like_DeparCoef print out hydrogenic populations */
static void prt_H_like_DeparCoef( long nelem );

void PrtZone(void)
{
	char chField7[8];
	char chLet, 
	  chQHMark;
	long int i, 
	  ishift, 
	  nelem ,
	  nd;
	double cdif, 
	  coninc,
	  con_density,
	  dmidle, 
	  fac, 
	  hatmic, 
	  rmidle;

#	ifdef DEBUG_FUN
	fputs( "<+>PrtZone()\n", debug_fp );
#	endif

	if( thermal.lgUnstable )
	{
		chLet = 'u';
	}
	else
	{
		chLet = ' ';
	}

	/* middle of zone for printing */
	rmidle = radius.Radius - radius.drad*0.5*radius.dRadSign;
	dmidle = radius.depth - radius.drad*0.5;

	/* option to print single line when quiet but tracing convergence
	 * with "trace convergence" command */
	if( called.lgTalk || trace.lgTrConvg )
	{
		/* print either ####123 or ###1234 */
		if( nzone <= 999 )
		{
			sprintf( chField7, "####%3ld", nzone );
		}
		else
		{
			sprintf( chField7, "###%4ld", nzone );
		}

		fprintf(ioQQQ, " %7.7s %cTe:",chField7, chLet);
		PrintE93(ioQQQ,phycon.te);
		fprintf(ioQQQ," Hden:");
		PrintE93(ioQQQ,phycon.hden);
		fprintf(ioQQQ," Ne:");
		PrintE93(ioQQQ,phycon.eden);
		fprintf(ioQQQ," R:");
		PrintE93(ioQQQ,rmidle );
		fprintf(ioQQQ," R-R0:");
		PrintE93(ioQQQ,dmidle);
		fprintf(ioQQQ," dR:");
		PrintE93(ioQQQ,radius.drad);
		fprintf(ioQQQ," NTR:%3ld Htot:",conv.nPres2Ioniz);
		PrintE93(ioQQQ,heat.htot);
		fprintf(ioQQQ," T912:");
		fprintf(ioQQQ,PrintEfmt("%9.2e",opac.TauAbsGeo[0][iso.ipIsoLevNIonCon[ipH_LIKE][0][ipH1s]-1] ));
		fprintf(ioQQQ,"###\n");
		  
		if( trace.lgTrConvg )
		{
			fprintf( ioQQQ, " H:%10.2e%10.2e He:%10.2e%10.2e%10.2e trip%10.2e\n", 
			  xIonFracs[ipHYDROGEN][0]/(xIonFracs[ipHYDROGEN][0] + xIonFracs[ipHYDROGEN][1]), 
			  xIonFracs[ipHYDROGEN][1]/(xIonFracs[ipHYDROGEN][0] + xIonFracs[ipHYDROGEN][1]), 
			  xIonFracs[ipHELIUM][0]/abundances.gas_phase[ipHELIUM], 
			  xIonFracs[ipHELIUM][1]/abundances.gas_phase[ipHELIUM], 
			  xIonFracs[ipHELIUM][2]/abundances.gas_phase[ipHELIUM], 
			  he.hei3/abundances.gas_phase[ipHELIUM] );
		}
	}

	/* now return if not talking */
	if( !called.lgTalk || trace.lgTrConvg )
	{ 
#		ifdef DEBUG_FUN
		fputs( " <->PrtZone()\n", debug_fp );
#		endif
		return;
	}

	/* lgDenFluc set to true in zero, only false when variable abundances
	 * lgAbTaON set true when element table used */
	if( !fluct.lgDenFluc || abundances.lgAbTaON )
	{
		fprintf( ioQQQ, " Abun:" );
		for( i=0; i < LIMELM; i++ )
		{
			fprintf( ioQQQ,PrintEfmt("%8.1e", abundances.gas_phase[i] ));
		}
		fprintf( ioQQQ, "\n" );
	}

	/*-------------------------------------------------
	 * print wind parameters if windy model */
	fac = wind.windv*phycon.hden*radius.r1r0sq;
	if( wind.windv != 0. )
	{
		if( wind.AccelTot == 0. )
		{
			fac = 1.;
		}
		else
		{
			fac = wind.AccelTot;
		}
		/*fprintf( ioQQQ, " WIND; V:%9.3ekm/s G:%10.3e Accel:%10.3e Fr(cont):%6.3f Fr(line):%6.3f Fr(dP):%6.3f\n", 
		  wind.windv/1e5, -wind.agrav, wind.AccelTot, wind.AccelCont/
		  fac, wind.AccelLine/fac, wind.AccelPres/fac );*/
		fprintf( ioQQQ, " WIND; V:");
		fprintf(ioQQQ,PrintEfmt("%10.3e",wind.windv/1e5));
		fprintf( ioQQQ, "km/s G:");
		fprintf(ioQQQ,PrintEfmt("%9.2e",-wind.agrav));
		fprintf( ioQQQ, " Accel:");
		fprintf(ioQQQ,PrintEfmt("%9.2e",wind.AccelTot));
		fprintf( ioQQQ, " Fr(cont):%6.3f Fr(line):%6.3f Fr(dP):%6.3f\n", 
		  wind.AccelCont/ fac, wind.AccelLine/fac, wind.AccelPres/fac );
	}

	/* print line with radiation pressure if significant */
	if( wind.windv != 0. || pressure.pbeta > .05 )
	{
		PrtLinePres();
	}

	/*---------------------------------------------------- */
	hatmic = (xIonFracs[ipHYDROGEN][0] + xIonFracs[ipHYDROGEN][1])/(xIonFracs[ipHYDROGEN][0] + xIonFracs[ipHYDROGEN][1] + hmi.hminus + 2.*(hmi.htwo + 
	  hmi.h2plus) + 3*hmi.h3plus);

	fprintf( ioQQQ, " Hydrogen     ");
	fprintf(ioQQQ,PrintEfmt("%9.2e",xIonFracs[ipHYDROGEN][0]/(xIonFracs[ipHYDROGEN][0] + xIonFracs[ipHYDROGEN][1])));
	fprintf(ioQQQ,PrintEfmt("%9.2e",xIonFracs[ipHYDROGEN][1]/(xIonFracs[ipHYDROGEN][0] + xIonFracs[ipHYDROGEN][1])));
	fprintf( ioQQQ, " H+o/Hden");
	fprintf(ioQQQ,PrintEfmt("%9.2e",hatmic ));
	fprintf(ioQQQ,PrintEfmt("%9.2e",hmi.hminus/phycon.hden ));
	fprintf( ioQQQ, " H-    H2");
	fprintf(ioQQQ,PrintEfmt("%9.2e",hmi.htwo/phycon.hden));
	fprintf(ioQQQ,PrintEfmt("%9.2e",hmi.h2plus/phycon.hden));
	fprintf( ioQQQ, " H2+ HeH+");
	fprintf(ioQQQ,PrintEfmt("%9.2e",hmi.hehp/phycon.hden));
	fprintf( ioQQQ, " Ho+ ColD");
	fprintf(ioQQQ,PrintEfmt("%9.2e",coldenCom.colden[ipCHI]));
	fprintf(ioQQQ,PrintEfmt("%9.2e",coldenCom.colden[ipCHII]));
	fprintf( ioQQQ, "\n");

	/* print departure coef if desired */
	if( iso.lgPrtDepartCoef[ipH_LIKE][ipHYDROGEN] )
	{
		fprintf( ioQQQ, " Hydrogen     " );
		fprintf(ioQQQ,PrintEfmt("%9.2e",  iso.DepartCoef[ipH_LIKE][0][ipH1s]));
		fprintf(ioQQQ,PrintEfmt("%9.2e",  1.));
		fprintf( ioQQQ, " H+o/Hden");
		fprintf(ioQQQ,PrintEfmt("%9.2e", (xIonFracs[ipHYDROGEN][0] + xIonFracs[ipHYDROGEN][1])/phycon.hden));
		fprintf(ioQQQ,PrintEfmt("%9.2e", hmi.hmidep));
		fprintf( ioQQQ, " H-    H2");
		fprintf(ioQQQ,PrintEfmt("%9.2e", hmi.h2dep));
		fprintf( ioQQQ, "      H2+");
		fprintf(ioQQQ,PrintEfmt("%9.2e", hmi.h2pdep));
		fprintf( ioQQQ, "      H3+");
		fprintf(ioQQQ,PrintEfmt("%9.2e",hmi.h3pdep));
		fprintf( ioQQQ, "\n" );
	}

	if( printit.lgPrintHeating )
	{
		fprintf( ioQQQ, "              ");
		fprintf(ioQQQ,PrintEfmt("%9.2e", heat.heating[0][0]/heat.htot));
		fprintf( ioQQQ,"         ");
		fprintf(ioQQQ,PrintEfmt("%9.2e", heat.heating[0][15]/heat.htot));
		fprintf( ioQQQ,"         ");
		fprintf(ioQQQ,PrintEfmt("%9.2e", heat.heating[0][16]/heat.htot));
		fprintf( ioQQQ,"\n");
	}

	/* temperature correspoding to radiation fields */
	coninc = 0.;
	cdif = 0.;
	for( i=0; i < rfield.nflux; i++ )
	{
		/* integrated energy flux, ergs s^-1 cm^-2 */
		coninc += rfield.flux[i]*(rfield.anu[i]*EN1RYD);
		cdif += (rfield.outlin[i] + 
			rfield.ConInterOut[i])* (rfield.anu[i]*EN1RYD);
	}
	/* convert flux in attenuated incident continuum, diffuse emission, into equivalent temperature */
	coninc = pow(coninc/SPEEDLIGHT/7.56464e-15,0.25);
	cdif = pow(cdif/SPEEDLIGHT/7.56464e-15,0.25);

	/* convert sum of flux into energy density, then equivalent pressure */
	con_density = (coninc + cdif) / SPEEDLIGHT;
	con_density /= BOLTZMANN;

	/* print info on hydrogen level populations */
	for( nelem=ipHYDROGEN; nelem<LIMELM; ++nelem )
	{
		if( abundances.lgElmtOn[nelem] )
		{
			if( iso.lgPrtLevelPops[ipH_LIKE][nelem] )
			{
				prt_H_like_Pops(nelem);
			}

			if( iso.lgPrtDepartCoef[ipH_LIKE][nelem] )
			{
				prt_H_like_DeparCoef(nelem);
			}
		}
	}

	if( printit.lgPrintHeating )
	{
		fprintf( ioQQQ, "              ");
		fprintf(ioQQQ,PrintEfmt("%9.2e", heat.heating[0][1]/heat.htot ));
		fprintf( ioQQQ, "         ");
		fprintf(ioQQQ,PrintEfmt("%9.2e", 0. ));
		fprintf( ioQQQ, " BoundCom");
		fprintf(ioQQQ,PrintEfmt("%9.2e", ionrec.CompRecoilHeatLocal/ heat.htot));
		fprintf( ioQQQ, "   Extra:");
		fprintf(ioQQQ,PrintEfmt("%9.2e",heat.heating[0][20]/heat.htot));
		fprintf( ioQQQ, "   Pairs:");
		fprintf(ioQQQ,PrintEfmt("%9.2e", heat.heating[0][21]/ heat.htot ));
		fprintf( ioQQQ,"  H-lines\n");
	}

	/* Helium */
	if( abundances.lgElmtOn[1] )
	{
		fprintf( ioQQQ, " Helium       " );
		for( i=1; i < 4; i++ )
		{
			fprintf(ioQQQ,PrintEfmt("%9.2e", xIonFracs[ipHELIUM][i-1]/abundances.gas_phase[ipHELIUM]) );
		}
		/*fprintf( ioQQQ, "%10.3e%10.3e He I 2S3 %10.3e Comp H, C%10.3e\n", 
		  rfield.cmheat, rfield.cmcool*phycon.te, filfac.FillFac, 
		  hydro.photn2 );*/
		fprintf( ioQQQ, " He I2SP3");
		fprintf(ioQQQ,PrintEfmt("%9.2e", he.hei3/abundances.gas_phase[ipHELIUM] ));
		fprintf(ioQQQ,PrintEfmt("%9.2e", he3lines.p2p/abundances.gas_phase[ipHELIUM] ));
		fprintf( ioQQQ, " Comp H,C");
		fprintf(ioQQQ,PrintEfmt("%9.2e", rfield.cmheat ));
		fprintf(ioQQQ,PrintEfmt("%9.2e",  rfield.cmcool*phycon.te));
		fprintf( ioQQQ , " Fill Fac");
		fprintf(ioQQQ,PrintEfmt("%9.2e", filfac.FillFac));
		fprintf( ioQQQ , " Gam1/tot");
		fprintf(ioQQQ,PrintEfmt("%9.2e", hydro.photn2));
		fprintf( ioQQQ, "\n");

		/* option to print departure coef */
		if( iso.lgPrtDepartCoef[ipH_LIKE][ipHELIUM] )
		{
			fprintf( ioQQQ, " Helium       " );
			fprintf(ioQQQ,PrintEfmt("%9.2e", he1bnCOM.he1bn[0]));
			fprintf(ioQQQ,PrintEfmt("%9.2e", iso.DepartCoef[ipH_LIKE][ipHELIUM][ipH1s]));
			fprintf(ioQQQ,PrintEfmt("%9.2e", 1.));
			fprintf( ioQQQ, " He I 2S3");
			fprintf(ioQQQ,PrintEfmt("%9.2e", he3bnCom.he3bn[0] ));

			/*fprintf( ioQQQ, "%10.3e%10.3e He I 2S3 %10.3e Comp H, C%10.3e\n", 
			  rfield.cmheat, rfield.cmcool*phycon.te, filfac.FillFac, 
			  hydro.photn2 );*/
			fprintf( ioQQQ, " Comp H,C");
			fprintf(ioQQQ,PrintEfmt("%9.2e", rfield.cmheat ));
			fprintf(ioQQQ,PrintEfmt("%9.2e", rfield.cmcool*phycon.te ));
			fprintf( ioQQQ , " Fill Fac");
			fprintf(ioQQQ,PrintEfmt("%9.2e", filfac.FillFac ));
			fprintf( ioQQQ , " Gam1/tot");
			fprintf(ioQQQ,PrintEfmt("%9.2e", hydro.photn2));
			fprintf( ioQQQ, "\n");
		}

		/* print heating from He (and others) if desired
		 * entry "lines" is induced line heating
		 * 1,12 ffheat:  2,3 he triplets, 1,20 compton */
		if( printit.lgPrintHeating )
		{
			/*fprintf( ioQQQ, "            %10.3e%10.3e    Lines:%10.2e%10.2e  Compton:%10.3e FF Heatig%10.3e\n", 
			  heat.heating[1][0]/heat.htot, heat.heating[1][1]/
			  heat.htot, heat.heating[0][22]/heat.htot, heat.heating[1][2]/
			  heat.htot, heat.heating[0][19]/heat.htot, heat.heating[0][11]/
			  heat.htot );*/
			fprintf( ioQQQ, "              ");
			fprintf(ioQQQ,PrintEfmt("%9.2e",heat.heating[1][0]/heat.htot));
			fprintf(ioQQQ,PrintEfmt("%9.2e",heat.heating[1][1]/heat.htot));
			fprintf( ioQQQ, "   Lines:");
			fprintf(ioQQQ,PrintEfmt("%9.2e",heat.heating[0][22]/heat.htot));
			fprintf(ioQQQ,PrintEfmt("%9.2e",heat.heating[1][2]/heat.htot));
			fprintf( ioQQQ, " Compton:");
			fprintf(ioQQQ,PrintEfmt("%9.2e",heat.heating[0][19]/heat.htot));
			fprintf( ioQQQ, " FFHeatig");
			fprintf(ioQQQ,PrintEfmt("%9.2e",heat.heating[0][11]/heat.htot));
			fprintf( ioQQQ, "\n");
		}

		/* helium singlets and triplets */
		fac = xIonFracs[ipHELIUM][1]/abundances.gas_phase[ipHELIUM];
		fprintf( ioQQQ, " He singlet o " );
		for( i=0; i < 6; i++ )
		{
			fprintf(ioQQQ,PrintEfmt("%9.2e", phe1lv.he1n[i]*fac ));
		}
		fprintf( ioQQQ, " He tripl" );
		for( i=0; i < NHE3LVL; i++ )
		{
			fprintf(ioQQQ,PrintEfmt("%9.2e", he3nCom.he3n[i]*fac ));
		}
		fprintf( ioQQQ, "\n" );

		/* option to print departure coef */
		if( iso.lgPrtDepartCoef[ipH_LIKE][ipHELIUM] )
		{
			fprintf( ioQQQ, " He singlet   " );
			for( i=0; i < (NHE1LVL + 1); i++ )
			{
				fprintf(ioQQQ,PrintEfmt("%9.2e", he1bnCOM.he1bn[i] ));
			}
			fprintf( ioQQQ, "\n" );

			fprintf( ioQQQ, " He triplet   " );
			for(i=0; i < NHE3LVL; i++)
			{
				fprintf(ioQQQ,PrintEfmt("%9.2e", he3bnCom.he3bn[i] ));
			}
			fprintf( ioQQQ, "\n" );
		}

		if( abundances.lgElmtOn[ipHELIUM] )
		{
			/* helium singlets and triplets */
			fac = xIonFracs[ipHELIUM][1]/abundances.gas_phase[ipHELIUM];
			fprintf( ioQQQ, " He singlet n " );
			fprintf(ioQQQ,PrintEfmt("%9.2e", iso.Pop2Ion[ipHE_LIKE][1][ipHe1s1S]*fac ));
			/* singlet n=2 complex */
			if( iso.numLevels[ipHE_LIKE][ipHELIUM]>= ipHe2p1P )
			{
				fprintf(ioQQQ,PrintEfmt("%9.2e", iso.Pop2Ion[ipHE_LIKE][1][ipHe2s1S]*fac ));
				fprintf(ioQQQ,PrintEfmt("%9.2e", iso.Pop2Ion[ipHE_LIKE][1][ipHe2p1P]*fac ));
			}
			else
			{
				fprintf(ioQQQ,PrintEfmt("%9.2e", 0. ));
				fprintf(ioQQQ,PrintEfmt("%9.2e", 0. ));
			}
			/* singlet n=3 complex */
			if( iso.numLevels[ipHE_LIKE][ipHELIUM]>= ipHe3p1P )
			{
				fprintf(ioQQQ,PrintEfmt("%9.2e", iso.Pop2Ion[ipHE_LIKE][1][ipHe3s1S]*fac ));
				fprintf(ioQQQ,PrintEfmt("%9.2e", iso.Pop2Ion[ipHE_LIKE][1][ipHe3p1P]*fac ));
				fprintf(ioQQQ,PrintEfmt("%9.2e", iso.Pop2Ion[ipHE_LIKE][1][ipHe3d1D]*fac ));
			}
			else
			{
				fprintf(ioQQQ,PrintEfmt("%9.2e", 0. ));
				fprintf(ioQQQ,PrintEfmt("%9.2e", 0. ));
				fprintf(ioQQQ,PrintEfmt("%9.2e", 0. ));
			}

			fprintf( ioQQQ, " He tripl" );
			/* triplet n=2 complex */
			if( iso.numLevels[ipHE_LIKE][ipHELIUM]>= ipHe2p3P2 )
			{
				fprintf(ioQQQ,PrintEfmt("%9.2e", iso.Pop2Ion[ipHE_LIKE][1][ipHe2s3S]*fac ));
				fprintf(ioQQQ,PrintEfmt("%9.2e", 
					iso.Pop2Ion[ipHE_LIKE][1][ipHe2p3P0]*fac+
					iso.Pop2Ion[ipHE_LIKE][1][ipHe2p3P1]*fac+
					iso.Pop2Ion[ipHE_LIKE][1][ipHe2p3P2]*fac ));
			}
			else
			{
				fprintf(ioQQQ,PrintEfmt("%9.2e", 0. ));
				fprintf(ioQQQ,PrintEfmt("%9.2e", 0. ));
			}
			/* triplet n=3 complex */
			if( iso.numLevels[ipHE_LIKE][ipHELIUM]> ipHe3d3D )
			{
				fprintf(ioQQQ,PrintEfmt("%9.2e", iso.Pop2Ion[ipHE_LIKE][1][ipHe3s3S]*fac ));
				fprintf(ioQQQ,PrintEfmt("%9.2e", iso.Pop2Ion[ipHE_LIKE][1][ipHe3p3P]*fac ));
				fprintf(ioQQQ,PrintEfmt("%9.2e", iso.Pop2Ion[ipHE_LIKE][1][ipHe3d3D]*fac ));
			}
			else
			{
				fprintf(ioQQQ,PrintEfmt("%9.2e", 0. ));
				fprintf(ioQQQ,PrintEfmt("%9.2e", 0. ));
				fprintf(ioQQQ,PrintEfmt("%9.2e", 0. ));
			}
			fprintf( ioQQQ, "\n" );
		}
	}

	/* loop over all possible he-like elements to see if any need to be printed */
	for( nelem=ipHELIUM; nelem<LIMELM; ++nelem )
	{
		if( abundances.lgElmtOn[nelem] )
		{
			if( iso.lgPrtLevelPops[ipHE_LIKE][nelem] )
			{
				prt_He_like_Pops(nelem);
			}
			if( iso.lgPrtDepartCoef[ipHE_LIKE][nelem] )
			{
				prt_He_like_DeparCoef(nelem);
			}
		}
	}

	/* >>chng 01 dec 08, move pressure to line before grains, after radiation properties */
	/* gas pressure, pressure due to incident radiation field, rad accel */
	fprintf( ioQQQ, " Pressure      NgasTgas");
	fprintf(ioQQQ,PrintEfmt("%9.2e", pressure.PressureGas/BOLTZMANN));
	fprintf( ioQQQ, " P(total)");
	fprintf(ioQQQ,PrintEfmt("%9.2e", pressure.PressureRadiation + pressure.PressureGas));
	fprintf( ioQQQ, " P( gas )");
	fprintf(ioQQQ,PrintEfmt("%9.2e", pressure.PressureGas));
	fprintf( ioQQQ, " P(Radtn)");
	fprintf(ioQQQ,PrintEfmt("%9.2e", pressure.PressureRadiation));
	fprintf( ioQQQ, " Rad accl");
	fprintf(ioQQQ,PrintEfmt("%9.2e", wind.AccelTot));
	fprintf( ioQQQ, " ForceMul");
	fprintf(ioQQQ,PrintEfmt("%9.2e", wind.fmul));
	fprintf( ioQQQ, "\n" );

	fprintf( ioQQQ , "               Texc(La)");
	fprintf(ioQQQ,PrintEfmt("%9.2e",  hydro.TexcLya ));
	fprintf( ioQQQ , " T(contn)");
	fprintf(ioQQQ,PrintEfmt("%9.2e",  coninc ));
	fprintf( ioQQQ , " T(diffs)");
	fprintf(ioQQQ,PrintEfmt("%9.2e",  cdif ));
	/* print the total radiation density expressed as an equivalent gas pressure */
	fprintf( ioQQQ , " nT (c+d)");
	fprintf(ioQQQ,PrintEfmt("%9.2e", con_density ));
	/* print the radiation to gas pressure */
	fprintf( ioQQQ , " PRad/Gas");
	fprintf(ioQQQ,PrintEfmt("%9.2e", pressure.pbeta ));
	fprintf( ioQQQ, "\n" );

	for( nd=0; nd < gv.nBin; nd++ )
	{
		/*  Change things so the quantum heated dust species are marked with an
		 *  asterisk just after the name (K Volk)
		 *  added QHMARK here and in the write statement */
		chQHMark = (char)(( gv.bin[nd]->lgQHeat && gv.bin[nd]->lgUseQHeat ) ? '*' : ' ');
		fprintf( ioQQQ, "%-12.12s%c  DustTemp",gv.bin[nd]->chDstLab, chQHMark);
		fprintf(ioQQQ,PrintEfmt("%9.2e", gv.bin[nd]->tedust));
		fprintf( ioQQQ, " Pot Volt");
		fprintf(ioQQQ,PrintEfmt("%9.2e", gv.bin[nd]->dstpot*EVRYD));
		fprintf( ioQQQ, " Chrg (e)");
		fprintf(ioQQQ,PrintEfmt("%9.2e", gv.bin[nd]->AveDustZ));
		fprintf( ioQQQ, " drf cm/s");
		fprintf(ioQQQ,PrintEfmt("%9.2e", gv.bin[nd]->DustDftVel));
		fprintf( ioQQQ, " Heating:");
		fprintf(ioQQQ,PrintEfmt("%9.2e", gv.bin[nd]->GasHeatPhotoEl));
		fprintf( ioQQQ, " Frac tot");
		fprintf(ioQQQ,PrintEfmt("%9.2e", gv.bin[nd]->GasHeatPhotoEl/heat.htot));
		fprintf( ioQQQ, "\n" );
	}
	/* >>chng 00 apr 20, moved punch-out of quantum heating data to qheat(), by PvH */

	/* heavy element molecules */
	if( hevmolec.hevmol[ipCO] > 0. )
	{
		fprintf( ioQQQ, " Molecules     CH/Ctot:");
		fprintf(ioQQQ,PrintEfmt("%9.2e", hevmolec.hevmol[ipCH]/abundances.gas_phase[ipCARBON]));
		fprintf( ioQQQ, " CH+/Ctot");
		fprintf(ioQQQ,PrintEfmt("%9.2e", hevmolec.hevmol[ipCHP]/abundances.gas_phase[ipCARBON]));
		fprintf( ioQQQ, " CO/Ctot:");
		fprintf(ioQQQ,PrintEfmt("%9.2e", hevmolec.hevmol[ipCO]/abundances.gas_phase[ipCARBON]));
		fprintf( ioQQQ, " CO+/Ctot");
		fprintf(ioQQQ,PrintEfmt("%9.2e", hevmolec.hevmol[ipCOP]/abundances.gas_phase[ipCARBON]));
		fprintf( ioQQQ, " H2O/Otot");
		fprintf(ioQQQ,PrintEfmt("%9.2e", hevmolec.hevmol[ipH2O]/abundances.gas_phase[ipOXYGEN]));
		fprintf( ioQQQ, " OH/Ototl");
		fprintf(ioQQQ,PrintEfmt("%9.2e", hevmolec.hevmol[ipOH]/abundances.gas_phase[ipOXYGEN]));
		fprintf( ioQQQ, "\n");
	}

	/* Lithium, Beryllium */
	if( abundances.lgElmtOn[2] || abundances.lgElmtOn[3] )
	{
		fprintf( ioQQQ, " Lithium      " );
		for( i=1; i <= 4; i++ )
		{
			fprintf(ioQQQ,PrintEfmt("%9.2e", xIonFracs[ipLITHIUM][i-1]/MAX2(1e-35,abundances.gas_phase[ipLITHIUM]) ));
		}
		fprintf( ioQQQ, " Berylliu" );
		for( i=1; i <= 5; i++ )
		{
			fprintf(ioQQQ,PrintEfmt("%9.2e",  xIonFracs[ipBERYLLIUM][i-1]/MAX2(1e-35,abundances.gas_phase[ipBERYLLIUM])) );
		}
		fprintf( ioQQQ, "\n" );

		/* option to print heating due to these stages*/
		if( printit.lgPrintHeating )
		{
			fprintf( ioQQQ, "              " );
			for( i=0; i < 3; i++ )
			{
				fprintf(ioQQQ,PrintEfmt("%9.2e",  heat.heating[2][i]/ heat.htot) );
			}
			fprintf( ioQQQ, "                    " );

			for( i=0; i < 4; i++ )
			{
				fprintf(ioQQQ,PrintEfmt("%9.2e", heat.heating[3][i]/heat.htot ));
			}
			fprintf( ioQQQ, "\n" );
		}
	}

	/* Boron */
	if( abundances.lgElmtOn[4] )
	{
		fprintf( ioQQQ, " Boron        " );
		for( i=1; i <= 6; i++ )
		{
			fprintf(ioQQQ,PrintEfmt("%9.2e", xIonFracs[ipBORON][i-1]/MAX2(1e-35,abundances.gas_phase[ipBORON]) ));
		}
		fprintf( ioQQQ, "\n" );

		/* option to print heating*/
		if( printit.lgPrintHeating )
		{ 
			fprintf( ioQQQ, "              " );
			for( i=0; i < 5; i++ )
			{
				fprintf(ioQQQ,PrintEfmt("%9.2e", heat.heating[4][i]/heat.htot ));
			}
			fprintf( ioQQQ, "\n" );
		}
	}

	/* Carbon */
	if( abundances.lgElmtOn[5] )
	{
		fprintf( ioQQQ, " Carbon       " );
		for( i=1; i <= 7; i++ )
		{
			fprintf(ioQQQ,PrintEfmt("%9.2e", xIonFracs[ipCARBON][i-1]/MAX2(1e-35,abundances.gas_phase[ipCARBON])) );
		}
		/* some molecules trail the line */
		fprintf( ioQQQ, " H2O+/O  " );
		fprintf(ioQQQ,PrintEfmt("%9.2e", hevmolec.hevmol[ipH2OP]/MAX2(1e-35,abundances.gas_phase[ipOXYGEN]) ));
		fprintf( ioQQQ, " OH+/Otot" );
		fprintf(ioQQQ,PrintEfmt("%9.2e", hevmolec.hevmol[ipOHP]/ MAX2(1e-35,abundances.gas_phase[ipOXYGEN]) ));
		/* print extra heating, normally zero */
		fprintf( ioQQQ, " Hex(tot)" );
		fprintf(ioQQQ,PrintEfmt("%9.2e", heat.heating[0][20] ));
		fprintf( ioQQQ, "\n" );

		/* option to print heating*/
		if( printit.lgPrintHeating )
		{
			fprintf( ioQQQ, "              " );
			for( i=0; i < 6; i++ )
			{
				fprintf(ioQQQ,PrintEfmt("%9.2e", heat.heating[5][i]/ heat.htot) );
			}
			fprintf( ioQQQ, "\n" );
		}
	}

	/* Nitrogen */
	if( abundances.lgElmtOn[6] )
	{
		fprintf( ioQQQ, " Nitrogen     " );
		for( i=1; i <= 8; i++ )
		{
			fprintf(ioQQQ,PrintEfmt("%9.2e",xIonFracs[ipNITROGEN][i-1]/ MAX2(1e-35,abundances.gas_phase[ipNITROGEN]) ));
		}
		fprintf( ioQQQ, " O2/Ototl" );
		fprintf(ioQQQ,PrintEfmt("%9.2e", hevmolec.hevmol[ipOTWO]/MAX2(1e-35,abundances.gas_phase[ipOXYGEN])));
		fprintf( ioQQQ, " O2+/Otot" );
		fprintf(ioQQQ,PrintEfmt("%9.2e", hevmolec.hevmol[ipO2P]/ MAX2(1e-35,abundances.gas_phase[ipOXYGEN]) ));
		fprintf( ioQQQ, "\n" );

		/* option to print heating*/
		if( printit.lgPrintHeating )
		{
			fprintf( ioQQQ, "              " );
			for( i=0; i < 7; i++ )
			{
				fprintf(ioQQQ,PrintEfmt("%9.2e", heat.heating[6][i]/ heat.htot ));
			}
			fprintf( ioQQQ, "\n" );
		}
	}

	/* now print rest of elements inside loops */

	/* Oxygen through Magnesium */
	for( nelem=7; nelem < 12; ++nelem )
	{
		if( abundances.lgElmtOn[nelem] )
		{
			/* print the element name and amount of shift */
			fprintf( ioQQQ, " %10.10s   ", elementnames.chElementName[nelem]);

			for( i=1; i <= nelem+2; i++ )
			{
				fprintf(ioQQQ,PrintEfmt("%9.2e", xIonFracs[nelem][i-1]/abundances.gas_phase[nelem] ));
			}
			if( nelem==7 )
			{
				/* print secondary ionization rate for oxygen */
				fprintf( ioQQQ, " sec ion:" );
					fprintf(ioQQQ,PrintEfmt("%9.2e", Secondaries.csupra) );
			}
			fprintf( ioQQQ, "\n" );

			/* print heating but only if needed */
			if( printit.lgPrintHeating )
			{
				fprintf( ioQQQ, "              " );
				for( i=1; i <= nelem+2; i++ )
				{
					fprintf(ioQQQ,PrintEfmt("%9.2e", heat.heating[nelem][i-1]/heat.htot ));
				}
				fprintf( ioQQQ, "\n" );
			}
		}
	}

	/* Aluminium through Zinc */
	for( nelem=12; nelem < LIMELM; ++nelem )
	{
		if( abundances.lgElmtOn[nelem] )
		{
			/* number of ionization stages to print across the page */
			/*@-redef@*/
			enum {LINE=13};
			/*@+redef@*/
			ishift = MAX2(0,IonRange.IonHigh[nelem]-LINE+1);

			/* print the element name and amount of shift */
			fprintf( ioQQQ, " %10.10s%2ld ", elementnames.chElementName[nelem],ishift );

			for( i=1; i <= LINE; i++ )
			{
				fprintf(ioQQQ,PrintEfmt("%9.2e", xIonFracs[nelem][i+ishift-1]/abundances.gas_phase[nelem]) );
			}
			fprintf( ioQQQ, "\n" );

			/* print heating but only if needed */
			if( printit.lgPrintHeating )
			{
				fprintf( ioQQQ, "              " );
				for( i=0; i < LINE; i++ )
				{
					fprintf(ioQQQ,
						PrintEfmt("%9.2e", heat.heating[nelem][i+ishift]/heat.htot ));
				}
				fprintf( ioQQQ, "\n" );
			}
		}
	}

	/* call FeII print routine if large atom is turned on */
	if( FeII.lgFeIION )
	{
		FeIIPrint();
	}

#	ifdef DEBUG_FUN
	fputs( " <->PrtZone()\n", debug_fp );
#	endif
	return;
}

/*prt_H_like_Pops print out hydrogenic populations */
static void prt_H_like_Pops( long nelem )
{
	long i ,
		limit ;

#	ifdef DEBUG_FUN
	fputs( "<+>prt_H_like_Pops()\n", debug_fp );
#	endif

	/* lgPrintHLevPops is set true with print h-like command, usually false
	 * when set true, also parse in optional number of levels to print, nPrintHLevPops
	 * will be current value of iso.numLevels[ipH_LIKE][nelem] if nothing entered, so set levels
	 * before print command */
	if( IonRange.IonHigh[nelem] != nelem + 1  )
	{
#		ifdef DEBUG_FUN
		fputs( " <->prt_H_like_Pops()\n", debug_fp );
#		endif
		/* return if no hydrogenic species present */
		return;
	}

	/* it is impossible for this to fail since ParsePrint set to at least 3 */
	ASSERT( iso.numPrintLevels[ipH_LIKE][nelem] > 2);

	/* print straight level pop per ionized hydrogen */
	fprintf( ioQQQ, " %2s%2li 1S-12   ",
		elementnames.chElementSym[nelem],(nelem+1) );

	limit = MIN2(iso.numPrintLevels[ipH_LIKE][nelem],13);
	for( i=ipH1s; i < limit; i++ )
	{
		fprintf( ioQQQ,PrintEfmt("%9.2e",  iso.Pop2Ion[ipH_LIKE][nelem][i] ));
	}
	fprintf(ioQQQ,"\n");

	if( iso.numPrintLevels[ipH_LIKE][nelem] >= limit )
	{
		long int nprint = 0;

		fprintf( ioQQQ, " %2s%2li  rest   ",
		elementnames.chElementSym[nelem], (nelem+1) );

		for( i=limit; i < iso.numPrintLevels[ipH_LIKE][nelem]; i++ )
		{
			fprintf( ioQQQ,PrintEfmt("%9.2e", iso.Pop2Ion[ipH_LIKE][nelem][i] ));
			++nprint;

			if( nprint == 13 )
			{
				nprint = 0;
				/* throw a newline every 14th column */
				fprintf( ioQQQ, "\n" );
				if( i!=iso.numPrintLevels[ipH_LIKE][nelem] )
				{
					/* space out if not first line with label */
					fprintf( ioQQQ, "              " );
				}
			}
		}
		/* end of loop, check whether we need another eol */
		if( nprint != 0 )
		{
			/* do not throw another if iso.numPrintLevels[ipH_LIKE][ipHYDROGEN] is multiple of 13 */
			fprintf( ioQQQ, "\n" );
		}
	}

#	ifdef DEBUG_FUN
	fputs( " <->prt_H_like_Pops()\n", debug_fp );
#	endif
	return;
}

/*prt_H_like_Pops print out hydrogenic populations */
static void prt_H_like_DeparCoef( long nelem )
{
	long i ,
		limit ;

#	ifdef DEBUG_FUN
	fputs( "<+>prt_H_like_DeparCoef()\n", debug_fp );
#	endif

	/* lgPrintHLevPops is set true with print h-like command, usually false
	 * when set true, also parse in optional number of levels to print, nPrintHLevPops
	 * will be current value of iso.numLevels[ipH_LIKE][nelem] if nothing entered, so set levels
	 * before print command */
	if( IonRange.IonHigh[nelem] != nelem + 1  )
	{
#		ifdef DEBUG_FUN
		fputs( " <->prt_H_like_DeparCoef()\n", debug_fp );
#		endif
		/* return if no hydrogenic species present */
		return;
	}

	/* it is impossible for this to fail since ParsePrint set to at least 3 */
	ASSERT( iso.numPrintLevels[ipH_LIKE][nelem] > 2);

	limit = MIN2(iso.numPrintLevels[ipH_LIKE][nelem],13);
	/* print this line so that it agrees with level populations above */
	fprintf( ioQQQ, " %2s%2li 1S-12   ",
		elementnames.chElementSym[nelem],(nelem+1) );

	for( i=ipH1s; i < limit; i++ )
	{
		fprintf( ioQQQ,PrintEfmt("%9.2e", iso.DepartCoef[ipH_LIKE][nelem][i]) );
	}
	fprintf( ioQQQ, "\n" );

	if( iso.numPrintLevels[ipH_LIKE][nelem] >= limit )
	{
		long int nprint = 0;

		fprintf( ioQQQ, " %2s%2li  rest   ",
		elementnames.chElementSym[nelem], (nelem+1) );

		for( i=limit; i < iso.numPrintLevels[ipH_LIKE][nelem]; i++ )
		{
			fprintf( ioQQQ,PrintEfmt("%9.2e", iso.DepartCoef[ipH_LIKE][nelem][i] ));
			++nprint;
			if( nprint == 13 )
			{
				/* throw a newline every 13th column */
				fprintf( ioQQQ, "\n" );
				nprint = 0;
				if( i!=iso.numPrintLevels[ipH_LIKE][nelem] )
				{
					/* throw a newline every 13th column */
					fprintf( ioQQQ, "              " );
				}
			}
		}
		if( nprint != 0 )
		{
			/* do not throw another if iso.numPrintLevels[ipH_LIKE][ipHYDROGEN] is multiple of 13 */
			fprintf( ioQQQ, "\n" );
		}
	}

#	ifdef DEBUG_FUN
	fputs( " <->prt_H_like_DeparCoef()\n", debug_fp );
#	endif
	return;
}
