/*PunchDo produce punch output during calculation,
 * chTime is 'MIDL' during calculation, 'LAST' at the end */
/*PunchNewContinuum produce the 'punch new continuum' output */
/*PunchLineStuff punch optical depths or source functions for all transferred lines */
/*pun1Line called by PunchLineStuff to produce output for one line */
/*PunchNewContinuum produce the 'punch new continuum' output */
/*PunLineIntensity produce the 'punch lines intensity' output */
/* punch h emiss, for chapt 4, routine is below */
/*PunResults1Line do single line of output for the punch results and punch line intensity commands */
/* the number of emission lines across one line of printout */
/*punResults punch results from punch results command */
/*PunResults1Line do single line of output for the punch results and punch line intensity commands */
/*PunchCooling punch coolants */
/*pgaunt called by punch gaunts command to output gaunt factors */
#include "cddefines.h"
#include "cddrive.h"
#include "physconst.h"
#include "mean.h"
#include "taulines.h"
#include "iso.h"
#include "rt.h"
#include "h2.h"
#include "wkhtcl.h"
#include "hydrogenic.h"
#include "gffsub.h"
#include "nhe1lvl.h"
#include "secondaries.h"
#include "he3lines.h"
#include "prtcolumns.h"
#include "grainvar.h"
#include "linesave.h"
#include "he1rb.h"
#include "makerecomb.h"
#include "mappar.h"
#include "dynamics.h"
#include "colden.h"
#include "ionrec.h"
#include "yield.h"
#include "prt.h"
#include "itercnt.h"
#include "hevmolec.h"
#include "heavy.h"
#include "converge.h"
#include "sphere.h"
#include "called.h"
#include "helike.h"
#include "abundances.h"
#include "tfidle.h"
#include "opacity.h"
#include "rfield.h"
#include "phycon.h"
#include "timesc.h"
#include "radius.h"
#include "pop371.h"
#include "assertresults.h"
#include "he.h"
#include "heat.h"
#include "cooling.h"
#include "phe1lv.h"
#include "heopfr.h"
#include "wind.h"
#include "hmi.h"
#include "ipvfil.h"
#include "punchskip.h"
#include "heatcool.h"
#include "ionfracs.h"
#include "pressure.h"
#include "he1rate.h"
#include "herec.h"
#include "nhe1.h"
#include "ph1com.h"
#include "elementnames.h"
#include "plwidth.h"
#include "ipoint.h"
#include "pfeii.h"
#include "gammas.h"
#include "punspec.h"
#include "chargtran.h"
#include "punt.h"
#include "prtmeanion.h"
#include "plankf.h"
#include "readar.h"
#include "rdinit.h"
#include "punch.h"

/*PunResults1Line do single line of output for the punch results and punch line intensity commands */
/* the number of emission lines across one line of printout */
static void PunResults1Line(FILE * io, 
  /* 4 char + null string */
  char *chLab, 
  float wl, 
  double xInten, 
  char chType,
  char *chFunction);/* null terminated string saying what to do */

/*pgaunt called by punch gaunts command to output gaunt factors */
static void pgaunt(FILE* io);

/*PunchCooling punch coolants */
static void PunchCooling(FILE * io);

/*punResults punch results from punch results command */
/*PunResults1Line do single line of output for the punch results and punch line intensity commands */
static void punResults(FILE* io);

static void PunchLineStuff(FILE * io,char *chJob , float xLimit);

/* punch h emiss, for chapt 4, routine is below */
static void AGN_Hemis(FILE *io );

/*PunchNewContinuum produce the 'punch new continuum' output */
static void PunchNewContinuum(FILE * io , long ipCon );

/*PunLineIntensity produce the 'punch lines intensity' output */
static void PunLineIntensity(FILE * io);

void PunchDo(
	char *chTime) /* chTime is null terminated 4 char string, either "MIDL" or "LAST" */
{
	char chEner[LIMELM][7];
	int lgOK, 
	  lgTlkSav;
	FILE * isav;
	long int
	  i, 
	  i1, 
	  ion, 
	  ipConMax, 
	  ipLinMax, 
	  ips, 
	  j, 
	  jj, 
	  limit, 
	  n, 
	  nd, 
	  nelem;
	double ConMax, 
	  RateInter, 
	  av, 
	  conem, 
	  damp, 
	  eps, 
	  flxatt, 
	  flxcor, 
	  flxin, 
	  flxref, 
	  flxtrn, 
	  fout, 
	  fref, 
	  fsum, 
	  opConSum, 
	  opLinSum, 
	  pop, 
	  stage, 
	  sum, 
	  texc, 
	  xLinMax;

#	ifdef DEBUG_FUN
	fputs( "<+>PunchDo()\n", debug_fp );
#	endif

	/* 
	 * the "last" option on punch command, to punch on last iteration,
	 * is parsed at the top of the loop in only one place.  
	 * no further action is needed at all for punch last to work
	 * ok throughout this routine 
	 */

	/* 
	 * each branch can have a test whether chTime is or is not "LAST"
	 * if( strcmp(chTime,"LAST") == 0 )
	 * if "LAST" then this is last call to routine after calc complete
	 * punch only if "LAST" when results at end of cal are needed
	 * test for .not."LAST" is for every zone result, where you do not
	 * want to punch last zone twice
	 */

	/* punch results on unit ipPnunit  */
	if( punch.npunch < 1 )
	{ 
#		ifdef DEBUG_FUN
		fputs( " <->PunchDo()\n", debug_fp );
#		endif
		return;
	}

	for( i=0; i < punch.npunch; i++ )
	{
		/* this global variable to remember where in the punch stack we are */
		punch.ipConPun = i;
		/* 
		 * lgPunLstIter set true if 'last' key occured on punch command
		 * normally is false.  This will skip punching if last set and
		 * this is not last iteration
		 */

		if( IterCnt.lgLastIt || (!punch.lgPunLstIter[i]) )
		{

			if( strcmp(punch.chPunch[i],"ABUN") == 0 )
			{
				/* punch abundances vs depth */
				if( strcmp(chTime,"LAST") != 0 )
				{
					for( j=0; j < LIMELM; j++ )
					{
						fprintf( punch.ipPnunit[i], "%6.2f", 
						  log10(abundances.gas_phase[j]) );
					}
					fprintf( punch.ipPnunit[i], "\n" );
				}
			}

			else if( strcmp(punch.chPunch[i],"ADVE") == 0 )
			{
				/* punch advection terms */
				if( strcmp(chTime,"LAST") != 0 && dynamics.lgAdvection )
				{
					if( nzone>0 )
					{
						fprintf( punch.ipPnunit[i], "%.5e\t%.3e\t%.3e\t%.3e\t%.3e\t%.3e\t%.3e\n",
							radius.depth,
							heat.htot , 
							dynamics.CoolHeat , 
							dynamics.dCoolHeatdT ,
							dynamics.Recomb[ipHYDROGEN][ipHYDROGEN],
							dynamics.Photo,
							dynamics.DynTimestep
							);
					}
				}
			}

			else if( strcmp(punch.chPunch[i],"AGES") == 0 )
			{
				/* punch timescales vs depth */
				if( strcmp(chTime,"LAST") != 0 )
				{
					fprintf( punch.ipPnunit[i], "%10.2e%10.2e%10.2e%10.2e%10.2e\n", 
					  /* depth, cm */
					  radius.depth,
					  /* cooling timescale */
					  phycon.pden*BOLTZMANN*1.5*phycon.te/ heat.htot, 
					  /* H2 formation timescale */
					  timesc.AgeH2MoleDest, 
					  /* CO formation timescale */
					  timesc.AgeCOMoleDest, 
					  /* H recombination timescale */
					  1./(phycon.eden*2.90e-10/(phycon.te70*phycon.te10/phycon.te03)) );
				}
			}

			else if( strcmp(punch.chPunch[i]," AGN") == 0 )
			{
				if( strcmp(chTime,"LAST") == 0 )
				{
					if( strcmp( punch.chPunchArgs[i], "HECS" ) == 0 )
					{
						/* this routine is in helike.c */
						AGN_He1_CS(punch.ipPnunit[i]);
					}
					if( strcmp( punch.chPunchArgs[i], "HEMI" ) == 0 )
					{
						/* punch h emiss, for chapt 4, routine is below */
						AGN_Hemis(punch.ipPnunit[i]);
					}
					else
					{
						fprintf( ioQQQ, " PunchDo does not recognize flag %4.4s set for AGN punch.  This is impossible.\n", 
						  punch.chPunch[i] );
						ShowMe();
						puts( "[Stop in PunchDo]" );
						cdEXIT(EXIT_FAILURE);
					}
				}
			}

			else if( strcmp(punch.chPunch[i],"ASSE") == 0 )
			{
				if( strcmp(chTime,"LAST") == 0 )
				{
					/* punch the assert output */
					/*lint -e534 ignore return value of following  - nothing to do with it */
					lgCheckAsserts(punch.ipPnunit[i]);
					/*lint +e534 ignore return value of following  - nothing to do with it */
				}
			}

			else if( strncmp(punch.chPunch[i],"CHA",3) == 0 )
			{
				if( strcmp(chTime,"LAST") == 0 )
				{
					/* one of the charge transfer options, all in chargtran.c */
					ChargTranPun( punch.ipPnunit[i] , punch.chPunch[i] );
				}
			}

			else if( strcmp(punch.chPunch[i],"COOL") == 0 )
			{
				if( strcmp(chTime,"LAST") != 0 )
					PunchCooling(punch.ipPnunit[i]);
			}

			else if( strcmp(punch.chPunch[i],"COLU") == 0 )
			{
				/* punch column densities */
				if( strcmp(chTime,"LAST") == 0 )
					PrtColumns(punch.ipPnunit[i]);
			}

			else if( strcmp(punch.chPunch[i],"COMP") == 0 )
			{
				/* compton energy exchange coefficients */
				if( strcmp(chTime,"LAST") != 0 )
				{
					for( jj=0; jj<rfield.nflux; jj = jj + PunchSkip.ncPunchSkip)
					{
						fprintf( punch.ipPnunit[i], "%10.2e%10.2e%10.2e\n", 
						  rfield.anu[jj], rfield.comup[jj]/rfield.widflx[jj], 
						  rfield.comdn[jj]/rfield.widflx[jj] );
					}
				}
			}

			/* punch continuum commands */
			else if( strcmp(punch.chPunch[i],"CON ") == 0 )
			{
				/* this branch is the usual "punch continuum" case */
				/* set pointer for possible change in units of energy in continuum
				 * AnuUnit will give anu in whatever units were set with punch units */
				if( strcmp(chTime,"LAST") == 0 )
				{
					for( j=0; j<rfield.nflux ; j = j+PunchSkip.ncPunchSkip)
					{
						/* four continua predicted here;
						 * incident, attenuated incident, emitted,
						 * then attenuated incident + emitted, last reflected
						 * reflected continuum is stored relative to inner radius
						 * others are stored for this radius */

						/* NB this code also used in punch emitted,
						 * transmitted continuum commands */

						/* the incident continuum */
						flxin = rfield.FluxSave[j]*rfield.anu2[j]*
						  EN1RYD/rfield.widflx[j];

						/* the reflected continuum */
						flxref = (rfield.anu2[j]*(rfield.ConRefIncid[j]+rfield.ConEmitReflec[j])/rfield.widflx[j] +
							rfield.anu[j]*PLWidth.PunchLWidth*rfield.reflin[j])*EN1RYD;

						/* the attenuated incident continuum */
						flxatt = rfield.flux[j]*rfield.anu2[j]*EN1RYD/
						  rfield.widflx[j]*radius.r1r0sq;

						/* the outward emitted continuum */
						conem = ((rfield.ConEmitOut[j])/
						  rfield.widflx[j]*rfield.anu2[j] + PLWidth.PunchLWidth*
						  rfield.outlin[j]*rfield.anu[j])*radius.r1r0sq*
						  EN1RYD*sphere.covgeo;

						/* sum of emitted and transmitted continua */
						flxtrn = conem + flxatt;

						/* photon energy in appropriate energy or wavelength units */
						fprintf( punch.ipPnunit[i],"%.3e\t", AnuUnit(rfield.AnuOrg[j]) );
						/* indicent continuum */
						fprintf( punch.ipPnunit[i],"%.3e\t", flxin ); 
						/* trans cont */
						fprintf( punch.ipPnunit[i],"%.3e\t", flxatt ); 
						/* DiffOut cont */
						fprintf( punch.ipPnunit[i],"%.3e\t", conem ); 
						/* net trans cont */
						fprintf( punch.ipPnunit[i],"%.3e\t", flxtrn ); 
						/* reflc cont */
						fprintf( punch.ipPnunit[i],"%.3e\t", flxref ); 
						/* total cont */
						fprintf( punch.ipPnunit[i],"%.3e\t", flxref + flxtrn ); 
						fprintf( punch.ipPnunit[i], "%4.4s\t%4.4s\n", 
						/* line	label */
						  rfield.chLineLabel[j] ,
						/* cont label*/
						  rfield.chContLabel[j] );
					}
				}
			}

			/* this is the punch spectrum command, 
			 * the new continuum command that will replace the previous one */
			else if( strcmp(punch.chPunch[i],"CONN") == 0 )
			{
				if( strcmp(chTime,"LAST") == 0 )
					/* io unit and which new continuum this is (was set when punch read in */
					PunchNewContinuum( punch.ipPnunit[i] , (long)punch.punarg[0][i]);
			}

			else if( strcmp(punch.chPunch[i],"CONC") == 0 )
			{
				/* punch incident continuum */
				/* set pointer for possible change in units of energy in continuum
				 * AnuUnit will give anu in whatever units were set with punch units */
				if( strcmp(chTime,"LAST") == 0 )
				{
					/* incident continuum */
					for( j=0; j<rfield.nflux; j = j + PunchSkip.ncPunchSkip)
					{
						flxin = rfield.FluxSave[j]*rfield.anu2[j]*
						  EN1RYD/rfield.widflx[j];
						/* >>chng 96 oct 22, format of anu to 11.5 to resolve grid near 1 ryd */
						fprintf( punch.ipPnunit[i], "%.5e\t%.3e\n", 
						  AnuUnit(rfield.AnuOrg[j]), flxin );
					}
				}
			}

			else if( strcmp(punch.chPunch[i],"CONG") == 0 )
			{
				/* punch emitted grain continuum */
				/* set pointer for possible change in units of energy in continuum
				 * AnuUnit will give anu in whatever units were set with punch units */
				if( strcmp(chTime,"LAST") == 0 )
				{
					/* tried to remember emission from the two grain types in rtdiffuse */
					for( j=0; j<rfield.nflux; j = j + PunchSkip.ncPunchSkip)
					{
						fsum = gv.GraphiteEmission[j]*rfield.anu2[j]*
						  EN1RYD/rfield.widflx[j] *radius.r1r0sq*sphere.covgeo;

						fout = gv.SilicateEmission[j]*rfield.anu2[j]*
						  EN1RYD/rfield.widflx[j] *radius.r1r0sq*sphere.covgeo;

						/* >>chng 96 oct 22, format of anu to 11.5 to resolve grid near 1 ryd */
						fprintf( punch.ipPnunit[i], "%12.4e %10.3e %10.3e\n", 
						  AnuUnit(rfield.AnuOrg[j]) , fsum , fout );
					}
				}
			}

			else if( strcmp(punch.chPunch[i],"CONR") == 0 )
			{
				/* punch reflected continuum */
				/* set pointer for possible change in units of energy in continuum
				 * AnuUnit will give anu in whatever units were set with punch units */
				if( strcmp(chTime,"LAST") == 0 )
				{
					if( sphere.lgSphere )
					{
						fprintf( punch.ipPnunit[i], " Reflected continuum not predicted when SPHERE is set.\n" );
						fprintf( ioQQQ , 
							"\n\n>>>>>>>>>>>>>\n Reflected continuum not predicted when SPHERE is set.\n" );
						puts( "[Stop in PunchDo]" );
						cdEXIT(EXIT_FAILURE);
					}

					for( j=0; j<rfield.nflux; j = j + PunchSkip.ncPunchSkip)
					{
						/* reflected continuum */
						flxref = rfield.anu2[j]*(rfield.ConRefIncid[j]+rfield.ConEmitReflec[j])/
						  rfield.widflx[j]*EN1RYD;
						/* reflected lines */
						fref = rfield.anu[j]*PLWidth.PunchLWidth*
						  rfield.reflin[j]*EN1RYD;
						/* ratio of reflected to incident continuum, the albedo */
						if( rfield.FluxSave[j] > 1e-25 )
						{
							av = rfield.ConRefIncid[j]/rfield.FluxSave[j];
						}
						else
						{
							av = 0.;
						}
						/* >>chng 96 oct 22, format of anu to 12.5 to resolve grid near 1 ryd */
						fprintf( punch.ipPnunit[i], "%12.5e%12.4e%12.4e%12.4e%12.4e %4.4s\n", 
						  AnuUnit(rfield.AnuOrg[j]), flxref, fref, flxref + fref, 
						  av, rfield.chContLabel[j] );
					}
				}
			}

			else if( strcmp(punch.chPunch[i],"CNVE") == 0 )
			{
				/* the punch convergence error command */
				if( strcmp(chTime,"LAST") != 0 )
				{
					fprintf( punch.ipPnunit[i], 
						"%.4e\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\n", 
						radius.depth, 
						pressure.PressureCorrect, 
						pressure.PressureCurrent, 
						(pressure.PressureCorrect - pressure.PressureCurrent)*100./pressure.PressureCorrect, 
						phycon.EdenTrue,
						phycon.eden,
						(phycon.EdenTrue - phycon.eden)*100./phycon.EdenTrue,
						heat.htot,
						cooling.ctot,
						(heat.htot - cooling.ctot)*100./heat.htot );
				}
			}

			else if( strcmp(punch.chPunch[i],"CONB") == 0 )
			{
				/* punch continuum bins binning */
				/* set pointer for possible change in units of energy in continuum
				 * AnuUnit will give anu in whatever units were set with punch units */
				if( strcmp(chTime,"LAST") != 0 )
				{
					for( j=0; j<rfield.nupper; j = j + PunchSkip.ncPunchSkip)
					{
						fprintf( punch.ipPnunit[i], "%14.5e %14.5e %14.5e\n", 
						  AnuUnit(rfield.AnuOrg[j]), rfield.anu[j], rfield.widflx[j] );
					}
				}
			}

			else if( strcmp(punch.chPunch[i],"COND") == 0 )
			{
				/* punch diffuse continuum the local thermal emission */
				/* set pointer for possible change in units of energy in continuum
				 * AnuUnit will give anu in whatever units were set with punch units */
				if( strcmp(chTime,"LAST") == 0 )
				{
					/* this option to punch diffuse continuum */
					for( j=0; j<rfield.nflux; j = j+PunchSkip.ncPunchSkip)
					{
						/* >>chng 96 oct 22, format of anu to 12.5 to resolve grid near 1 ryd */
						fprintf( punch.ipPnunit[i], "%12.5e\t%12.5e\n", 
						  AnuUnit(rfield.AnuOrg[j]), 
						  rfield.ConEmitLocal[j]*rfield.anu2[j]*EN1RYD/rfield.widflx[j]);
					}
				}
			}

			else if( strcmp(punch.chPunch[i],"CONE") == 0 )
			{
				/* punch emitted continuum */
				/* set pointer for possible change in units of energy in continuum
				 * AnuUnit will give anu in whatever units were set with punch units */
				if( strcmp(chTime,"LAST") == 0 )
				{
					/* punch emitted continuum */
					for( j=0; j<rfield.nflux;j = j +PunchSkip.ncPunchSkip)
					{
						/* this is the reflected component */
						flxref = (rfield.anu2[j]*(rfield.ConRefIncid[j]+rfield.ConEmitReflec[j])/
						  rfield.widflx[j] + rfield.anu[j]*PLWidth.PunchLWidth*
						  rfield.reflin[j])*EN1RYD;

						/* this is the total emission in the outward direction */
						conem = (rfield.ConEmitOut[j])/rfield.widflx[j]*rfield.anu2[j] + 
							PLWidth.PunchLWidth*rfield.outlin[j]*rfield.anu[j];

						conem *= radius.r1r0sq*EN1RYD*sphere.covgeo;

						/* output: photon energy, reflected, outward, total emission
						 *  >>chng 96 oct 22, format of anu to 11.5 to resolve grid near 1 ryd */
						fprintf( punch.ipPnunit[i], "%.5e\t%.3e\t%.3e\t%.3e\t%4.4s\t%4.4s\n", 
						  AnuUnit(rfield.AnuOrg[j]), 
						  flxref, 
						  conem, 
						  flxref + conem, 
						  rfield.chLineLabel[j], 
						  rfield.chContLabel[j]
						   );
					}
				}
			}

			else if( strcmp(punch.chPunch[i],"CONF") == 0 )
			{
				/* FeII continuuum, check that FeII is turned on */
				if( FeII.lgFeIION && ( strcmp(chTime,"LAST") == 0 ))
				{
					for( j=0; j < nFeIIConBins; j++ )
					{
						/* [x][0] is center wavelength, [1] and [2] are upper and
						 * lower bounds in Angstroms.  
						 * these are set in FeIIZero */
						/* emission from large FeII atom, integrated over band */
						fprintf( punch.ipPnunit[i], "%.2f\t%e \n", 
						(FeII_Cont[j][1]+FeII_Cont[j][2])/2.,
						FeII_Cont[j][0] );
					}
				}
			}

			else if( strcmp(punch.chPunch[i],"CONi") == 0 )
			{
				/* punch continuum interactions */
				/* set pointer for possible change in units of energy in continuum
				 * AnuUnit will give anu in whatever units were set with punch units */

				/* continuum interactions */
				if( strcmp(chTime,"LAST") != 0 )
				{
					/* this is option to set lowest energy */
					if( punch.punarg[0][i] <= 0. )
					{
						i1 = 1;
					}
					else if( punch.punarg[0][i] < 100. )
					{
						i1 = ipoint(punch.punarg[0][i]);
					}
					else
					{
						i1 = (long int)punch.punarg[0][i];
					}

					fref = 0.;
					fout = 0.;
					fsum = 0.;
					sum = 0.;
					flxin = 0.;

					for( j=i1-1; j < rfield.nflux; j++ )
					{
						fref += rfield.flux[j]*opac.opac[j];
						fout += rfield.otslin[j]*opac.opac[j];
						fsum += rfield.otscon[j]*opac.opac[j];
						sum += rfield.ConInterOut[j]*opac.opac[j];
						flxin += rfield.outlin[j]*opac.opac[j];
					}
					fprintf( punch.ipPnunit[i], "%10.2e%10.2e%10.2e%10.2e%10.2e\n", 
					  fref, fout, fsum, sum, flxin );
				}
			}

			else if( strcmp(punch.chPunch[i],"CONI") == 0 )
			{
				/* punch ionizing continuum */
				/* set pointer for possible change in units of energy in continuum
				 * AnuUnit will give anu in whatever units were set with punch units */

				if( strcmp(chTime,"LAST") == 0 )
				{
					/* this flag will remember whether we have ever printed anything */
					int lgPrt=FALSE;

					/* punch ionizing continuum command
					 * this is option to set lowest energy */
					if( punch.punarg[0][i] <= 0. )
					{
						i1 = 1;
					}
					else if( punch.punarg[0][i] < 100. )
					{
						i1 = ipoint(punch.punarg[0][i]);
					}
					else
					{
						i1 = (long int)punch.punarg[0][i];
					}

					sum = 0.;
					for( j=i1-1; j < rfield.nflux; j++ )
					{
						flxcor = rfield.flux[j] + 
						  rfield.otslin[j] + 
						  rfield.otscon[j] + 
						  rfield.ConInterOut[j] +
						  rfield.outlin[j];

						sum += flxcor*opac.opac[j];
					}

					if( sum > 0. )
					{
						sum = 1./sum;
					}
					else
					{
						sum = 1.;
					}

					fsum = 0.;

					for( j=i1-1; j<rfield.nflux ; ++j)
					{
						flxcor = rfield.flux[j] + 
						  rfield.otslin[j] + 
						  rfield.otscon[j] + 
						  rfield.ConInterOut[j]+
						  rfield.outlin[j];

						fsum += flxcor*opac.opac[j];

						/* punched quantities are freq, flux, flux*cross sec,
						 * fraction of total, integral fraction of total */
						RateInter = flxcor*opac.opac[j]*sum;

						/* punage(i,2) is lowest interaction rate to consider, def=0.01 (1 percnt) */
						/* >>chng 01 nov 22, format to c-friendly */
						if( (RateInter >= punch.punarg[1][i]) && (flxcor > SMALLFLOAT) )
						{
							lgPrt = TRUE;
							/* >>chng 96 oct 22, format of anu to 11.5 to resolve grid near 1 ryd */
							fprintf( punch.ipPnunit[i], 
								"%li\t%.5e\t%.2e\t%.2e\t%.2f\t%.2f\t%.2f\t%.2f\t%.2e\t%.2e\t%.4s\t%.4s\n", 
							  j,
							  AnuUnit(rfield.AnuOrg[j]), 
							  flxcor, 
							  flxcor*opac.opac[j], 
							  rfield.flux[j]/flxcor, 
							  rfield.otslin[j]/flxcor, 
							  rfield.otscon[j]/flxcor, 
							  (rfield.ConInterOut[j]+ rfield.outlin[j])/flxcor, 
							  RateInter, 
							  fsum*sum, 
							  rfield.chLineLabel[j], 
							  rfield.chContLabel[j] );
						}
					}
					if( !lgPrt )
					{
						/* entered logical block but did not print anything */
						fprintf(punch.ipPnunit[i],
							" punchdo, the PUNCH IONIZING CONTINUUM command did not find a strong point, sum fsum were %.2e %.2e\n",sum,fsum);
					}
				}
			}

			else if( strcmp(punch.chPunch[i],"CORA") == 0 )
			{
				/* punch raw continuum */
				/* set pointer for possible change in units of energy in continuum
				 * AnuUnit will give anu in whatever units were set with punch units */

				if( strcmp(chTime,"LAST") == 0 )
				{
					/* this option to punch all raw ionizing continuum */
					for( j=0;j<rfield.nflux;j = j + PunchSkip.ncPunchSkip)
					{
						fprintf( punch.ipPnunit[i], 
							"%.5e\t%.3e\t%.3e\t%.3e\t%.3e\t%.3e\t%.3e\t%.3e\t%.3e\t%.3e\t%4.4s\t%4.4s\n", 
						  AnuUnit(rfield.AnuOrg[j]), 
						  rfield.flux[j], 
						  rfield.otslin[j], 
						  rfield.otscon[j], 
						  rfield.ConRefIncid[j],
						  rfield.ConEmitReflec[j], 
						  rfield.ConInterOut[j],
						  rfield.outlin[j], 
						  rfield.ThrowOut[j] ,
						  rfield.ConEmitOut[j] ,
						  rfield.chLineLabel[j], 
						  rfield.chContLabel[j] );
					}
				}
			}

			else if( strcmp(punch.chPunch[i],"CONo") == 0 )
			{
				/* punch outward local continuum */
				/* set pointer for possible change in units of energy in continuum
				 * AnuUnit will give anu in whatever units were set with punch units */

				if( strcmp(chTime,"LAST") == 0 )
				{
					/* option to punch out outward continuum here */
					for( j=0;j<rfield.nflux; j = j + PunchSkip.ncPunchSkip)
					{
						fprintf( punch.ipPnunit[i], "%11.5e%10.2e%10.2e%10.2e%10.2e\n", 
						  AnuUnit(rfield.AnuOrg[j]), 
						  rfield.SavOutCon[j], 
						  rfield.ConEmitOut[j] + rfield.outlin[j], 
						  rfield.SavOutCon[j]* opac.opac[j]*rfield.anu[j], 
						  (rfield.flux[j] + rfield.otscon[j] + rfield.otslin[j] + 
						  rfield.ConInterOut[j])*opac.opac[j]*
						  rfield.anu[j] );
					}
				}
			}

			else if( strcmp(punch.chPunch[i],"CONO") == 0 )
			{
				/* punch outward continuum */
				/* set pointer for possible change in units of energy in continuum
				 * AnuUnit will give anu in whatever units were set with punch units */

				if( strcmp(chTime,"LAST") == 0 )
				{
					/* option to punch out outward continuum */
					for( j=0; j<rfield.nflux; j = j + PunchSkip.ncPunchSkip)
					{
						fprintf( punch.ipPnunit[i], "%11.5e%10.2e%10.2e%10.2e%10.2e\n", 
						  AnuUnit(rfield.AnuOrg[j]), 
						  rfield.flux[j]*rfield.anu2[j]* EN1RYD/rfield.widflx[j]*radius.r1r0sq, 
						  rfield.ConInterOut[j]/rfield.widflx[j]*rfield.anu2[j]*radius.r1r0sq*EN1RYD, 
						  PLWidth.PunchLWidth* rfield.outlin[j]*rfield.anu[j]*radius.r1r0sq*EN1RYD, 
						  (rfield.ConInterOut[j]/rfield.widflx[j]*
						  rfield.anu2[j] + PLWidth.PunchLWidth*rfield.outlin[j]*
						  rfield.anu[j])*radius.r1r0sq*EN1RYD );
					}
				}
			}

			else if( strcmp(punch.chPunch[i],"CONT") == 0 )
			{
				/* punch transmitted continuum */
				/* set pointer for possible change in units of energy in continuum
				 * AnuUnit will give anu in whatever units were set with punch units */

				if( strcmp(chTime,"LAST") == 0 )
				{
					/* this option to punch transmitted continuum */
					for( j=0;j<rfield.nflux; j = j + PunchSkip.ncPunchSkip)
					{
						/* attenuated incident continuum
						 * >>chng 97 jul 10, remove PunchLWidth from this one only since
						 * we must conserve energy even in lines */
						flxatt = rfield.flux[j]*rfield.anu2[j]*EN1RYD/
						  rfield.widflx[j]*radius.r1r0sq;

						/*conem = (rfield.ConOutNoInter[j] + rfield.ConInterOut[j]+rfield.outlin[j])*
						  rfield.anu2[j] ;
						conem *= radius.r1r0sq*EN1RYD*sphere.covgeo;*/
						/* >>chng 00 jan 03, above did not include all contributors.  
						 * Pasted in below from usual
						 * punch continuum command */
						conem = (rfield.ConEmitOut[j]/
						  rfield.widflx[j]*rfield.anu2[j] + PLWidth.PunchLWidth*
						  rfield.outlin[j]*rfield.anu[j])*radius.r1r0sq*
						  EN1RYD*sphere.covgeo;

						flxtrn = conem + flxatt;

						/* use AnuOrg here instead of anu since probably
						 * going to be used by table read
						 * and we want good anu array for sanity check*/
						fprintf( punch.ipPnunit[i],"%10.3e\t", AnuUnit(rfield.AnuOrg[j]) );
						fprintf( punch.ipPnunit[i],"%10.3e\n", flxtrn );
					}
				}
			}

			else if( strcmp(punch.chPunch[i],"DUSO") == 0 )
			{
				/* punch grain opacity */
				if( strcmp(chTime,"LAST") == 0 )
				{
					for( j=0; j < rfield.nflux; j++ )
					{
						fprintf( punch.ipPnunit[i], 
						  "%.5e\t%.2e\t%.2e\t%.2e\n", 
						  rfield.anu[j], 
						  gv.dstab[j] + gv.dstsc[j], 
						  gv.dstab[j], gv.dstsc[j] );
					}
				}
			}

			else if( strcmp(punch.chPunch[i],"DUSP") == 0 )
			{
				fprintf( punch.ipPnunit[i], "%.4e\t", 
				  radius.depth );
				/* punch grain physical conditions */
				for( nd=0; nd < gv.nBin; nd++ )
				{
					fprintf( punch.ipPnunit[i], "%.2e\t", gv.bin[nd]->tedust );
				}

				for( nd=0; nd < gv.nBin; nd++ )
				{
					fprintf( punch.ipPnunit[i], "%.2e\t", gv.bin[nd]->dstpot*EVRYD );
				}

				for( nd=0; nd < gv.nBin; nd++ )
				{
					fprintf( punch.ipPnunit[i], "%.2e\t", gv.bin[nd]->DustDftVel );
				}

				fprintf( punch.ipPnunit[i], "%.2e\t%.2e\n", 
				  heat.heating[0][13]/heat.htot, 
				  gv.GasCoolColl/heat.htot );
			}

			else if( strcmp(punch.chPunch[i],"DUSQ") == 0 )
			{
				/* punch grain Qs */
				if( strcmp(chTime,"LAST") == 0 )
				{
					for( j=0; j < rfield.nflux; j++ )
					{
						fprintf( punch.ipPnunit[i], "%11.4e", 
						  rfield.anu[j] );
						for( nd=0; nd < gv.nBin; nd++ )
						{
							fprintf( punch.ipPnunit[i], "%9.1e%9.1e", 
							   gv.bin[nd]->dstab1[j]*4./gv.bin[nd]->IntArea,
							   gv.bin[nd]->dstsc1[j]*4./gv.bin[nd]->IntArea );
						}
						fprintf( punch.ipPnunit[i], "\n" );
					}
				}
			}

			else if( strcmp(punch.chPunch[i],"ELEM") == 0 )
			{
				if( strcmp(chTime,"LAST") != 0 )
				{
					/* this is the index for the atomic number on the physical scale */
					jj = (long int)punch.punarg[0][i];

					fprintf( punch.ipPnunit[i], " %.4e", 
					  radius.depth );

					for( j=1; j <= (jj + 1); j++ )
					{
						ASSERT( jj > 0 );
						fprintf( punch.ipPnunit[i], "\t%.2e", 
						  xIonFracs[jj-1][j-1]/abundances.gas_phase[jj-1] );
					}
					fprintf( punch.ipPnunit[i], "\n" );
				}
			}

			else if( strcmp(punch.chPunch[i],"RECA") == 0 )
			{
				/* this will create table for agn then exit, 
				 * routine is in makerecom.c */
				MakeRecombAGN( punch.ipPnunit[i] );
				cdEXIT(EXIT_FAILURE);
			}

			else if( strcmp(punch.chPunch[i],"RECE") == 0 )
			{
				/* punch recombination efficiencies, 
				 * option turned on with the  "punch recombination efficiencies" command
				 * output for the punch recombination coefficients command is actually
				 * produced by a series of routines, as they generate the recombination
				 * coefficients.  these include 
				 * dielsupres, helium, hydrorecom, iibod, and makerecomb*/
				fprintf( punch.ipPnunit[i], 
					"%12.4e %12.4e %12.4e %12.4e %12.4e %12.4e %12.4e\n", 
				  iso.RadRecomb[ipH_LIKE][0][0][ipRecRad], 
				  iso.RadRecomb[ipH_LIKE][0][0][ipRecNetEsc] ,
				  iso.RadRecomb[ipH_LIKE][0][2][ipRecRad],
				  iso.RadRecomb[ipH_LIKE][0][2][ipRecNetEsc],
				  phe1lv.he1rec[ipRecNetEsc][0], 
				  phe1lv.he1rec[ipRecEsc][0], 
				  heopfr.ophe1f[0] );

			}
			else if( strcmp(punch.chPunch[i],"FE2f") == 0 )
			{
				/* set with punch feii fred command, this punches some stuff from
				* fred hamann's feii atom */
				if( strcmp(chTime,"LAST") != 0 )
					pfeii(punch.ipPnunit[i]);

			}
			else if( strcmp(punch.chPunch[i],"FE2d") == 0 )
			{
				/* punch some departure cefficients for large feii atom */
				if( strcmp(chTime,"LAST") != 0 )
					FeIIPunDepart(punch.ipPnunit[i],FALSE);

			}
			else if( strcmp(punch.chPunch[i],"FE2D") == 0 )
			{
				/* punch all departure cefficients for large feii atom */
				if( strcmp(chTime,"LAST") != 0 )
					FeIIPunDepart(punch.ipPnunit[i],TRUE);

			}
			else if( strcmp(punch.chPunch[i],"FE2p") == 0 )
			{
				/* punch some level populations for large feii atom */
				if( strcmp(chTime,"LAST") != 0 )
					FeIIPunPop(punch.ipPnunit[i],FALSE);

			}
			else if( strcmp(punch.chPunch[i],"FE2P") == 0 )
			{
				/* punch all level populations for large feii atom */
				if( strcmp(chTime,"LAST") != 0 )
					FeIIPunPop(punch.ipPnunit[i],TRUE);

			}
			else if( strcmp(punch.chPunch[i],"GAMM") == 0 )
			{
				if( strcmp(chTime,"LAST") != 0 )
				{
					long ns;
					/* punch photoionization rates, with the PUNCH GAMMAS command */
					for( nelem=0; nelem < LIMELM; nelem++ )
					{
						for( ion=0; ion <= nelem; ion++ )
						{
							for( ns=0; ns < Heavy.nsShells[nelem][ion]; ns++ )
							{
								fprintf( punch.ipPnunit[i], "%3ld%3ld%3ld%10.2e%10.2e%10.2e", 
									nelem+1, ion+1, ns+1, 
									ionrec.PhotoRate_Ground[nelem][ion][ns][0], 
									ionrec.PhotoRate_Ground[nelem][ion][ns][1] ,
									ionrec.PhotoRate_Ground[nelem][ion][ns][2] );

								for( i=0; i < yield.nyield[nelem][ion][ns]; i++ )
								{
									fprintf( punch.ipPnunit[i], "%5.2f", yield.vyield[nelem][ion][ns][i] );
								}
								fprintf( punch.ipPnunit[i], "\n" );
							}
						}
					}
				}
					/*PunGamma(punch.ipPnunit[i]);*/

			}
			else if( strcmp(punch.chPunch[i],"GAUN") == 0 )
			{
				/* punch gaunt factors */
				if( strcmp(chTime,"LAST") != 0 )
					pgaunt(punch.ipPnunit[i]);

			}
			else if( strcmp(punch.chPunch[i],"HEAT") == 0 )
			{
				/* punch heating */
				if( strcmp(chTime,"LAST") != 0 )
					HeatPunch(punch.ipPnunit[i]);
			}

			/*  punch helium */
			/* informatin ou the helium singlets */
			else if( strcmp(punch.chPunch[i],"HEL1") == 0 )
			{
				if( strcmp(chTime,"LAST") != 0 )
				{
					if( he1rate.smhe2ov1 > 1e-30 )
					{
						/* this is simple estimate of singlet to total he */
						fref = (xIonFracs[ipHELIUM][1]/he1rate.smhe2ov1)/abundances.gas_phase[ipHELIUM];
					}
					else
					{
						fref = 0.;
					}

					/* second number is ratio of predicted HeII/AheII to simple
					 *  clhe2ov1 is computed He1/He1 */
					fprintf( punch.ipPnunit[i], 
						"he1%10.2e%10.2e%10.2e%10.2e%10.2e%10.2e%10.2e\n", 
					  xIonFracs[ipHELIUM][0]/abundances.gas_phase[ipHELIUM], 
					  fref, he1rate.clhe2ov1, he1rate.smhe2ov1, 
					  herecCom.reci*phycon.eden, 
					  phe1lv.he1gam[0], 
					  he.hei3/abundances.gas_phase[ipHELIUM] );

					/* print out photoionization rates */
					GammaPrt(nhe1Com.nhe1[0],rfield.nflux,opac.iophe1[0],
					  punch.ipPnunit[i],phe1lv.he1gam[0],phe1lv.he1gam[0]*
					  0.05);
				}
			}

			/* information about the helium triplets - actually special he new debug
			 * get it with punch helium triplets */
			else if( strcmp(punch.chPunch[i],"HEL3") == 0 )
			{
				if( strcmp(chTime,"LAST") != 0 )
				{
					fprintf( punch.ipPnunit[i], 
						"%.2e\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\n",
						/* ionization fracs */
						xIonFracs[ipHELIUM][1]/he.hei1, 
						iso.xIonRatio[ipHE_LIKE][1],

						/* 23S pops */
						he3lines.p2s, 
						EmisLines[ipHE_LIKE][1][ipHe2p3P0][ipHe2s3S].PopLo*xIonFracs[ipHELIUM][1],

						/* recom coef */
						herecCom.rectri+he1rb.he1rtt,
						iso.RadRec_effec[ipHE_LIKE][ipHELIUM],

						/* ground state photo rates */
						phe1lv.he1gam[0],
						iso.gamnc[ipHE_LIKE][ipHELIUM][ipHe1s1S]
						);

#					if 0
					/* this is simple estimate of triplet to total he */
					if( he3rate.she2ov3 > 0. )
					{
						fref = (xIonFracs[ipHELIUM][1]/he3rate.she2ov3)/abundances.gas_phase[ipHELIUM];
					}
					else
					{
						fref = 0.;
					}
					fprintf( punch.ipPnunit[i], "HeTrip%10.2e%10.2e%10.2e%10.2e%10.2e\n", 
					  he.hei3/abundances.gas_phase[ipHELIUM], fref, herecCom.rectri*
					  phycon.eden, he3gams.he3gam[0], he3rate.collhe3 );
					/* print out photoionization rates */
					GammaPrt(he.nhei3,nhe1Com.nhe1[0],opac.ioptri,
					  punch.ipPnunit[i] , he3gams.he3gam[0] , he3gams.he3gam[0]*0.05);
#					endif
				}
			}

			/* punch hummer, results needed for Lya transport, to feed into David's routine */
			else if( strcmp(punch.chPunch[i],"HUMM") == 0 )
			{
				damp = EmisLines[ipH_LIKE][ipHYDROGEN][ipH2p][ipH1s].damp;
				eps = EmisLines[ipH_LIKE][ipHYDROGEN][ipH2p][ipH1s].Aul/
				  (EmisLines[ipH_LIKE][ipHYDROGEN][ipH2p][ipH1s].ColUL *phycon.eden);
				fprintf( punch.ipPnunit[i], 
					" %10.3e %10.3e %10.3e %10.3e %10.3e %10.3e %10.3e\n", 
				  radius.depth, 
				  EmisLines[ipH_LIKE][ipHYDROGEN][ipH2p][ipH1s].TauIn, 
				  iso.Pop2Ion[ipH_LIKE][0][ipH1s]*xIonFracs[ipHYDROGEN][1], 
				  iso.Pop2Ion[ipH_LIKE][0][ipH2p]*xIonFracs[ipHYDROGEN][1], 
				  phycon.te, damp, eps );
			}

			else if( strcmp(punch.chPunch[i],"HYDc") == 0 )
			{
				/* punch hydrogen physical conditions */
				fprintf( punch.ipPnunit[i], 
					" %.3e\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\n", 
				  radius.depth, phycon.te, phycon.hden, phycon.eden, 
				  xIonFracs[ipHYDROGEN][0]/phycon.hden, xIonFracs[ipHYDROGEN][1]/phycon.hden, hmi.htwo/phycon.hden, 
				  hmi.h2plus/phycon.hden, hmi.h3plus/phycon.hden, 
				  hmi.hminus/phycon.hden );
			}

			else if( strcmp(punch.chPunch[i],"HYDi") == 0 )
			{
				if( strcmp(chTime,"LAST") != 0 )
				{
					/* punch hydrogen ionization
					 * this will be total decays to ground */
					RateInter = 0.;
					stage = iso.ColIoniz[ipH_LIKE][0][0]*phycon.eden*iso.Pop2Ion[ipH_LIKE][0][ipH1s];
					fref = iso.gamnc[ipH_LIKE][0][ipH1s]*iso.Pop2Ion[ipH_LIKE][0][ipH1s];
					fout = iso.Pop2Ion[ipH_LIKE][0][ipH1s];
					for( ion=ipH2s; ion < iso.numLevels[ipH_LIKE][ipHYDROGEN]; ion++ )
					{
						/* this is total decays to ground */
						RateInter += 
							EmisLines[ipH_LIKE][ipHYDROGEN][ion][ipH1s].Aul*
						  (EmisLines[ipH_LIKE][ipHYDROGEN][ion][ipH1s].Pesc + 
						  EmisLines[ipH_LIKE][ipHYDROGEN][ion][ipH1s].Pelec_esc + 
						  EmisLines[ipH_LIKE][ipHYDROGEN][ion][ipH1s].Pdest);
						/* total photo from all levels */
						fref += iso.gamnc[ipH_LIKE][0][ion]*iso.Pop2Ion[ipH_LIKE][0][ion];
						/* total col ion from all levels */
						stage += iso.ColIoniz[ipH_LIKE][0][ion]*phycon.eden*
						  iso.Pop2Ion[ipH_LIKE][0][ion];
						fout += iso.Pop2Ion[ipH_LIKE][0][ion];
					}
					fprintf( punch.ipPnunit[i], "hion\t%4ld\t%10.2e\t%10.2e", 
					  nzone, 
					  iso.gamnc[ipH_LIKE][0][ipH1s], 
					  iso.RecomTotal[ipH_LIKE][0] );
					for(j=0; j < LIMELM; j++)
					{
						fprintf( punch.ipPnunit[i], "\t%10.2e", 
						  iso.RadRec_caseB[ipH_LIKE][j] );
					}

					fprintf( punch.ipPnunit[i], 
						"\t%10.2e\t%10.2e\t%10.2e\t%10.2e\t%10.2e\t%10.2e\t%10.2e\t%10.2e\n", 
					  xIonFracs[ipHYDROGEN][1]/xIonFracs[ipHYDROGEN][0], 
					  iso.gamnc[ipH_LIKE][0][ipH1s]/(phycon.eden*iso.RecomTotal[ipH_LIKE][0]), 
					  iso.RadRecomb[ipH_LIKE][0][1][ipRecEsc], 
					  RateInter, 
					  fref/MAX2(1e-37,fout), 
					  stage/MAX2(1e-37,fout), 
					  iso.gamnc[ipH_LIKE][0][ipH1s]*xIonFracs[ipHYDROGEN][0]/(phycon.eden* xIonFracs[ipHYDROGEN][1]) ,
					  Secondaries.csupra);

					GammaPrt(iso.ipIsoLevNIonCon[ipH_LIKE][0][0],rfield.nflux,iso.ipOpac[ipH_LIKE][0][ipH1s],
					  punch.ipPnunit[i],iso.gamnc[ipH_LIKE][0][ipH1s],iso.gamnc[ipH_LIKE][0][ipH1s]*
					  0.05);
				}
			}

			else if( strcmp(punch.chPunch[i],"HYDp") == 0 )
			{
				/* punch hydrogen populations */
				fprintf( punch.ipPnunit[i], " %10.2e%10.2e%10.2e", 
				  radius.depth, xIonFracs[ipHYDROGEN][0], xIonFracs[ipHYDROGEN][1] );
				for( j=ipH1s; j <= 6; j++ )
				{
					fprintf( punch.ipPnunit[i], "%10.2e", iso.Pop2Ion[ipH_LIKE][0][j] );
				}
				fprintf( punch.ipPnunit[i], "%10.2e%10.2e\n", 
				  iso.Pop2Ion[ipH_LIKE][0][ipH2s], iso.Pop2Ion[ipH_LIKE][0][ipH2p] );
			}

			else if( strcmp(punch.chPunch[i],"HYD2") == 0 )
			{
				/* punch hydrogen 21 cm optical depth and spin temperature */
				fprintf( punch.ipPnunit[i], "%.2e\t%.2e\t%.2e\n", 
				radius.depth, TauLines[ipH21cm].TauIn , phycon.te );
			}

			else if( strcmp(punch.chPunch[i],"HYDr") == 0 )
			{
				/* punch hydrogen recomb cooling for agn */
				phycon.te = 2500.;
				while( phycon.te <= 20000. )
				{
					double r1;
					double ThinCoolingCaseB; 

					tfidle(FALSE);

					r1 = HydroRecCool(1,0);
					ThinCoolingCaseB = pow(10.,((-25.859117 + 
					  0.16229407*phycon.telogn[0] + 
					  0.34912863*phycon.telogn[1] - 
					  0.10615964*phycon.telogn[2])/(1. + 
					  0.050866793*phycon.telogn[0] - 
					  0.014118924*phycon.telogn[1] + 
					  0.0044980897*phycon.telogn[2] + 
					  6.0969594e-5*phycon.telogn[3])))/phycon.te;

					fprintf( punch.ipPnunit[i], " %10.2e\t", 
						phycon.te);
					fprintf( punch.ipPnunit[i], " %10.2e\t", 
						(r1+ThinCoolingCaseB)/(BOLTZMANN*phycon.te) );

					fprintf( punch.ipPnunit[i], " %10.2e\t", 
						r1/(BOLTZMANN*phycon.te));

					fprintf( punch.ipPnunit[i], " %10.2e\n", 
						ThinCoolingCaseB/(BOLTZMANN*phycon.te));

					phycon.te *= 2.;
				}
			}

			else if( strcmp(punch.chPunch[i],"IONI") == 0 )
			{
				if( strcmp(chTime,"LAST") == 0 )
				{
					/* punch mean ionization distribution */
					PrtMeanIon( 'i', FALSE , punch.ipPnunit[i] );
				}
			}

			else if( strcmp(punch.chPunch[i]," IP ") == 0 )
			{
				if( strcmp(chTime,"LAST") == 0 )
				{
					/* punch valence shell ip's */
					for( nelem=0; nelem < LIMELM; nelem++ )
					{
						for( n=0; n <= 15; n += 15 )
						{
							if( n + 1 <= nelem+1 )
							{
								fprintf( punch.ipPnunit[i], 
								  " \n" );
								limit = MIN2(n+15,nelem+1);
								fprintf( punch.ipPnunit[i], 
								  "%2.2s", elementnames.chElementSym[nelem]);
								for( ion=n + 1; ion <= limit; ion++ )
								{
									fprintf( punch.ipPnunit[i], 
									  "%4ld", ion );
								}
								fprintf( punch.ipPnunit[i], 
								  "\n" );
							}

							if( n + 1 <= nelem+1 )
							{
								for( ips=0; ips < Heavy.nsShells[n][MIN2(n+15,nelem+1)-1]; ips++ )
								{
									limit = MIN2(n+15,nelem+1);
									for( j=n; j < limit; j++ )
									{
										sum = PH1COM.PH1[ips][nelem+1-j][nelem][0];
										if( sum < 2. )
										{
											strcpy( chEner[j], "      " );
										}
										else if( sum < 10. )
										{
											sprintf( chEner[j], "%6.3f", sum );
										}
										else if( sum < 100. )
										{
											sprintf( chEner[j], "%6.2f", sum );
										}
										else if( sum < 1000. )
										{
											sprintf( chEner[j], "%6.1f", sum );
										}
										else
										{
											sprintf( chEner[j], "%6ld",  (long)(sum) );
										}
									}

									limit = MIN2(n+15,nelem+1);
									fprintf( punch.ipPnunit[i], 
									  "%2.2s", Heavy.chShell[ips]
									   );

									for( j=n; j < limit; j++ )
									{
										fprintf( punch.ipPnunit[i], 
										  "%6.6s", chEner[j] );
									}

									fprintf( punch.ipPnunit[i], 
									  "\n" );
								}
							}
						}
					}
				}
			}

			else if( strcmp(punch.chPunch[i],"LINC") == 0 )
			{
				/* punch line cumulative */
				/* lgOK not used, placdholder */
				if( strcmp(chTime,"LAST") != 0 )
				{
					/* not used for anything here, but should not pass baloney*/
					lgOK = TRUE;
					punlin(punch.ipPnunit[i],"PUNC",lgOK); 
				}
			}

			else if( strcmp(punch.chPunch[i],"LINL") == 0 )
			{
				/* punch line labels */
				prt_LineLabels(punch.ipPnunit[i]);
#				if 0
				puts( "[Stop in PunchDo]" );
				fprintf( ioQQQ, " Cloudy ends:\n" );
				cdEXIT(EXIT_FAILURE);
#				endif
			}

			else if( strcmp(punch.chPunch[i],"LINO") == 0 )
			{
				if( strcmp(chTime,"LAST") == 0 )
				{
					/* punch line optical depths, routine is below, file static */
					PunchLineStuff(punch.ipPnunit[i],"optical" , punch.punarg[0][i]);
				}
			}

			else if( strcmp(punch.chPunch[i],"LINP") == 0 )
			{
				if( strcmp(chTime,"LAST") != 0 )
				{
					static int lgFirst=TRUE;
					/* punch line populations, need to do this twice if very first
					 * call since first call to PunchLineStuff generates atomic parameters
					 * rather than level pops, routine is below, file static */
					PunchLineStuff(punch.ipPnunit[i],"populat" , punch.punarg[0][i]);
					if( lgFirst )
					{
						lgFirst = FALSE;
						PunchLineStuff(punch.ipPnunit[i],"populat" , punch.punarg[0][i]);
					}
				}
			}

			else if( strcmp(punch.chPunch[i],"LIND") == 0 )
			{
				/* punch line data, then stop */
				PunchLineData(punch.ipPnunit[i]);
				puts( "[Normal stop in PunchDo]" );
				fprintf( ioQQQ, " Cloudy ends:\n" );
				cdEXIT(EXIT_FAILURE);
			}

			else if( strcmp(punch.chPunch[i],"LINS") == 0 )
			{
				/* punch line structure */
				if( strcmp(chTime,"LAST") != 0 )
				{
					/* not acutally used, but should not pass baloney*/
					lgOK = TRUE;
					punlin(punch.ipPnunit[i],"PUNS",lgOK);
				}
			}

			else if( strcmp(punch.chPunch[i],"LINA") == 0 )
			{
				if( strcmp(chTime,"LAST") == 0 )
				{
					/* punch out all lines with energies */
					for( j=0; j < LineSave.nsum; j++ )
					{
						/* xLineEnergy is sentinel saying to add to continuum only if positive */
						if( LineSv[j].xLineEnergy > 0. && 
							LineSv[j].sumlin > 0. )
						{
							fprintf( punch.ipPnunit[i], "%12.5e\t%8.3f\t%4.4s ", 
							  AnuUnit(LineSv[j].xLineEnergy), 
							  log10(MAX2(SMALLFLOAT,LineSv[j].sumlin) ) + radius.Conv2PrtInten, 
							  LineSv[j].chALab );

							prt_wl( punch.ipPnunit[i], LineSv[j].wavelength );

							fprintf( punch.ipPnunit[i], " \t%c\n", 
							  LineSv[j].chSumTyp);
						}
					}
				}
			}

			else if( strcmp(punch.chPunch[i],"LINI") == 0 )
			{
				if( strcmp(chTime,"LAST") == 0 && 
					(nzone/punch.LinEvery)*punch.LinEvery != nzone )
				{
					/* this is the last zone
					 * punch line intensities - but do not do last zone twice */
					PunLineIntensity(punch.ipPnunit[i]);
				}
				else if( strcmp(chTime,"LAST") != 0 )
				{
					/* following so we only punch first zone if LinEvery reset */
					if( (punch.lgLinEvery && nzone == 1) || 
					  (nzone/punch.LinEvery)*punch.LinEvery == 
					  nzone )
					{
						/* this is middle of calculation
						 * punch line intensities */
						PunLineIntensity(punch.ipPnunit[i]);
					}
				}
			}

			/* punch Lya - some details about Lya */
			else if( strcmp(punch.chPunch[i],"LYMA") == 0 )
			{
				pop = (iso.Pop2Ion[ipH_LIKE][0][ipH2p]/6.)/(iso.Pop2Ion[ipH_LIKE][0][ipH1s]/2.);
				if( pop > 0. )
				{
					texc = -1.183e5/log(pop);
				}
				else
				{
					texc = 0.;
				}
				fprintf( punch.ipPnunit[i], 
					"%.2e\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\n", 
					radius.depth,
				  EmisLines[ipH_LIKE][ipHYDROGEN][ipH2p][ipH1s].TauIn, 
				  pop, 
				  texc, 
				  phycon.te, 
				  texc/phycon.te ,
				  EmisLines[ipH_LIKE][ipHYDROGEN][ipH2p][ipH1s].Pdest, 
				  opac.opac[EmisLines[ipH_LIKE][ipHYDROGEN][ipH2p][ipH1s].ipCont-1],
				  opac.albedo[EmisLines[ipH_LIKE][ipHYDROGEN][ipH2p][ipH1s].ipCont-1] );
			}

			else if( strcmp(punch.chPunch[i],"MAP ") == 0 )
			{
				/* do the map now if we are at the zone, or if this
				 * is the LAST call to this routine and map not done yet */
				if(  (MapPar.lgMapDone==FALSE ) &&
					(nzone == MapPar.MapZone  ||  strcmp(chTime,"LAST") == 0 ) )
				{
					lgTlkSav = called.lgTalk;
					called.lgTalk = TRUE;
					isav = ioQQQ;
					ioQQQ = punch.ipPnunit[i];
					punt(" map");
					ioQQQ = isav;
					called.lgTalk = lgTlkSav;
				}
			}

			else if( strcmp(punch.chPunch[i],"MOLE") == 0 )
			{
				if( strcmp(chTime,"LAST") != 0 )
				{
					/* molecules, especially for pdr */
					fprintf( punch.ipPnunit[i], 
						"%.3e\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\n", 
					  radius.depth, 
					  2.*hmi.htwo/phycon.hden, 
					  2.*hmi.htwo_star/phycon.hden, 
					  hevmolec.hevmol[ipCO]  /abundances.gas_phase[ipCARBON], 
					  hevmolec.hevmol[ipH2O] /abundances.gas_phase[ipOXYGEN], 
					  hevmolec.hevmol[ipOH]  /abundances.gas_phase[ipOXYGEN], 
					  hevmolec.hevmol[ipCH]  /abundances.gas_phase[ipCARBON], 
					  2.*hevmolec.hevmol[ipOTWO]/abundances.gas_phase[ipOXYGEN] );
				}
			}

			else if( strcmp(punch.chPunch[i],"OPAC") == 0 )
			{
				/* punch opacity - routine will parse which type of opacity punch to do */
				if( strcmp(chTime,"LAST") == 0 )
					PunOpac(punch.ipPnunit[i],i);
			}

			/* punch optical depths command */
			else if( strcmp(punch.chPunch[i],"OPTI") == 0 )
			{
				if( strcmp(chTime,"LAST") == 0 )
				{
					for( j=0; j < rfield.nflux; j++ )
					{
						fprintf( punch.ipPnunit[i], 
							"%12.4e\t%.3e\t%12.4e\t%.3e\n", 
						  AnuUnit(rfield.AnuOrg[j]), 
						  opac.TauAbsFace[j]+opac.TauScatFace[j], 
						  opac.TauAbsFace[j], 
						  opac.TauScatFace[j] );
					}
				}
			}

			else if( strcmp(punch.chPunch[i]," OTS") == 0 )
			{
				ConMax = 0.;
				xLinMax = 0.;
				opConSum = 0.;
				opLinSum = 0.;
				ipLinMax = 1;
				ipConMax = 1;

				for( j=0; j < rfield.nflux; j++ )
				{
					opConSum += rfield.otscon[j]*opac.opac[j];
					opLinSum += rfield.otslin[j]*opac.opac[j];
					if( rfield.otslin[j]*opac.opac[j] > xLinMax )
					{
						xLinMax = rfield.otslin[j]*opac.opac[j];
						ipLinMax = j+1;
					}
					if( rfield.otscon[j]*opac.opac[j] > ConMax )
					{
						ConMax = rfield.otscon[j]*opac.opac[j];
						ipConMax = j+1;
					}
				}
				fprintf( punch.ipPnunit[i], 
					"tot con lin=%.2e%.2e lin=%.4s%.4e%.2e con=%.4s%.4e%.2e\n", 
				  opConSum, opLinSum, rfield.chLineLabel[ipLinMax-1]
				  , rfield.anu[ipLinMax-1], xLinMax, rfield.chContLabel[ipConMax-1]
				  , rfield.anu[ipConMax-1], ConMax );
			}

			else if( strcmp(punch.chPunch[i],"OVER") == 0 )
			{
				/* this is the floor for the smallest ionization fractions printed */
				double toosmall = SMALLFLOAT;

				/* overview of model results,
				 * depth, te, hden, eden, ion fracs H, He, c, O */
				if( strcmp(chTime,"LAST") != 0 )
				{
					/* print the depth */
					fprintf( punch.ipPnunit[i], "%.5e\t", radius.depth );

					/* temperature, heating */
					fprintf( punch.ipPnunit[i], "%.3f\t%.3f", 
					  log10(phycon.te), log10(heat.htot) ); 

					/* hydrogen and electron densities */
					fprintf( punch.ipPnunit[i], "\t%.3f\t%.3f", 
					  log10(phycon.hden), log10(phycon.eden) );
					  
					/* molecular fraction of hydrogen */
					fprintf( punch.ipPnunit[i], "\t%.3f", 
					  log10(MAX2(toosmall,2.*hmi.htwo/phycon.hden)) );
					  
					/* ionization fractions of hydrogen */
					fprintf( punch.ipPnunit[i], "\t%.3f\t%.3f", 
					  -log10(MAX2(toosmall,xIonFracs[ipHYDROGEN][0]/phycon.hden)), 
					  -log10(MAX2(toosmall,xIonFracs[ipHYDROGEN][1]/phycon.hden)) );

					/* ionization fractions of helium */
					for( j=1; j <= 3; j++ )
					{
						fprintf( punch.ipPnunit[i], "\t%.3f", 
						  -log10(MAX2(toosmall,xIonFracs[ipHELIUM][j-1]/
						  abundances.gas_phase[ipHELIUM])) );
					}

					/* carbon monoxide molecular fraction of CO */
					fprintf( punch.ipPnunit[i], "\t%.3f", 
					  log10(MAX2(toosmall, hevmolec.hevmol[ipCO]/abundances.gas_phase[ipCARBON])) );

					/* ionization fractions of carbon */
					for( j=1; j <= 4; j++ )
					{
						fprintf( punch.ipPnunit[i], "\t%.3f", 
						  -log10(MAX2(toosmall,xIonFracs[ipCARBON][j-1]/
						  abundances.gas_phase[ipCARBON])) );
					}

					/* ionization fractions of carbon */
					for( j=1; j <= 6; j++ )
					{
						fprintf( punch.ipPnunit[i], "\t%6.3f", 
						  -log10(MAX2(toosmall,xIonFracs[ipOXYGEN][j-1]/
						  abundances.gas_phase[ipOXYGEN])) );
					}
					fprintf( punch.ipPnunit[i], "\n" );
				}
			}

			else if( strcmp(punch.chPunch[i]," PDR") == 0 )
			{
				if( strcmp(chTime,"LAST") != 0 )
				{
					av = opac.TauTotalGeo[0][ipvfil.ipVFilter-1]*1.08574;
					fprintf( punch.ipPnunit[i], 
						"%.3e\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\n", 
					  radius.depth, 
					  coldenCom.colden[ipCOLUMNDENSITY], 
					  av, 
					  phycon.te, 
					  xIonFracs[ipHYDROGEN][0]/phycon.hden, 
					  hmi.htwo/phycon.hden, 
					  hmi.htwo_star/phycon.hden, 
					  xIonFracs[ipCARBON][0]/abundances.gas_phase[ipCARBON], 
					  hevmolec.hevmol[ipCO]/abundances.gas_phase[ipCARBON], 
					  hevmolec.hevmol[ipH2O]/abundances.gas_phase[ipOXYGEN] );
				}
			}

			else if( strcmp(punch.chPunch[i],"PHYS") == 0 )
			{
				if( strcmp(chTime,"LAST") != 0 )
				{
					/* punch physical conditions */
					fprintf( punch.ipPnunit[i], "%14.6e%12.4e%11.3e%11.3e%11.3e%11.3e\n", 
					  radius.depth, phycon.te, phycon.hden, 
					  phycon.eden, heat.htot, wind.AccelTot );
				}
			}

			else if( strcmp(punch.chPunch[i],"PRES") == 0 )
			{
				/* the punch pressure command */
				if( strcmp(chTime,"LAST") != 0 )
				{
					fprintf( punch.ipPnunit[i], 
						"%.4e\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\t%c\n", 
					  radius.depth, 
					  pressure.PressureCorrect, 
					  pressure.PressureCurrent, 
					  pressure.PressureInit + pressure.PresInteg, 
					  pressure.PressureInit, 
					  pressure.PressureGas, 
					  pressure.PressureRam, 
					  pressure.PressureRadiation, 
					  /* subtract continuum rad pres which has already been added on */
					  pressure.PresInteg - pressure.pinzon, 
					  wind.windv/1e5,
					  sqrt(5.*pressure.PressureGas/3./phycon.xMassDensity)/1e5,
					  TorF(conv.lgConvPres) );
				}
			}

			else if( strcmp(punch.chPunch[i],"RADI") == 0 )
			{
				if( strcmp(chTime,"LAST") != 0 )
				{
					fprintf( punch.ipPnunit[i], " %4ld%12.4e%12.4e%12.4e\n", 
					  nzone, radius.Radius, radius.depth, 
					  radius.drad );
				}
			}

			else if( strcmp(punch.chPunch[i],"RESU") == 0 )
			{
				/*  punch results of the calculation */
				if( strcmp(chTime,"LAST") == 0 )
					punResults(punch.ipPnunit[i]);
			}

			else if( strcmp(punch.chPunch[i],"SOUS") == 0 )
			{
				/* full spectrum of continuum source function at 1 depth
				 *  command was "punch source spectrum" */
				if( strcmp(chTime,"LAST") != 0 )
				{
					limit = MIN2(rfield.ipMaxBolt,rfield.nflux);
					for( j=0; j < limit; j++ )
					{
						fprintf( punch.ipPnunit[i], 
							"%12.4e%12.4e%12.4e%12.4e%12.4e\n", 
						  rfield.anu[j], 
						  rfield.ConEmitLocal[j]/rfield.widflx[j], 
						  opac.opac[j], 
						  rfield.ConEmitLocal[j]/rfield.widflx[j]/MAX2(1e-35,opac.opac[j]), 
						  rfield.ConEmitLocal[j]/rfield.widflx[j]/MAX2(1e-35,opac.opac[j])/plankf(j) );
					}
				}
			}

			else if( strcmp(punch.chPunch[i],"SOUD") == 0 )
			{
				/* parts of continuum source function vs depth
				 * command was source depth */
				j = iso.ipIsoLevNIonCon[ipH_LIKE][0][ipH1s] + 2;
				fprintf( punch.ipPnunit[i], 
					"%12.4e%12.4e%12.4e%12.4e\n", 
				  opac.TauAbsFace[j-1], 
				  rfield.ConEmitLocal[j-1]/rfield.widflx[j-1]/MAX2(1e-35,opac.opac[j-1]), 
				  rfield.otscon[iso.ipIsoLevNIonCon[ipH_LIKE][0][ipH1s]-1], 
				  rfield.otscon[iso.ipIsoLevNIonCon[ipH_LIKE][0][0]-1]/opac.opac[iso.ipIsoLevNIonCon[ipH_LIKE][0][ipH1s]-1] );
			}

			/* this is punch special option */
			else if( strcmp(punch.chPunch[i],"SPEC") == 0 )
			{
				PunSpec(punch.ipPnunit[i],chTime);
			}

			else if( strcmp(punch.chPunch[i],"TEGR") == 0 )
			{
				/* punch history of heating and cooling */
				if( strcmp(chTime,"LAST") != 0 )
				{
					fprintf( punch.ipPnunit[i], " " );
					for( j=0; j < NGRID; j++ )
					{
						fprintf( punch.ipPnunit[i], 
							"%4ld%11.3e%11.3e%11.3e\n", 
						  HeatCool.nZonGrid[j], 
						  HeatCool.TeGrid[j], 
						  HeatCool.HtGrid[j], 
						  HeatCool.ClGrid[j] );
					}
				}
			}

			else if( strcmp(punch.chPunch[i],"TEMP") == 0 )
			{
				/* temperature and its derivative */
				fprintf( punch.ipPnunit[i], " %4ld%12.4e%12.4e\n", 
				  nzone, phycon.te, (phycon.te - phycon.tlast)/
				  radius.drad );
			}

			else if( strcmp(punch.chPunch[i],"TIME") == 0 )
			{
				static double ElapsedTime , ZoneTime;
				if( nzone<=1 )
				{
					ElapsedTime = cdExecTime();
					ZoneTime = 0.;
				}
				else
				{
					double t = cdExecTime();
					ZoneTime = t - ElapsedTime;
					ElapsedTime = t;
				}

				/* zone, time for this zone, elapsed time */
				fprintf( punch.ipPnunit[i], " %ld\t%.3f\t%.2f\n", 
				  nzone,  ZoneTime , ElapsedTime );
			}

			else if( strcmp(punch.chPunch[i],"TPRE") == 0 )
			{
				/* temperature and its predictors, turned on with punch tprid */
				fprintf( punch.ipPnunit[i], "%5ld %11.4e %11.4e %11.4e %g\n", 
				  nzone, phycon.TeInit, phycon.TeProp, phycon.te, 
				  (phycon.TeProp- phycon.te)/phycon.te );
			}

			else if( strcmp(punch.chPunch[i],"VERN") == 0 )
			{
				if( (strcmp(chTime,"LAST") == 0) && FeII.lgFeIION)
				{
					/*FeIILines("pun",norm.ScaleNormLine/LineSv[norm.ipNormWavL].sumlin);*/
					/*FeIIPunchLines(FeII.ioVerner);*/
					FeIIPunchLines( punch.ipPnunit[i] );
				}
			}

			else if( strcmp(punch.chPunch[i],"WIND") == 0 )
			{
				/* wind velocity, radiative accel, and ratio total to e- accel */
				fprintf( punch.ipPnunit[i], 
					"%.5e\t%.5e\t%.4e\t%.4e\t%.4e\t%.4e\t%.4e\n", 
				  radius.Radius, 
				  radius.depth, 
				  wind.windv, 
				  wind.AccelTot, 
				  wind.AccelLine,
				  wind.AccelCont ,
				  wind.fmul );
			}

			else
			{
				/* this is insanity, internal flag set in getpunch not seen here */
				fprintf( ioQQQ, " PunchDo does not recognize flag %4.4s set by GETPUNCH.  This is impossible.\n", 
				  punch.chPunch[i] );
				ShowMe();
				puts( "[Stop in PunchDo]" );
				cdEXIT(EXIT_FAILURE);
			}
			/* at start of loop, broke to here if not last iteration,
			 * and punch last was set
			 * throw special line if punching every iteration */
			if( strcmp(chTime,"LAST") == 0 && !IterCnt.lgLastIt && punch.lgHashEndIter )
			{
				fprintf( punch.ipPnunit[i], " ###########################\n" );
			}
		}
	}

#	ifdef DEBUG_FUN
	fputs( " <->PunchDo()\n", debug_fp );
#	endif
	return;
}

/*PunLineIntensity produce the 'punch lines intensity' output */
static void PunLineIntensity(FILE * io)
{
	char chCard[INPUT_LINE_LENGTH];
	int lgEOF;
	long int i;

#	ifdef DEBUG_FUN
	fputs( "<+>PunLineIntensity()\n", debug_fp );
#	endif

	/* used to punch out all the emission line intensities
	 * first initialize the line image reader */

	/* start the file with the input commands */
	rdinit();
	fprintf( io, "**********************************************************************************************************************************\n" );
	
	lgEOF = FALSE;
	while( !lgEOF )
	{
		readar(chCard,&lgEOF);
		if( !lgEOF )
		{
			fprintf( io, "%s\n", chCard );
		}
	}

	/* now print any cautions or warnings */
	cdWarnings( io);
	cdCautions( io);
	fprintf( io, "zone=%5ld\n", nzone );
	fprintf( io, "**********************************************************************************************************************************\n" );
	fprintf( io, "begin emission lines\n" );

	/* >>chng 96 jul 03, only punch non-zero intensities */
	PunResults1Line(io,"    ",0,0.,'o',"Start");
	for( i=0; i < LineSave.nsum; i++ )
	{
		if( LineSv[i].sumlin > 0. )
		{
			PunResults1Line(io,(char*)LineSv[i].chALab,LineSv[i].wavelength,
			  LineSv[i].sumlin, LineSv[i].chSumTyp, "Line ");
		}
	}

	PunResults1Line(io,"    ",0,0.,'o',"Flush");

	fprintf( io, "     \n" );
	fprintf( io, "**********************************************************************************************************************************\n" );


#	ifdef DEBUG_FUN
	fputs( " <->PunLineIntensity()\n", debug_fp );
#	endif
	return;
}

static int lgPopsFirst , lgOptical ;

/*PunchLineStuff punch optical depths or source functions for all transferred lines */
static void PunchLineStuff(FILE * io,char *chJob , float xLimit )
{

	long int nelem , ipLo , ipHi , i , ipISO;
	long index = 0;
	static int lgFirst=TRUE;

#	ifdef DEBUG_FUN
	fputs( "<+>PunchLineStuff()\n", debug_fp );
#	endif

	/*find out which job this is and set a flag to use later */
	if( strcmp( &*chJob , "optical" ) == 0 )
	{
		/* punch line optical depths */
		lgOptical = TRUE;
		lgPopsFirst = FALSE;
	}
	else if( strcmp( &*chJob , "populat" ) == 0 )
	{
		lgOptical = FALSE;
		/* level population information */
		if( lgFirst )
		{
			lgPopsFirst = TRUE;
			fprintf(io,"index\tAn.ion\tgLo\tgUp\tE(wn)\tgf\n");
			lgFirst = FALSE;
		}
		else
		{
			lgPopsFirst = FALSE;
		}
	}
	else
	{
		fprintf( ioQQQ, " insane job in PunchLineStuff =%s\n", 
		  &*chJob );
		puts( "[Stop in PunchLineStuff]" );
		cdEXIT(EXIT_FAILURE);
	}

	/* loop over all lines, calling put1Line to create info (routine located below) */
	/*hydrogen like lines */
	/* >>chng 02 may 16, had been explicit H and He-like loops */
	for( ipISO=ipH_LIKE; ipISO<NISO; ++ipISO )
	{
		for( nelem=ipISO; nelem < LIMELM; nelem++ )
		{
			if( abundances.lgElmtOn[nelem]  )
			{
				for( ipHi=1; ipHi < iso.numLevels[ipISO][nelem]; ipHi++ )
				{
					for( ipLo=0; ipLo <ipHi; ipLo++ )
					{
						++index;
						pun1Line( &EmisLines[ipISO][nelem][ipHi][ipLo] , io , xLimit  , index);
					}
				}
				/* also do lyman lines if optical depths are to be done */
				if( lgOptical )
				{
					for( ipHi=iso.numLevels[ipISO][nelem]; ipHi < iso.nLyman[ipISO]; ipHi++ )
					{
						++index;
						pun1Line( &iso.ExtraLymanLines[ipISO][nelem][ipHi] , io , xLimit  , index);
					}
				}
			}
		}
	}

#	if 0	/*helium like lines */
	for( nelem=ipHELIUM; nelem < LIMELM; nelem++ )
	{
		if( nelem < 2 || abundances.lgElmtOn[nelem] )
		{
			/* arrays are dim'd ipHe2p1P */
			for( ipLo=ipHe1s1S; ipLo < iso.numLevels[ipHE_LIKE][nelem]-1; ipLo++ )
			{
				/* set ENTIRE array to impossible values, in case of bad pointer */
				for( ipHi=ipLo+1; ipHi < iso.numLevels[ipHE_LIKE][nelem]; ipHi++ )
				{
					++index;
					pun1Line( &EmisLines[ipHE_LIKE][nelem][ipHi][ipLo] , io, xLimit  , index);
				}
			}
			/* also do lyman lines if optical depths are to be done */
			if( lgOptical )
			{
				for( ipHi=iso.n_HighestResolved[ipHE_LIKE][nelem]; ipHi < iso.nLyman[ipHE_LIKE]; ipHi++ )
				{
					++index;
					pun1Line( &iso.ExtraLymanLines[ipHE_LIKE][nelem][ipHi] , io , xLimit  , index);
				}
			}
		}
	}
#	endif

	/* index from 1 to skip over dummy line */
	for( i=1; i < nLevel1; i++ )
	{
		++index;
		pun1Line( &TauLines[i] , io , xLimit  , index);
	}

	for( i=0; i < nWindLine; i++ )
	{
		if( TauLine2[i].nelem != TauLine2[i].IonStg )
		{
			++index;
			pun1Line( &TauLine2[i] , io , xLimit  , index);
		}
	}

	if( FeII.lgFeIION )
	{
		/* do optical depths of FeII lines, if large atom is turned on */
		FeIIPunchLineStuff( io , xLimit  , index);
	}

	/* punch optical depths of H2 lines */
	H2_PunchLineStuff( io , xLimit  , index);

	/* C12O16 */
	for( i=0; i < nCORotate; i++ )
	{
		++index;
		pun1Line( &C12O16Rotate[i] , io , xLimit  , index);
	}

	/* C13O16 */
	for( i=0; i < nCORotate; i++ )
	{
		++index;
		pun1Line( &C13O16Rotate[i] , io , xLimit  , index);
	}
	fprintf(io, "##################################\n"); 

#	ifdef DEBUG_FUN
	fputs( " <->PunchLineStuff()\n", debug_fp );
#	endif
	return;
}

/*pun1Line called by PunchLineStuff to produce output for one line */
void pun1Line( EmLine * t , FILE * io , float xLimit  , long index )
{

	if( lgOptical )
	{
		/* optical depths, no special first time, only print them */
		if( t->TauIn >= xLimit )
		{
			/* label like "C  4" or "H  1" */
			fprintf( io , "%2.2s%2.2s\t", 
			  elementnames.chElementSym[t->nelem-1] ,
			  elementnames.chIonStage[t->IonStg-1]  );

			/* print wavelengths, either line in main printout labels, 
			 * or in various units in exponential notation */
			if( strcmp( punch.chConPunEnr[punch.ipConPun], "labl" )== 0 )
			{
				prt_wl( io , t->WLAng );
			}
			else
			{
				/* this converts energy in rydbergs into any of the other units */
				fprintf( io , "%.7e", AnuUnit((float)(t->EnergyWN * WAVNRYD)) );
			}
			fprintf( io , "\t%.3f\n", log10(MAX2(SMALLFLOAT,t->TauIn))  );
		}
	}
	else if( lgPopsFirst )
	{
		char chLbl[11];
		/* first call to line populations, print atomic parameters and indices */
		strcpy( chLbl, chLineLbl(t) );
		fprintf(io, "%li\t%s\t" , index , chLbl );
		/* stat weights */
		fprintf(io, "%.0f\t%.0f\t", 
			t->gLo ,t->gHi);
		/* energy difference, gf */
		fprintf(io, "%.2f\t%.3e\t", 
			t->EnergyWN ,t->gf);
		fprintf(io, "\n");
	}
	else
	{
		/* not first call, so do level populations and indices defined above */
		if( t->PopHi > xLimit )
		{
			fprintf(io,"%li\t%.2e\t%.2e\n", index,
				t->PopLo , 
				t->PopHi );
		}
	}
}

/*PunchNewContinuum produce the 'punch new continuum' output */
static void PunchNewContinuum(FILE * io, long ipCon )
{
	long int ipLo, ipHi,
		j ,
		ncells;

	double 
		wllo=3500. , 
		wlhi=7000. , 
		resolution = 2.;

	double *energy, 
		*cont_incid,
		*cont_atten,
		*diffuse_in,
		*diffuse_out;

	/* get the low limit, cp_range_min is zero if not set */
	wllo = MAX2( rfield.anu[0] , punch.cp_range_min[ipCon] );
	if( punch.cp_range_max[ipCon] > 0. )
	{
		/* set to smaller of these two  */
		wlhi = MIN2( rfield.anu[rfield.nflux-1] , punch.cp_range_max[ipCon]  );
	}
	else
	{
		/* use high energy limit since not set */
		wlhi = rfield.anu[rfield.nflux-1] ;
	}

	if( punch.cp_resolving_power[ipCon] != 0. )
	{
		/* next two bogus to fool lint - they cannot happen */
		ipLo = LONG_MAX;
		ipHi = LONG_MAX;
		/* wwe will set a new continuum mesh */
		ncells = (long)((wlhi-wllo)/resolution + 1);
	}
	else
	{
		/* use native continuum mesh */
		ipLo = ipoint(wllo)-1;
		ipHi = ipoint(wlhi)-1;
		ncells = ipHi - ipLo + 1;
	}

	/* now allocate the space */
	if( (energy = (double *)MALLOC( (size_t)(ncells+1)*sizeof(double) ) )==NULL )
		bad_malloc();
	if( (cont_incid = (double *)MALLOC( (size_t)(ncells+1)*sizeof(double) ) )==NULL )
		bad_malloc();
	if( (cont_atten = (double *)MALLOC( (size_t)(ncells+1)*sizeof(double) ) )==NULL )
		bad_malloc();
	if( (diffuse_in = (double *)MALLOC( (size_t)(ncells+1)*sizeof(double) ) )==NULL )
		bad_malloc();
	if( (diffuse_out = (double *)MALLOC( (size_t)(ncells+1)*sizeof(double) ) )==NULL )
		bad_malloc();

	/* was the resolution changed from the default native resolution ? */
	if( punch.cp_resolving_power[ipCon] != 0. )
	{
		/* now create energy grid */
		energy[0] = wlhi;
		j = 0;
		while( energy[j]-resolution > wllo )
		{
			++j;
			ASSERT( j< ncells+1 );
			energy[j] = energy[j-1] - resolution;
		}

		ncells = j;
		/* now convert to rydbergs */
		for( j=0; j<ncells; ++j )
		{
			energy[j] = RYDLAM / energy[j];
		}
	}
	else 
	{
		/* now convert to rydbergs */
		for( j=0; j<ncells; ++j )
		{
			energy[j] = rfield.AnuOrg[j+ipLo] - rfield.widflx[j+ipLo]/2.;
		}
	}

	/* for cdSPEC the energy vector is the lower edge of the energy cell */
	/* get incident continuum */
	cdSPEC( 1 , energy , ncells , cont_incid );
	/* get attenuated incident continuum */
	cdSPEC( 2 , energy , ncells , cont_atten );
	/* get attenuated incident continuum */
	cdSPEC( 5 , energy , ncells , diffuse_in );
	/* get attenuated incident continuum */
	cdSPEC( 4 , energy , ncells , diffuse_out );

	/* for this example we will do a wavelength range */
	for( j=0; j<ncells-1 ; ++j )
	{
		/* photon energy in appropriate energy or wavelength units */
		fprintf( io,"%.3e\t", AnuUnit((float)(energy[j]+rfield.widflx[j+ipLo]/2.) ) );
		fprintf( io,"%.3e\t", cont_incid[j] );
		fprintf( io,"%.3e\t", cont_atten[j] );
		fprintf( io,"%.3e", diffuse_in[j]+diffuse_out[j] );
		fprintf( io,"\n" );
	}

	free(energy);
	free(cont_incid);
	free(diffuse_in);
	free(diffuse_out);
	free(cont_atten);
}

/* punch agn hemiss, for chapt 4, routine is below */
static void AGN_Hemis(FILE *io )
{
#	define NTE 4
	float te[NTE] = {5000., 10000., 15000., 20000.};
	float *continuum[NTE];
	long i , j;

	/* make table of continuous emission at various temperatuers */
	/* first allocate space */
	for( i=0;i<NTE; ++i)
	{
		if( (continuum[i] = (float *)MALLOC((unsigned)rfield.nflux*sizeof(float) ))==NULL)
			bad_malloc();

		/* set the next temperature */
		phycon.te = te[i];
		/* recompute everything at this new temp */
		tfidle(TRUE);
		/* converge the pressure-temperature-ionization solution for this zone */
		ConvPresTempEdenIoniz();

		/* now get the thermal emission */
		RTDiffuse();
		for(j=0;j<rfield.nflux; ++j )
		{
			continuum[i][j] = rfield.ConEmitLocal[j]/(float)phycon.eden/
				(xIonFracs[ipHYDROGEN][1] + xIonFracs[ipHELIUM][1] + xIonFracs[ipHELIUM][2] );
		}
	}

	/* print title for line */
	fprintf(io,"wl");
	for( i=0;i<NTE; ++i)
	{
		fprintf(io,"\t%.0f",te[i]);
	}
	fprintf( io , "\tcont\n"); 

	/* not print all n temperatures across a line */
	for(j=0;j<rfield.nflux; ++j )
	{
		fprintf( io , "%12.5e", 
		  AnuUnit(rfield.AnuOrg[j]) );
		/* loop over the temperatures, and for each, calculate a continuum */
		for( i=0;i<NTE; ++i)
		{
			fprintf(io,"\t%.3e",continuum[i][j]*rfield.anu2[j]*EN1RYD/rfield.widflx[j]);
		}
		/* cont label and end of line*/
		fprintf( io , "\t%s\n" , rfield.chContLabel[j]); 
	}

	/* now free the continua */
	for( i=0;i<NTE; ++i)
	{
		free( continuum[i] );
	}

	fprintf( ioQQQ, " I have left the code in a disturbed state, and will now exit.\n");
	puts( "[Stop in PunchDo]" );
	cdEXIT(EXIT_FAILURE);
}

/*punResults punch results from punch results command */
/*PunResults1Line do single line of output for the punch results and punch line intensity commands */
static void punResults(FILE* io)
{
	char chCard[INPUT_LINE_LENGTH];
	int lgEOF;
	long int i , n;

#	ifdef DEBUG_FUN
	fputs( "<+>punResults()\n", debug_fp );
#	endif

	/* used to punch out line intensities, optical depths,
	 * and column densities */
	lgEOF = FALSE;
	/* first initialize the line image reader */
	rdinit();

	fprintf( io, "**********************************************************************************************************************************\n" );
	lgEOF = FALSE;
	readar(chCard,&lgEOF);
	while( !lgEOF )
	{
		fprintf( io, "%s\n", chCard );
		readar(chCard,&lgEOF);
	}

	/* first print any cautions or warnings */
	cdWarnings(io);
	cdCautions(io);
	fprintf( io, "**********************************************************************************************************************************\n" );

	fprintf( io, "C*OPTICAL DEPTHS ELECTRON=%10.3e\n", opac.telec );

	fprintf( io, "BEGIN EMISSION LINES\n" );
	PunResults1Line(io,"    ",0,0.,'o',"Start");

	for( i=0; i < LineSave.nsum; i++ )
	{
		if( LineSv[i].sumlin > 0. )
		{
			PunResults1Line(io,(char*)LineSv[i].chALab,LineSv[i].wavelength,
			  LineSv[i].sumlin,LineSv[i].chSumTyp,"Line ");
		}
	}

	PunResults1Line(io,"    ",0,0.,'o',"Flush");

	fprintf( io, "     \n" );

	fprintf( io, "BEGIN COLUMN DENSITIES\n" );
	/* make sure this is kept parallel with cdGett, which uses it
	 * real in all column densities*/

	/* this dumps out the whole array, which will be picked up by cdGett */
	/* following loop relies on LIMELM being 30, assert it here in case
	 * this is ever changed */
	ASSERT( LIMELM == 30 );
	/* this order of indices is to keep 30 as the fastest variable,
	 * and the 32 (LIMELM+2) as the slower one */
	for(i=0; i < LIMELM+2; i++)
	{
		for( n=0; n<LIMELM; n++ )
		{
			fprintf( io, " %10.3e", IonMeans.xIonMeans[0][n][i] );
			/* throw line feed every 10 numbers */
			if( n==9|| n==19 || n==29 )
			{
				fprintf( io, "\n" );
			}
		}
	}

	fprintf( io, "END OF RESULTS\n" );
	fprintf( io, "**********************************************************************************************************************************\n" );

#	ifdef DEBUG_FUN
	fputs( " <->punResults()\n", debug_fp );
#	endif
	return;
}

#define	LINEWIDTH	6

/*PunResults1Line do single line of output for the punch results and punch line intensity commands */
/* the number of emission lines across one line of printout */
static void PunResults1Line(FILE * io, 
  /* 4 char + null string */
  char *chLab, 
  float wl, 
  double xInten, 
  char chType,
  char *chFunction)/* null terminated string saying what to do */
{

	long int i;
	static float wavelength[LINEWIDTH];
	static long ipLine;
	static double xIntenSave[LINEWIDTH];
	static char chTypeSave[LINEWIDTH];
	static char chLabSave[LINEWIDTH][5];

#	ifdef DEBUG_FUN
	fputs( "<+>PunResults1Line()\n", debug_fp );
#	endif

	/* if LineWidth is changed then change format in write too */

	if( strcmp(chFunction,"Start") == 0 )
	{
		ipLine = 0;
	}
	else if( strcmp(chFunction,"Line ") == 0 )
	{
		/* save results in array so that they can be printed when done */
		wavelength[ipLine] = wl;
		strcpy( chLabSave[ipLine], chLab );
		xIntenSave[ipLine] = xInten;
		chTypeSave[ipLine] = chType;

		/* now increment the counter and then check if we have filled the line, 
		 * and so should print it */
		++ipLine;
		/* do print now if we are in column mode (one line per line) or if we have filled up
		 * the line */
		if( ( strcmp(punch.chPunRltType,"column") == 0 ) || ipLine == LINEWIDTH )
		{
			/* "array " is usual array 6 wide, "column" is one line per line */
			for( i=0; i < ipLine; i++ )
			{
				fprintf( io, " %4.4s ", chLabSave[i] );
				prt_wl( io, wavelength[i] );
				fprintf( io,"\t%.3e", xIntenSave[i]);
				/* >>chng 02 apr 24, do not print type */
				/*fprintf( io, " %c", chTypeSave[i] );*/
				/* single column for input into data base */
				if( strcmp(punch.chPunRltType,"column") == 0 )				
					fprintf( io, "\n" );
			}
			/* only put cr if we did not just put one */
			if( strcmp(punch.chPunRltType,"array ") == 0 )				
				fprintf( io, " \n" );
			ipLine = 0;
		}
	}
	else if( strcmp(chFunction,"Flush") == 0 )
	{
		if( ipLine > 0 )
		{
			/* this is an option to print many emission lines across an output line,
			 * the array option, or a single column of numbers, the column option
			 * that appears on the "punch results" and "punch intensity" commands
			 */
			/* usual array 6 wide */
			for( i=0; i < ipLine; i++ )
			{
				fprintf( io, " %4.4s", chLabSave[i] );
				prt_wl( io, wavelength[i] );
				fprintf( io,"\t%.3e", xIntenSave[i]);
				/* >>chng 02 apr 24, do not print type */
				/*fprintf( io, " %c", chTypeSave[i] );*/
				/* single column for input into data base */
				if( strcmp(punch.chPunRltType,"column") == 0 )				
					fprintf( io, "\n" );
			}
			if( strcmp(punch.chPunRltType,"array ") == 0 )
				fprintf( io, " \n" );
		}
	}
	else
	{
		fprintf( ioQQQ, " PunResults1Line called with insane request=%5.5s\n", 
		  chFunction );
		puts( "[Stop in result]" );
		cdEXIT(EXIT_FAILURE);
	}

#	ifdef DEBUG_FUN
	fputs( " <->PunResults1Line()\n", debug_fp );
#	endif
	return;
}

/* this is limit to number of coolants to save */
#define	IPSAVE	100
/* this is limit to number of coolants to print out */
#define  IPRINT 100

/*PunchCooling punch coolants */
static void PunchCooling(FILE * io)
{
	char chL2[IPSAVE][5], 
	  chLSav[IPSAVE][5];

	long int i, 
	  imax, 
	  ip, 
	  is, 
	  j;
	float sav[IPSAVE], 
	  sav2[IPSAVE];

	double csav[IPSAVE], 
	  csav2[IPSAVE], 
	  cset, 
	  sgn2[IPSAVE], 
	  sgnsav[IPSAVE], 
	  xmax;

#	ifdef DEBUG_FUN
	fputs( "<+>PunchCooling()\n", debug_fp );
#	endif

	for( i=0; i<IPSAVE; ++i )
	{
		csav[i] = -DBL_MAX;
		strcpy( chLSav[i] ,  "crap" );
		sav[i] = -FLT_MIN;
		sgnsav[i] = -DBL_MAX;
	}

	/* cset will be weakest cooling to consider
	 * WeakHeatCool set with 'set weakheatcool' command
	 * default is 0.05 */
	cset = cooling.ctot*WkHtCl.WeakHeatCool;

	/* first find all strong lines, both + and - sign */
	ip = 0;
	for( i=0; i < cooling.ncltot; i++ )
	{
		/* only remember the most important heating/ cooling agents */
		if( (cooling.cooling[i] > cset || cooling.heatnt[i] > cset) )
		{
			strcpy( chLSav[ip], cooling.chClntLab[i] );
			sav[ip] = cooling.collam[i];
			csav[ip] = MAX2(cooling.cooling[i],cooling.heatnt[i])/
			  cooling.ctot;

			/* save sign to remember if heating or cooling line */
			if( cooling.heatnt[i] == 0. )
			{
				sgnsav[ip] = 1.;
			}
			else
			{
				sgnsav[ip] = -1.;
			}

			/* this will now be one too many, which is ok since following
			 * loop is < ip */
			++ip;

			/* IPSAVE is dimension of save arrays, do not exceed this */
			if( ip >= IPSAVE ) break;
		}
	}

	/* will be pointer to largest value */
	imax = 0;

	/* order strongest to weakest */
	for( i=0; i < ip; i++ )
	{
		xmax = 0.;
		for( j=0; j < ip; j++ )
		{
			if( csav[j] > xmax )
			{
				xmax = csav[j];
				imax = j;
			}
		}
		strcpy( chL2[i], chLSav[imax] );
		sav2[i] = sav[imax];
		csav2[i] = csav[imax];
		sgn2[i] = sgnsav[imax];
		csav[imax] = -1.;
	}

	/* warn if tcovergence failure occurred */
	if( !conv.lgConvTemp )
	{
		fprintf( io, " >>>>  Temperature notconverged.\n" );
	}
	else if( !conv.lgConvEden )
	{
		fprintf( io, " >>>>  Electron density not convergenced.\n" );
	}
	else if( !conv.lgConvIoniz )
	{
		fprintf( io, " >>>>  Ionization not converged.\n" );
	}
	else if( !conv.lgConvPres )
	{
		fprintf( io, " >>>>  Pressure not converged.\n" );
	}

	/* convert very long wavelengths to micros */
	for( i=0; i < ip; i++ )
	{
		if( sav2[i] > 100000.f )
			sav2[i] /= 10000.f;
	}

	/* start the printout with zone number, total heating and total cooling */
	fprintf( io, "%.2e\t%.2e\t%10.2e", phycon.te, heat.htot, 
	  cooling.ctot );

	/* print only up to IPRINT, which is defined above */
	ip = MIN2( ip , IPRINT );

	/* now print the coolants 
	 * keep sign of coolant, for strong negative cooling 
	 * order is ion, wavelength, fraction of total */
	for( is=0; is < ip; is++ )
	{
		fprintf( io, "\t%s %.1f\t%.3f", chL2[is], sav2[is], 
		  sign(csav2[is],sgn2[is]) );
	}
	fprintf( io, " \n" );

#	ifdef DEBUG_FUN
	fputs( " <->PunchCooling()\n", debug_fp );
#	endif
	return;
}

#define	NENR_GAUNT	31
#define	NTE_GAUNT	21
/*pgaunt called by punch gaunts command to output gaunt factors */
static void pgaunt(FILE* io)
{
	long int i, 
	  ier[NENR_GAUNT][NTE_GAUNT], 
	  if1, 
	  ite, 
	  j;

	float ener[NENR_GAUNT], 
	  g[NENR_GAUNT][NTE_GAUNT], 
	  gfac, 
	  ste[NTE_GAUNT], 
	  z;

#	ifdef DEBUG_FUN
	fputs( "<+>pgaunt()\n", debug_fp );
#	endif

	/* this routine is called from the PUNCH GAUNTS command
	 * it drives the gaunt factor routine to punch gaunts over full range */

	for( i=0; i < NTE_GAUNT; i++ )
	{
		ste[i] = (float)(0.5*i);
	}

	for( i=0; i < NENR_GAUNT; i++ )
	{
		ener[i] = (float)(0.5*i - 5.);
	}

	/* ener is log of energy */
	for( ite=0; ite < NTE_GAUNT; ite++ )
	{
		phycon.alogte = ste[ite];
		/* nuclear charge */
		z = (float)log10(1.);

		for( j=0; j < NENR_GAUNT; j++ )
		{
			gffsub(z,&ener[j],(float*)&gfac,1,1,&if1);
			g[j][ite] = gfac;
			ier[j][ite] = if1;
		}
	}

	/* now punch out the results */
	fprintf( io, "      " );
	for( i=1; i <= NTE_GAUNT; i++ )
	{
		fprintf( io, "%6.1f", ste[i-1] );
	}
	fprintf( io, "\n" );

	for( j=0; j < NENR_GAUNT; j++ )
	{
		fprintf( io, "%6.2f", ener[j] );
		for( ite=0; ite < NTE_GAUNT; ite++ )
		{
			fprintf( io, "%6.2f", log10(g[j][ite]) );
		}
		fprintf( io, "\n" );
	}

	fprintf( io, "      " );
	for( i=0; i < NTE_GAUNT; i++ )
	{
		fprintf( io, "%6.1f", ste[i] );
	}
	fprintf( io, "\n" );

	for( j=0; j < NENR_GAUNT; j++ )
	{
		fprintf( io, "%6.3f", ener[j] );
		for( ite=0; ite < NTE_GAUNT; ite++ )
		{
			fprintf( io, "%6ld", ier[j][ite] );
		}
		fprintf( io, "\n" );
	}

	/* now do the same thing as triplets */
	fprintf( io, "      " );
	for( i=0; i < NTE_GAUNT; i++ )
	{
		fprintf( io, "%6.1f", ste[i] );
	}
	fprintf( io, "\n" );

	for( i=0; i < NTE_GAUNT; i++ )
	{
		for( j=0; j < NENR_GAUNT; j++ )
		{
			fprintf( io, "%6.2f%6.2f%6.2f\n", ste[i], ener[j], 
			  log10(g[j][i]) );
		}
	}

#	ifdef DEBUG_FUN
	fputs( " <->pgaunt()\n", debug_fp );
#	endif
	return;
}
#undef	NENR_GAUNT
#undef	NTE_GAUNT

