/*PunSpec generate output for the punch special command */
#include "cddefines.h"
#include "taulines.h"
#include "radius.h"
#include "opacity.h"
/* includes above almost always needed */
#include "coolheavy.h"
#include "rfield.h"
#include "iso.h"
#include "ffun.h"
#include "heat.h"
#include "colden.h"
#include "phycon.h"
#include "atom_oi.h"
#include "ionfracs.h"
#include "punspec.h"

void PunSpec(FILE* io , 
  char *chTime)
{
	/*long int i;*/

#	ifdef DEBUG_FUN
	fputs( "<+>PunSpec()\n", debug_fp );
#	endif

	if( strncmp(chTime,"LAST",4) == 0 )
	{
#		if 0
		long ipISO , nelem , limit , i;
		double EdenAbund , fach;
#		include "physconst.h"
#		include "hydrogenic.h"
#		include "ionfracs.h"
		/* code to execute only after last zone 
		PunFeII( io );*/
		ipISO = ipHYDROGEN;
		nelem = ipHYDROGEN;

		/* in all following the factor of two is because a single
		 * decay produces two photons */
		EdenAbund = iso.Pop2Ion[ipH_LIKE][nelem][ipH2s]*xIonFracs[nelem][nelem+1]*8.226*pow(1.+nelem,6);
		fprintf(io," 2s = %.3e\n", EdenAbund);

		/* upper limit to H-like 2-phot is energy of La, which is in ipCont-1 cell */
		limit = EmisLines[ipH_LIKE][nelem][ipH2p][ipH1s].ipCont-1;
		/* remember sum of rates, this will add up to twice the real rate since
		 * each transition makes two photons */
		for( i=0; i < limit; i++ )
		{
			/*>>chng 01 jan 23, previous change had doubled cross section for H two-photon,
			 * so here we divide by 2 to get old answer */
			/* >>chng 01 sep 16, break out TWO_PHOT_CONST and factor of two from AsHy2nu */
			fach = hydro.AsHy2nu[ipISO][nelem][i]/2.f;
			fach *= rfield.anu2[i]/rfield.widflx[i]*EN1RYD;
			fprintf(io,"%.3e\t%.3e\t%.3e\n", 
				RYDLAM/1e4/rfield.anu[i] , fach , fach*(float)EdenAbund );
		}
#		endif

	}
	else
	{
		/* code to execute after every zone */
		fprintf(io,"%.4e\t%.4e\t%.4e\t%.4e\t%.4e\n",
			radius.depth,
			TauLines[ipT1304].Pesc,
			atom_oi.popoi[1],
			TauLines[ipT1304].PopLo,
			xIonFracs[ipOXYGEN][0]
			);
	}

#	ifdef DEBUG_FUN
	fputs( " <->PunSpec()\n", debug_fp );
#	endif
	return;
}
