/*RefIndex calculates the index of refraction of air using the line energy in wavenumbers,
 * used to convert vacuum wavelengths to air wavelengths. */
#include "cddefines.h"
#include "refindex.h"

double RefIndex(EmLine * t)
{
	double RefIndex_v, 
	  WaveMic, 
	  xl, 
	  xn;

#	ifdef DEBUG_FUN
	fputs( "<+>RefIndex()\n", debug_fp );
#	endif

	/* the wavelength in microns */
	WaveMic = 1.e4/t->EnergyWN;

	/* only do index of refraction if longward of 2000A */
	if( WaveMic > 0.2 )
	{
		/* longward of 2000A
		 * xl is 1/WaveMic^2 */
		xl = 1.0/WaveMic/WaveMic;
		/* use a formula from Allen's 3rd Edition AQ, p.124 */
		xn = 255.4/(41. - xl);
		xn += 29498.1/(146. - xl);
		xn += 64.328;
		RefIndex_v = xn/1.e6 + 1;
	}
	else
	{
		RefIndex_v = 1.;
	}

#	ifdef DEBUG_FUN
	fputs( " <->RefIndex()\n", debug_fp );
#	endif
	return( RefIndex_v );
}
