/*strk compute stark broadening escape probabilities using Puetter formalism */
#include "cddefines.h"
#include "taulines.h"
#include "nhe1lvl.h"
#include "iso.h"
#include "strkon.h"
#include "he1as.h"
#include "hydrogenic.h"
#include "he1str.h"
#include "he1tau.h"
#include "he1nxt.h"
#include "phycon.h"
#include "strk.h"

void strk(void)
{
	long int ipLo, 
	  ipHi;
	double aa , ah, 
	  stark, 
	  strkla;

#	ifdef DEBUG_FUN
	fputs( "<+>strk()\n", debug_fp );
#	endif

	if( !strkon.lgStarkON || phycon.eden < 1e8 )
	{
		for( ipHi=0; ipHi < iso.numLevels[ipH_LIKE][ipHYDROGEN]; ipHi++ )
		{
			for( ipLo=0; ipLo < iso.numLevels[ipH_LIKE][ipHYDROGEN]; ipLo++ )
			{
				hydro.pestrk[ipHi][ipLo] = 0.;
				hydro.pestrk[ipLo][ipHi] = 0.;
			}
		}

		for( ipHi=0; ipHi < NHE1LVL; ipHi++ )
		{
			for( ipLo=0; ipLo < NHE1LVL; ipLo++ )
			{
				he1str.peshe1[ipHi][ipLo] = 0.;
			}
		}
		
#		ifdef DEBUG_FUN
		fputs( " <->strk()\n", debug_fp );
#		endif
		return;
	}

	/* evaluate Stark escape probability from 
	 * >>ref Puetter Ap.J. 251, 446. */

	/* coefficients for Stark broadening escape probability
	 * needs factor of nu/nl ** 3 *xl to be Puetters AH */
	ah = 6.9e-6*1000./1e12/(phycon.sqrte*phycon.te10*phycon.te10*
	  phycon.te03*phycon.te01*phycon.te01)*phycon.eden;

	/* coefficient for all lines except Ly alpha */
	stark = 0.264*pow(ah,0.4);

	/* coefficient for Ly alpha */
	strkla = 0.538*ah*4.*9.875*(phycon.sqrte/phycon.te10/phycon.te03);

	/* Lyman lines always have outer optical depths */
	/*ASSERT( EmisLines[ipH_LIKE][ipHYDROGEN][ipH2p][ipH1s].TauIn> 0. );*/
	/* >>chng 02 mar 31, put in max, crashed on some first iteration 
	 * with negative optical depths,
	 * NB did not understand why neg optical depths started */
	aa = pow(MAX2(SMALLFLOAT,EmisLines[ipH_LIKE][ipHYDROGEN][ipH2p][ipH1s].TauIn),-0.75f);
	hydro.pestrk[ipH1s][ipH2p] = 
		(float)(strkla/2.*MAX2(1.,aa));

	hydro.pestrk[ipH1s][ipH2p] = (float)MIN2(.01,hydro.pestrk[ipH1s][ipH2p]);

	hydro.pestrk[ipH2p][ipH1s] = 
		hydro.pestrk[1][2]*EmisLines[ipH_LIKE][ipHYDROGEN][ipH2p][ipH1s].Aul;

	he1str.peshe1[0][1] = (float)(strkla/2.*(pow(MAX2(1.,he1nxtCOM.he1nxt[0][1]),-0.75) + 
	  pow(vfmax(1.,he1tauCOM.he1lim[0][1]/10.,he1tauCOM.he1lim[0][1]-
	  he1nxtCOM.he1nxt[0][1],FEND),-0.75)));

	he1str.peshe1[0][1] = (float)MIN2(.01,he1str.peshe1[0][1]);

	he1str.peshe1[1][0] = he1str.peshe1[0][1]*he1as.He1EinA[0][1];

	for( ipHi=3; ipHi < iso.numLevels[ipH_LIKE][ipHYDROGEN]; ipHi++ )
	{
		hydro.pestrk[1][ipHi] = (float)(stark*hydro.strkar[1][ipHi]/2.*pow(MAX2(1.,
		  EmisLines[ipH_LIKE][ipHYDROGEN][ipHi][ipH1s].TauIn),-0.75));

		hydro.pestrk[1][ipHi] = (float)MIN2(.01,hydro.pestrk[1][ipHi]);
		hydro.pestrk[ipHi][1] = EmisLines[ipH_LIKE][ipHYDROGEN][ipHi][ipH1s].Aul*
		  hydro.pestrk[1][ipHi];
	}

	for( ipHi=2; ipHi < NHE1LVL; ipHi++ )
	{
		he1str.peshe1[0][ipHi] = (float)(strkla/2.*(pow(MAX2(1.,he1nxtCOM.he1nxt[0][ipHi]),-0.75) + 
		  pow(vfmax(1.,he1tauCOM.he1lim[0][ipHi]/10.,he1tauCOM.he1lim[0][ipHi]-
		  he1nxtCOM.he1nxt[0][ipHi],FEND),-0.75)));

		he1str.peshe1[0][ipHi] = (float)MIN2(.01,he1str.peshe1[0][ipHi]);
		he1str.peshe1[ipHi][0] = he1str.peshe1[0][ipHi]*he1as.He1EinA[0][ipHi];
	}

	/* all other lines */
	for( ipLo=ipH2s; ipLo < (iso.numLevels[ipH_LIKE][ipHYDROGEN] - 1); ipLo++ )
	{
		for( ipHi=ipLo + 1; ipHi < iso.numLevels[ipH_LIKE][ipHYDROGEN]; ipHi++ )
		{
			aa = stark*hydro.strkar[ipLo][ipHi]*
			  pow(MAX2(1.,EmisLines[ipH_LIKE][ipHYDROGEN][ipHi][ipLo].TauIn),-0.75);
			hydro.pestrk[ipLo][ipHi] = 
				(float)MIN2(.01,aa);

			hydro.pestrk[ipHi][ipLo] = EmisLines[ipH_LIKE][ipHYDROGEN][ipHi][ipLo].Aul*
			  hydro.pestrk[ipLo][ipHi];
		}
	}

	for( ipLo=1; ipLo < (NHE1LVL - 1); ipLo++ )
	{
		for( ipHi=ipLo + 1; ipHi < NHE1LVL; ipHi++ )
		{
			/* >>chng 00 dec 18, set to zero, had used hydrogenic As */
			he1str.peshe1[ipLo][ipHi] = 0.;
			he1str.peshe1[ipHi][ipLo] = 0.;
		}
	}


#	ifdef DEBUG_FUN
	fputs( " <->strk()\n", debug_fp );
#	endif
	return;
}

