/*timer time dependent models */
#include "cddefines.h"
#include "cooling.h"
#include "linesave.h"
#include "pressure.h"
#include "timefc.h"
#include "timed.h"
#include "heat.h"
#include "phycon.h"
#include "zonecnt.h"
#include "radius.h"
#include "rfield.h"
#include "stopcalc.h"
#include "called.h"
#include "converge.h"
#include "prtzone.h"
#include "lines.h"
#include "prtfinal.h"
#include "timer.h"

void timer(void)
{
	long int i;

	double psave, 
	  rad, 
	  time;
	static double change = 40.;

#	ifdef DEBUG_FUN
	fputs( "<+>timer()\n", debug_fp );
#	endif

	/* time dependent rec-col behind shock with no radiation.
	 * initial conditions set by physical conditions in last zone */
	rfield.nflux = -1;
	time = 0.;
	/* this is the flag that will be used to say time-dep model */
	timed.itime = -1;
	rad = 0.;
	PrtZone();
	nzone = 1;
	timefcCom.timefc = 1.;
	heat.power = 0.;
	cooling.totcol = 0.;
	cooling.GrossHeat = 0.;
	heat.htot = PressureTotalDo()*1.5;
	psave = heat.htot;

	if( called.lgTalk )
	{
		fprintf( ioQQQ, "1                              TIME DEPENDENT MODEL OF ZONE%3ld THERMAL ENERGY=%10.3e\n", 
		  timed.itime, psave );
	}

	/* clear out line array */
	for( i=0; i < LineSave.nsum; i++ )
	{
		LineSv[i].sumlin = 0.;
	}

	/*-------------------------------------------------------------------
	 * choose dt to 1/change of cooling time
	 * continue until TE drops below TEND */
	while( phycon.te > StopCalc.tend )
	{
		timed.dt = (float)(heat.htot/cooling.ctot/change);

		/* heavy elements
		 * call carbon
		 * call nitrog
		 * call oxygen
		 * call neon
		 * call magnes
		 * call alumin
		 * call silicn
		 * call sulphr
		 * call clrine
		 * call argoni
		 * call calcm
		 * call iron
		 * call cobalt
		 * call nickel
		 *
		 * get new electron density, find emission spectrum and rATE */

		radius.drad = timed.dt;
		lines();

		radius.depth = time;

		if( (nzone/ZoneCnt.nprint)*ZoneCnt.nprint == nzone )
			PrtZone();

		nzone += 1;
		heat.htot += -cooling.ctot*timed.dt;

		if( heat.htot < 0. )
		{
			if( called.lgTalk )
				{
				fprintf( ioQQQ, " htot is <0, htot, ctot, dt=%12.3e%12.3e%12.3e\n", 
				  heat.htot, cooling.ctot, timed.dt );
				}
			puts( "[Stop in timer]" );
			cdEXIT(EXIT_FAILURE);
		}

		phycon.te = phycon.te*(float)(heat.htot/(heat.htot + cooling.ctot*timed.dt));
		rad += cooling.ctot*timed.dt;
		time += timed.dt;

		/* following for density changing with time */
		timefcCom.timefc = 1.;

		/* if( tmpwr.eq.0. ) go to4 */
		if( timed.tmpwr != 0. )
		{
			timefcCom.timefc = (float)pow((timed.tmt1 + timed.dt)/timed.tmt1,timed.tmpwr);
			strcpy( pressure.chCPres, "TIME" );
			PressureChange(FALSE);
			timed.tmt1 += timed.dt;
			heat.htot *= timefcCom.timefc;
		}
	}

	heat.power = psave;
	cooling.totcol = rad;
	PrtZone();
	PrtFinal();


#	ifdef DEBUG_FUN
	fputs( " <->timer()\n", debug_fp );
#	endif
	return;
}

