/*TrimStages raise or lower most extreme stages of ionization considered,
 * called by ConvIonizeOpacityDo */
#include "cddefines.h"
#include "ionfracs.h"
#include "ionrange.h"
#include "heavy.h"
#include "rfield.h"
#include "abundances.h"
#include "heat.h"
#include "trimstages.h"

void TrimStages(
	/* nelem is on the C scale, 0 for H, 5 for C */
	long int nelem )
{

	/* this will remember that higher stages trimed up or down */
	int lgHi_Down = FALSE;
	int lgHi_Up = FALSE;
	/* this will remember that lower stages trimed up or own*/
	int lgLo_Up = FALSE;
	int lgLo_Down = FALSE;
	long int ion_lo_save = IonRange.IonLow[nelem],
		ion_hi_save = IonRange.IonHigh[nelem];

#	ifdef DEBUG_FUN
	fputs( "<+>TrimStages()\n", debug_fp );
#	endif

	/*confirm all numbers are within their range of validity */
	ASSERT( nelem >= 0 && nelem < LIMELM );
	ASSERT( IonRange.IonLow[nelem] >= 0 );
	ASSERT( IonRange.IonHigh[nelem] <= nelem+1 );
	/* IonHigh can be equal to IonLow if both are zero - no ionization*/
	ASSERT( IonRange.IonLow[nelem] < IonRange.IonHigh[nelem] || 
		(IonRange.IonLow[nelem]==0 && IonRange.IonHigh[nelem]==0 )  );

	/* raise or lower highest and lowest stages of ionization to
	 * consider only significant stages
	 * IonLow[nelem] lowest stage of ionization on C scale, atom == 0
	 * IonHigh[nelem]  stage of ionization
	 *
	 * NB  NB  NB  NB  xIonFracs must have 1 added to above to get over tot abund */

	/* special - trim down upper stages trim if they have essentially zero abundance */
	while( 
		(xIonFracs[nelem][IonRange.IonHigh[nelem]]/abundances.gas_phase[nelem] < SMALLFLOAT || 
		/* >>chng 02 feb 06, add this check, which can only happen in exotic models
		 * at startup.  This index is safe since IonHigh is always at least 1.  At worst
		 * test will check abundance of element, which is 0 element of IonFracs */
		xIonFracs[nelem][IonRange.IonHigh[nelem]-1]/abundances.gas_phase[nelem] < SMALLFLOAT || 
		xIonFracs[nelem][IonRange.IonHigh[nelem]] < SMALLFLOAT || 
		xIonFracs[nelem][IonRange.IonHigh[nelem]-1] < SMALLFLOAT) && 
		/* >>chng 02 may 12, rm +1 since this had effect of not allowing fully atomic */
		IonRange.IonHigh[nelem] > IonRange.IonLow[nelem] )
		/*IonRange.IonHigh[nelem] > IonRange.IonLow[nelem] + 1 )*/
	{
		/* xIonFracs(nelem,i) is density of ith ionization stage (cm^-3) */
		/* the -2 is correct, -1 since atom of ion is what heats, and another -1 since
		 * scale for xIonFracs is offset by one from heating array */
		xIonFracs[nelem][IonRange.IonHigh[nelem]] = 0.;
		heat.heating[nelem][IonRange.IonHigh[nelem]-1] = 0.;

		/* decrement high stage limit */
		--IonRange.IonHigh[nelem];
		/* remember this happened */
		lgHi_Down = TRUE;
	}

	/* >>chng 01 aug 02, add logic to trim up zero abundances */
	/* special - trim up lower stages trim if they have essentially zero abundance */
	/* >>chng 02 feb 06, add check on true density */
	while( 
		(xIonFracs[nelem][IonRange.IonLow[nelem]]/abundances.gas_phase[nelem] < SMALLFLOAT || 
		xIonFracs[nelem][IonRange.IonLow[nelem]] < SMALLFLOAT ) && 
		IonRange.IonLow[nelem] < IonRange.IonHigh[nelem] - 1 )
	{
		/* xIonFracs[nelem][i] is density of ith ionization stage (cm^-3) */
		/* the -2 is correct, -1 since atom of ion is what heats, and another -1 since
		 * scale for xIonFracs is offset by one from heating array */
		xIonFracs[nelem][IonRange.IonLow[nelem]] = 0.;
		/* >>chng 01 aug 04, remove -1 which clobbers heat.heating when IonLow == 0 */
		/*heat.heating[nelem][IonRange.IonLow[nelem]-1] = 0.;*/
		heat.heating[nelem][IonRange.IonLow[nelem]] = 0.;

		/* decrement high stage limit */
		++IonRange.IonLow[nelem];
		lgLo_Up = TRUE;
	}

	/* sanity check */
	/* IonHigh can be equal to IonLow if both are zero - no ionization*/
	ASSERT( IonRange.IonLow[nelem] < IonRange.IonHigh[nelem] || 
		(IonRange.IonLow[nelem]==0 && IonRange.IonHigh[nelem]==0 )  );

	/* trim down high stages that have too small an abundance */
	/* >>chng 01 apr 21, last comparison had been IonHigh > 2, change to relative to IonLow */
	if( 
		(!IonRange.lgNoDec &&
		xIonFracs[nelem][IonRange.IonHigh[nelem]]/abundances.gas_phase[nelem] <= (float)IonRange.trimhi) && 
		IonRange.IonHigh[nelem] > IonRange.IonLow[nelem]+1  )
	{
		xIonFracs[nelem][IonRange.IonHigh[nelem]] = 0.;
		heat.heating[nelem][IonRange.IonHigh[nelem]-1] = 0.;
		--IonRange.IonHigh[nelem];
		lgHi_Down = TRUE;
	}

	/* >>chng 02 marf 24, this option added - previously code did not do increasing ionization*/
	/* option to trim up highest stages */
	/* only consider this if we are fairly deep into the model, there are
	 * unconsidered ionization stages above the current limit, and the upper
	 * stage was not just trimmed down,
	 * last test is to avoid this logic in vastly deep neutral zone */
	if(    (nzone > 10 )
		&& (IonRange.IonHigh[nelem]<nelem+1 )
		&& (!lgHi_Down )
		&& (xIonFracs[ipHYDROGEN][1]/abundances.gas_phase[ipHYDROGEN]>0.9 ) )
	{
		/* only raise highest stage if ionization potential of next highest stage is within
		 * continuum array and the abundance of the highest stage is significant */
		/* in this one, IonHigh+1 since want next higher stage of ionization */
		if( Heavy.Valence_IP_Ryd[nelem][IonRange.IonHigh[nelem]+1] < rfield.anu[rfield.nflux-1] &&
			/* in this one, IonHigh+1 because of offset of abundance scale, with [0] being atom*/
			xIonFracs[nelem][IonRange.IonHigh[nelem]]/abundances.gas_phase[nelem] > (float)MIN2(0.1,IonRange.trimhi*10000.) )  
		{
			/*fprintf(ioQQQ,"uuppp %li %li \n", nelem, IonRange.IonHigh[nelem] );*/
			/* raise highest level of ionization */
			++IonRange.IonHigh[nelem];
			lgHi_Up = TRUE;
			/* >>chng 01 aug 02, set this to zero so that sanity check elsewhere will be ok */
			xIonFracs[nelem][IonRange.IonHigh[nelem]] = SMALLFLOAT*10.f;
		}
	}

	/* sanity check */
	/* IonHigh can be equal to IonLow if both are zero - no ionization*/
	ASSERT( IonRange.IonLow[nelem] < IonRange.IonHigh[nelem] || 
		(IonRange.IonLow[nelem]==0 && IonRange.IonHigh[nelem]==0 )  );

	/* lower lowest stage of ionization if we have significant abundance at current lowest */
	if( xIonFracs[nelem][IonRange.IonLow[nelem]]/abundances.gas_phase[nelem] > 1e-3f && 
		IonRange.IonLow[nelem] > 0 )
	{
		/* lower lowest level of ionization */
		--IonRange.IonLow[nelem];
		lgLo_Down = TRUE;
		/* >>chng 01 aug 02, set this to zero so that sanity check elsewhere will be ok */
		xIonFracs[nelem][IonRange.IonLow[nelem]] = SMALLFLOAT;
	}

	/* raise lowest stage of ionization, but only if we are near illuminated face of cloud*/
	/* >>chng 01 aug 08, add test on nzones */
	/* >>chng 02 feb 07, this logic was inverted!  change from nzone > 1 to nzone < 10 */
	/*else if( nzone > 1 &&*/
	else if( nzone < 10 &&
		(xIonFracs[nelem][IonRange.IonLow[nelem]]/abundances.gas_phase[nelem] <= (float)IonRange.trimlo) && 
		(IonRange.IonLow[nelem] < (IonRange.IonHigh[nelem] - 2) ) )
	{
		/* raise lowest level of ionization */
		xIonFracs[nelem][IonRange.IonLow[nelem]] = 0.;
		/* no minus one in below since this is low bound, already bounds at atom */
		heat.heating[nelem][IonRange.IonLow[nelem]] = 0.;
		++IonRange.IonLow[nelem];
		lgLo_Up = TRUE;
	}

	/* sanity check */
	/* IonHigh can be equal to IonLow if both are zero - no ionization*/
	ASSERT( IonRange.IonLow[nelem] < IonRange.IonHigh[nelem] || 
		(IonRange.IonLow[nelem]==0 && IonRange.IonHigh[nelem]==0 )  );

	/* these are standard bounds checks that appear throughout this routine
	 * xIonFracs[IonLow+1] is first one with positive abundances
	 * 
	 * in case where lower ionization stage was just lowered the abundance
	 * was set to SMALLFLOAT so test must be < SMALLFLOAT */
	if( IonRange.IonLow[nelem] > 1 )
	{
		ASSERT( IonRange.IonLow[nelem] <= 1 ||
			xIonFracs[nelem][IonRange.IonLow[nelem]-1] == 0. );
	}

	ASSERT( xIonFracs[nelem][IonRange.IonLow[nelem]] >= SMALLFLOAT ||
		xIonFracs[nelem][IonRange.IonLow[nelem]]/abundances.gas_phase[nelem] >= SMALLFLOAT );

	{
		/* Experiment with calculating radial integrals myself.	*/
		/*@-redef@*/
		enum {DEBUG=FALSE};
		/*@+redef@*/

		if ( DEBUG && nelem == 8 )
		{
			if( lgHi_Down ||lgHi_Up ||lgLo_Up ||lgLo_Down )
			{
				fprintf(ioQQQ,"TrimZone\t%li\t",nzone );
				if(  lgHi_Down )
				{
					fprintf(ioQQQ,"high dn %li to %li",
						ion_hi_save , 
						IonRange.IonHigh[nelem] );
				}
				if( lgHi_Up )
				{
					fprintf(ioQQQ,"high up %li to %li",
						ion_hi_save , 
						IonRange.IonHigh[nelem] );
				}
				if( lgLo_Up )
				{
					fprintf(ioQQQ,"low up %li to %li",
						ion_lo_save , 
						IonRange.IonLow[nelem] );
				}
				if( lgLo_Down )
				{
					fprintf(ioQQQ,"low dn %li to %li",
						ion_lo_save , 
						IonRange.IonLow[nelem] );
				}
				fprintf(ioQQQ,"\n" );
			}
		}
	}


#	ifdef DEBUG_FUN
	fputs( " <->TrimStages()\n", debug_fp );
#	endif
	return;
}
