/*zero zero out or initialize variables, called by cdInit, but also by func during optimization,
 * this is called before any commands are parsed */
/*rfield_optac_zero zero out rfield arrays between certain limits */
#include "cddefines.h"
#include "physconst.h"
#include "hydrogenic.h"
#include "nfeii.h"
#include "punch.h"
#include "o3exc.h"
#include "dtmase.h"
#include "plwidth.h"
#include "doppvel.h"
#include "mgexc.h"
#include "testit.h"
#include "grain.h"
#include "rt.h"
#include "h2.h"
#include "linesave.h"
#include "dynamics.h"
#include "thermal.h"
#include "pmp2s.h"
#include "mean.h"
#include "helike.h"
#include "pop371.h"
#include "iso.h"
#include "tfidle.h"
#include "converge.h"
#include "ionrange.h"
#include "zonecnt.h"
#include "timesc.h"
#include "heots.h"
#include "peimbt.h"
#include "ionrec.h"
#include "continuum.h"
#include "phfit.h"
#include "fe2neg.h"
#include "punchskip.h"
#include "ionfracs.h"
#include "typmatrx.h"
#include "co.h"
#include "holod.h"
#include "insanity.h"
#include "fluct.h"
#include "physok.h"
#include "ca2mly.h"
#include "hevmolec.h"
#include "pca2ex.h"
#include "jmin.h"
#include "drneg.h"
#include "input.h"
#include "bit32.h"
#include "atom_oi.h"
#include "pressure.h"
#include "dndt.h"
#include "intalk.h"
#include "heatsum.h"
#include "stopcalc.h"
#include "numderiv.h"
#include "wind.h"
#include "negdrg.h"
#include "colden.h"
#include "stimax.h"
#include "hmi.h"
#include "dcala.h"
#include "heat.h"
#include "tehigh.h"
#include "nsbig.h"
#include "rfield.h"
#include "drminu.h"
#include "hemase.h"
#include "bndsok.h"
#include "habing.h"
#include "resion.h"
#include "the1lo.h"
#include "he3lines.h"
#include "chargtran.h"
#include "he.h"
#include "abundances.h"
#include "radius.h"
#include "opacity.h"
#include "neutrn.h"
#include "fe2tau.h"
#include "broke.h"
#include "max2pht.h"
#include "angllum.h"
#include "secondaries.h"
#include "called.h"
#include "phycon.h"
#include "aaaa.h"
#include "warnings.h"
#include "cooling.h"
#include "nhe1lvl.h"
#include "nhe3lvl.h"
#include "he1bn.h"
#include "he3bn.h"
#include "he3n.h"
#include "he3pht.h"
#include "he1dmp.h"
#include "fe2cool.h"
#include "fe4cool.h"
#include "zero.h"

void zero(void)
{
	long int i,
	  ion,
	  ipISO ,
	  nelem,
	  ns;

	/* this is used to signify the first call to this routine.  At that
	 * stage some memory has not been allocated so must not initialize */
	static int lgFirstCall = TRUE;

#	ifdef DEBUG_FUN
	fputs( "<+>zero()\n", debug_fp );
#	endif

	/* option to print numbers 
	fprintf(ioQQQ,"%.3e\n", sqrt(PI*2./BOLTZMANN)*POW2(H_BAR)/pow(ELECTRON_MASS, 1.5) );*/

	/* this routine is called exactly one time at the start of
	 * the calculation of a single model.  It is called before
	 * the boundary conditions are read in, and is never called again
	 * during that calculation.  When the code is used as a subroutine
	 * this routine is called first, when a specific model is initialized.
	 * All default variables that must be initialized before a calculation
	 * must appear in the routine.
	 */

	/* set version number */
	AAAA();

	/* these used to be in block data logic */
	Zerologic();

	/* set all initial abundances */
	ZeroAbund();

	/* zero out parameters needed by large FeII atom */
	FeIIZero();

	/* zero out warnings, cautions, notes, etc */
	wcnint();

	/* default line width for plots, in units of speed of light
	 * PunchLWidth = 1.
	 * >>chng 97 jul 10, from unity to 1000 km/sec */
	PLWidth.PunchLWidth = (float)(SPEEDLIGHT/1000.e5);

	/* limits for highest and lowest stages of ionization in TrimStage */
	IonRange.trimhi = 1e-6;
	IonRange.trimlo = 1e-10;

	/* change amgle of illumination */
	Angllum.AngleIllum = 1.;

	holod.fcool = 0.;
	holod.dfcool = 0.;
	holod.feheat = 0.;
	pmp2s.p1909 = 0.;
	pmp2s.p2326 = 0.;
	pmp2s.p1895 = 0.;
	pmp2s.p1666 = 0.;
	pmp2s.p1401 = 0.;

	/* this counts number of times ionize is called by PressureChange, in current zone
	 * these are reset here, so that we count from first zone not search */
	conv.nPres2Ioniz = 0;
	/* clear flag indicating the ionization convergence failures 
	 * have ever occured in current zone */
	conv.lgConvIonizThisZone = FALSE;

	/* tolerance in heating -  cooling balance */
	conv.HeatCoolRelError = 0.02f;

	conv.LimFail = 20;
	conv.lgMap = FALSE;

	/* true if level 2 lines were contributors to the ots rates, set in dimacool */
	conv.lgLevel2_OTS_Imp = TRUE;
	/* true if level 2 lines were contributors to the cooling, set in dimacool */
	conv.lgLevel2_Cool_Imp = TRUE;

	/* this counts how many times ionize is called in this model after startr,
	 * and is flag used by ionize to understand it is being called the first time*/
	conv.nTotalIoniz = 0;
	/* these are variables to remember the biggest error in the
	 * electron density, and the zone in qhich it occurred */
	conv.BigEdenError = 0.;
	conv.AverEdenError = 0.;
	conv.BigHeatCoolError = 0.;
	conv.AverHeatCoolError = 0.;
	conv.BigPressError = 0.;
	conv.AverPressError = 0.;
	strcpy( conv.chSolverEden , "simple" );
	/* this did not work - conserv.in failed 
	strcpy( conv.chSolverEden , "new" );*/
	strcpy( conv.chSolverTemp , "simple" );
	/* most models failed with impossible bracket to solver with this on,
	 * check blister.in for one 
	strcpy( conv.chSolverTemp , "new" );*/

	/* iterate to convergence flag */
	conv.lgAutoIt = FALSE;
	/* convergence criteria */
	conv.autocv = 0.20f;

	fluct.flong = 0.;
	fluct.flcPhase = 0.;

	/* this option, use the new rrfit recombination rates */
	PhFitOn.lgPhFit = FALSE;

	/* age of the cloud, to check for time-steady */
	timesc.CloudAgeSet = -1.f;
	/* some timescale for CO and H2 */
	timesc.AgeH2MoleDest = 0.;
	timesc.AgeCOMoleDest = 0.;
	timesc.BigH2MoleForm = 0.;
	timesc.BigCOMoleForm = 0.;
	timesc.TimeH21cm = 0.;

	peimbt.tsqden = 1e7;

	/* CO related variables */
	co.codfrc = 0.;
	co.codtot = 0.;
	co.CODissHeat = 0.;
	/* the limit to the amount of CO */
	co.COLimit = 0.80f;
	/* flag saying model stopped due to too much co */
	co.lgLotsCO = FALSE;
	/* the CO molecule */
	co.lgComNeg = FALSE;
	co.COCoolBigFrac = 0.;
	co.lgCOCoolCaped = FALSE;
	/* largest fraction of C atoms in CO */
	co.CarMolFrac = -1.f;

	NumDeriv.lgNumDeriv = FALSE;
	fluct.lgDenFluc = TRUE;
	/* nsum is line pointer within large stack of line intensities */
	LineSave.nsum = 0;

	/* this is scale factor, reset with set resoluton command, for setting
	 * the continuum resolution.  Setting to 0.1 will increase resolution by 10x.
	 * this multiplies the resolution contained in the continuum_mesh.dat file */
	continuum.ResolutionScaleFactor = 1.;

	/* set of variables used to control punch command */
	punch.npunch = 0;
	punch.cp_npun = 0;
	punch.lgPunContinuum = FALSE;
	punch.lgHashEndIter = TRUE;
	punch.lgDRPLst = FALSE;

	/* free free heating, cooling, net */
	hydro.FreeFreeCool = 0.;
	hydro.FreeFreeHeat = 0.;
	hydro.HFFNet = 0.;

	hydro.cintot = 0.;

	/* option to print emissivity instead of intensity/luminosity */
	hydro.lgHydEmiss = FALSE;
	hydro.lgHiPop2 = FALSE;
	hydro.pop2mx = 0.;
	hydro.lgHLyaMased = FALSE;

	/* flag for Lya masing */
	hydro.xLaMase = 0.;
	hydro.HCollIonMax = 0.;

	/* hydrogen redistribution functions */
	hydro.ipLya = ipPRD;
	hydro.ipReso = ipCRD;
	hydro.ipSub = ipCRDW;

	/* this is flag indicating which type of model atom to use, 
	 * set with atom hydrogen populations, departure, lowt */
	/* >>chng 02 mar 13, this had been set to POPU which had the effect
	 * of forcing the populations solution even for very extreme low ionization.
	 * a few models did have neg pops as a result.  There was no reason given for the
	 * change nor was a time stamp present.  So, the code had been running without
	 * this protection for some time.  Changed back to none here, to enable the
	 * test in hydrolevel, and also made limits there much more stringent (since
	 * they had (unintentionally?) been very stringent for some time now). */
	/*strcpy( hydro.chTypeAtom , "POPU" );*/
	strcpy( hydro.chTypeAtom , "none" );

	/* type of hydrogen atom topoff, options are " add" and "scal" 
	 * in versions 90 this was " add", but was "scal" in 91
	 * >>chng 99 jan 16, changed back to " add"*/
	/*strcpy( hydro.chHTopType, "scal" );*/
	strcpy( hydro.chHTopType, " add" );

	/* Lya excitation temperature, counter for hotter than gas */
	hydro.TexcLya = 0.;
	hydro.TLyaMax = 0.;
	hydro.nLyaHot = 0;

	/* >>refer	abundance	D/H	Pettini, M., & Bowen, D.V., 2001, ApJ, 560, 41 */
	/* quoted error is +/- 0.35 */
	hydro.D2H_ratio = 1.65e-5;

	/* for totally forbidden He lines this will be the A */
	helike.SmallA = 1e-20f;

	 /* flag set by compile he-like command, says to regenerate table of recombination coef */
	helike.lgCompileRecomb = FALSE;

	/* flag saying whether to use a set of physics meant to 
	 * replicate the Benjamin et al. HeI results,
	 * set with ATOM HE-LIKE BENJAMIN command */
	helike.lgSetBenjamin = FALSE;

	/* default is to use old helium atom */
	helike.lgUseOld = FALSE;/*this one - use new atom */
	helike.lgUseOld = TRUE;/*this one - use old atom */

	rt.DoubleTau = 1.;
	rt.lgFstOn = TRUE;
	rt.lgElecScatEscape = TRUE;
	rfield.SumOutCon = 0.;
	rfield.SumIncCon = 0.;
	/* rfield.DiffPumpOn is unity unless process disabled by setting to 1
	 * with no diffuse line pumping command */
	rfield.DiffPumpOn = 1.;

	/* which matrix inversion routine to use */
	strcpy( TypMatrx.chMatrix, "linpack" );

	/* the h2 molecule */
	h2.H2_to_H_limit = 1e-4;
	h2.lgH2ON = FALSE;
	if( !lgH2_READ_DATA )
	{
		/* the number of electronic levels in the H2 molecule,
		 * this is enough to do the Lyman and Werner bands -
		 * reset with atom h2 levels command */
		h2.nelec = 3;
	}

	/**********************************************************************
	 * all parameters having to do with secondary ionization 
	 * by suprathermal electrons 
	 **********************************************************************/
	Secondaries.SetCsupra = 0.;
	Secondaries.lgCSetOn = FALSE;
	Secondaries.lgSecOFF = FALSE;
	Secondaries.SecHIonMax = 0.;

	Secondaries.heatef = 1.;
	Secondaries.efionz = 0.;
	Secondaries.exctef = 0.;
	Secondaries.csupra = 0.;
	Secondaries.x12tot = 0.;
	Secondaries.sec2total = 0.;

	for( nelem=0; nelem< LIMELM; ++nelem )
	{
		Secondaries.Hx12[0][nelem] = 0.;
		Secondaries.Hx12[1][nelem] = 0.;
	}
	Secondaries.Hx12[0][LIMELM] = 0.;
	Secondaries.Hx12[1][LIMELM] = 0.;

	/* on first call, these arrays do not exist, only zero here on 
	 * second and later calls, on first call, create them */
	if( lgFirstCall )
	{
		/* these will save bound electron recoil information data */
		if( (ionrec.ipCompRecoil = 
			(long**)MALLOC(sizeof(long*)*(unsigned)LIMELM ))==NULL )
			bad_malloc();
		if( (ionrec.CompRecoilIonRate = 
			(double**)MALLOC(sizeof(double*)*(unsigned)LIMELM ))==NULL )
			bad_malloc();
		if( (ionrec.CompRecoilIonRateSave = 
			(double**)MALLOC(sizeof(double*)*(unsigned)LIMELM ))==NULL )
			bad_malloc();
		if( (ionrec.CompRecoilHeatRate = 
			(double**)MALLOC(sizeof(double*)*(unsigned)LIMELM ))==NULL )
			bad_malloc();
		if( (ionrec.CompRecoilHeatRateSave = 
			(double**)MALLOC(sizeof(double*)*(unsigned)LIMELM ))==NULL )
			bad_malloc();
		if( (ionrec.PhotoRate_Ground = 
			(double****)MALLOC(sizeof(double***)*(unsigned)LIMELM ))==NULL )
			bad_malloc();
		if( (ionrec.CollIonRate_Ground = 
			(double***)MALLOC(sizeof(double**)*(unsigned)LIMELM ))==NULL )
			bad_malloc();
		/* now flus out the recoil arrays */
		for(nelem=0; nelem<LIMELM; ++nelem )
		{
			if( (ionrec.ipCompRecoil[nelem] = 
				(long*)MALLOC(sizeof(long)*(unsigned)(nelem+1) ))==NULL )
				bad_malloc();
			if( (ionrec.CompRecoilIonRate[nelem] = 
				(double*)MALLOC(sizeof(double)*(unsigned)(nelem+1) ))==NULL )
				bad_malloc();
			if( (ionrec.CompRecoilIonRateSave[nelem] = 
				(double*)MALLOC(sizeof(double)*(unsigned)(nelem+1) ))==NULL )
				bad_malloc();
			if( (ionrec.CompRecoilHeatRate[nelem] = 
				(double*)MALLOC(sizeof(double)*(unsigned)(nelem+1) ))==NULL )
				bad_malloc();
			if( (ionrec.CompRecoilHeatRateSave[nelem] = 
				(double*)MALLOC(sizeof(double)*(unsigned)(nelem+1) ))==NULL )
				bad_malloc();
			if( (ionrec.PhotoRate_Ground[nelem] = 
				(double***)MALLOC(sizeof(double**)*(unsigned)(nelem+1) ))==NULL )
				bad_malloc();
			if( (ionrec.CollIonRate_Ground[nelem] = 
				(double**)MALLOC(sizeof(double*)*(unsigned)(nelem+1) ))==NULL )
				bad_malloc();

			for( ion=0; ion<nelem+1; ++ion )
			{
				if( (ionrec.PhotoRate_Ground[nelem][ion] = 
					(double**)MALLOC(sizeof(double*)*(unsigned)NSHELLS ))==NULL )
					bad_malloc();
				if( (ionrec.CollIonRate_Ground[nelem][ion] = 
					(double*)MALLOC(sizeof(double)*(unsigned)2 ))==NULL )
					bad_malloc();
				for( ns=0; ns<NSHELLS; ++ns )
				{
					if( (ionrec.PhotoRate_Ground[nelem][ion][ns] = 
						(double*)MALLOC(sizeof(double)*(unsigned)3 ))==NULL )
						bad_malloc();
				}
				ionrec.ipCompRecoil[nelem][ion] = -100000;
			}
		}
	}

	for( nelem=0; nelem< LIMELM; ++nelem )
	{
		for( ion=0; ion<nelem+1; ++ion )
		{
			ionrec.CompRecoilIonRate[nelem][ion] = 0.;
			ionrec.CompRecoilHeatRate[nelem][ion] = 0.;
			ionrec.CollIonRate_Ground[nelem][ion][0] = 0.;
			ionrec.CollIonRate_Ground[nelem][ion][1] = 0.;
			for( ns=0; ns < NSHELLS; ++ns )
			{
				/* must be zero since ion routines use these when
				 * not yet defined */
				ionrec.PhotoRate_Ground[nelem][ion][ns][0] = 0.;
				ionrec.PhotoRate_Ground[nelem][ion][ns][1] = 0.;
				ionrec.PhotoRate_Ground[nelem][ion][ns][2] = 0.;
			}
		}
	}
	ionrec.lgPhotoIoniz_On = TRUE;
	ionrec.lgCompRecoil = TRUE;

	/**********************************************************************
	 * these are options to print errors to special window,
	 * set with print errors command, 
	 * output will go to standard error
	 * defined in cdInit 
	 **********************************************************************/
	lgPrnErr = FALSE;
	ioPrnErr = stderr;

	Max2Pht.xMax2Pht = 0.;
	Fe2Neg.nFe2Neg = 0;

	/* turn off flag for insane goings */
	insanity.lgInsane = FALSE;

	/* punch every one continuum point */
	PunchSkip.ncPunchSkip = 1;

	/* the code is ok at startup */
	broke.lgBroke = FALSE;
	broke.lgFixit = FALSE;
	broke.lgCheckit = FALSE;

	/* the ipSolar array is a set of pointers used for reading
	 * in abundances with the "abundances" command
	 * the hydrogen abundance of unity is not read in */
	abundances.npSolar = LIMELM - 1;
	for( i=0; i < abundances.npSolar; i++ )
	{
		abundances.ipSolar[i] = i + 2;
	}

	/* turn element on if this is first call to this routine,
	 * but do not reset otherwise since would clobber how elements were set up */
	{
		static int nCalled = 0;
		if( nCalled == 0 )
		{
			for( nelem=0; nelem < LIMELM; nelem++ )
			{
				/* never turn on element if turned off on first iteration */
				abundances.lgElmtOn[nelem] = TRUE;

				/* option to set ionization with element ioniz cmnd,
				* default (FALSE) is to solve for ionization */
				abundances.lgSetIoniz[nelem] = FALSE;
			}
		}
		++nCalled;
	}

	/* this is the simple fred hamann feii atom */
	for( i=0; i < NFEII; i++ )
	{
		fe2tau.Fe2PopLte[i] = 0.;
		fe2tau.feopc[i] = 0.;
		fe2tau.Fe2TauLte[i] = opac.taumin;
	}

	/* zero out volume and column density save arrays */
	MeanZero();

	rfield.lgInducProcess = TRUE;
	physok.lgPhysOK = TRUE;

	/* parameters to do with wind */
	wind.lgWindOK = TRUE;
	wind.windv0 = 0.;
	wind.comass = 0.;
	wind.windv = 0.;
	wind.emdot = 0.;
	wind.AccelAver = 0.;
	wind.acldr = 0.;
	wind.agrav = 0.;
	wind.AccelTot = 0.;
	wind.AccelCont = 0.;
	wind.AccelLine = 0.;
	wind.AccelPres = 0.;
	wind.AccelMax = 0.;
	wind.fmul = 0.;
	wind.lgVelPos = TRUE;

	/* zero out heating rates */
	HeatZero();

	/* main arrays to save ionization fractions*/
	for( nelem=0; nelem < LIMELM; nelem++ )
	{
		abundances.gas_phase[nelem] = 0.;
		xMolFracs[nelem] = 0.;
		for( ion=0; ion < LIMELM+1; ion++ )
		{
			xIonFracs[nelem][ion] = 0.;
		}
	}

	ca2mly.Ca2RmLya = 0.;
	pca2ex.popca2ex = 0.;


	/* zero out molecular species */
	for( i=0; i < NHEVML; i++ )
	{
		hevmolec.hevmol[i] = 0.;
		hevmolec.hevcol[i] = 0.;
	}
	/* ratio of C12O16 to C13O16 */
	hevmolec.RatioC12O16_2_C13O16 = 30.;

	/* flag saying that H2O water dest rate went to zero */
	hevmolec.lgH2Ozer = FALSE;

	jmin.rjnmin = FLT_MAX;
	jmin.ajmmin = FLT_MAX;
	drneg.lgDrNeg = FALSE;

	/* this is the default allowed relative error in the electron density */
	phycon.EdenError = 0.01f;

	/* extra electron density, set with eden command */
	phycon.EdenExtra = 0.;

	/* forced electron density, set with set eden command */
	phycon.EdenSet = 0.;

	/* this is the default allowed relative error in the pressure */
	phycon.PressureError = 0.01f;

	/* try toe predict next zone's temperature in constant density models,
	 * as done in StartZone.  Turned off with no tepred command */
	phycon.lgPredNextTe = TRUE;

	/* had to move above up here to prevent ms c from using double without
	 * doing store*/
	phycon.EdenFFSum = 0.;

	/* some titles and line images */
	for( i=0; i<74; ++i)
	{
		input.chTitle[i] = ' ';
	}
	input.chTitle[75] = '\0';

	/* velocity field information */
	/* the turbulent velocity at illuminated face, internall in cm/s,
	 * but entered with turbulence command in km/s */
	DoppVel.TurbVel = 0.;
	/* The scale in cm over which the turbulence is dissipated.  Normally 0,
	 * only set if dissipate keyword appears on turbulence command */
	DoppVel.DispScale = 0.;

	/* flag for constant pressure, include continuum too */
	pressure.lgConPres = TRUE;
	/* pressure related variables */
	pressure.PresInteg = 0.;
	pressure.pinzon = 0.;

	pressure.lgRadPresON = FALSE;
	pressure.PressureRam = 0.;
	pressure.PressureRadiation = 0.;
	pressure.lgPradCap = FALSE;
	pressure.lgPradDen = FALSE;
	pressure.lgRadPrsON = TRUE;
	/* normally abort when radiation pressure exceeds gas pressure in const pres mod,
	 * this is option to keep going, set with NO ABORT on constant pressure command */
	pressure.lgRadPresAbortOK = TRUE;
	strcpy( pressure.chCPres, "CDEN" );
	/* this flag will say we hit the sonic point */
	pressure.lgSonicPoint = FALSE;

	pressure.RadBetaMax = 0.;
	pressure.PresMax = 0.;

	/* zero out some dynamics variables */
	DynaZero();

	/* check whether this is a 32-bit machine
	 * use te in common, which forc will translate as a float.
	 * then set te after test */
	/* check whether this is a 32-bit machine
	 * use te in common, which forc will translate as a float.
	 * then set te after test */
	phycon.te = 1e-37f;
	phycon.te /= 1e40;
	if( phycon.te == 0. )
	{
		bit32.lgBit32 = TRUE;
	}
	else
	{
		bit32.lgBit32 = FALSE;
	}

	/* now set physical conditions array */
	phycon.te = 1e4;
	phycon.sqrte = 100.;
	phycon.eden = 1.;
	/* >>chng 02 feb 28, this was set to 1 here, and to -99 in zerologic, so that
	 * check whether hden was specified was defeated.  Reset to correct -99. here.*/
	phycon.hden = -99.;
	phycon.TotalNuclei = 1.;
	/* following will force updaing all temperature variables */
	tfidle(TRUE);

	atom_oi.nNegOI = 0;
	for( i=0; i< N_OI_LEVELS; ++i )
	{
		atom_oi.popoi[i] = 0.;
	}

	/* do we want to punch negative opacities */
	opac.lgNegOpacIO = FALSE;

	/* this is flag for turning on case b */
	opac.lgCaseB = FALSE;

	/* this is separate flag for turning off collisions from n=2 */
	opac.lgCaseB_HummerStorey = FALSE;

	/* this is separate flag for turning off excited state photoionization */
	opac.lgCaseB_no_photo = FALSE;

	strcpy( opac.chOpcTyp, "    " );

	/* smallest allowed line and Lya optical depths, reset with
	 * caseb command */
	opac.taumin = 1e-20f;
	opac.tlamin = 1e-20f;

	opac.otsmin = 0.;

	/* this flag says to use the static opacities,
	 * only evaluate them at start of each new zone.
	 * when set false with 
	 * no static opacities
	 * command, always reevalute them */
	opac.lgOpacStatic =  TRUE;

	/* set true in radinc if negative opacites ever occur */
	opac.lgOpacNeg = FALSE;

	/* can turn of scattering opacities for some geometries */
	opac.lgScatON = TRUE;

	/* >>chng 01 jul 26, moved next statement from below loop to avoid bug in gcc 2.95.3, PvH */
	/* default diffuse fields is outward only */
	strcpy( rfield.chDffTrns, "OU2" );

	rfield_opac_zero( 0 , rfield.nupper );

	/* strcpy( rfield.chDffTrns, "OU2" ); */
	rfield.lgOutOnly = TRUE;

	/* variables having to do with compiling and/or using the
	 * ancillary file of stored opacities */
	opac.lgCompileOpac = FALSE;
	/* "no file opacity" command sets following var false, says not to use file */
	/*TODO file opacities are disabled for now - reinstate this when arrays settle down */
	opac.lgUseFileOpac = FALSE;

	opac.telec = opac.taumin;
	opac.thmin = opac.taumin;

	opac.tpcah[0] = opac.taumin;
	opac.tpcah[1] = 1e20f;

	opac.lgTauOutOn = FALSE;

	dndt.dDensityDT = 0.;
	resion.otsfe2 = 0.;
	negdrg.lgNegGrnDrg = FALSE;
	thermal.nUnstable = 0;
	thermal.lgUnstable = FALSE;

	/* various criteria for stopping model */
	StopCalc.tauend = 0.;
	StopCalc.taunu = 0.;
	StopCalc.iptnu = -1;
	/* highest allowed temperature */
	StopCalc.T2High = 1e12f;
	/* highest and lowest temperatues to ever allow */
	StopCalc.TeHighest = 1e10f;
	StopCalc.TeLowest = 2.8f;
	/* the floor sets a limit to the temperature in the calculation -
	 * if te falls below this, we do a constant temperature cloud at
	 * this temperature */
	StopCalc.TeFloor = 0.;
	/* stopping temperature */
	StopCalc.tend = 4000.;
	/* stop electron fraction, usually not used */
	StopCalc.StopElecFrac = -FLT_MAX;
	/* ending column densities */
	StopCalc.HColStop = 1e30f;
	StopCalc.colpls = 1e30f;
	StopCalc.colnut = 1e30f;
	StopCalc.StopElecDensity = -1e30f;

	/* limits to stop line command */
	StopCalc.nstpl = 0;
	for( i=0; i < MXSTPL; i++ )
	{
		StopCalc.stpint[i] = FLT_MAX;
		StopCalc.ipStopLin1[i] = 0;
		StopCalc.ipStopLin2[i] = 0;
		StopCalc.StopLineWl[i] = 0;
		StopCalc.StopLineWl2[i] = 0;
		strcpy(StopCalc.chStopLabel[i] , "none" );
		strcpy(StopCalc.chStopLabel2[i] , "none" );
	}

	neutrn.frcneu = 0.;
	neutrn.effneu = 1.;
	neutrn.totneu = 0.;
	neutrn.lgNeutrnHeatOn = FALSE;

	hemase.lgHeMase = FALSE;
	rfield.lgUSphON = FALSE;
	stimaxCom.stimax[0] = 0.;
	stimaxCom.stimax[1] = 0.;

	hmi.htwo = 0.;
	hmi.h2plus = 0.;
	hmi.h3plus = 0.;
	hmi.htwo_star = 0.;
	hmi.hminus = 0.;
	hmi.hmihet = 0.;
	hmi.HeatH2DexcMax = 0.;
	hmi.hmitot = 0.;
	hmi.H2Opacity = 0.;
	hmi.hmidep = 1.;
	hmi.h2dep = 1.;
	hmi.h2pdep = 1.;
	hmi.h3pdep = 1.;
	hmi.BiggestH2 = -1.f;
	hmi.lgAll_H2 = FALSE;

	dcala.oldcla = 0.;
	dcala.Ca3d = 0.;
	dcala.Ca4p = 0.;
	dcala.dstCala = 0.;

	/* zero out some column densities */
	for( i=0; i < NCOLD; i++ )
	{
		coldenCom.colden[i] = 0.;
	}
	for( i=0; i < 5; i++ )
	{
		coldenCom.C2Pops[i] = 0.;
		coldenCom.C2Colden[i] = 0.;
	}

	/* these are the low and high energy bounds of the continuum */
	rfield.emm = 1.001e-8f;
	rfield.egamry = 7.354e6f;

	rfield.nflux = rfield.nupper;

	/* where cloud is optically thick to brems */
	rfield.ipEnergyBremsThin = 0;
	rfield.EnergyBremsThin = 0.;

	/* this is the faintest the high-energy tail of the continuum be */
	rfield.FluxFaint = 1e-10f;

	for( i=0; i < LIMSPC; i++ )
	{
		/* range(i,1) = 1.
		 * >>chng 96 dec 18, from inf mass ryd to H mass ryg */
		rfield.range[0][i] = HIONPOT;
		rfield.range[1][i] = rfield.egamry;
		rfield.ioTableRead[i] = NULL;
	}
	rfield.comtot = 0.;
	rfield.comoff = 1.;
	rfield.cmcool = 0.;
	rfield.cinrat = 0.;

	/* reset some variable related to cooling */
	colzro();
	cooling.lgColNeg = TRUE;
	cooling.lgCNegChk = TRUE;
	cooling.CoolHeatMax = 0.;
	cooling.wlCoolHeatMax = 0;
	cooling.totcol = 0.;
	cooling.GrossHeat = 0.;
	cooling.heatl = 0.;
	cooling.coolheat = 0.;
	cooling.lgCExtraOn = FALSE;
	cooling.CoolExtra = 0.;
	cooling.ctot = 1.;

	heat.HeatNet = 0.;
	heat.htot = 1.;

	heat.power = 0.;

	radius.rinner = 0.;
	radius.distance = 0.;
	radius.Radius = 0.;
	radius.lgRadiusKnown = FALSE;
	radius.drad = 0.;
	radius.depth = 1e-30;
	radius.r1r0sq = 1.;
	/* this is changed with the roberto command, to go from out to in */
	radius.dRadSign = 1.;
	/* RDFALT is log of default starting radius (cm) */
	radius.rdfalt = 25.;

	/* set default cylinder thickness */
	radius.CylindHigh = 1e35f;
	radius.lgCylnOn = FALSE;

	radius.dReff = 1.;
	radius.dVeff = 1.;
	radius.dRNeff = 1.;
	radius.lgdR2Small = FALSE;

	radius.glbdst = 0.;
	radius.glbrad = 0.;

	radius.sdrmin = SMALLFLOAT;
	radius.sdrmax = 1e30f;
	radius.lgSMinON = FALSE;

	nzone = 0;
	ZoneCnt.nprint = 1000;
	ZoneCnt.lgZoneSet = FALSE;
	ZoneCnt.lgZoneTrp = FALSE;
	ZoneCnt.lgEndDflt = TRUE;

	/* this is default number of zones
	 * >>chng 96 jun 5, from 400 to 500 for thickes corners4 grid */
	ZoneCnt.nEndDflt = 600;

	for( i=0; i < ITRDIM; i++ )
	{
		ZoneCnt.nend[i] = ZoneCnt.nEndDflt;
		radius.router[i] = 1e30;
	}

	heots.esc584 = 0.;
	heots.esc626 = 0.;
	heots.esc911 = 0.;
	heots.esc910 = 0.;
	heots.esc610 = 0.;
	heots.esc660 = 0.;

	/* save initial condition for talk in case PRINT LAST used */
	intalk.lgInTalk = called.lgTalk;

	/* flags for whether continuum is defined over all energies */
	bndsok.lgMMok = TRUE;
	bndsok.lgHPhtOK = TRUE;
	bndsok.lgXRayOK = TRUE;
	bndsok.lgGamrOK = TRUE;

	tehigh.thist = 0.;
	tehigh.tlowst = 1e20f;
	nsbigCom.nsbig = 0;

	habing.lgHabing = FALSE;

	drminu.lgDrMinUsed = FALSE;

	resion.otsfe2 = 0.;

	mgexc.popmg2 = 0.;
	mgexc.rmg2l = 0.;
	o3exc.poiii2 = 0.;
	o3exc.poiii3 = 0.;
	o3exc.poiexc = 0.;

	the1loCom.the1lo = 1000.;
	the1loCom.nhe1lo = 0;

	he3lines.pht2s = 0.;
	he3lines.p2s = 0.;
	he3lines.p2p = 0.;
	he3lines.p3s = 0.;
	he3lines.p3p = 0.;
	he3lines.p3d = 0.;
	he3lines.p10830 = 0.;
	he3lines.p5876 = 0.;
	he3lines.p7065 = 0.;
	he3lines.p3889 = 0.;
	he3lines.he3clx = 0.;
	o3exc.d5007r = 0.;
	o3exc.d5007t = 0.;
	o3exc.d4363 = 0.;
	o3exc.d6300 = 0.;

	/***************************************************
	 * charge transfer ionization and recombination 
	 ***************************************************/
	/* HCharHeatMax, HCharCoolMax are largest fractions of heating in cur zone
	 * or cooling due to ct */
	ChargTran.HCharHeatMax = 0.;
	ChargTran.HCharCoolMax = 0.;

	ChargTran.HIonFrac = 0.;
	ChargTran.HCharExcIonTotal = 0.;
	ChargTran.HIonFracMax = 0.;
	ChargTran.HCharExcRecTotal = 0.;
	/* option to turn off H charge transfer ionization, set to zero, with no charge transfer command */
	ChargTran.HCTOn = 1.;

	/* flag saying that charge transfer heating should be included,
	 * turned off with no CTHeat commmand */
	ChargTran.HCharHeatOn = 1.;
	for( nelem=0; nelem< LIMELM; ++nelem )
	{
		for( ion=0; ion<LIMELM; ++ion )
		{
			ChargTran.HCharExcIon[nelem][ion] = 0.;
			ChargTran.HCharExcRec[nelem][ion] = 0.;
		}
	}

	/* >>chng 97 jan 6, from 0 to 8.5e-10*q as per Alex Dalgarno e-mail
	 * >>chng 97 feb 6, from 8.5e-10*q 1.92e-9x as per Alex Dalgarno e-mail */
	ChargTran.HCTAlex = 1.92e-9;

	he.hei3 = 0.;
	he.hei1 = 0.;

	for( nelem=0; nelem < LIMELM; nelem++ )
	{
		abundances.solar[nelem] = abundances.SolarSave[nelem];
		/* these are depltion scale factors */
		abundances.depset[nelem] = 1.;
		/*begin sanity check */
		if( abundances.solar[nelem] == 0. || abundances.depset[nelem] == 0. )
		{
			fprintf( ioQQQ, " ZERO finds insane abundance or depletion.\n" );
			fprintf( ioQQQ, " atomic number=%6ld abundance=%10.2e depletion=%10.2e\n", 
			  nelem, abundances.solar[nelem], abundances.depset[nelem] );
			ShowMe();
			puts( "[Stop in zero]" );
			cdEXIT(EXIT_FAILURE);
		}
		/*end sanity check */
	}

	abundances.lgAbTaON = FALSE;
	abundances.lgAbnSolar = FALSE;

	/* typical ISM depletion factors, subjective mean of Cowie and Songaila
	 * and Jenkins 
	 * */
	abundances.Depletion[0] = 1.;
	abundances.Depletion[1] = 1.;
	abundances.Depletion[2] = .16f;
	abundances.Depletion[3] = .6f;
	abundances.Depletion[4] = .13f;
	abundances.Depletion[5] = 0.4f;
	abundances.Depletion[6] = 1.0f;
	abundances.Depletion[7] = 0.6f;
	abundances.Depletion[8] = .3f;
	abundances.Depletion[9] = 1.f;
	abundances.Depletion[10] = 0.2f;
	abundances.Depletion[11] = 0.2f;
	abundances.Depletion[12] = 0.01f;
	abundances.Depletion[13] = 0.03f;
	abundances.Depletion[14] = .25f;
	abundances.Depletion[15] = 1.0f;
	abundances.Depletion[16] = 0.4f;
	abundances.Depletion[17] = 1.0f;
	abundances.Depletion[18] = .3f;
	abundances.Depletion[19] = 1e-4f;
	abundances.Depletion[20] = 5e-3f;
	abundances.Depletion[21] = 8e-3f;
	abundances.Depletion[22] = 6e-3f;
	abundances.Depletion[23] = 6e-3f;
	abundances.Depletion[24] = 5e-2f;
	abundances.Depletion[25] = 0.01f;
	abundances.Depletion[26] = 0.01f;
	abundances.Depletion[27] = 0.01f;
	abundances.Depletion[28] = .1f;
	abundances.Depletion[29] = .25f;

	abundances.lgDepln = FALSE;

	abundances.ScaleMetals = 1.;

	/* option to turn off an element */
	for( ipISO=ipHYDROGEN; ipISO<NISO; ++ipISO )
	{
		/* number of Lyman lines to include in opacities, this can be vastly larger
		 * than the number of actual levels in the model atom */
		iso.nLyman[ipISO] = 100;

		/* controls whether l-mixing and collisional ionization included */
		iso.lgColl_l_mixing[ipISO] = TRUE;
		iso.lgColl_excite[ipISO] = TRUE;
		iso.lgColl_ionize[ipISO] = TRUE;

		/* this will become a check on how well case b worked */
		for( nelem=0; nelem < LIMELM; nelem++ )
		{
			/* option to print departure coefficient */
			iso.lgPrtDepartCoef[ipISO][nelem] = FALSE;
			/* print hydrogenic level populations */
			iso.lgPrtLevelPops[ipISO][nelem] = FALSE;
			iso.CaseBCheck[ipISO][nelem] = -FLT_MAX;
		}
	}

	/* lowest level is 2s,
	 * in versions 90 this was equal to 10, but was 1 in 91
	 * >>chng 99 jan 16, changed back to 10*/
	/*iso.nTopOff[ipH_LIKE] = 1;*/
	iso.nTopOff[ipH_LIKE] = 10;

	/* topoff for he-like sequence */
	iso.nTopOff[ipHE_LIKE] = 0;

	/* option to turn off an element */
	for( nelem=0; nelem < LIMELM; nelem++ )
	{
		/* set of scale factors for changing abundances with elements command */
		abundances.ScaleElement[nelem] = 1.;
		/* option to have abundances from table */
		abundances.lgAbunTabl[nelem] = FALSE;
	}

	dtMase.dTauMase = 0.;
	dtMase.lgMaserCapHit = FALSE;

	Testit.lgTestIt = FALSE;
	Testit.lgTestOn = FALSE;

	/* zero out some grain variables */
	GrainZero();

	he3pht.he3photo = 0.;
	he3pht.He3Fr2Phot = 0.;
	he3pht.he3lya = 0.;

	for( i=0; i < (NHE1LVL + 1); i++ )
	{
		he1bnCOM.he1bn[i] = 1.;
	}

	/* array of lifetimes for helium lines - sum of a's down/4pi*912 */
	he1dmpCOM.he1dmp[0] = 0.;
	he1dmpCOM.he1dmp[1] = 455.1f;
	he1dmpCOM.he1dmp[2] = 72.4f;
	he1dmpCOM.he1dmp[3] = 21.9f;
	he1dmpCOM.he1dmp[4] = 8.42f;
	he1dmpCOM.he1dmp[5] = 3.77f;
	he1dmpCOM.he1dmp[6] = 1.82f;
	he1dmpCOM.he1dmp[7] = 0.939f;
	he1dmpCOM.he1dmp[8] = 0.438f;

	for( i=0; i < NHE3LVL; i++ )
	{
		he3nCom.he3n[i] = 0.;
		he3bnCom.he3bn[i] = 1.;
	}

	fe2cool.Fe2L16Tot = 0.;
	fe2cool.fe21406 = 0.;
	fe2cool.fe21507 = 0.;
	fe2cool.fe21508 = 0.;
	fe2cool.fe21609 = 0.;
	fe2cool.fe21308 = 0.;
	fe2cool.fe21207 = 0.;
	fe2cool.fe21106 = 0.;
	fe2cool.fe21006 = 0.;
	fe2cool.fe21204 = 0.;
	fe2cool.fe21103 = 0.;
	fe2cool.fe21104 = 0.;
	fe2cool.fe21001 = 0.;
	fe2cool.fe21002 = 0.;
	fe2cool.fe20201 = 0.;
	fe2cool.fe20302 = 0.;
	fe2cool.fe20706 = 0.;
	fe2cool.fe20807 = 0.;
	fe2cool.fe20908 = 0.;
	fe2cool.fe21007 = 0.;
	fe2cool.fe21107 = 0.;
	fe2cool.fe21108 = 0.;
	fe2cool.fe21110 = 0.;
	fe2cool.fe21208 = 0.;
	fe2cool.fe21209 = 0.;
	fe2cool.fe21211 = 0.;
	fe4cool.Fe4CoolTot = 0.;
	fe4cool.fe40401 = 0.;
	fe4cool.fe42836 = 0.;
	fe4cool.fe42829 = 0.;
	fe4cool.fe42567 = 0.;
	fe4cool.fe41207 = 0.;
	fe4cool.fe41206 = 0.;
	fe4cool.fe41106 = 0.;
	fe4cool.fe41007 = 0.;
	fe4cool.fe41008 = 0.;
	fe4cool.fe40906 = 0.;

	/* this is flag saying whether this is very first call,
	 * a time when space has not been allocated */
	lgFirstCall = FALSE;

#	ifdef DEBUG_FUN
	fputs( " <->zero()\n", debug_fp );
#	endif
	return;
}

/*rfield_opac_zero zero out rfield arrays between certain limits */
void rfield_opac_zero( long lo , long ihi )
{
	long int i;

	/* >>chng 01 aug 19, space not allocated yet,
	 * following code must also be present in contcreatemesh where
	 * space allocated for the first time */
	if( lgRfieldMalloced )
	{
		for( i=lo; i <= ihi; i++ )
		{
			rfield.OccNumbDiffCont[i] = 0.;
			rfield.ContBoltz[i] = 0.;

			rfield.ConEmitLocal[i] = 0.;
			rfield.ConEmitReflec[i] = 0.;
			rfield.ConEmitOut[i] = 0.;

			rfield.reflin[i] = 0.;
			rfield.ConRefIncid[i] = 0.;
			rfield.SummedCon[i] = 0.;
			rfield.convoc[i] = 0.;
			rfield.flux[i] = 0.;
			rfield.SummedOcc[i] = 0.;
			rfield.SummedDif[i] = 0.;
			rfield.flux[i] = 0.;
			rfield.otslin[i] = 0.;
			rfield.otscon[i] = 0.;
			rfield.ConInterOut[i] = 0.;
			rfield.outlin[i] = 0.;
			rfield.ConOTS_local_OTS_rate[i] = 0.;
			rfield.ConOTS_local_photons[i] = 0.;
			rfield.otsconNew[i] = 0.;
			rfield.otslinNew[i] = 0.;

			opac.OldOpacSave[i] = 0.;
			/* >>chng 99 apr 11, only opac had been set to 0, RT_DestProb crashed
			 * with div by zero when called by tauout before opacities had been
			 * defined.  Now set al three to very small number,
			 * CODE CRASHED - changed back to zero, apparetly some part of
			 * code uses opacity of zero to check on continuum bounds */
			opac.opac[i] = 0.;
			/* NB read above before changing set to zero in above */
			opac.scatop[i] = 0.;
			opac.albedo[i] = 0.;
			opac.TauTotalGeo[0][i] = opac.taumin;
			opac.TauAbsGeo[0][i] = opac.taumin;
			opac.TauScatGeo[0][i] = opac.taumin;
			opac.tmn[i] = 1.;
			opac.FreeFreeOpacity[i] = 0.;
			opac.ExpZone[i] = 1.;
			opac.e2TauAbs[i] = 1.;
			opac.ExpmTau[i] = 1.;
			opac.OpacStatic[i] = 1.;
		}
	}
	return;
}
