/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*cdGett get input parameters from Cloudy header and predictions from body out output, 
 * used when analyzing stored output
 * parameters are not converted from logs, results of this
 * routine are as they appear on the header */
#include "cddefines.h"
#include "mean.h"
#include "linesave.h"

/* NB this routine is seldom used anymore since it is so easy to compute
 * models on the fly and pull results directly with cdLine.  This routine
 * may be removed someday. */
struct t_getpar {
	float gethdn, 
	  getflx, 
	  getu, 
	  gthcol, 
	  getbbt, 
	  getaox, 
	  getpl[3], 
	  gettrb, 
	  gettab, 
	  getagn[2], 
	  getradius;
	float gttaue;
	}	getpar;
#include "cddrive.h"

int cdGett(
	/* ioIN is a previously opened file pointer*/
	FILE * ioIN) 
	/* return value will be set true if we hit eof, more models later if false*/
{
	char chCard[INPUT_LINE_LENGTH], 
	  chKey[5];
	int lgDone, 
	  lgEOL;
	long int i, 
		n,
	  ierr, 
	  n0;
	static int lgFirstTime=TRUE;

#	ifdef DEBUG_FUN
	fputs( "<+>cdGett()\n", debug_fp );
#	endif

	/* this routine reads the output generated with the 
	 * punch results command
	 * if parameter was not entered then zero set
	 *
	 * these are the parameters which may be read off the input stream
	 * all must be initialized here */

	if( lgFirstTime )
	{
		/* this is the large main line array */
		if( (LineSv=(LinSv *)MALLOC((unsigned)300000*sizeof( LinSv ) ) ) == NULL )
		{
			fprintf( ioQQQ, "StartIter could not allocate space for LineSave.nsum array, needed %li\n",
				LineSave.nsum );
			puts( "[Stop in StartIter]" );
			cdEXIT(EXIT_FAILURE);
		}
		lgFirstTime = FALSE;
	}

	/* zero out ionization array for safely */
	for(n=0; n < LIMELM; n++)
	{
		for( i=0; i<LIMELM; i++ )
		{
			IonMeans.xIonMeans[0][i][n] = 0.;
		}
	}
	/* radius */
	getpar.getradius = 0.;

	/* table command, possible parameter */
	getpar.gettab = 0.;

	/* turbulence command */
	getpar.gettrb = 0.;

	/* stop column density command */
	getpar.gthcol = 0.;
	
	/* black body temperature command */
	getpar.getbbt = 0.;
	
	/* ratio command parameter, probably alpha ox */
	getpar.getaox = 0.;
	
	/* the input hydrogen density, from hden command */
	getpar.gethdn = 0.;
	
	/* the input photon flux, from phi(h) command */
	getpar.getflx = 0.;
	
	/* the input ionization parameter, from ionization par command */
	getpar.getu = 0.;
	
	/* the deduced electron scattering optical depth */
	getpar.gttaue = 0.;
	
	/* these are the parameters on the power law command */
	getpar.getpl[0] = 0.;
	getpar.getpl[1] = 0.;
	getpar.getpl[2] = 0.;
	
	/* parameters for agn command */
	getpar.getagn[0] = 0.;
	getpar.getagn[1] = 0.;
	
	/* this will be flag saying if we hit normal end of model */
	lgDone = FALSE;

	if( fgets( chCard , (int)sizeof(chCard) , ioIN ) == NULL )
	{
		fprintf( ioQQQ, " cdGett error getting input1\n" );
		puts( "[Stop in cdGett]" );
		cdEXIT(EXIT_FAILURE);
	}

	ierr = FALSE;
	while( ierr == FALSE && !lgDone )
	{
		/* change chCard to all caps, and put first 4 char as null term string into chKey */
		/* chKey will be the key to search on */
		cap4(chKey,chCard);

		if( strcmp(chKey,"BLAC") == 0 )
		{
			/* temperature on blackbody line, leave as is */
			i = 4;
			getpar.getbbt = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
		}

		else if( strcmp(chKey,"AGN ") == 0 )
		{
			/* agn command */
			i = 3;
			getpar.getagn[0] = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
			getpar.getagn[1] = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
		}

		else if( strcmp(chKey,"POWE") == 0 )
		{
			/* power law command */
			i = 4;
			getpar.getpl[0] = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
			getpar.getpl[1] = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
			getpar.getpl[2] = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
		}

		else if( strcmp(chKey,"RADI") == 0 )
		{
			/* radius command */
			i = 4;
			getpar.getradius = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
		}

		else if( strcmp(chKey,"RATI") == 0 )
		{
			/* ratio command */
			i = 4;
			getpar.getaox = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
		}

		else if( strcmp(chKey,"HDEN") == 0 )
		{
			/* this is an hden command, scan off density */
			i = 4;
			getpar.gethdn = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
		}

		else if( strcmp(chKey,"STOP") == 0 && lgMatch("COLU",chCard
		  ) )
		{
			/* this is hydrogen column density */
			i = 4;
			getpar.gthcol = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
		}

		else if( strcmp(chKey,"TABL") == 0 )
		{
			/* table command */
			i = 4;
			getpar.gettab = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
		}

		else if( strcmp(chKey,"PHI(") == 0 )
		{
			/* this is a flux command, scan off flux */
			i = 4;
			getpar.getflx = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
		}

		else if( strcmp(chKey,"IONI") == 0 )
		{
			/* this is a ionization parameter command, scan off U */
			i = 4;
			getpar.getu = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
		}

		else if( strcmp(chKey,"C*OP") == 0 )
		{
			/* this is a line of deduced optical depths */
			i = 4;
			getpar.gttaue = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
		}

		else if( strcmp(chKey,"TURB") == 0 )
		{
			/* this is a turbulence */
			i = 4;
			getpar.gettrb = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);

		}

		else if( strncmp( chCard,"BEGIN EMISSION LINES", 20) == 0 )
		{
			/* this  is not zero since code assumes that 0 is unity integration */
			n0 = 1;
			do
			{
				if( fgets( chCard , (int)sizeof(chCard) , ioIN ) == NULL )
				{
					ierr = TRUE;
				}
				else
				{
					sscanf( chCard, 
						" %4s%6f%10le "
						 "%4s%6f%10le "
						 "%4s%6f%10le "
						 "%4s%6f%10le "
						 "%4s%6f%10le "
						 "%4s%6f%10le",
						LineSv[n0+0].chALab,&LineSv[n0+0].wavelength, &LineSv[n0+0].sumlin ,
						LineSv[n0+1].chALab,&LineSv[n0+1].wavelength, &LineSv[n0+1].sumlin ,
						LineSv[n0+2].chALab,&LineSv[n0+2].wavelength, &LineSv[n0+2].sumlin ,
						LineSv[n0+3].chALab,&LineSv[n0+3].wavelength, &LineSv[n0+3].sumlin ,
						LineSv[n0+4].chALab,&LineSv[n0+4].wavelength, &LineSv[n0+4].sumlin ,
						LineSv[n0+5].chALab,&LineSv[n0+5].wavelength, &LineSv[n0+5].sumlin );
					n0 += 6;
				}
			}
			while( ierr==FALSE && strncmp( chCard , "    " ,  4)!=0 );

			/* total number read in, including blanks */
			LineSave.nsum = n0 + 5;

			/* this will be number of lines total, decrement total until hit label*/
			while( strcmp( LineSv[LineSave.nsum].chALab, "    ") ==0 )
			{
				--LineSave.nsum;
			}
		}
		else if( strncmp( chCard , "BEGIN COLUMN DENSITI", 20 ) == 0 )
		{
			/* real in all column densities
			 * make sure this is kept parallel with CDCOLM, which uses it */

			for(i=0; i < LIMELM+2; i++)
			{
				for( n=0; n<LIMELM; n+=10 )
				{
					float a,b,c,d,e,f,g,h,hh,hhh ;
					if( fgets( chCard , (int)sizeof(chCard) , ioIN ) == NULL )
					{
						ierr = TRUE;
					}
					else
					{
						sscanf( chCard, 
							" %10e"
							" %10e"
							" %10e"
							" %10e"
							" %10e"
							" %10e"
							" %10e"
							" %10e"
							" %10e"
							" %10e" , 
							&a,&b,&c,&d,&e,&f,&g,&h,&hh,&hhh );
						IonMeans.xIonMeans[0][i][n+0] = a;
						IonMeans.xIonMeans[0][i][n+1] = b;
						IonMeans.xIonMeans[0][i][n+2] = c;
						IonMeans.xIonMeans[0][i][n+3] = d;
						IonMeans.xIonMeans[0][i][n+4] = e;
						IonMeans.xIonMeans[0][i][n+5] = f;
						IonMeans.xIonMeans[0][i][n+6] = g;
						IonMeans.xIonMeans[0][i][n+7] = h;
						IonMeans.xIonMeans[0][i][n+8] = hh;
						IonMeans.xIonMeans[0][i][n+9] = hhh;
					}
				}
			}
		}
		else if( strncmp( chCard,"END OF RESULTS",14) == 0 )
		{
			/* following is normal way to exit */
			lgDone = TRUE;
		}

		if( fgets( chCard , (int)sizeof(chCard) , ioIN ) == NULL )
		{
			ierr = TRUE;
		}
		else
		{
			ierr = FALSE;
		}
	}

	if( lgDone )
	{
#		ifdef DEBUG_FUN
		fputs( " <->cdGett()\n", debug_fp );
#		endif
		return(FALSE);
	}
	else
	{
#		ifdef DEBUG_FUN
		fputs( " <->cdGett()\n", debug_fp );
#		endif
		return(TRUE);
	}
}

