/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/* colden.h */
/* number of column densities for H molecules */
#define	NCOLD	8

#define	ipCH2PLS	3
#define	ipCHEHP	5
#define	ipCHI	4
#define	ipCHII	6
#define	ipCH3PLS	7
#define	ipCHMIN	1
#define	ipCOLH2	2
#define	ipCOLUMNDENSITY	0

EXTERN struct t_colden {

	/*save column densities from iteration to iteration, to check whether
	 *it changed by too much (a bad sign)
	 *column densities, mostly h molecule related */
	float colden[NCOLD], 
	  ColDenSav[ITRDIM];

	/* integral of ne np over radius */
	double dlnenp;
	/* integral of ne n(He+) over radius */
	double dlnenHep;
	/* integral of ne nHe++) over radius */
	double dlnenHepp;

	/* pops and column density for CII atom */
	float C2Pops[5],
		C2Colden[5];

	/* pops and column density for SiII atom */
	float Si2Pops[5],
		Si2Colden[5];

	/* pops and column density for CI atom */
	float C1Pops[3],
		C1Colden[3];

	/* pops and column density for OI atom */
	float O1Pops[3],
		O1Colden[3];

	/* He I 23S */
	float He123S;

	}	colden;
