/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*CoolZinc compute zinc cooling */
#include "cddefines.h"
#include "taulines.h"
#include "level2.h"
#include "lines_service.h"
#include "thermal.h"
#include "cooling.h"

void CoolZinc()
{

#	ifdef DEBUG_FUN
	fputs( "<+>CoolZinc()\n", debug_fp );
#	endif

	/* zinc iv 3.625 microns, 
	 *  >>refer	Zn 4	wl	Dinerstein, H.L.,  Gaballe, T.R> 2001, ApJ, 562, 515-520 */
	PutCS(1., &TauLines[ipZn04363]);
	level2( &TauLines[ipZn04363]);

#	ifdef DEBUG_FUN
	fputs( " <->CoolZinc()\n", debug_fp );
#	endif
	return;
}

