/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*DielSupres derive scale factors for suppression of Burgess dielectronic recombination */
#include "cddefines.h"
#include "ionrec.h"
#include "dense.h"
#include "phycon.h"
#include "punch.h"
#include "dielsupres.h"

void DielSupres(void)
{
	long int i;
	double effden;

#	ifdef DEBUG_FUN
	fputs( "<+>DielSupres()\n", debug_fp );
#	endif

	/* dielectronic burgess recombination suppresion
	 * default is this to be true */
	if( ionrec.lgSupDie[0] )
	{
		for( i=0; i < LIMELM; i++ )
		{
			/* following is effective density for scaling from Davidson's plot
			 * first do temperature scaling, term in () is SQRT(te/15,000) */
			effden = dense.eden/(phycon.sqrte/122.47);

			/* this is rough charge dependence, z^7 from Davidson */
			effden /= powi((float)(i+1)/3.,7);

			ionrec.DielSupprs[0][i] = (float)(1.-0.092*log10(effden));
			ionrec.DielSupprs[0][i] = (float)MIN2(1.,ionrec.DielSupprs[0][i]);
			ionrec.DielSupprs[0][i] = (float)MAX2(0.08,ionrec.DielSupprs[0][i]);
		}
	}

	else
	{
		for( i=0; i < LIMELM; i++ )
		{
			ionrec.DielSupprs[0][i] = 1.;
		}
	}

	/* nussbaumer and storey recombination
	 * default is this to be false */
	if( ionrec.lgSupDie[1] )
	{
		for( i=0; i < LIMELM; i++ )
		{
			/* assume same factors as above */
			ionrec.DielSupprs[1][i] = ionrec.DielSupprs[0][i];
		}
	}
	else
	{
		for( i=0; i < LIMELM; i++ )
		{
			ionrec.DielSupprs[1][i] = 1.;
		}
	}

	/* option to punch recombination coefficents, set with punch recomb coef command*/
	if( punch.lgioRecom > 0 )
	{
		fprintf( punch.ioRecom, " DielSupres finds following dielectronic recom suppression factors.\n" );
		fprintf( punch.ioRecom, "  Z    fac \n" );
		for( i=0; i < LIMELM; i++ )
		{
			fprintf( punch.ioRecom, "%3ld %10.3e %10.3e\n", i+1, 
			  ionrec.DielSupprs[0][i], ionrec.DielSupprs[1][i] );
		}
		fprintf( punch.ioRecom, "\n");
	}


#	ifdef DEBUG_FUN
	fputs( " <->DielSupres()\n", debug_fp );
#	endif
	return;
}

