/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/* this info used to estimate destruction of Lya by overlap with FeII
 * in case where large atom is not turned on */

/*  number of FeII lines in Fred's atom */
#define	NFEII	373

/*Fe2_ovr_DataInit storing energy levels for Fred's FeII ground,
 * called */
void Fe2_ovr_DataInit(void);

/*fe2ovr compute FeII overlap with Lya */
void fe2ovr(void);

/*pfeii create punch output describing pumping of FeII by Lya */
void pfeii(FILE* io);

EXTERN struct t_ipfe2Com {
	long int ipfe2[NFEII];

	/* opacity and optical depths for ground of Fred's FeII atom */
	float feopc[NFEII], 
	  Fe2TauLte[NFEII], 
	  Fe2PopLte[NFEII];

	float fe2lam[NFEII], 
	  fe2osc[NFEII], 
	  fe2enr[NFEII], 
	  fe2gs[NFEII];

}	fe2ovr_la;
