/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*FndLineHt search through line heat arrays to find the strongest heat source */
#include "cddefines.h"
#include "taulines.h"
#include "fndlineht.h"

void FndLineHt(long int *level, 
  /* this is the index of the strongest line in the array on the c scale */
  long int *ipStrong, 
  double *Strong)
{
	long int i; 

#	ifdef DEBUG_FUN
	fputs( "<+>FndLineHt()\n", debug_fp );
#	endif

	*Strong = 0.;
	*level = 0;

	/* do the level 1 lines, 0 is dummy line, <=nLevel1 is correct for c scale */
	for( i=1; i <= nLevel1; i++ )
	{
		/* check if a line was the major heat agent */
		if( TauLines[i].heat > *Strong )
		{
			*ipStrong = i;
			*level = 1;
			*Strong = TauLines[i].heat;
		}
	}

	/* now do the level 2 lines */
	for( i=0; i < nWindLine; i++ )
	{
		/* check if a line was the major heat agent */
		if( TauLine2[i].heat > *Strong )
		{
			*ipStrong = i;
			*level = 2;
			*Strong = TauLine2[i].heat;
		}
	}

	/* now do co carbon monoxide lines */
	for( i=0; i < nCORotate; i++ )
	{
		/* check if a line was the major heat agent */
		if( C12O16Rotate[i].heat > *Strong )
		{
			*ipStrong = i;
			*level = 3;
			*Strong = C12O16Rotate[i].heat;
		}
	}
	for( i=0; i < nCORotate; i++ )
	{
		/* check if a line was the major heat agent */
		if( C13O16Rotate[i].heat > *Strong )
		{
			*ipStrong = i;
			*level = 4;
			*Strong = C13O16Rotate[i].heat;
		}
	}

	/* now do the hyperfine structure lines */
	for( i=0; i < nHFLines; i++ )
	{
		/* check if a line was the major heat agent */
		if( HFLines[i].heat > *Strong )
		{
			*ipStrong = i;
			*level = 5;
			*Strong = HFLines[i].heat;
		}
	}

#	ifdef DEBUG_FUN
	fputs( " <->FndLineHt()\n", debug_fp );
#	endif
	return;
}

