/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*GetLineRec return rec coef*hnu*eden*n_ion for C, N, or O recombination lines from Dima's list,
 * also zero's line in master stack so not entered second time in later dump of all rec lines */
#include "cddefines.h"
#include "reccno.h"
#include "dense.h"
#include "getlinerec.h"

double GetLineRec(
	/* this is the number of the emission line in the stack of lines, on the C scale */
	long int ip, 
	/* the multiplet wavelength */
  long int lWl)
{
	double GetLineRec_v;

#	ifdef DEBUG_FUN
	fputs( "<+>GetLineRec()\n", debug_fp );
#	endif

	/*begin sanity check */
	if( (long)(RecCNO.RecCoefCNO[2][ip]+0.5) != lWl )
	{
		fprintf( ioQQQ, " GetLineRec called with incorrect wavelength.\n" );
		fprintf( ioQQQ, " index, call and get wl are %5ld%5ld%5ld\n", 
		  ip, lWl, (long)(RecCNO.RecCoefCNO[2][ip]+0.5) );
		puts( "[Stop in GetLineRec]" );
		cdEXIT(EXIT_FAILURE);
	}
	/*end sanity check */
	
	/* final product is vol emissivity in line */
#	if 0
	GetLineRec_v = RecCNO.RecCoefCNO[3][ip]*dense.eden*
		dense.xIonDense[(long)(RecCNO.RecCoefCNO[0][ip]-RecCNO.RecCoefCNO[1][ip]+2)][(long)(RecCNO.RecCoefCNO[0][ip])-1]*
	  1.99e-8/RecCNO.RecCoefCNO[2][ip];
#	endif
	GetLineRec_v = RecCNO.RecCoefCNO[3][ip]*dense.eden*
		dense.xIonDense[(long)(RecCNO.RecCoefCNO[0][ip])-1][(long)(RecCNO.RecCoefCNO[0][ip]-RecCNO.RecCoefCNO[1][ip]+2)-1]*
	  1.99e-8/RecCNO.RecCoefCNO[2][ip];

	/* zero out rec coef so that not used again in master dump
	 * this routine cannot be called twice on same line */
	RecCNO.RecCoefCNO[3][ip] = 0.;

#	ifdef DEBUG_FUN
	fputs( " <->GetLineRec()\n", debug_fp );
#	endif
	return( GetLineRec_v );
}

