/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/* these are the vectors that store the original Hummer and Storey case B
 * line data for H and He - the declaration for the interpolator follows */

#define NHSDIM 15 /*used for following vectors*/
#define NLINEHS 300  /*dimension of array with lines*/
#define HS_NZ 8 /* number of elements that can be read in */

EXTERN struct t_CaseBHS {
	/* these are the density and temperature mesh points on the
	 * original Hummer & Storey data, for H[0] and He[1], */
	double Density[2][HS_NZ][NHSDIM], 
		ElecTemp[2][HS_NZ][NHSDIM],
		/*emiss[ipTemp][ipDens][ipLevel]*/
		Emiss[2][HS_NZ][NHSDIM][NHSDIM][NLINEHS] ;

	/* saves the number of density temperature mesh points for the two cases for the HS_NZ elements */
	long int nDensity[2][HS_NZ] , ntemp[2][HS_NZ] , ncut[2][HS_NZ] ;

	/* following will be set false if we ever stop over bounds of HS table
	 * for any element.  first index is case A [0] or case B [1] -
	 * second is element number */
	int lgHCaseBOK[2][HS_NZ];

} CaseBHS ;


double HSRate( 
/* general utility to read in line emissivities from the Storey & Hummer tables
 of case B emissivities.  */
	long int iHi,	/* the principal quantum numbers, . */
	long int iLo,	/* upper and lower levels in any order*/
	long int iZ,	/* charge of ion, only 1 and 2 for now*/
	double TempIn,	/* temperature, must lie within the range of the table,
						   which depends on 
						   the ion charge, and is 500 - 30,000K for hydrogen */
	double DenIn,	/* the density and must lie within the range of the table*/
	/* case - 'a' or 'b' */
	char chCase 
	);
