/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/* input.h */

/* limit to number of line images that can be read in */
#define	NKRD	4000

EXTERN struct t_input {

	/*
	 * copy of current line image, set when readar is called,
	 * used by parser when original (not cap'd) line needed
	 */
	char chOrgCard[INPUT_LINE_LENGTH];

	/* 
	 * this is cap'd image of command line, for use with patern matches 
	 */
	char chCARDCAPS[INPUT_LINE_LENGTH];

	/* 
	 * we will save the original (not caped) image of the line here 
	 */
	char chCardSav[NKRD][INPUT_LINE_LENGTH], 

	/* 
	 * title entered with the title command 
	 */
	  chTitle[INPUT_LINE_LENGTH];

	long int 
	  /* total number of lines read in with cdRead */
	  nSave,

	  /* this points to the command we are now parsing, within the stack of commands */
	  nRead,		

	  /* number of init commands saved */
	  nSaveIni,	

	  /* +/-1, says whether to increment or decrement nRead, since init commands
		* are at the bottom of the stack and we read backwards */
	  iReadWay,	

	  /* saves current value of nRead, while parsing init commands */
	  nReadSv;	

	/* this is set true if underscore present in input stream, which was
	 * set to space */
	int lgUnderscoreFound;

	/* this is set true if left or right bracket, [ or ], present in input stream, which was
	 * set to space */
	int lgBracketFound;

	/* logical variable testing whether any input lines were too long 
	* definition is in cdInit */
	int lgCardSavTooLong;

	}	input;


