/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*IonBeryl ionization balance for beryllium */
#include "cddefines.h"
#ifdef NDIM
#	undef NDIM
#endif
#define	NDIM	5
#include "dense.h"
#include "trace.h"
#include "collidionize.h"
#include "makerecomb.h"
#include "ionzer.h"
#include "photoionize.h"
#include "bidiag.h"
#include "ionize.h"

void IonBeryl(void)
{
	long int i, 
	  _r;
	static double dicoef[2][NDIM - 1], 
	  dite[2][NDIM - 1];
	static double rec[NDIM - 2]={1.47e-10,8.74e-10,7.98e-9};
	static double pl[NDIM - 2]={-0.624,-0.645,-0.803};
	static double tlow[2]={1.44e-10,-0.621};
	static double ditcrt[NDIM - 1]={1.2e4,1.2e4,1.1e4,1e20};
	static double aa[NDIM - 1]={2.3196,0.,0.,0.};
	static double bb[NDIM - 1]={10.7328,0.,0.,0.};
	static double cc[NDIM - 1]={6.8830,0.,0.,0.};
	static double dd[NDIM - 1]={-0.1824,0.,0.,0.};
	static double ff[NDIM - 1]={0.4101,0.1,0.1,0.};
	static int _aini = 1;
	if( _aini ){ /* Do 1 TIME INITIALIZATIONS! */
		{ static double _itmp2[] = {2.54e-3,6.15e-3,1.62e-3,0.};
		for( i=1, _r = 0; i <= (NDIM - 1); i++ )
		{
			dicoef[0][i-1] = _itmp2[_r++];
			}
		}
		{ static double _itmp3[] = {4.42e-2,5.88e-2,0.343,0.};
		for( i=1, _r = 0; i <= (NDIM - 1); i++ )
		{
			dicoef[1][i-1] = _itmp3[_r++];
			}
		}
		{ static double _itmp4[] = {1.57e5,1.41e5,8.19e4,0.};
		for( i=1, _r = 0; i <= (NDIM - 1); i++ )
		{
			dite[0][i-1] = _itmp4[_r++];
			}
		}
		{ static double _itmp5[] = {3.74e5,1.41e5,1.59e5,0.};
		for( i=1, _r = 0; i <= (NDIM - 1); i++ )
		{
			dite[1][i-1] = _itmp5[_r++];
			}
		}
		_aini = 0;
	}

#	ifdef DEBUG_FUN
	fputs( "<+>IonBeryl()\n", debug_fp );
#	endif

	/* boron nelem=4
	 * data are for carbon
	 *
	 * real CollidRate(nelem,2)
	 *
	 * rates from Shull and van Steenberg, Ap.J. Sup 48, 95. */
	/* DATA GRDEFF/0.10,0.10,0.10,0.053/
	 * GRDEFF is fraction of recombinations to ground state, used for
	 * outward diffuse fields
	 *
	 * rec from +3, +4 from Arnaud et al Ast Ap Sup 60 425. (1985)
	 * rec from fully ionized uses Seaton '79 in ionrat */
	/* Pequignot and Aldrovandi Ast Ap 161, 169. */

	if( !dense.lgElmtOn[ipBERYLLIUM] )
	{
		
#		ifdef DEBUG_FUN
		fputs( " <->IonBeryl()\n", debug_fp );
#		endif
		return;
	}

	/* zero out ionization balance arrays */
	ionzer(ipBERYLLIUM);

	PhotoIonize(ipBERYLLIUM,FALSE);

	/* find collisional ionization rates */
	CollidIonize(ipBERYLLIUM);

	/* get recombination coefficients */
	MakeRecomb(rec,pl,(double*)dicoef,(double*)dite,ditcrt,aa,bb,cc,
	  dd,ff,ipBERYLLIUM,tlow);

	/* solve for ionization balance */
	BiDiag(ipBERYLLIUM,FALSE);

	if( trace.lgTrace && trace.lgHeavyBug )
	{
		fprintf( ioQQQ, "     Beryli returns; frac=" );
		for( i=1; i <= (ipBERYLLIUM + 2); i++ )
		{
			fprintf( ioQQQ, "%10.3e", dense.xIonDense[ipBERYLLIUM][i-1]/
			  dense.gas_phase[ipBERYLLIUM] );
		}
		fprintf( ioQQQ, "\n" );
	}

#	ifdef DEBUG_FUN
	fputs( " <->IonBeryl()\n", debug_fp );
#	endif
	return;
}

