/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*IonOxyge derive ionization balance for oxygen */
#include "cddefines.h"
#ifdef NDIM
#	undef NDIM
#endif
#define	NDIM	9
#include "opacity.h"
#include "o3exc.h"
#include "heat.h"
#include "dense.h"
#include "iso.h"
#include "trace.h"
#include "pmp2s.h"
#include "rfield.h"
#include "ionrec.h"
#include "chargtran.h"
#include "ionrange.h"
#include "collidionize.h"
#include "ionzer.h"
#include "popexc.h"
#include "makerecomb.h"
#include "photoionize.h"
#include "bidiag.h"
#include "gammas.h"
#include "ionize.h"

void IonOxyge(void)
{
	long int i, 
	  iup, 
	  _r;
	double aeff;
	static double dicoef[2][NDIM - 1], 
	  dite[2][NDIM - 1];
	static double rec[NDIM - 2]={1.60e-10,7.67e-10,2.35e-09,4.59e-09,
	  1.73e-08,3.04e-8,1.56e-7};
	static double pl[NDIM - 2]={-0.678,-0.646,-0.666,-0.670,-0.759,
	  -0.774,-0.834};
	static double tlow[2]={0.,0.};
	static double ditcrt[NDIM - 1]={2.7e4,2.2e4,2.4e4,2.5e4,1.6e4,1.0e6,
	  1.5e6,1e20};
	static double aa[NDIM - 1]={0.,-0.0036,0.,0.0061,-2.8425,0.,0.,
	  0.};
	static double bb[NDIM - 1]={0.0238,0.7519,21.8790,0.2269,0.2283,
	  0.,0.,0.};
	static double cc[NDIM - 1]={0.0659,1.5252,16.2730,32.1419,40.4072,
	  0.,0.,0.};
	static double dd[NDIM - 1]={0.0349,-0.0838,-0.7020,1.9939,-3.4956,
	  0.,0.,0.};
	static double ff[NDIM - 1]={0.5334,0.2769,1.1899,-0.0646,1.7558,
	  0.,0.,0.};
	static int _aini = 1;
	if( _aini ){ /* Do 1 TIME INITIALIZATIONS! */
		{ static double _itmp2[] = {1.11e-3,5.07e-3,1.48e-2,1.84e-2,
		  4.13e-3,1.06e-1,6.23e-2,0.};
		for( i=1, _r = 0; i <= (NDIM - 1); i++ )
		{
			dicoef[0][i-1] = _itmp2[_r++];
			}
		}
		{ static double _itmp3[] = {.0925,.181,.305,.1,.162,.34,.304,
		  0.};
		for( i=1, _r = 0; i <= (NDIM - 1); i++ )
		{
			dicoef[1][i-1] = _itmp3[_r++];
			}
		}
		{ static double _itmp4[] = {1.75e5,1.98e5,2.41e5,2.12e5,1.25e5,
		  6.25e6,7.01e6,0.};
		for( i=1, _r = 0; i <= (NDIM - 1); i++ )
		{
			dite[0][i-1] = _itmp4[_r++];
			}
		}
		{ static double _itmp5[] = {1.45e5,3.35e5,2.83e5,2.83e5,2.27e5,
		  1.12e6,1.47e6,0.};
		for( i=1, _r = 0; i <= (NDIM - 1); i++ )
		{
			dite[1][i-1] = _itmp5[_r++];
			}
		}
		_aini = 0;
	}

#	ifdef DEBUG_FUN
	fputs( "<+>IonOxyge()\n", debug_fp );
#	endif

	/* oxygen, atomic number 8 */
	if( !dense.lgElmtOn[ipOXYGEN] )
	{
		o3exc.poiii2Max = 0.;
		o3exc.poiii3Max = 0.;
		o3exc.r4363Max = 0.;
		o3exc.r5007Max = 0.;
		o3exc.poiii2 = 0.;
		pmp2s.p1666 = 0.;
		pmp2s.AugerO3 = 0.;
		pmp2s.p1401 = 0.;
		pmp2s.s3727 = 0.;
		pmp2s.s7325 = 0.;
		heat.heating[7][9] = 0.;
		o3exc.poimax = 0.;
		
#		ifdef DEBUG_FUN
		fputs( " <->IonOxyge()\n", debug_fp );
#		endif
		return;
	}

	ionzer(ipOXYGEN);

	PhotoIonize(ipOXYGEN,FALSE);

	/* find collisional ionization rates */
	CollidIonize(ipOXYGEN);

	/* get recombination coefficients */
	MakeRecomb(rec,pl,(double*)dicoef,(double*)dite,ditcrt,aa,bb,cc,
	  dd,ff,ipOXYGEN,tlow);

	/* photoexcitation of O III 1666 and O IV 1401
	 * TODO this will be zero in current form of phfit
	 * set 2s**2 rate to rate for O V */
	pmp2s.p1666 = ionrec.PhotoRate_Shell[ipOXYGEN][3][1][0];

	pmp2s.p1401 = ionrec.PhotoRate_Shell[ipOXYGEN][2][1][0];

	/* photoionization from O++ 1D
	 *
	 * estimate gamma function by assuming no frequency dependence
	 * betwen 1D and O++3P edge */
	/* destroy upper level of OIII 5007*/
	o3exc.d5007r = (float)(GammaK(opac.ipo3exc[0],opac.ipo3exc[1],
	  opac.ipo3exc[2] , 1. ));

	/* destroy upper level of OIII 4363*/
	o3exc.d4363 = (float)(GammaK(opac.ipo3exc3[0],opac.ipo3exc3[1],
	  opac.ipo3exc3[2] , 1. ));

	/* destroy upper level of OI 6300*/
	o3exc.d6300 = (float)(GammaK(opac.ipo1exc[0],opac.ipo1exc[1],
	  opac.ipo1exc[2] , 1. ));

	/* A21 = 0.0263 */
	aeff = 0.0263 + o3exc.d5007r;

	/* 1. as last arg makes this the relative population */
	o3exc.poiii2 = (float)(popexc(2.5,9.,5.,aeff,2.88e4,1.)/aeff);
	{
		/*@-redef@*/
		enum {DEBUG_LOC=FALSE};
		/*@+redef@*/
		if( DEBUG_LOC )
		{
			fprintf(ioQQQ,"pop rel  %.1e rate %.1e  grnd rate %.1e\n", 
				o3exc.poiii2 , o3exc.d5007r ,ionrec.PhotoRate_Shell[ipOXYGEN][2][2][0] );
		}
	}

	/* photoionization from excited states */
	if( nzone > 0 ) 
	{
		/* neutral oxygen destruction */
		ionrec.PhotoRate_Shell[ipOXYGEN][0][2][0] = ionrec.PhotoRate_Shell[ipOXYGEN][0][2][0]*
		  (1. - o3exc.poiexc) + o3exc.d6300*o3exc.poiexc;

		/* doubly ionized oxygen destruction */
		ionrec.PhotoRate_Shell[ipOXYGEN][2][2][0] = ionrec.PhotoRate_Shell[ipOXYGEN][2][2][0]*
		  (1. - o3exc.poiii2 - o3exc.poiii3) + o3exc.d5007r*o3exc.poiii2 + 
		  o3exc.d4363*o3exc.poiii3;

		if( ionrec.PhotoRate_Shell[ipOXYGEN][2][2][0] > 1e-30 && IonRange.IonLow[ipOXYGEN] <= 2 )
		{
			if( (o3exc.d5007r*o3exc.poiii2 + o3exc.d4363*o3exc.poiii3)/
			  ionrec.PhotoRate_Shell[ipOXYGEN][2][2][0] > (o3exc.r4363Max + 
			  o3exc.r5007Max) )
			{
				o3exc.poiii2Max = (float)(o3exc.d5007r*o3exc.poiii2/ionrec.PhotoRate_Shell[ipOXYGEN][2][2][0]);
				o3exc.poiii3Max = (float)(o3exc.d4363*o3exc.poiii3/ionrec.PhotoRate_Shell[ipOXYGEN][2][2][0]);
			}
			o3exc.r4363Max = (float)(MAX2(o3exc.r4363Max,o3exc.d4363));
			o3exc.r5007Max = (float)(MAX2(o3exc.r5007Max,o3exc.d5007r));
		}

		/* ct into excited states */
		if( IonRange.IonLow[ipOXYGEN] <= 0 && (ionrec.PhotoRate_Shell[ipOXYGEN][0][2][0] + 
		  ChargTran.HCharExcIon[ipOXYGEN][0]*dense.xIonDense[ipHYDROGEN][1]) > 1e-30 )
		{
			o3exc.poimax = (float)(MAX2(o3exc.poimax,o3exc.d6300*o3exc.poiexc/
			  (ionrec.PhotoRate_Shell[ipOXYGEN][0][2][0]+
			  ChargTran.HCharExcIon[ipOXYGEN][0]* dense.xIonDense[ipHYDROGEN][1])));
		}
	}
	else
	{
		o3exc.poiii2Max = 0.;
		o3exc.poiii3Max = 0.;
		o3exc.r4363Max = 0.;
		o3exc.r5007Max = 0.;
		o3exc.poimax = 0.;
	}

	/* save atomic oxygen photodistruction rate for 3727 creation */
	if( IonRange.IonLow[ipOXYGEN] == 0 && pmp2s.i2d < rfield.nflux )
	{
		pmp2s.s3727 = (float)(GammaK(pmp2s.i2d,pmp2s.i2p,opac.iopo2d , 1. ));

		iup = MIN2(iso.ipIsoLevNIonCon[ipH_LIKE][1][0],rfield.nflux);
		pmp2s.s7325 = (float)(GammaK(pmp2s.i2d,iup,opac.iopo2d , 1. ));

		pmp2s.s7325 -= pmp2s.s3727;
		pmp2s.s3727 = pmp2s.s3727 + pmp2s.s7325;

		/* ratio of cross sections */
		pmp2s.s7325 *= 0.66f;
	}
	else
	{
		pmp2s.s3727 = 0.;
		pmp2s.s7325 = 0.;
	}

	pmp2s.AugerO3 = (float)ionrec.PhotoRate_Shell[ipOXYGEN][0][0][0];

	/* >>chng 01 dec 07, remove oatmic - dense.xMolecules now in bidiag */
	/* following accounts for part of oxygen that is in CO, since BiDiag only
	 * wants atoms/ions, but [0][ipOXYGEN] includes molecules too.  Must temperariyly
	 * convert [0][ipOXYGEN] to atoms/molecules only 
	coatom.oatmic = (float)(dense.gas_phase[ipOXYGEN]*
		MAX2(1e-7 , 1.-hevmolec.hevmol[ipCO]/dense.gas_phase[ipOXYGEN] ) );*/

	/* solve for ionization balance */
	BiDiag(ipOXYGEN,FALSE);

	/* 1666 ratio corrected for phot crs at 50ev */
	pmp2s.p1666 *= dense.xIonDense[ipOXYGEN][1]*0.3;
	pmp2s.p1401 *= dense.xIonDense[ipOXYGEN][2]*0.43;
	pmp2s.s3727 *= dense.xIonDense[ipOXYGEN][0];
	pmp2s.s7325 *= dense.xIonDense[ipOXYGEN][0];
	pmp2s.AugerO3 *= dense.xIonDense[ipOXYGEN][0];

	if( trace.lgTrace )
	{
		fprintf( ioQQQ, "     IonOxyge returns; frac=" );
		for( i=1; i <= 9; i++ )
		{
			fprintf( ioQQQ, " %10.3e", dense.xIonDense[ipOXYGEN][i-1]/
			  dense.gas_phase[ipOXYGEN] );
		}
		fprintf( ioQQQ, "\n" );
	}

#	ifdef DEBUG_FUN
	fputs( " <->IonOxyge()\n", debug_fp );
#	endif
	return;
}
