/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/* enter lines into the line storage array, called once per zone for each line*/
void linadd(
	double xInten,	/* xInten - local emissivity per unit vol, no fill fac */
  float wavelength,	/* lam integer wavelength */
  char *chLab,		/* string label for ion */
  char chInfo );		/* character type of entry for line - given below */
						/* 'c' cooling, 'h' heating, 'i' info only, 'r' recom line */

/*TexcLine derive excitation temperature of line from contents of line array */
double TexcLine(EmLine * t);

/*DumpLine print various information about an emission line vector, used in debugging */
void DumpLine(EmLine * t);

/*GetGF convert Einstein A into oscillator strength */
double GetGF(double eina, 
	  double enercm, 
	  double gup);

/*eina convert a gf into an Einstein A */
double eina(double gf, 
	  double enercm, 
	  double gup);

/*abscf convert gf into absorption coefficient */
double abscf(double gf, 
	  double enercm, 
	  double gl);

/* setting true will use low-density Lyman branching ratios */
#define LOWDEN_LYMAN FALSE

/* returns fraction of populations the produce emission */
double emit_frac( EmLine *t );

/* generate null terminated line label from contents of line trans array */
void chIonLbl( char*, EmLine * t );

/*chLineLbl use information in line transfer arrays to generate a line label */
/* this label is null terminated */
char* chLineLbl(EmLine * t );

/*RefIndex calculates the index of refraction of air using the line energy in wavenumbers,
 * used to convert vacuum wavelengths to air wavelengths. */
double RefIndex(EmLine * t);


/*PutCS enter a collision strength into an individual line struc */
void PutCS(double cs, 
  /* the line struc */
  EmLine * t);

/* This routine is exclusively used for getting wavelength errors	*/
void GetWLError( float wavelength, float *errorwave, double *a );

/* put forbidden line into stack, using index derived below */
void lindst(double xInten, 
  float wavelength, 
  char *chLab, 
  long int ipnt, 
  char chInfo, 
  int lgOutToo);

/*PntForLine generate pointer for forbidden line */
void PntForLine(double wavelength, 
  char *chLabel, 
  /* this is array index on the f, not c scale,
   * for the continuum cell holding the line */
  long int *ipnt);

/*PutLine enter local line intensity into the intensity stack for eventual printout */
void PutLine(EmLine * t);

/*PutExtra enter and 'extra' intensity source for some line */
void PutExtra(double Extra);

/*EmLineJunk set all elements of EmLine struc to dangerous values */
void EmLineJunk( EmLine * t );

/*EmLineZero set all elements of EmLine struc to zero */
void EmLineZero( EmLine * t );

/* convert down coll rate back into electron cs in case other parts of code need this for reference */
void LineConvRate2CS( EmLine * t );
