/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*ParseCommands main command line parser, called by Cloudy to decode commands, 
 * it then call other routines to parse specific commands */
void ParseCommands(void);

/*ParseAbundances parse and read in composition as set by abundances command */
void ParseAbundances(char *chCard,
  int lgDSet);

/*ParseDont parse the dont command */
void ParseDont(char*);

/*ParsePunch parse the punch command */
void ParsePunch(char *chCard );

/*initialize punch file pointers */
void PunchFilesInit(void);

/*close all open punch files */
void ClosePunchFiles(void);

/*ParseAge - parse the age command */
void ParseAge(char*);

/*ParseAgn parse parameters for the AGN continuum shape command */
void ParseAgn(char *chCard);

/* parse the blackgody command */
void ParseBlackbody(
  /* input command line, already changed to caps */
  char *chCard,	
  /* counter for which continuum source this is */
  long int *nqh,
  /* optional area that might be set here */
  float *ar1);					

/*ParseCompile compile werner or kurucz model atmospheres into cloudy format, by K Volk */
void ParseCompile(char *chCard );

/*ParseConstant parse the constant ... command */
void ParseConstant(char*);

/*ParseDLaw parse parameters on the dlaw command so set some density vs depth law*/
void ParseDLaw(char *chCard );

/*ParseTLaw parse parameters on the tlaw command to set some temperature vs depth */
void ParseTLaw(char *chCard );

/*ParseDriveCmnd parse the drive command - drive calls to various subs */
void ParseDriveCmnd(char *chCard );

/*ParseGrain parse parameters on Peter's version of the grains command */
void ParseGrain(char *chCard, 
  int *lgDset);

/*ParseAtomCO parse the atom co command */
void ParseAtomCO(char *chCard );

/*ParseFluc parse the fluctuations command */
void ParseFluc(char*);

/*ParseHDEN parse the HDEN command */
void ParseHDEN(char*);

/*ParseAtomHLike parse the hydrogen command, to set options for hydrogenic species */
void ParseAtomHLike(char*);

/*ParseInit parse the init command */
void ParseInit(char*);

/*ParseInterp parse parameters on interpolate command */
void ParseInterp(char *chCard, 
  int *lgEOF);

/*ParseIonPar parse the ionization parameter command */
void ParseIonPar(long int *nqh, 
  char *chCard,
  float *ar1);

/*ParseNorm parse parameters on the normalize command */
void ParseNorm(char *chCard);

/*ParseOptimize parse the optimize command */
void ParseOptimize(char *chCard);

/*ParsePrint parse the print command  */
void ParsePrint(char *chCard );

/*ParseRadius parse the radius command */
void ParseRadius(char*,float*);

/*ParseSet parse the set command */
void ParseSet(char*);

/*ParseTable parse the table read command */
void ParseTable(long int *nqh, 
  char *chCard,
  float *ar1);

/*ParseTrace parse the trace command */
void ParseTrace(char*);

/*ParseAbsMag parse the absolute magnitude command */
void ParseAbsMag(char*,long*);

/*ParseBackgrd parse the background continuum command */
void ParseBackgrd(long*,char*,float*);

/*ParseCoronal parse the cronal equilibrum command */
void ParseCoronal(char*,long*,float*);

/*ParseElement parse options on element command */
void ParseElement(char *chCard );

/*ParseFireBall parse parameters from fireball command */
void ParseFireBall(double z, 
  long int *nqh, 
  float *ar1);

/*ParseF_nu parse intensity command parameters */
void ParseF_nu(char *chCard, 
  long int *nqh, 
  float *ar1, 
  char *chType, 
  int lgNU2);

/*ParseGlobule parse parameters off the globule command */
void ParseGlobule(char *chCard);

/*ParseRangeOption parse the range option on the luminosity command */
void ParseRangeOption(long,char*);

/*ParseMap parse map command to produce map of heating and cooling */
void ParseMap(char*);

/*ParseMetal parse parameters on metal command */
void ParseMetal(char*);

/*ParsePlot parse the plot command */
void ParsePlot(char*);

/*ParsePowerlawContinuum parse the power law continuum command */
void ParsePowerlawContinuum(char*);

/*ParseRatio parse the ratio command */
void ParseRatio(char*,long*);

/*ParseSphere parse the sphere command */
void ParseSphere(char*);

/*ParseStop parse the stop command */
void ParseStop(char*);

/*CrashDo any of several tests to check that the code can crash */
void CrashDo(char *chCard);
