/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*ParseDLaw parse parameters on the dlaw command */
#include "cddefines.h"
#include "dense.h"
#include "varypar.h"
#include "abund.h"
#include "input.h"
#include "readar.h"
#include "parse.h"

void ParseDLaw(char *chCard )
{
	char chCAP[5];
	int lgEOL, 
	  lgEnd;
	long int i, 
	  j;

#	ifdef DEBUG_FUN
	fputs( "<+>ParseDLaw()\n", debug_fp );
#	endif

	/* call fcn FABDEN(RADIUS) which uses the ten parameters
	 * N.B.; existing version of FABDEN must be deleted
	 * >>chng 96 nov 29, added table option */
	if( lgMatch("TABL",chCard) )
	{
		/* when called, read in densities from input stream */
		strcpy( dense.chDenseLaw, "DLW2" );
		if( lgMatch("DEPT",chCard) )
		{
			dense.lgDLWDepth = TRUE;
		}
		else
		{
			dense.lgDLWDepth = FALSE;
		}

		readar(chCard,&lgEnd);
		i = 1;
		dense.frad[0] = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
		dense.fhden[0] = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
		if( lgEOL )
		{
			fprintf( ioQQQ, " No pairs entered - can\'t interpolate.\n Sorry.\n" );
			puts( "[Stop in getdlaw]" );
			cdEXIT(EXIT_FAILURE);
		}

		dense.nvals = 2;
		lgEnd = FALSE;

		/* read pairs of numbers until we find line starting with END */
		while( !lgEnd && dense.nvals < LIMTABD )
		{
			readar(chCard,&lgEnd);
			if( !lgEnd )
			{
				cap4(chCAP , chCard);
				if( strncmp(chCAP , "END" , 3 ) == 0 )
					lgEnd = TRUE;
			}

			if( !lgEnd )
			{
				i = 1;
				dense.frad[dense.nvals-1] = (float)FFmtRead(chCard
				  ,&i,INPUT_LINE_LENGTH,&lgEOL);
				dense.fhden[dense.nvals-1] = (float)FFmtRead(chCard
				  ,&i,INPUT_LINE_LENGTH,&lgEOL);
				dense.nvals += 1;
			}
		}
		--dense.nvals;

		for( i=1; i < dense.nvals; i++ )
		{
			/* the radius values are assumed to be strictly increasing */
			if( dense.frad[i] <= dense.frad[i-1] )
			{
				fprintf( ioQQQ, " density.in radii must be in increasing order\n" );
				puts( "[Stop in getdlaw]" );
				cdEXIT(EXIT_FAILURE);
			}
		}
	}
	else
	{
		/* this is usual case, call fabden to get density */
		i = 4;
		for( j=0; j < 10; j++ )
		{
			dense.DensityLaw[j] = FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
		}

		/* set flag so we know which law to use later */
		strcpy( dense.chDenseLaw, "DLW1" );

		/* vary option */
		if( VaryPar.lgVarOn )
		{
			/* NB - there are 5 = LIMEXT numbers on this line - if LIMEXT ever changes,
			 * chnage this too */
			strcpy( VaryPar.chVarFmt[VaryPar.nparm], "DLAW %f %f %f %f %f " );

			/* index for where to write */
			VaryPar.nvfpnt[VaryPar.nparm] = input.nRead;
			for( j=0; j<LIMEXT; ++j )
			{
				VaryPar.vparm[j][VaryPar.nparm] = (float)dense.DensityLaw[j];
			}
			VaryPar.vincr[VaryPar.nparm] = 0.5;
			VaryPar.nvarxt[VaryPar.nparm] = LIMEXT;
			++VaryPar.nparm;
		}
	}

#	ifdef DEBUG_FUN
	fputs( " <->ParseDLaw()\n", debug_fp );
#	endif
	return;
}
