/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
#include "cddefines.h"
#include "path.h"

/* This file contains the path, the location where all the cloudy data files are located.
 * Modify the path as set in the "char chDataPath" below, and never worry about setting 
 * a path again. 
 *
 * there are several sample paths - the first is for my pc, which runs windows and
 * is not commented out.  
 * the rest are examples of setting the path on a unix box 
 */

/* FILENAME_PATH_LENGTH is the size of the string that holds the path.  The longest
 * string that can be held is one less than this, due to the end
 * end of string sentinal in C.  Increase this is a larger string
 * is needed to hold the path on your system.  
 * FILENAME_PATH_LENGTH is set in cddefines.h - look at that file to see what
 * the longest string is */

/* Comments in C:  there are many sample paths below, and these are commented out.
 * in C a comment begins with the character string "slash star" and ends with the
 * string "star slash".  These sentences are comments because they begin and end this
 * way.  To make a commented part no longer commented, you need to remove both the "slash star"
 * and the "star slash". */

#ifdef LOCAL_DATA_PATH
/* the first branch was added by Robin Williams and allows you to specify
 * any path as an argument to the compiler */ 
char chDataPath[FILENAME_PATH_LENGTH]=LOCAL_DATA_PATH;/**/
#else
 /* path to directory where data live on my pc, 
 * this is the format to use on a windows machine
 * remove or comment out the next 5 lines if you don't want to use it */
char chDataPath[FILENAME_PATH_LENGTH]="c:\\projects\\cloudy\\current\\data\\" ;
#endif

/* this is the path on the linux cluster here in lexington */
/*char chDataPath[FILENAME_PATH_LENGTH]="$exe = "/home59/home37/gary/cloudy/current/data/";*/

/* this is a sample path on a unix box, This
 * is my path on the sdx 64 processor system we have here in Lexington.*/
/* char chDataPath[FILENAME_PATH_LENGTH]="/u/home1/gary/cloudy/current/data/" ;*/

/* TRUE says that the path has been set with set path command,
 * or has been set here, It is false if the path is not set,
 * Leave this line alone - only change it if you really want to tell the
 * code that the path was not set here.  You will then need a
 * set path command in every input stream */
int lgDataPathSet=TRUE;
