/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/* phycon.h */
EXTERN struct t_phycon {

	/*te, electron temperature
	 *NB, this is used in zero to check whether 32 bit environment in use,
	 *if ever declared double will need to change that test, setting lgBit32*/
	float te;

	/* the current electron temperature in eV */
	float te_eV;

	/* the current electron temperature in Ryd */
	float te_ryd;

	/* the current electron temperature in wavenumbers */
	float te_wn;

	/* 1/TE */
	float teinv;

	/* T^2 */
	float tesqrd;

	/* ratio of electron to nuclei density, could be >1 because of he, set in esum */
	float ElecFrac;

	/*total number of colliders (atoms, ions, molecules) in gas, no electrons */
	double CollidDensity;

	/*xMassDensity grams per cc */
	float xMassDensity, 

	  /* total number of particles per cubic centimeter */
	  pden, 

	  /* mean AMU per particle */
	  wmole ,

	  /* total number of nuclei, set in PressureTotal */
		TotalNuclei;

	/* EdenHCorr is eden + hi * 1.7e-4, includes correction for H atom collisions */
	double EdenHCorr;

	/* total ionization energy of gas, erg/cm^3, evaluated in PressureTotal,
	 * this is the amount of energy needed to go from pure atoms to the current
	 * ionization of the gas. */
	double EnergyIonization;

	/* the total internal energy of atoms and molecules within the gas, erg/cm^3.  This is
	 * the amount of energy to excite the current level populations from the ground.
	 * this includes electronic excitations of atoms and rotation excitations of molecules 
	 */
	double EnergyExcitation;

	/* the enthalpy per unit vol, updated with pressure updated */
	double EnthalpyDensity;

	/* this is the total binding energy of the molecules, and is negative, the energy
	 * need to get back to free atoms */
	double EnergyBinding;

	/* this is the true eden as set in esum, we will try to converge eden to this */
	double EdenTrue;

	/*flags set when bad electron density is detected */
	int lgEdenBad;

	/*zone where bad electron density was detected */
	long int nzEdenBad;

	/*EdenExtra extra electrons added with eden command*/
	float EdenExtra;

	/*EdenSet electron density set with set eden command*/
	float EdenSet;

	/* sum of heavy element free electrons, set in esum */
	float EdenFFSum;

	/* edensqte is eden/sqrte */
	float edensqte; 

	/* cdsqte is eden/sqrte times 8.629e-6 - this multiplies the collision strength to 
	 * produce the deexcitation rate */
	float cdsqte;

	/* these are simple powers of the electron temperature, are
	 * evaluated in tfidle, and can be used to avoid exponentials*/
	float sqrte, 
	  te32, 
	  te90, 
	  te70, 
	  te30, 
	  te20, 
	  te10, 
	  te07,
	  te05, 
	  te04, 
	  te03, 
	  te02, 
	  te01, 
	  te005, 
	  te003, 
	  te001;
	/*1 is log Te, 2 is (log T)^2, etc*/
	float telogn[7] ,
		/* this is used to rescale telogn array for other charge,
		 * ith element is log(i+1)^(i+1)*/
		sqlogz[LIMELM];

	/* alogte is base 10 log of temperature */
	float alogte;

	/* alogte is base e log of temperature */
	float alogete;

	/* alogte is base 10 log of density */
	float alogne;

	/* square root of electron density, set in tfidle */
	float SqrtEden;

	/* temperature of previous zone,used for punch */
	float tlast;

	float 
	  /* inital temperature */
	  TeInit, 
	  /* proposed temperature */
	  TeProp,
	  /* inital electron density */
	  EdenInit ,
	  /* proposed electron density */
	  EdenProp ;

	/* energy density temperature */
	float TEnerDen;

	}	phycon;

