/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*PressureTotal determine the gas and line radiation pressures for current conditions,
 * this sets the variable pressure.PresTotlCurr */
void PresTotCurrent(void);

/* variables dealing with pressure across model */
EXTERN struct t_pressure {

	/* lowest and highest total current pressure to desired
	 * pressures in model, a measure of how well converged it is.  This
	 * includes total pressure, so in a constant gas pressure model will
	 * show a large excursion */
	float PresLow, 
	  PresHigh;

	float PresPowerlaw;

	/* the initial and current ram pressure */
	double PresRamInit , PresRamCurr ;

	/* the current pressure, and the correct pressure, the ratio
	 * of the two is the error, PresTotlCurr is set in PressureTotal */
	double PresTotlCurr, 
	  PresTotlCorrect,
	  /* PresGasCurr is gas pressure, nkT, set in PressureTotal */
	  PresGasCurr;

	/* PresTotlInit - total pressure at the illuminated face */
	double PresTotlInit;

	/* PresRadCurr is line radiation pressure for current zone */
	double PresRadCurr;

	/* flag saying whether or not incident continuum should be included
	 * in total pressure, turned off with constant gas pressure */
	int lgContRadPresOn;

	/* total pressure related variables
	 * PresInteg is integral */
	float PresInteg, 
	  pinzon;

	/* lgRadPresON says whether radiation pressure enabled, turned ooff with
	* constant density, constant gas pressure commands, on with constant pressure */
	int lgRadPresON;

	float HLalpha, 
	  /* RadBetaMax is largest ratio of radiation to gas pressure */
	  RadBetaMax, 
	  /* pbeta is ratio of radition to gas pressure, evaluated in PressureTotal */
	  pbeta, 
	  /* PresMas is largest pressure that occurred in the calculation */
	  PresMax;

	/* pointer to line with greatest radiation pressure */
	long int ipPradMax;

	/* string with label for line with greatest contributrion to pressure*/
	char chLineRadPres[101];

	/* lgPradCap true if radiation pressure capped on first iteration
	 * lgPradDen capped by thermalization length */
	int lgPradCap, 
	  lgPradDen;

	/* flag true if radiation pressure is turned on, part of total pressure */
	int lgLineRadPresOn;

	/* option to not abort on high radiation pressure - set TRUE in initialization,
	 * set false with NO ABORT on constant radiation pressure command */
	int lgRadPresAbortOK;

	/* we hit the sonic point */
	int lgSonicPoint;

	}	pressure;

