/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*radacl radiative acceleration due to incident continuum, calls forlin for lines*/
#include "cddefines.h"
#include "physconst.h"
#include "rfield.h"
#include "opacity.h"
#include "wind.h"
#include "forlin.h"
#include "phycon.h"
#include "radacl.h"

void radacl(void)
{
	long int i;
	double rforce;

#	ifdef DEBUG_FUN
	fputs( "<+>radacl()\n", debug_fp );
#	endif
	/*radiative acceleration due to incident continuum, calls forlin for lines
	 *used for wind solution derives AccelLine and AccelCont */

	rforce = 0.;
	for( i=0; i < rfield.nflux; i++ )
	{
		rforce += (rfield.flux[i] + rfield.outlin[i] + rfield.ConInterOut[i])*
		  rfield.anu[i]*(opac.opacity_abs[i] + opac.opacity_sct[i]);
	}

	/* radiative acceleration; xMassDensity is gm per cc, eval when PTOT called */
	wind.AccelLine = (float)(forlin()/SPEEDLIGHT/phycon.xMassDensity);
	wind.AccelCont = (float)(rforce*EN1RYD/SPEEDLIGHT/phycon.xMassDensity);

#	ifdef DEBUG_FUN
	fputs( " <->radacl()\n", debug_fp );
#	endif
	return;
}
